/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMLanguage;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.ClientSocketHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;

public final class ClientSocketListener
implements Runnable {
    private ServerSocket serverSocket;
    private APMLanguage language;
    private final String logPrefix = " [" + this.getClass().getName() + "] ";

    public ClientSocketListener(ServerSocket serverSocket, APMLanguage language) {
        try {
            this.serverSocket = serverSocket;
            this.language = language;
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error(" {} Unable to initialize ClientSocketListener object {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public void run() {
        Socket clientSocket = null;
        boolean acceptClientConnection = true;
        while (acceptClientConnection) {
            try {
                if (this.serverSocket.isClosed()) {
                    AgentStartupLogger.logger.warn("{} Server socket is closed :{} ", (Object)this.logPrefix, (Object)this.serverSocket.isClosed());
                    acceptClientConnection = false;
                } else {
                    clientSocket = this.serverSocket.accept();
                }
                if (clientSocket != null) {
                    clientSocket.setTcpNoDelay(true);
                    clientSocket.setKeepAlive(true);
                    ClientSocketHandler socketHandler = new ClientSocketHandler(clientSocket, this.language);
                    Thread socketHandlerThread = new Thread(socketHandler);
                    socketHandlerThread.setName("Client Socket Handler");
                    socketHandlerThread.setDaemon(true);
                    socketHandlerThread.start();
                    acceptClientConnection = true;
                    continue;
                }
                acceptClientConnection = false;
            }
            catch (SocketTimeoutException ste) {
                System.err.println("Client socket connection has been timedout " + ste.getMessage());
                AgentStartupLogger.logger.error("{} Client socket connection has been timedout {} ", (Object)this.logPrefix, (Object)ste);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
            catch (IOException ioe) {
                System.err.println("IO Exception while waiting for client socket connection " + ioe.getMessage());
                AgentStartupLogger.logger.error("{} IO Exception while waiting for client socket connection {} ", (Object)this.logPrefix, (Object)ioe);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
            catch (SecurityException se) {
                System.err.println("Security Manager settings not allowing to accept client socket connection " + se.getMessage());
                AgentStartupLogger.logger.error("{} Security Manager settings not allowing to accept client socket connection {} ", (Object)this.logPrefix, (Object)se);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
            catch (Exception e) {
                System.err.println("Unable to get client socket connection ... " + e.getMessage());
                AgentStartupLogger.logger.error("{} nable to get client socket connection ... {} ", (Object)this.logPrefix, (Object)e);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
        }
    }

    private void closeClientSocket(Socket clientSocket) {
        if (clientSocket != null) {
            try {
                if (!clientSocket.isClosed()) {
                    clientSocket.close();
                    clientSocket = null;
                }
            }
            catch (IOException ioe) {
                AgentStartupLogger.logger.error("{} Exception while closing the client socket {} {} ", new Object[]{this.logPrefix, clientSocket.toString(), ioe});
            }
        }
    }
}

