/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.AgentLogger;
import com.eg.IPV6Helper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.CRIOContainersThread;
import com.eg.apm.ContainerCategory;
import com.eg.apm.ContainerImpl;
import com.eg.apm.ContainerInfo;
import com.eg.apm.ContainerUtils;
import com.eg.apm.EgApmMainAgentInfo;
import com.eg.apm.KubernetesAPI;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class CRIOContainers
extends ContainerImpl {
    private static CRIOContainers crioContServer = null;
    private static final String sync = new String("sync");
    private static final String loggerDispStr = "[CRIOContainers]";
    protected static boolean useSudo = false;

    private CRIOContainers(ContainerCategory containerCategory) {
        super(containerCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CRIOContainers getCRIOContainerInstance(ContainerCategory containerCategory) {
        if (crioContServer == null) {
            String string = sync;
            synchronized (string) {
                if (crioContServer == null) {
                    crioContServer = new CRIOContainers(containerCategory);
                }
            }
        }
        return crioContServer;
    }

    public Hashtable getContainerPortDetails() {
        return this.ht_containerIdAndPort;
    }

    public String getContainerIp(String string) {
        this.updateRepo();
        String string2 = "";
        String string3 = "";
        if (this.ht_runningContainerIpMap != null && this.ht_runningContainerIpMap.containsKey(string)) {
            string2 = (String)this.ht_runningContainerIpMap.get(string);
            string3 = "CACHE";
        } else {
            string2 = this.getContainerIpWithRetry(string);
            string3 = "RETRY";
        }
        APMDiscoveryLogger.discoveryLogger.debug("{} strContainerId : {}, strContIpAddr : {}, ipRetrivedFrom : {}, ht_runningContainerIpMap : {}", new Object[]{loggerDispStr, string, string2, string3, this.ht_runningContainerIpMap});
        return string2;
    }

    public void updateRepo() {
        this.updateRepo(false);
    }

    public void updateRepo(boolean bl) {
        long l = System.currentTimeMillis();
        if (l - this.lastUpdatedTime >= 600000L || bl && l - this.lastUpdatedTime > 10000L) {
            this.ht_runningContainerIpMap = this.getRunningContainerIpDetails();
            this.lastUpdatedTime = l;
        }
    }

    public String getPodNameSpaceName(String string) {
        this.updateRepo();
        String string2 = "";
        if (this.ht_containerIdAndNameSpace != null && this.ht_containerIdAndNameSpace.containsKey(string)) {
            string2 = (String)this.ht_containerIdAndNameSpace.get(string);
        } else {
            this.updateRepo(true);
            if (this.ht_containerIdAndNameSpace != null && this.ht_containerIdAndNameSpace.containsKey(string)) {
                string2 = (String)this.ht_containerIdAndNameSpace.get(string);
            }
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} strContainerId : {}, strPodNameSpaceName : {}, ht_containerIdAndNameSpace : {}", new Object[]{loggerDispStr, string, string2, this.ht_containerIdAndNameSpace});
        return string2;
    }

    public Hashtable getRunningContainerIpDetails() {
        Hashtable hashtable;
        String string;
        String string2;
        int n;
        Hashtable hashtable2 = this.geRunningContainerDetails();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (hashtable2 != null && hashtable2.size() > 0) {
            int n2 = hashtable2.size();
            int n3 = 10;
            n = 1;
            int n4 = 0;
            Enumeration enumeration = hashtable2.keys();
            string2 = "";
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ++n4;
                if (string == null) continue;
                arrayList2.add(string);
                Hashtable hashtable4 = (Hashtable)hashtable2.get(string);
                if (hashtable4 == null) continue;
                if (n <= n3) {
                    string2 = n == 1 ? string : string2 + " " + string;
                    ++n;
                }
                if (n == n3) {
                    arrayList.add(string2);
                    string2 = "";
                    n = 1;
                }
                if (n4 == n2 && n != n3) {
                    arrayList.add(string2);
                }
                String string3 = null;
                if (!hashtable4.containsKey("Names") || (string3 = (String)hashtable4.get("Names")) == null) continue;
                hashtable3.put(string3, this.trimTo12Char(string));
            }
        }
        if ((hashtable = this.getContainerIpDetails(arrayList2)) == null) {
            hashtable = new Hashtable();
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (arrayList2 != null && arrayList2.size() > 0) {
            Object object;
            n = EgApmMainAgentInfo.getInstance().getMaxDokcerThreads();
            ArrayList<CRIOContainersThread> arrayList4 = new ArrayList<CRIOContainersThread>();
            for (int i = 0; i < arrayList2.size(); ++i) {
                string2 = (String)arrayList2.get(i);
                string = "crictl inspect --output json " + string2;
                if (useSudo) {
                    string = "sudo " + string;
                }
                long l = System.currentTimeMillis();
                long l2 = 360000L;
                long l3 = l - l2;
                while (arrayList4.size() >= n) {
                    for (int j = 0; j < arrayList4.size(); ++j) {
                        CRIOContainersThread cRIOContainersThread = (CRIOContainersThread)arrayList4.get(j);
                        if (cRIOContainersThread.isDone()) {
                            ArrayList arrayList5 = cRIOContainersThread.getOutput();
                            if (arrayList5 != null && arrayList5.size() > 0) {
                                String string4 = this.convertArrayListToJson(arrayList5);
                                arrayList3.add(string4);
                            }
                            arrayList4.remove(j);
                            --j;
                            continue;
                        }
                        l = System.currentTimeMillis();
                        l3 = l - l2;
                        if (cRIOContainersThread.startTime >= l3) continue;
                        try {
                            cRIOContainersThread.interrupt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        arrayList4.remove(j);
                        --j;
                    }
                    if (arrayList4.size() < n) break;
                    try {
                        Thread.currentThread();
                        Thread.sleep(300L);
                    }
                    catch (Exception exception) {}
                }
                object = new CRIOContainersThread(this, string);
                arrayList4.add((CRIOContainersThread)object);
            }
            long l = 360000L;
            while (arrayList4.size() > 0) {
                long l4 = System.currentTimeMillis();
                long l5 = l4 - l;
                for (int i = 0; i < arrayList4.size(); ++i) {
                    CRIOContainersThread cRIOContainersThread = (CRIOContainersThread)arrayList4.get(i);
                    if (cRIOContainersThread.isDone()) {
                        ArrayList arrayList6 = cRIOContainersThread.getOutput();
                        if (arrayList6 != null && arrayList6.size() > 0) {
                            object = this.convertArrayListToJson(arrayList6);
                            arrayList3.add(object);
                        }
                        arrayList4.remove(i);
                        --i;
                        continue;
                    }
                    if (cRIOContainersThread.startTime >= l5) continue;
                    try {
                        cRIOContainersThread.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList4.remove(i);
                    --i;
                }
                if (arrayList4 == null || arrayList4.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
        this.getRunningContainerPodAndPort(arrayList3, hashtable3, hashtable);
        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} al_runningContainersData : {}, ht_ContainerNameIdMapping : {}, ht_ContainerIdIpMap : {}", new Object[]{loggerDispStr, arrayList3, hashtable3, hashtable});
        }
        return hashtable;
    }

    private void getRunningContainerPodAndPort(ArrayList arrayList, Hashtable hashtable, Hashtable hashtable2) {
        APMDiscoveryLogger.discoveryLogger.trace("{} update-01 getRunningContainerPodAndPort", (Object)loggerDispStr);
        if (arrayList == null || arrayList.size() == 0) {
            return;
        }
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        int n = arrayList.size();
        APMDiscoveryLogger.discoveryLogger.trace("{} update-01 getRunningContainerPodAndPort - data size : {} ", (Object)loggerDispStr, (Object)n);
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            try {
                Object object;
                Object object2;
                Object object3;
                JSONObject jSONObject;
                JSONObject jSONObject2 = this.stringToJSON(string);
                if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} Container Id : {}, Json result : {}", new Object[]{loggerDispStr, string, jSONObject2});
                }
                if (jSONObject2 == null || jSONObject2.size() <= 0 || !jSONObject2.containsKey("status") || (jSONObject = (JSONObject)jSONObject2.get("status")) == null) continue;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (jSONObject.containsKey("id")) {
                    string4 = jSONObject.get("id").toString();
                }
                if (jSONObject.containsKey("labels") && (object3 = (JSONObject)jSONObject.get("labels")) != null) {
                    if (object3.containsKey("io.kubernetes.container.name")) {
                        string2 = object3.get("io.kubernetes.container.name").toString();
                    }
                    if (object3.containsKey("io.kubernetes.pod.name")) {
                        string3 = object3.get("io.kubernetes.pod.name").toString();
                    }
                    if (object3.containsKey("io.kubernetes.pod.namespace")) {
                        string5 = object3.get("io.kubernetes.pod.namespace").toString();
                    }
                }
                if (jSONObject.containsKey("annotations") && (object3 = (JSONObject)jSONObject.get("annotations")) != null && object3.containsKey("io.kubernetes.container.ports") && (object2 = this.stringToJSONArray((String)(object = (String)object3.get("io.kubernetes.container.ports")))) != null && object2.size() > 0) {
                    for (int j = 0; j < object2.size(); ++j) {
                        JSONObject jSONObject3 = (JSONObject)object2.get(j);
                        if (!jSONObject3.containsKey("containerPort")) continue;
                        try {
                            Long l = (Long)jSONObject3.get("containerPort");
                            if (l == null) continue;
                            arrayList2.add(l.toString());
                            continue;
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do stringToJSON() : {}", (Object)loggerDispStr, (Object)exception);
                        }
                    }
                }
                if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} containerName : {}, podName : {}, containerID : {}, port: {}", new Object[]{loggerDispStr, string2, string3, string4, arrayList2});
                }
                object3 = this.trimTo12Char(string4);
                object = new ContainerInfo((String)object3);
                if (arrayList2 != null && arrayList2.size() > 0) {
                    object2 = this.getHighPriorityPort(arrayList2);
                    this.ht_containerIdAndPort.put(object3, object2);
                    ((ContainerInfo)object).setPort((String)object2);
                    ((ContainerInfo)object).setPorts(arrayList2);
                }
                if (object3 != null && string3 != null && string3.length() > 0) {
                    this.ht_containerIdAndPodName.put(object3, string3);
                    ((ContainerInfo)object).setPodName(string3);
                }
                if (object3 != null && string5 != null && string5.length() > 0) {
                    this.ht_containerIdAndNameSpace.put(object3, string5);
                    ((ContainerInfo)object).setNameSpace(string5);
                }
                if (object3 != null && string2 != null && string2.length() > 0) {
                    ((ContainerInfo)object).setName(string2);
                }
                boolean bl = this.IsIpDiscovered((String)object3, hashtable2, (ContainerInfo)object);
                APMDiscoveryLogger.discoveryLogger.trace("{} update-01 Is Container IP already discovered for {} - {}", new Object[]{loggerDispStr, object3, bl});
                if (bl) continue;
                this.discoveryIp((Map)jSONObject2, hashtable2, (String)object3, (ContainerInfo)object);
                continue;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get container ports in crio host : {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
            APMDiscoveryLogger.discoveryLogger.trace("{} ht_containerIdAndPodName : {}, ht_containerIdAndPort : {}, ht_containerIdAndNameSpace : {}, ht_NotRunningContainers :{}", new Object[]{loggerDispStr, this.ht_containerIdAndPodName, this.ht_containerIdAndPort, this.ht_containerIdAndNameSpace, this.ht_NotRunningContainers});
        }
    }

    private void discoveryIp(Map map, Hashtable hashtable, String string, ContainerInfo containerInfo) {
        if (map == null || hashtable == null || string == null) {
            return;
        }
        String string2 = "";
        try {
            JSONObject jSONObject;
            JSONObject jSONObject2;
            Object object;
            if (map.containsKey("info") && (object = (JSONObject)map.get("info")) != null && object.containsKey("runtimeSpec") && (jSONObject2 = (JSONObject)object.get("runtimeSpec")) != null && jSONObject2.containsKey("annotations") && (jSONObject = (JSONObject)jSONObject2.get("annotations")) != null && jSONObject.containsKey("io.kubernetes.cri-o.IP.0") && (string2 = (String)jSONObject.get("io.kubernetes.cri-o.IP.0")) != null && IPV6Helper.validateIPV4(string2.trim())) {
                hashtable.put(string, string2);
                containerInfo.setIp(string2);
                APMDiscoveryLogger.discoveryLogger.trace("{} update-01 Container IP discovered in second attempt, container ID : {}, IP : {}", new Object[]{loggerDispStr, string, string2});
            }
            if (string2.length() == 0) {
                this.getPodIpUsingK8sApi(containerInfo);
                object = containerInfo.getIp();
                if (object != null && ((String)object).length() > 0 && hashtable != null) {
                    hashtable.put(string, string2);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get IP address", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void getPodIpUsingK8sApi(ContainerInfo containerInfo) {
        try {
            if (containerInfo != null) {
                KubernetesAPI kubernetesAPI;
                String string;
                String string2 = containerInfo.getId();
                String string3 = containerInfo.getNameSpace();
                String string4 = containerInfo.getId();
                if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && (string = (kubernetesAPI = KubernetesAPI.createInstance()).getPodIp(string3, string4)) != null && string.length() > 0) {
                    String string5 = string;
                    containerInfo.setIp(string5);
                    AgentLogger.bgTaskLogger.trace("{} {} Pod IP from k8s api from labels[io.kubernetes.pod.namespace] {} ", new Object[]{loggerDispStr, string2, string5});
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get IP address using k8s api", (Object)loggerDispStr, (Object)exception);
        }
        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
            AgentLogger.bgTaskLogger.trace("{} ContainerInfo - {}", (Object)loggerDispStr, (Object)containerInfo);
        }
    }

    private boolean IsIpDiscovered(String string, Hashtable hashtable, ContainerInfo containerInfo) {
        try {
            String string2;
            if (hashtable != null && string != null && (string2 = (String)hashtable.get(string)) != null && string2.length() > 4) {
                containerInfo.setIp(string2);
                return true;
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to verify IP addresss availablity for {} ", new Object[]{loggerDispStr, string, exception});
        }
        return false;
    }

    private String trimTo12Char(String string) {
        if (string != null && string.length() >= 12) {
            string = string.substring(0, 12);
        }
        return string;
    }

    public int getPodPort(String string) {
        int n = 0;
        return n;
    }

    public int getDockerPort(String string) {
        int n = 0;
        return n;
    }

    public Hashtable geRunningContainerDetails() {
        try {
            Hashtable hashtable = new Hashtable();
            String string = "crictl ps -a";
            ArrayList arrayList = this.executeCommand(string);
            APMDiscoveryLogger.discoveryLogger.trace("{} 06-Oct-2021 attempt 1 cmd : {} Result : {}  ", new Object[]{loggerDispStr, string, arrayList});
            if (arrayList == null || arrayList.size() == 0) {
                string = "sudo crictl ps -a";
                arrayList = this.executeCommand(string);
                APMDiscoveryLogger.discoveryLogger.trace("{} 06-Oct-2021 attempt 2 cmd : {} Result : {}  ", new Object[]{loggerDispStr, string, arrayList});
                if (arrayList != null && arrayList.size() != 0) {
                    useSudo = true;
                }
            } else {
                useSudo = false;
            }
            if (arrayList == null || arrayList.size() == 0) {
                APMDiscoveryLogger.discoveryLogger.trace("{} cmd : {} Output is null or empty, So, Return.. ", (Object)loggerDispStr, (Object)string);
                return null;
            }
            int n = arrayList.size();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "";
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                String string10 = (String)arrayList.get(i);
                if (string10 == null) continue;
                if (string10.indexOf("CONTAINER") >= 0 || string10.indexOf("CONTAINER ID") >= 0) {
                    if (string10.indexOf("CONTAINER") >= 0) {
                        n2 = string10.indexOf("CONTAINER");
                    } else if (string10.indexOf("CONTAINER ID") >= 0) {
                        n2 = string10.indexOf("CONTAINER ID");
                    }
                    n3 = string10.indexOf("IMAGE");
                    n4 = string10.indexOf("CREATED");
                    n5 = string10.indexOf("STATE");
                    n7 = string10.indexOf("NAME");
                    n6 = string10.indexOf("ATTEMPT");
                    n8 = string10.indexOf("POD ID");
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                string2 = string10.substring(n2, n3 - 1).trim();
                string3 = string10.substring(n3, n4 - 1).trim();
                string4 = string10.substring(n4, n5 - 1).trim();
                string5 = string10.substring(n5, n7 - 1).trim();
                string7 = string10.substring(n7, n6 - 1).trim();
                string9 = string10.substring(n6, n8 - 1).trim();
                string6 = string10.substring(n8).trim();
                string6 = ContainerUtils.trimTo12Char(string6);
                Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
                hashtable2.put("Image", string3);
                hashtable2.put("Created", string4);
                hashtable2.put("Status", string5);
                hashtable2.put("Names", string7);
                hashtable2.put("Attempt", string9);
                hashtable2.put("Podid", string6);
                hashtable2.put("ContainerId", string2);
                if (string5 == null) continue;
                if (string5.toLowerCase().indexOf("running") >= 0) {
                    hashtable.put(this.trimTo12Char(string2), hashtable2);
                    continue;
                }
                this.ht_NotRunningContainers.put(this.trimTo12Char(string2), new Boolean(true));
            }
            return hashtable;
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get running container details: {}", (Object)loggerDispStr, (Object)exception);
            return null;
        }
    }

    private Hashtable getContainerIpDetails(ArrayList arrayList) {
        Object object;
        Object object2;
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        int n = arrayList.size();
        int n2 = EgApmMainAgentInfo.getInstance().getMaxDokcerThreads();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            if (string == null) continue;
            String string2 = "crictl exec " + string + " hostname -i";
            if (useSudo) {
                string2 = "sudo " + string2;
            }
            long l = System.currentTimeMillis();
            long l2 = 360000L;
            long l3 = l - l2;
            while (arrayList2.size() >= n2) {
                for (int j = 0; j < arrayList2.size(); ++j) {
                    object2 = (CRIOContainersThread)arrayList2.get(j);
                    if (((CRIOContainersThread)object2).isDone()) {
                        ArrayList arrayList3 = ((CRIOContainersThread)object2).getOutput();
                        String string3 = ((CRIOContainersThread)object2).getContainerId();
                        if (arrayList3 != null && arrayList3.size() > 0 && string3 != null) {
                            String string4 = (String)arrayList3.get(0);
                            if (string4 != null && string4.indexOf(" ") > 0) {
                                StringTokenizer stringTokenizer = new StringTokenizer(string4, " ");
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string5 = stringTokenizer.nextToken();
                                    if (string5 == null || !IPV6Helper.validateIPV4(string5.trim())) continue;
                                    hashtable.put(this.trimTo12Char(string3), string5);
                                    break;
                                }
                            } else if (string4 != null && IPV6Helper.validateIPV4(string4.trim())) {
                                hashtable.put(this.trimTo12Char(string3), string4);
                            }
                        }
                        arrayList2.remove(j);
                        --j;
                        continue;
                    }
                    l = System.currentTimeMillis();
                    l3 = l - l2;
                    if (((CRIOContainersThread)object2).startTime >= l3) continue;
                    try {
                        ((Thread)object2).interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList2.remove(j);
                    --j;
                }
                if (arrayList2.size() < n2) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {}
            }
            object = new CRIOContainersThread(this, string2, string);
            arrayList2.add(object);
        }
        long l = 360000L;
        while (arrayList2.size() > 0) {
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            for (int i = 0; i < arrayList2.size(); ++i) {
                CRIOContainersThread cRIOContainersThread = (CRIOContainersThread)arrayList2.get(i);
                if (cRIOContainersThread.isDone()) {
                    ArrayList arrayList4 = cRIOContainersThread.getOutput();
                    object = cRIOContainersThread.getContainerId();
                    if (arrayList4 != null && arrayList4.size() > 0 && object != null && (object2 = (String)arrayList4.get(0)) != null && IPV6Helper.validateIPV4(((String)object2).trim())) {
                        hashtable.put(this.trimTo12Char((String)object), object2);
                    }
                    arrayList2.remove(i);
                    --i;
                    continue;
                }
                if (cRIOContainersThread.startTime >= l5) continue;
                try {
                    cRIOContainersThread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                arrayList2.remove(i);
                --i;
            }
            if (arrayList2 == null || arrayList2.size() == 0) break;
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} ht_containerIps : {}", (Object)loggerDispStr, hashtable);
        return hashtable;
    }

    private Hashtable getPodDetails() {
        ArrayList arrayList;
        String string = "crictl pods";
        if (useSudo) {
            string = "sudo " + string;
        }
        if ((arrayList = this.executeCommand(string)) == null || arrayList.size() == 0) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            if (arrayList != null && arrayList.size() > 0) {
                boolean bl = false;
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string2 = (String)arrayList.get(i);
                    if (string2 == null || string2.length() == 0 || string2 == null) continue;
                    if (string2.indexOf("POD ID") >= 0) {
                        n = string2.indexOf("POD ID");
                        n2 = string2.indexOf("CREATED");
                        n3 = string2.indexOf("STATE");
                        n4 = string2.indexOf("NAME");
                        n5 = string2.indexOf("NAMESPACE");
                        n6 = string2.indexOf("ATTEMPT");
                        bl = true;
                        continue;
                    }
                    if (!bl) continue;
                    String string3 = string2.substring(n, n2 - 1).trim();
                    String string4 = string2.substring(n4, n5 - 1).trim();
                    hashtable.put(this.trimTo12Char(string3), string4);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception in getPodDetails() : {}", (Object)loggerDispStr, (Object)exception);
        }
        return hashtable;
    }

    public ArrayList executeCommand(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = new ArrayList();
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            arrayList2 = egUtilities.getExecOutputLines(string);
            if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                APMDiscoveryLogger.discoveryLogger.debug("{} executeCommand() cmd : {} output : {}", new Object[]{loggerDispStr, string, arrayList2});
            }
            if (arrayList2 != null && arrayList2.size() >= 2) {
                arrayList = (ArrayList)arrayList2.get(0);
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to execute cmd : {}", new Object[]{loggerDispStr, string, exception});
        }
        return arrayList;
    }

    private JSONObject stringToJSON(String string) {
        JSONParser jSONParser = new JSONParser();
        JSONObject jSONObject = null;
        try {
            jSONObject = (JSONObject)jSONParser.parse(string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do stringToJSON() : {}", new Object[]{loggerDispStr, string, exception});
            return null;
        }
        return jSONObject;
    }

    private JSONArray stringToJSONArray(String string) {
        JSONParser jSONParser = new JSONParser();
        JSONArray jSONArray = null;
        try {
            jSONArray = (JSONArray)jSONParser.parse(string);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do stringToJSONArray() : {}", new Object[]{loggerDispStr, string, exception});
            return null;
        }
        return jSONArray;
    }

    private String convertArrayListToJson(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String getHighPriorityPort(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 0) {
            if (arrayList.contains("443")) {
                return "443";
            }
            if (arrayList.contains("8080")) {
                return "8080";
            }
            return (String)arrayList.get(0);
        }
        return "0000";
    }

    public String getHostInternalIp() {
        return "127.0.0.1";
    }

    public boolean isContainerZ() {
        return this.isDockerContainer() || this.isCrioContainer() || this.isPodmanContainer();
    }

    private String getContainerIpWithRetry(String string) {
        String string2;
        Object object;
        Object object2;
        Object object3 = "";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = EgApmMainAgentInfo.getInstance().getMaxDokcerThreads();
        ArrayList<CRIOContainersThread> arrayList2 = new ArrayList<CRIOContainersThread>();
        String string3 = "crictl inspect --output json " + string;
        if (useSudo) {
            string3 = "sudo " + string3;
        }
        APMDiscoveryLogger.discoveryLogger.trace("{} getContainerIpWithRetry - Inspect Command  : {} ", (Object)loggerDispStr, (Object)string3);
        long l = System.currentTimeMillis();
        long l2 = 360000L;
        long l3 = l - l2;
        while (arrayList2.size() >= n) {
            try {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object2 = (CRIOContainersThread)arrayList2.get(i);
                    if (((CRIOContainersThread)object2).isDone()) {
                        object = ((CRIOContainersThread)object2).getOutput();
                        if (object != null && ((ArrayList)object).size() > 0) {
                            string2 = this.convertArrayListToJson((ArrayList)object);
                            arrayList.add(string2);
                        }
                        arrayList2.remove(i);
                        --i;
                        continue;
                    }
                    l = System.currentTimeMillis();
                    l3 = l - l2;
                    if (((CRIOContainersThread)object2).startTime >= l3) continue;
                    try {
                        ((Thread)object2).interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList2.remove(i);
                    --i;
                }
                if (arrayList2.size() < n) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(300L);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} getContainerIpWithRetry() Exception : {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        Object object4 = new CRIOContainersThread(this, string3);
        arrayList2.add((CRIOContainersThread)object4);
        long l4 = 360000L;
        while (arrayList2.size() > 0) {
            try {
                long l5 = System.currentTimeMillis();
                long l6 = l5 - l4;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    object4 = (CRIOContainersThread)arrayList2.get(i);
                    if (((CRIOContainersThread)object4).isDone()) {
                        object2 = ((CRIOContainersThread)object4).getOutput();
                        if (object2 != null && ((ArrayList)object2).size() > 0) {
                            object = this.convertArrayListToJson((ArrayList)object2);
                            arrayList.add(object);
                        }
                        arrayList2.remove(i);
                        --i;
                        continue;
                    }
                    if (((CRIOContainersThread)object4).startTime >= l6) continue;
                    try {
                        ((Thread)object4).interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    arrayList2.remove(i);
                    --i;
                }
                if (arrayList2 == null || arrayList2.size() == 0) break;
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} getContainerIpWithRetry() Exception : {}", (Object)loggerDispStr, (Object)exception);
            }
        }
        if (arrayList != null) {
            int n2 = arrayList.size();
            APMDiscoveryLogger.discoveryLogger.trace("{} getContainerIpWithRetry() update_19-july-2021 data size : {}", (Object)loggerDispStr, (Object)n2);
            for (int i = 0; i < n2; ++i) {
                String string4 = (String)arrayList.get(i);
                if (string4 == null) continue;
                try {
                    Object object5;
                    Object object6;
                    block50: {
                        Object object7;
                        JSONObject jSONObject;
                        Object object8;
                        JSONObject jSONObject2;
                        JSONObject jSONObject3 = this.stringToJSON(string4);
                        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                            APMDiscoveryLogger.discoveryLogger.trace("{}  Json result : {}", (Object)loggerDispStr, (Object)jSONObject3);
                        }
                        if (jSONObject3 == null || jSONObject3.size() <= 0 || !jSONObject3.containsKey("status") || (jSONObject2 = (JSONObject)jSONObject3.get("status")) == null) continue;
                        object4 = "";
                        object2 = "";
                        object = "";
                        string2 = "";
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        if (jSONObject2.containsKey("id") && (object = jSONObject2.get("id").toString()) != null && ((String)object).length() >= 13) {
                            object = ((String)object).substring(0, 12);
                        }
                        if (jSONObject2.containsKey("labels") && (object8 = (JSONObject)jSONObject2.get("labels")) != null) {
                            if (object8.containsKey("io.kubernetes.container.name")) {
                                object4 = object8.get("io.kubernetes.container.name").toString();
                            }
                            if (object8.containsKey("io.kubernetes.pod.name")) {
                                object2 = object8.get("io.kubernetes.pod.name").toString();
                            }
                            if (object8.containsKey("io.kubernetes.pod.namespace")) {
                                string2 = object8.get("io.kubernetes.pod.namespace").toString();
                            }
                        }
                        if (jSONObject2.containsKey("annotations") && (object8 = (JSONObject)jSONObject2.get("annotations")) != null && object8.containsKey("io.kubernetes.container.ports") && (object6 = this.stringToJSONArray((String)(object5 = (String)object8.get("io.kubernetes.container.ports")))) != null && object6.size() > 0) {
                            for (int j = 0; j < object6.size(); ++j) {
                                jSONObject = (JSONObject)object6.get(j);
                                if (!jSONObject.containsKey("containerPort")) continue;
                                try {
                                    object7 = (Long)jSONObject.get("containerPort");
                                    if (object7 == null) continue;
                                    arrayList3.add(((Long)object7).toString());
                                    continue;
                                }
                                catch (Exception exception) {
                                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do stringToJSON() : {}", (Object)loggerDispStr, (Object)exception);
                                }
                            }
                        }
                        if (ApmConfigManager.getInstance().isLogBigSizeObjects()) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} containerName : {}, podName : {}, containerID : {}, port: {}", new Object[]{loggerDispStr, object4, object2, object, arrayList3});
                        }
                        object8 = this.trimTo12Char((String)object);
                        object5 = new ContainerInfo((String)object8);
                        if (arrayList3 != null && arrayList3.size() > 0) {
                            object6 = this.getHighPriorityPort(arrayList3);
                            try {
                                this.ht_containerIdAndPort.put(object8, object6);
                            }
                            catch (Exception exception) {
                                APMDiscoveryLogger.discoveryLogger.warn("{} Exception : {}", (Object)loggerDispStr, (Object)exception);
                            }
                            ((ContainerInfo)object5).setPort((String)object6);
                            ((ContainerInfo)object5).setPorts(arrayList3);
                        }
                        if (object8 != null && object2 != null && ((String)object2).length() > 0) {
                            try {
                                this.ht_containerIdAndPodName.put(object8, object2);
                            }
                            catch (Exception exception) {
                                APMDiscoveryLogger.discoveryLogger.warn("{} Exception : {}", (Object)loggerDispStr, (Object)exception);
                            }
                            ((ContainerInfo)object5).setPodName((String)object2);
                        }
                        if (object8 != null && string2 != null && string2.length() > 0) {
                            try {
                                this.ht_containerIdAndNameSpace.put(object8, string2);
                            }
                            catch (Exception exception) {
                                APMDiscoveryLogger.discoveryLogger.warn("{} Exception : {}", (Object)loggerDispStr, (Object)exception);
                            }
                            ((ContainerInfo)object5).setNameSpace(string2);
                        }
                        if (object8 != null && object4 != null && ((String)object4).length() > 0) {
                            ((ContainerInfo)object5).setName((String)object4);
                        }
                        try {
                            JSONObject jSONObject4;
                            if (!jSONObject3.containsKey("info") || (object6 = (JSONObject)jSONObject3.get("info")) == null || !object6.containsKey("runtimeSpec") || (jSONObject4 = (JSONObject)object6.get("runtimeSpec")) == null || !jSONObject4.containsKey("annotations") || (jSONObject = (JSONObject)jSONObject4.get("annotations")) == null || !jSONObject.containsKey("io.kubernetes.cri-o.IP.0") || (object7 = (String)jSONObject.get("io.kubernetes.cri-o.IP.0")) == null || !IPV6Helper.validateIPV4(((String)object7).trim())) break block50;
                            try {
                                this.ht_runningContainerIpMap.put(object8, object7);
                            }
                            catch (Exception exception) {
                                APMDiscoveryLogger.discoveryLogger.warn("{} Exception : {}", (Object)loggerDispStr, (Object)exception);
                            }
                            ((ContainerInfo)object5).setIp((String)object7);
                            object3 = object7;
                            APMDiscoveryLogger.discoveryLogger.debug("{} getContainerIpWithRetry() update_19-july-2021 Container IP discovered , container ID : {}, IP : {}, nameSpace : {}, port : {}, podName:{}, containerName :{}", new Object[]{loggerDispStr, object8, object7, string2, arrayList3, object2, object4});
                        }
                        catch (Exception exception) {
                            APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get IP address", (Object)loggerDispStr, (Object)exception);
                        }
                    }
                    if (((String)object3).length() != 0) continue;
                    this.getPodIpUsingK8sApi((ContainerInfo)object5);
                    object6 = ((ContainerInfo)object5).getIp();
                    if (object6 == null || ((String)object6).length() <= 0) continue;
                    object3 = object6;
                    continue;
                }
                catch (Exception exception) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get container ports in crio host : {}", (Object)loggerDispStr, (Object)exception);
                }
            }
        }
        return object3;
    }

    public static void main(String[] stringArray) {
    }
}

