/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMLanguage;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.ClientSocketListener;
import com.eg.apm.ComponentWatcherTracker;
import com.eg.apm.ContainersService;
import com.eg.apm.SocketIpSelectorUtil;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BaseThreadPoolManager;
import com.eg.jtm.NodeThreadPoolManager;
import com.eg.jtm.ThreadPoolManager;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Date;
import org.apache.commons.configuration.PropertiesConfiguration;

public abstract class AgentSocketServer {
    private static final String logPrefix = " [AgentSocketServer] ";
    private static final long AGENT_SOCKET_RETRY_SLEEP_DURATION = 1000L;
    private static final int AGENT_SOCKET_MAX_RETRY_ATTEMPTS = 0;
    private ServerSocket serverSocket = null;
    private BaseThreadPoolManager threadPoolManager = null;

    public AgentSocketServer() {
        ComponentWatcherTracker.isWatcherNull(true);
    }

    private void closeServerSocket(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                if (!serverSocket.isClosed()) {
                    serverSocket.close();
                }
            }
            catch (IOException ioe) {
                AgentStartupLogger.logger.error("{} I/O Error when try to close server socket port  : {} ", (Object)logPrefix, (Object)ioe);
            }
        }
        serverSocket = null;
    }

    protected ServerSocket createServerSocket(ServerSocket serverSocket, int serverSocketPort, String bindIp) {
        this.closeServerSocket(serverSocket);
        try {
            serverSocket = new ServerSocket();
            serverSocket.bind(new InetSocketAddress(bindIp, serverSocketPort));
            AgentStartupLogger.logger.info("{} BTM Offload Server Socket is listening on bindIp: {} \t serverSocketPort: {} ", new Object[]{logPrefix, bindIp, serverSocketPort});
            return serverSocket;
        }
        catch (IOException ioe) {
            System.err.println("BTM Offload - Unable to create agent server socket on port :" + serverSocketPort + ". Port may be already in use. " + ioe.getMessage());
            AgentStartupLogger.logger.error("{} BTM Offload - Unable to create agent server socket on port : {} \t . Port may be already in use. {} ", new Object[]{logPrefix, serverSocketPort, ioe});
        }
        catch (SecurityException se) {
            System.err.println("BTM Offload - Security Manager settings not allowing to create server socket " + se.getMessage());
            AgentStartupLogger.logger.error("{} BTM Offload - Security Manager settings not allowing to create server socket{}", (Object)logPrefix, (Object)se);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("BTM Offload - Specified server socket port " + serverSocketPort + " is out of range or invalid " + iae.getMessage());
            AgentStartupLogger.logger.error("{} Given agent server socket port is out of range or invalid :{} {}", new Object[]{logPrefix, serverSocketPort, iae});
        }
        catch (Exception e) {
            System.err.println("BTM Offload - Unable to create server socket due to " + e.getMessage());
            AgentStartupLogger.logger.error("{} BTM Offload - Unable to create server socket due to {}", (Object)logPrefix, (Object)e);
        }
        return null;
    }

    protected void sleepMethod(long sleeptime) {
        try {
            Thread.sleep(sleeptime);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to sleep   : {}", (Object)logPrefix, (Object)e);
        }
    }

    protected boolean createServerSocket(BTMOffloadAPMSocketConfiguration configuration, int offloadPort, boolean isContainerZHost, APMLanguage language) {
        boolean isCreated = false;
        try {
            boolean bindLocalOnly = configuration.isBindLocalHostOnly();
            SocketIpSelectorUtil socketIpSelectorUtil = SocketIpSelectorUtil.getInstance();
            AgentStartupLogger.logger.info("{} isBindLocalHostOnly? {} , isContainerZHost? {} , isContainerHostIpAvailable? {} ", new Object[]{logPrefix, bindLocalOnly, isContainerZHost, socketIpSelectorUtil.isContainerHostIpAvailable()});
            String bindIP = this.getBindIP(configuration, socketIpSelectorUtil, isContainerZHost, bindLocalOnly);
            AgentStartupLogger.logger.info("{} Bind IP is {} ", (Object)bindIP);
            isCreated = this.isSocketCreated(configuration, isContainerZHost, offloadPort, bindIP, socketIpSelectorUtil, language);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isCreated;
    }

    protected boolean doReattempt(BTMOffloadAPMSocketConfiguration configuration, int offloadPort, boolean isContainerZHost, APMLanguage language) {
        int retryCounter = 1;
        boolean created = false;
        while (!created) {
            this.sleepMethod(1000L);
            created = this.createServerSocket(configuration, offloadPort, isContainerZHost, language);
            if (created || retryCounter > 0) break;
            ++retryCounter;
        }
        return created;
    }

    protected void initializePoolsAndListeners(int workers, int queueSize, APMLanguage language) {
        if (language == APMLanguage.JAVA) {
            this.threadPoolManager = ThreadPoolManager.getInstance();
        } else if (language == APMLanguage.NODEJS) {
            this.threadPoolManager = NodeThreadPoolManager.getInstance();
        } else {
            System.err.println("APM Language(" + (Object)((Object)language) + ") is not supported. So not initialining thread pools, etc. Exiting !!!");
            return;
        }
        this.threadPoolManager.start(workers, queueSize);
        ClientSocketListener listener = new ClientSocketListener(this.serverSocket, language);
        Thread clientSocketListenerThread = new Thread(listener);
        clientSocketListenerThread.setName("Client Socket Listener - " + (Object)((Object)language));
        clientSocketListenerThread.setDaemon(true);
        clientSocketListenerThread.start();
    }

    protected int getPortNo(String portString) {
        int port_no = -1;
        try {
            port_no = Integer.parseInt(portString);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.warn("{} Invalid Port No ({}) is specified.", (Object)logPrefix, (Object)port_no);
            port_no = -1;
        }
        if (port_no <= 1024) {
            AgentStartupLogger.logger.warn("{} Invalid Port No ({}) is specified.", (Object)logPrefix, (Object)port_no);
            port_no = -1;
        }
        return port_no;
    }

    protected void closeServerSocket() {
        if (this.serverSocket != null) {
            try {
                if (!this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                    this.serverSocket = null;
                    AgentStartupLogger.logger.warn("{} eG APM - Java/NodeJS BTM Offload Server Socket Closed", (Object)logPrefix);
                }
            }
            catch (IOException ioe) {
                AgentStartupLogger.logger.error("{} I/O Error when try to close Java/NodeJS server socket port  : ", (Object)logPrefix, (Object)ioe);
            }
        }
        if (this.threadPoolManager != null) {
            this.threadPoolManager.clearThreadPoolManager();
            this.threadPoolManager = null;
            AgentStartupLogger.logger.warn("{} Cleared ThreadPoolManager for eG APM - Java/NodeJS", (Object)logPrefix);
        }
    }

    protected boolean isServerSocketCreated() {
        return this.serverSocket != null;
    }

    private boolean isSocketCreated(BTMOffloadAPMSocketConfiguration configuration, boolean isContainerZHost, int offloadPort, String bindIP, SocketIpSelectorUtil socketIpSelectorUtil, APMLanguage language) {
        boolean created = false;
        if (offloadPort != -1) {
            this.serverSocket = this.createServerSocket(this.serverSocket, offloadPort, bindIP);
        }
        if (this.serverSocket != null) {
            created = true;
            System.out.println(new Date() + logPrefix + " BTM Offload Server Socket running on IP -  " + bindIP + " found from, " + configuration.getIpDecidedFrom() + " and Port :" + offloadPort + " found From : " + configuration.getPortDecidedFrom());
            AgentStartupLogger.logger.warn("{} INFO :- BTM Offload Server Socket running on IP - {} found from {}, port - {} found from {}", new Object[]{logPrefix, bindIP, configuration.getIpDecidedFrom(), offloadPort, configuration.getPortDecidedFrom()});
            if (language == APMLanguage.JAVA && (isContainerZHost || socketIpSelectorUtil.isAgentIPAssignedAsBindIp() || configuration.isCustomIPAvailable() || configuration.isCustomPortAvailable() || socketIpSelectorUtil.isContainerHostIpAvailable())) {
                this.updateBtmFiles(bindIP, offloadPort);
            }
            socketIpSelectorUtil.setListeningIp(bindIP);
        }
        return created;
    }

    private String getBindIP(BTMOffloadAPMSocketConfiguration configuration, SocketIpSelectorUtil socketIpSelectorUtil, boolean isContainerZHost, boolean bindLocalOnly) {
        String bindIP = configuration.getOffloadServerSocketIP();
        if (configuration.isCustomIPAvailable()) {
            bindIP = configuration.getCustomOffloadServerSocketIP();
        } else if (isContainerZHost && socketIpSelectorUtil.isContainerHostIpAvailable()) {
            bindIP = socketIpSelectorUtil.getContainerHostIp();
        } else if (!bindLocalOnly) {
            bindIP = "0.0.0.0";
        } else if (bindLocalOnly) {
            bindIP = "127.0.0.1";
        }
        return bindIP;
    }

    private void updateMountPathConfigs(String bindIP, int port_no) {
        ContainersService containersService = ContainersService.getInstance();
        AgentStartupLogger.logger.warn("{} [EG_EVENT_INFO] eG Agent is running as a DAEMON-SET : {},  Container Runtime exits : {} !!!", new Object[]{logPrefix, containersService.isDaemonSet(), containersService.isContainerZ()});
        if (containersService.isValidForMountPath()) {
            String mountPath = String.valueOf(containersService.getMountPath()) + "/config.props";
            boolean isMountPathAvailable = false;
            boolean canWrite = false;
            try {
                File file = new File(mountPath);
                if (file.exists()) {
                    isMountPathAvailable = true;
                    if (file.canWrite()) {
                        canWrite = true;
                    }
                }
            }
            catch (Exception e) {
                AgentStartupLogger.logger.warn("{} Unable to find mount path  {} ", new Object[]{logPrefix, mountPath, e});
            }
            AgentStartupLogger.logger.warn("{} [EG_EVENT_INFO] {} - isMountPathAvailable : {} , canWrite : {} ", new Object[]{logPrefix, mountPath, isMountPathAvailable, canWrite});
            if (isMountPathAvailable && canWrite) {
                this.updateToOffloadConfigProperties(mountPath, bindIP, port_no);
            } else {
                AgentStartupLogger.logger.warn("{}  eG Agent running as a daemonset, but unable to find {} path to update the offload socket ip details", (Object)logPrefix, (Object)mountPath);
            }
        }
    }

    private void updateToOffloadConfigProperties(String propsFilePath, String bindIP, int port_no) {
        try {
            PropertiesConfiguration properties = new PropertiesConfiguration(propsFilePath);
            properties.setProperty("AGENT_PORT", (Object)port_no);
            properties.setProperty("AGENT_IP", (Object)bindIP);
            properties.setProperty("AGENT_CONTAINER_IP", (Object)bindIP);
            properties.save();
            AgentStartupLogger.logger.warn("{} [EG_EVENT_INFO] - {} - Bind IP : {}, Port: {}  - updated Successfully!!", new Object[]{logPrefix, properties.getFileName(), bindIP, port_no});
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Exception Occurred while updating config.props {} ", (Object)logPrefix, (Object)e);
        }
    }

    private void updateBtmFiles(String bindIP, int port_no) {
        System.out.println("update btm files ");
        try {
            String btmPropsDir4Zip = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.apmOffloadFolderPath;
            String propsFilePath = String.valueOf(btmPropsDir4Zip) + "default" + BTMConstants.fileSeperator + "config.props";
            this.updateToOffloadConfigProperties(propsFilePath, bindIP, port_no);
            this.updateMountPathConfigs(bindIP, port_no);
            APMFileOperations apm = new APMFileOperations();
            String tempPath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.apmOffloadFilePathTemp + "ipupdate";
            String zipFilePath = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.javaApmSrcZipFilePath;
            String zipFilePathBkp = String.valueOf(EgInstallInfo.getInstallDir()) + BTMConstants.apmOffloadFolderPath + "btm_default.zip";
            File btm = new File(zipFilePathBkp);
            if (!btm.exists()) {
                apm.copyFile(new File(zipFilePath), btm);
            }
            apm.unZip(zipFilePath, tempPath);
            String propsFilePathTemp = String.valueOf(tempPath) + BTMConstants.fileSeperator + "config.props";
            this.updateToOffloadConfigProperties(propsFilePathTemp, bindIP, port_no);
            apm.zipDirectory(new File(tempPath), zipFilePath);
            apm.deleteDirectory(tempPath);
            System.out.println("update btm files finished");
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Exception Occurred while updating btm files {} ", (Object)logPrefix, (Object)e);
        }
    }
}

