/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMLanguage;
import com.eg.apm.APMQueue;
import com.eg.apm.APMUtils;
import com.eg.apm.APMWorkerHelper;
import com.eg.apm.AppTierName;
import com.eg.apm.JVMDataRepository;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaAPMExceptionObject;
import com.eg.apm.JavaAPMStatusCodeObject;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.Status;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.UPDManager;
import com.eg.jtm.URLPatternData;
import com.eg.jvmmonitor.JVMMetricData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APMWorker
implements Runnable {
    protected APMQueue<Object> myQueue;
    public static int counter = 1;
    private String loggerDispStr = "[APMWorker]";
    private boolean runThis = true;

    public APMWorker(APMQueue<Object> myQueue2) {
        this.myQueue = myQueue2;
    }

    @Override
    public void run() {
        this.loggerDispStr = "[APMWorker] [" + Thread.currentThread().getName() + "] ";
        do {
            try {
                boolean end = false;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} runThis : {}", (Object)this.loggerDispStr, (Object)this.runThis);
                while (!end && this.runThis) {
                    try {
                        Object obj = this.myQueue.dequeue(true);
                        if (obj instanceof MethodInfo) {
                            MethodInfo methodInfo = (MethodInfo)obj;
                            if (methodInfo != null) {
                                this.processMethodInfo(methodInfo);
                            }
                        } else if (obj instanceof JVMMetricData) {
                            try {
                                JVMMetricData jvmData = (JVMMetricData)obj;
                                this.processJvmMetricData(jvmData);
                            }
                            catch (Exception e) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to parse JVMMetricData object completely... {}", (Object)this.loggerDispStr, (Object)e);
                            }
                        } else if (obj instanceof HashMap) {
                            HashMap discoveryData = (HashMap)obj;
                            String jvmGUID = (String)discoveryData.get("JvmGUID");
                            this.processAutoDiscovery(discoveryData, jvmGUID);
                        } else {
                            this.sleep(10L);
                        }
                    }
                    catch (Exception e) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to parse apm object completely... {}", (Object)this.loggerDispStr, (Object)e);
                        end = true;
                    }
                    this.sleep(1L);
                }
                this.sleep(1000L);
            }
            catch (Exception e) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occured in the worker thread {}", (Object)this.loggerDispStr, (Object)e);
                break;
            }
            this.sleep(100L);
        } while (this.runThis);
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Worker exiting - runThis : {}", (Object)this.loggerDispStr, (Object)this.runThis);
    }

    private void processJvmMetricData(JVMMetricData jvmData) {
        if (jvmData != null) {
            Map rootProps = jvmData.getProperties();
            String jvmGUID = (String)rootProps.get("JvmGUID");
            Hashtable jvmMetrictable = (Hashtable)rootProps.get("JVM");
            if (jvmMetrictable != null) {
                JVMDataRepository.getDataRepository().setData(jvmGUID, jvmMetrictable);
            }
        }
    }

    private void processAutoDiscovery(Map discoveryData, String nodeID) {
        try {
            String containerName = (String)discoveryData.get("CONTAINER_NAME");
            if (containerName != null && containerName.trim().length() > 0) {
                APMDiscoveryHelper.storeAutoDiscoveryDetails(discoveryData, nodeID);
            } else {
                APMDiscoveryLogger.discoveryLogger.debug("{} Discovery data received seems to be invalid, Hence discarding the discoverd details for {}, discovered data - {} ", new Object[]{this.loggerDispStr, nodeID, discoveryData});
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while getting auto discovery details !!.. so set the default value... {}", (Object)this.loggerDispStr, (Object)e);
        }
    }

    private void processMethodInfo(MethodInfo methodInfo) {
        try {
            String patternObject;
            Map rootProps = methodInfo.getProperties();
            String jvmGuid = (String)rootProps.get("JvmGUID");
            String nodeId = (String)rootProps.get("NodeID");
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} NodeID : {} , JvmGUID : {} & Main Props : {}", new Object[]{this.loggerDispStr, nodeId, jvmGuid, rootProps});
            APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(jvmGuid);
            if (component == null) {
                return;
            }
            if (rootProps.containsKey("is404Request") && ((Boolean)rootProps.get("is404Request")).booleanValue()) {
                this.processStatusCodeDetails(rootProps, component, true);
                return;
            }
            String patternString = (String)rootProps.get("PS");
            if (patternString == null && component.isDiscoverdAndManagedComponent()) {
                String jmxPort = (String)rootProps.get("CONTAINER_JMX_PORT");
                String httpPortList = "";
                ArrayList portList = (ArrayList)rootProps.get("CONTAINER_HTTP_HTTPS_PORT_LIST");
                if (portList != null) {
                    httpPortList = portList.toString();
                }
                APMDiscoveryHelper.storeJmxPortDetails(component.getNickWithPortWithType(), jmxPort, httpPortList, jvmGuid);
                return;
            }
            if (APMUtils.isDetailsAvailable(rootProps, "TRANSACTION_FLOW_DETAILS")) {
                JavaTransactionFlowUtility.retriveTransactionFlowDetails(rootProps, jvmGuid);
                String reqIdWithNodeOrder = methodInfo.getGuidString();
                this.updateAutoNamingTables(nodeId, reqIdWithNodeOrder, patternString);
                this.checkAppnameTiername(rootProps, nodeId);
            }
            this.updateCommonJVMDetails(component, rootProps);
            boolean firstNode = (Boolean)rootProps.get("firstNode");
            boolean keyTransaction = (Boolean)rootProps.get("keyTransaction");
            String requestType = (String)rootProps.get("requestType");
            long cpuTime = (Long)rootProps.get("cpuTime");
            long blockedTime = (Long)rootProps.get("blockedTime");
            long waitedTime = (Long)rootProps.get("waitedTime");
            if (JavaBTMOffloadLogger.btmOffLoadLogger.isDebugEnabled()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL : {} \t Response Time :  {} ", new Object[]{this.loggerDispStr, methodInfo.getRawURL(), methodInfo.getExecutionTime()});
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} isFirstNode -   {}, keyTransaction -  {}, requestType -   {}", new Object[]{this.loggerDispStr, firstNode, keyTransaction, requestType});
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} CPU time -   {}, Blocked time -   {}, Waited time -   {}", new Object[]{this.loggerDispStr, cpuTime, blockedTime, waitedTime});
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} methodInfo.isErrorURL() - {}, methodInfo.isSlowURL() - {}, methodInfo.isStalled() - {}", new Object[]{this.loggerDispStr, methodInfo.isErrorURL(), methodInfo.isSlowURL(), methodInfo.isStalled()});
            }
            UPDManager updTemp = component.getUPDManager();
            if (keyTransaction) {
                patternObject = updTemp.manualPatternTable.get(patternString);
                if (patternObject == null) {
                    updTemp.manualPatternTable.put(patternString, patternString);
                    updTemp.updateTables4Manual();
                }
            } else {
                patternObject = updTemp.autoPatternTable.get(patternString);
                if (patternObject == null) {
                    updTemp.autoPatternTable.put(patternString, patternString);
                    updTemp.updateTables4Auto();
                }
            }
            this.processStatusCodeDetails(rootProps, component, false);
            if (methodInfo.isErrorURL()) {
                this.addToUPD(updTemp, methodInfo, firstNode, keyTransaction, requestType, cpuTime, blockedTime, waitedTime);
                ArrayList incomingList = (ArrayList)rootProps.remove("JAVA_EXCEPTION_DETAILS");
                if (incomingList != null && incomingList.size() > 0) {
                    String eGGUID = (String)rootProps.get("GUID");
                    JavaAPMExceptionObject javaApmExpObj = new JavaAPMExceptionObject(eGGUID, requestType, patternString, incomingList);
                    component.getApmRepositoryForException().addExceptions(javaApmExpObj);
                }
            } else if (methodInfo.isSlowURL()) {
                this.addToUPD(updTemp, methodInfo, firstNode, keyTransaction, requestType, cpuTime, blockedTime, waitedTime);
            } else if (methodInfo.isStalled()) {
                this.addStalledURLDetails(updTemp, methodInfo, firstNode, keyTransaction, requestType, cpuTime, blockedTime, waitedTime);
            } else {
                this.updateAllUrlDetails(updTemp, methodInfo, firstNode, keyTransaction, requestType, cpuTime, blockedTime, waitedTime);
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to parse Methodinfo object completely... {}", (Object)this.loggerDispStr, (Object)e);
        }
    }

    private void processStatusCodeDetails(Map rootProps, APMComponent component, boolean is404Request) {
        try {
            if (is404Request) {
                double[] requestDetails = (double[])rootProps.get("404RequestDetails");
                JavaAPMStatusCodeObject codeObject = new JavaAPMStatusCodeObject("404", requestDetails[0], requestDetails[1], true);
                component.getApmRepositoryForStatusCode().addStatusCodes(codeObject);
            } else {
                Object statusCodeValue = rootProps.get("STATUS");
                if (statusCodeValue != null && statusCodeValue.equals("-")) {
                    return;
                }
                int statusCode = (Integer)rootProps.get("STATUS");
                String statusMesage = (String)rootProps.get("STATUS_MESSAGE");
                if (statusMesage == null) {
                    statusMesage = "-";
                }
                boolean isErrorRedirectRequest = (Boolean)rootProps.remove("REDIRECTED_ERROR_PAGE");
                String patternString = (String)rootProps.get("PS");
                String reqGUID = (String)rootProps.get("GUID");
                JavaAPMStatusCodeObject codeObject = new JavaAPMStatusCodeObject(reqGUID, patternString, String.valueOf(statusCode), statusMesage, isErrorRedirectRequest);
                component.getApmRepositoryForStatusCode().addStatusCodes(codeObject);
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} exception while updating status code repository  {} ", (Object)this.loggerDispStr, (Object)e);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace(String.valueOf(this.loggerDispStr) + "{} updated status code details in status code repository for  {}", (Object)this.loggerDispStr, rootProps.get("requestID"));
    }

    private void checkAppnameTiername(Map rootProps, String nodeID) {
        try {
            String appnameFromJar = (String)rootProps.get("appName");
            appnameFromJar = appnameFromJar != null ? appnameFromJar : "";
            String tiernameFromJar = (String)rootProps.get("tierName");
            tiernameFromJar = tiernameFromJar != null ? tiernameFromJar : "";
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  appnameFromJar : {} , tiernameFromJar : {}  ", new Object[]{this.loggerDispStr, appnameFromJar, tiernameFromJar});
            AppTierName appTierNameObj = APMWorkerHelper.getInstance().getAppTierObject(nodeID);
            String appnameFromManager = appTierNameObj == null ? null : appTierNameObj.getAppName();
            appnameFromManager = appnameFromManager != null ? appnameFromManager : "";
            String tiernameFromManager = appTierNameObj == null ? null : appTierNameObj.getTierName();
            tiernameFromManager = tiernameFromManager != null ? tiernameFromManager : "";
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} appnameFromManager : {} , tiernameFromManager : {}  ", new Object[]{this.loggerDispStr, appnameFromManager, tiernameFromManager});
            String app = "none";
            String tier = "none";
            if (appnameFromJar.equals(appnameFromManager) && tiernameFromJar.equals(tiernameFromManager)) {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Both App and Tier name from JAR and MANAGER is same", (Object)this.loggerDispStr);
                return;
            }
            boolean updateMangerAppNamesIntoJar = false;
            boolean updateMangerTierNamesIntoJar = false;
            if (appnameFromManager.equals("MyApp") && !appnameFromJar.equals(appnameFromManager)) {
                app = appnameFromJar;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  appnameFromJar from JAR is not same, so using {} to update eg_apmTemp.ini", (Object)this.loggerDispStr, (Object)appnameFromJar);
            } else {
                updateMangerAppNamesIntoJar = true;
            }
            if (tiernameFromManager.equals("MyTier") && !tiernameFromJar.equals(tiernameFromManager)) {
                tier = tiernameFromJar;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  tiernameFromJar [{}] from JAR is not same, so using {} to update eg_apmTemp.ini", new Object[]{this.loggerDispStr, tiernameFromJar, tiernameFromManager});
            } else {
                updateMangerTierNamesIntoJar = true;
            }
            if (!app.equals("none") || !tier.equals("none")) {
                String componentype = appTierNameObj == null ? null : appTierNameObj.getAppName();
                componentype = componentype != null ? componentype : "Not_Found";
                JavaTransactionFlowUtility.storeAppTiernameIntoTemp(nodeID, componentype, String.valueOf(app) + ":" + tier);
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occured due to {} ", (Object)this.loggerDispStr, (Object)e);
        }
    }

    private void updateAutoNamingTables(String nodeID, String reqIDWithnodeOrder, String patternString) {
        StringBuilder nodeIDwithOrder = new StringBuilder();
        String nodeOrderOnly = reqIDWithnodeOrder.substring(reqIDWithnodeOrder.lastIndexOf("#~#") + 3);
        nodeIDwithOrder.append(nodeID);
        nodeIDwithOrder.append(">");
        nodeIDwithOrder.append(patternString);
        nodeIDwithOrder.append(">");
        nodeIDwithOrder.append(nodeOrderOnly);
        APMWorkerHelper helper = APMWorkerHelper.getInstance();
        String nodeIDwithOrderStr = nodeIDwithOrder.toString();
        Integer noOfReq = helper.getRequestCount(nodeIDwithOrderStr);
        if (!helper.isAvilableInComputedNodeOrders(nodeIDwithOrderStr) && noOfReq == null) {
            helper.addToAutoNameMap(nodeIDwithOrderStr, 1);
        } else if (noOfReq != null && noOfReq > 0 && noOfReq <= 100) {
            helper.addToAutoNameMap(nodeIDwithOrderStr, noOfReq + 1);
        } else if (helper.isAvilableInComputedNodeOrders(nodeIDwithOrderStr)) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} {} Node order reached maximum count limit,so discarding this node order ", (Object)this.loggerDispStr, (Object)nodeIDwithOrderStr);
            helper.removeFromAutoNameMap(nodeIDwithOrderStr);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} - {}", (Object)this.loggerDispStr, (Object)helper.toString());
    }

    private void updateCommonJVMDetails(APMComponent component, Map rootProps) {
        String[] sessionUserMapping;
        component.setHeartBeatStatus(Status.HEART_BEATING);
        String commonDetails = (String)rootProps.get("DataBaseHT");
        if (commonDetails != null && commonDetails.equalsIgnoreCase("true")) {
            String timezone = (String)rootProps.remove("TimeZone");
            String blockedtime = (String)rootProps.remove("blockedWaitedTimeNotSupported");
            String cputime = (String)rootProps.remove("cpuTimeNotSupported");
            Hashtable customPC = (Hashtable)rootProps.remove("CustomPC");
            component.setTimeZone(timezone);
            if (component.getAPMLanguage() == APMLanguage.JAVA) {
                JavaAPMComponent javaComponent = (JavaAPMComponent)component;
                javaComponent.setBlockedWaitNotSupported(blockedtime);
                javaComponent.setCpuTimeNotSupported(cputime);
                javaComponent.setCustomPointCuts(customPC);
            }
        }
        if ((sessionUserMapping = (String[])rootProps.remove("sessionUserMapping")) != null && sessionUserMapping.length > 0) {
            String userName = sessionUserMapping[0];
            String sessionId = sessionUserMapping[1];
            component.updateSessionUserMapping(sessionId, userName);
        }
    }

    protected void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateAllUrlDetails(UPDManager updTemp, MethodInfo Minfo, boolean firstNode, boolean keyTransaction, String requestType, long cpuTime, long blockedTime, long waitedTime) {
        block3: {
            try {
                String pName = Minfo.getUrlPatternsMatched();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL - {}   {}ms & matched patterns {}", new Object[]{this.loggerDispStr, Minfo.getProperties().get("requestID"), Minfo.getExecutionTime(), Minfo.getUrlPatternsMatched()});
                URLPatternData matchingUPD = (URLPatternData)updTemp.getUPDTblWC(keyTransaction).get(pName);
                if (matchingUPD != null) {
                    matchingUPD.updateAllUrlCount(Minfo, firstNode, requestType, cpuTime, blockedTime, waitedTime);
                }
            }
            catch (Exception e) {
                if (Minfo == null) break block3;
                Minfo.clearURLTree();
            }
        }
    }

    private void addToUPD(UPDManager updTemp, MethodInfo Minfo, boolean firstNode, boolean keyTransaction, String requestType, long cpuTime, long blockedTime, long waitedTime) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL - {}   {}ms & matched patterns {}", new Object[]{this.loggerDispStr, Minfo.getProperties().get("requestID"), Minfo.getExecutionTime(), Minfo.getUrlPatternsMatched()});
                String pName = Minfo.getUrlPatternsMatched();
                URLPatternData matchingUPD = (URLPatternData)updTemp.getUPDTblWC(keyTransaction).get(pName);
                if (matchingUPD != null) {
                    matchingUPD.addURLInfo(Minfo, firstNode, requestType, cpuTime, blockedTime, waitedTime);
                }
            }
            catch (Exception e) {
                if (Minfo == null) break block3;
                Minfo.clearURLTree();
            }
        }
    }

    public void addStalledURLDetails(UPDManager updTemp, MethodInfo Minfo, boolean firstNode, boolean keyTransaction, String requestType, long cpuTime, long blockedTime, long waitedTime) {
        block3: {
            try {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} URL - {}   {}ms & matched patterns {}", new Object[]{this.loggerDispStr, Minfo.getProperties().get("requestID"), Minfo.getExecutionTime(), Minfo.getUrlPatternsMatched()});
                String pName = Minfo.getUrlPatternsMatched();
                URLPatternData matchingUPD = (URLPatternData)updTemp.getUPDTblWC(keyTransaction).get(pName);
                if (matchingUPD != null) {
                    matchingUPD.addStalledURLInfo(Minfo, firstNode, requestType, cpuTime, blockedTime, waitedTime);
                }
            }
            catch (Exception e) {
                if (Minfo == null) break block3;
                Minfo.clearURLTree();
            }
        }
    }

    public void setRunThis(boolean runThis) {
        this.runThis = runThis;
    }
}

