/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.CompositeX509KeyManager;
import com.eg.CompositeX509TrustManager;
import com.eg.EgInstallInfo;
import com.eg.SSLStoreInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;

public class SSLContextProvider {
    public static SSLContext getContext() throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        char[] storepass = "egagentclientpass".toCharArray();
        String customJksPath = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/egagentclient.tks";
        FileInputStream fin = new FileInputStream(customJksPath);
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(fin, storepass);
        return SSLContextProvider.getContext(keyStore, storepass);
    }

    public static SSLContext getContext(boolean includeKeyStore) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        ArrayList<SSLStoreInfo> storeList = SSLContextProvider.getStoreDetails();
        return SSLContextProvider.getContext(storeList);
    }

    private static ArrayList<SSLStoreInfo> getStoreDetails() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ArrayList<SSLStoreInfo> storeList = new ArrayList<SSLStoreInfo>();
        char[] keyStorePass = "egagentpass".toCharArray();
        String customJksPath = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/egagent.jks";
        FileInputStream jksFin = new FileInputStream(customJksPath);
        KeyStore jksKeyStore = KeyStore.getInstance("JKS");
        jksKeyStore.load(jksFin, keyStorePass);
        SSLStoreInfo keyStoreInfo = new SSLStoreInfo(jksKeyStore, keyStorePass);
        char[] trustStorePass = "egagentclientpass".toCharArray();
        String customTksPath = String.valueOf(EgInstallInfo.getInstallDir()) + "/agent/egagentclient.tks";
        FileInputStream tksFin = new FileInputStream(customTksPath);
        KeyStore tksKeyStore = KeyStore.getInstance("JKS");
        tksKeyStore.load(tksFin, trustStorePass);
        SSLStoreInfo trustStoreInfo = new SSLStoreInfo(tksKeyStore, trustStorePass);
        storeList.add(keyStoreInfo);
        storeList.add(trustStoreInfo);
        return storeList;
    }

    private static SSLContext getContext(ArrayList<SSLStoreInfo> storeList) throws KeyManagementException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        ArrayList<X509KeyManager> keyManagerList = new ArrayList<X509KeyManager>();
        ArrayList<X509TrustManager> trustManagerList = new ArrayList<X509TrustManager>();
        X509KeyManager jvmKeyManager = SSLContextProvider.getKeyManager(defaultAlgorithm, null, null);
        X509TrustManager jvmTrustManager = SSLContextProvider.getTrustManager(defaultAlgorithm, null);
        keyManagerList.add(jvmKeyManager);
        trustManagerList.add(jvmTrustManager);
        int i = 0;
        while (i < storeList.size()) {
            SSLStoreInfo storeInfo = storeList.get(i);
            KeyStore keystore = storeInfo.getKeyStore();
            char[] password = storeInfo.getStorePass();
            X509KeyManager customKeyManager = SSLContextProvider.getKeyManager("SunX509", keystore, password);
            X509TrustManager customTrustManager = SSLContextProvider.getTrustManager("SunX509", keystore);
            keyManagerList.add(customKeyManager);
            trustManagerList.add(customTrustManager);
            ++i;
        }
        KeyManager[] keyManagers = new KeyManager[]{new CompositeX509KeyManager(keyManagerList)};
        TrustManager[] trustManagers = new TrustManager[]{new CompositeX509TrustManager(trustManagerList)};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    public static SSLContext getContext(KeyStore keystore, char[] password) throws KeyManagementException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
        X509KeyManager customKeyManager = SSLContextProvider.getKeyManager("SunX509", keystore, password);
        X509KeyManager jvmKeyManager = SSLContextProvider.getKeyManager(defaultAlgorithm, null, null);
        X509TrustManager customTrustManager = SSLContextProvider.getTrustManager("SunX509", keystore);
        X509TrustManager jvmTrustManager = SSLContextProvider.getTrustManager(defaultAlgorithm, null);
        KeyManager[] keyManagers = new KeyManager[]{new CompositeX509KeyManager((List)ImmutableList.of((Object)jvmKeyManager, (Object)customKeyManager))};
        TrustManager[] trustManagers = new TrustManager[]{new CompositeX509TrustManager((List)ImmutableList.of((Object)jvmTrustManager, (Object)customTrustManager))};
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, trustManagers, null);
        return context;
    }

    private static X509KeyManager getKeyManager(String algorithm, KeyStore keystore, char[] password) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(keystore, password);
        return (X509KeyManager)Iterables.getFirst((Iterable)Iterables.filter(Arrays.asList(factory.getKeyManagers()), X509KeyManager.class), null);
    }

    private static X509TrustManager getTrustManager(String algorithm, KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(keystore);
        return (X509TrustManager)Iterables.getFirst((Iterable)Iterables.filter(Arrays.asList(factory.getTrustManagers()), X509TrustManager.class), null);
    }
}

