/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigFilesSync;
import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class EgDbaseInfo {
    private IniFile dbaseFilePtr;
    private File dbaseFile;
    private long lastModifiedTime;
    private long lastSize;
    private String whoami;
    private String dbaseFileName;
    private String mySync = new String("mysync");
    private static String defaultTablesSection = "DEF_TABLES";
    private static String dynamicTablesSection = "DYN_TABLES";
    private static String partitionTablesSection = "PARTITIONED_TABLES";
    private static String configTestFieldSizeSection = "CONFIG_TEST_FIELD_SIZE";
    private static String mgrDetailsSection = "MANAGER_DETAILS";

    public static void main(String[] stringArray) {
        EgDbaseInfo egDbaseInfo = new EgDbaseInfo("manager");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgDbaseInfo(String string) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.dbaseFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDbaseConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDbaseConfigFile);
        egConfigInfo = null;
        this.dbaseFile = new File(this.dbaseFileName);
        String string2 = this.mySync;
        synchronized (string2) {
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgDbaseInfo(String string, boolean bl) {
        this.whoami = string;
        EgConfigInfo egConfigInfo = new EgConfigInfo(string);
        this.dbaseFileName = string.equals("agent") ? new String(EgConfigInfo.egAgentConfigDir + EgConfigInfo.egDbaseConfigFile) : new String(EgConfigInfo.egMgrConfigDir + EgConfigInfo.egDbaseConfigFile);
        egConfigInfo = null;
        this.dbaseFile = new File(this.dbaseFileName);
        String string2 = this.mySync;
        synchronized (string2) {
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName, bl);
        }
    }

    public long lastModified() {
        if (this.whoami.equals("agent")) {
            return this.dbaseFile.lastModified();
        }
        return IniFile.getLastModified(this.dbaseFileName);
    }

    public long lastSize() {
        if (this.whoami.equals("agent")) {
            return this.dbaseFile.length();
        }
        return IniFile.getLastSize(this.dbaseFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == this.lastModifiedTime && this.lastSize == l2) {
            return false;
        }
        String string = this.mySync;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l == this.lastModifiedTime && this.lastSize == l2) {
                return false;
            }
            this.lastModifiedTime = l;
            this.lastSize = l2;
            this.dbaseFilePtr = new IniFile(this.dbaseFileName);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        String string = this.mySync;
        synchronized (string) {
            this.dbaseFilePtr = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        String string = this.mySync;
        synchronized (string) {
            this.dbaseFilePtr = new IniFile(this.dbaseFileName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDefaultTables() {
        this.checkForUpdate();
        String string = this.mySync;
        synchronized (string) {
            return this.dbaseFilePtr.getVariables(defaultTablesSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getDynamicTables() {
        this.checkForUpdate();
        String string = this.mySync;
        synchronized (string) {
            return this.dbaseFilePtr.getVariables(dynamicTablesSection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPartitionTables() {
        this.checkForUpdate();
        String string = this.mySync;
        synchronized (string) {
            return this.dbaseFilePtr.getVariables(partitionTablesSection);
        }
    }

    public void addDynamicTable(String string) {
        this.addDynamicTable(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicTable(String string, String string2) {
        IniFile iniFile = EgConfigFilesSync.getInstance(this.dbaseFileName, true, false);
        iniFile.setValue(dynamicTablesSection, string, "true");
        if (string2 != null && string2.trim().length() != 0) {
            iniFile.setValue(partitionTablesSection, string, string2);
        }
        iniFile.saveFile();
        String string3 = this.mySync;
        synchronized (string3) {
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName);
        }
        EgConfigFilesSync.releaseInstance(this.dbaseFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPartitionTable(String string, String string2) {
        if (string2 != null && string2.trim().length() != 0) {
            IniFile iniFile = EgConfigFilesSync.getInstance(this.dbaseFileName, true, false);
            iniFile.setValue(partitionTablesSection, string, string2);
            iniFile.saveFile();
            String string3 = this.mySync;
            synchronized (string3) {
                this.lastModifiedTime = this.lastModified();
                this.lastSize = this.lastSize();
                this.dbaseFilePtr = new IniFile(this.dbaseFileName);
            }
            EgConfigFilesSync.releaseInstance(this.dbaseFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePartitionedDate(String string, String string2) {
        try {
            IniFile iniFile = EgConfigFilesSync.getInstance(this.dbaseFileName, true, false);
            iniFile.setValue(partitionTablesSection, string, string2);
            iniFile.saveFile();
            String string3 = this.mySync;
            synchronized (string3) {
                this.lastModifiedTime = this.lastModified();
                this.lastSize = this.lastSize();
                this.dbaseFilePtr = new IniFile(this.dbaseFileName);
            }
            EgConfigFilesSync.releaseInstance(this.dbaseFileName);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDynamicTable(String string) {
        IniFile iniFile = EgConfigFilesSync.getInstance(this.dbaseFileName, true, false);
        iniFile.deleteValue(dynamicTablesSection, string);
        iniFile.saveFile();
        String string2 = this.mySync;
        synchronized (string2) {
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName);
        }
        EgConfigFilesSync.releaseInstance(this.dbaseFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePartitionEntry(String string) {
        IniFile iniFile = EgConfigFilesSync.getInstance(this.dbaseFileName, true, false);
        iniFile.deleteValue(partitionTablesSection, string);
        iniFile.saveFile();
        String string2 = this.mySync;
        synchronized (string2) {
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName);
        }
        EgConfigFilesSync.releaseInstance(this.dbaseFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPartitionedDate(String string) {
        this.checkForUpdate();
        String string2 = this.mySync;
        synchronized (string2) {
            String string3 = this.dbaseFilePtr.getValue(partitionTablesSection, string);
            if (string3 == null || string3.trim().length() == 0) {
                return null;
            }
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConfigTestFieldSize(String string) {
        this.checkForUpdate();
        String string2 = this.mySync;
        synchronized (string2) {
            String string3 = this.dbaseFilePtr.getValue(configTestFieldSizeSection, string);
            if (string3 == null || string3.trim().length() == 0) {
                string3 = this.dbaseFilePtr.getValue(configTestFieldSizeSection, "Default");
            }
            try {
                return Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("[EgDbaseInfo]Invalid config test field size entry for " + string);
                return 512;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getConfigTestFieldSize() {
        this.checkForUpdate();
        String[] stringArray = null;
        Vector vector = null;
        String string = this.mySync;
        synchronized (string) {
            stringArray = this.dbaseFilePtr.getVariables(configTestFieldSizeSection);
            vector = this.dbaseFilePtr.getAllValues(configTestFieldSizeSection);
        }
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.get(i);
            if (string2 == null || string2.trim().length() <= 0) continue;
            try {
                hashtable.put(stringArray[i], new Integer(string2));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableExistInDB(String string) {
        this.checkForUpdate();
        String string2 = null;
        String string3 = this.mySync;
        synchronized (string3) {
            string2 = this.dbaseFilePtr.getValue(dynamicTablesSection, string);
        }
        return string2 != null && string2.length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDefaultTableExistInDB(String string) {
        String string2 = null;
        this.checkForUpdate();
        String string3 = this.mySync;
        synchronized (string3) {
            string2 = this.dbaseFilePtr.getValue(defaultTablesSection, string);
        }
        return string2 != null && string2.length() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManagerVersion() {
        this.checkForUpdate();
        String string = null;
        String string2 = this.mySync;
        synchronized (string2) {
            string = this.dbaseFilePtr.getValue(mgrDetailsSection, "ManagerVersion");
        }
        if (string == null || string.length() == 0) {
            return "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDefaultFileGroupName() {
        this.checkForUpdate();
        String string = this.mySync;
        synchronized (string) {
            return this.dbaseFilePtr.getValue("FILEGROUP_NAME_MAPPPING", "default");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileGroupName(String string) {
        this.checkForUpdate();
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = null;
        Vector vector = null;
        String string3 = this.mySync;
        synchronized (string3) {
            stringArray = this.dbaseFilePtr.getVariables("FILEGROUP_NAME_MAPPPING");
            vector = this.dbaseFilePtr.getAllValues("FILEGROUP_NAME_MAPPPING");
        }
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4 != null && string4.indexOf(",") != -1) {
                if (string4.indexOf(string) != -1) {
                    n = i;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                continue;
            }
            arrayList.add(string4);
        }
        if (arrayList != null && arrayList.size() > 0 && arrayList.contains(string)) {
            String string5 = this.mySync;
            synchronized (string5) {
                string2 = n == -1 ? this.dbaseFilePtr.getValue("FILEGROUP_NAME_MAPPPING", string) : (String)vector.get(n);
            }
        }
        if (string2 == null || string2.trim().length() == 0) {
            string2 = this.getDefaultFileGroupName();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDefaultTable(String string) {
        IniFile iniFile = EgConfigFilesSync.getInstance(this.dbaseFileName, true, false);
        iniFile.setValue(defaultTablesSection, string, "true");
        iniFile.saveFile();
        String string2 = this.mySync;
        synchronized (string2) {
            this.lastModifiedTime = this.lastModified();
            this.lastSize = this.lastSize();
            this.dbaseFilePtr = new IniFile(this.dbaseFileName);
        }
        EgConfigFilesSync.releaseInstance(this.dbaseFileName);
    }
}

