/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.CertificateVerificationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509Extensions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CRLVerifier {
    private CRLVerifier() {
    }

    public static void verifyCertificateCRLs(X509Certificate x509Certificate) throws CertificateVerificationException {
        try {
            List<String> list = CRLVerifier.getCrlDistributionPoints(x509Certificate);
            for (String string : list) {
                X509CRL x509CRL = CRLVerifier.downloadCRL(string);
                if (!x509CRL.isRevoked(x509Certificate)) continue;
                throw new CertificateVerificationException("The certificate is revoked by CRL: " + string);
            }
        }
        catch (Exception exception) {
            if (exception instanceof CertificateVerificationException) {
                throw (CertificateVerificationException)exception;
            }
            throw new CertificateVerificationException("Can not verify CRL for certificate: " + x509Certificate.getSubjectX500Principal());
        }
    }

    private static X509CRL downloadCRL(String string) throws IOException, CertificateException, CRLException, CertificateVerificationException, NamingException {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://")) {
            return CRLVerifier.downloadCRLFromWeb(string);
        }
        if (string.startsWith("ldap://")) {
            return CRLVerifier.downloadCRLFromLDAP(string);
        }
        throw new CertificateVerificationException("Can not download CRL from certificate distribution point: " + string);
    }

    private static X509CRL downloadCRLFromLDAP(String string) throws CertificateException, NamingException, CRLException, CertificateVerificationException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string);
        InitialDirContext initialDirContext = new InitialDirContext(hashtable);
        Attributes attributes = initialDirContext.getAttributes("");
        Attribute attribute = attributes.get("certificateRevocationList;binary");
        byte[] byArray = (byte[])attribute.get();
        if (byArray == null || byArray.length == 0) {
            throw new CertificateVerificationException("Can not download CRL from: " + string);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL downloadCRLFromWeb(String string) throws MalformedURLException, IOException, CertificateException, CRLException {
        URL uRL = new URL(string);
        InputStream inputStream = uRL.openStream();
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(inputStream);
            return x509CRL;
        }
        finally {
            inputStream.close();
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate x509Certificate) throws CertificateParsingException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
        if (byArray == null) {
            return new ArrayList<String>();
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray));
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        DEROctetString dEROctetString = (DEROctetString)aSN1Primitive;
        byte[] byArray2 = dEROctetString.getOctets();
        ASN1InputStream aSN1InputStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(byArray2));
        ASN1Primitive aSN1Primitive2 = aSN1InputStream2.readObject();
        CRLDistPoint cRLDistPoint = CRLDistPoint.getInstance((Object)aSN1Primitive2);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DistributionPoint distributionPoint : cRLDistPoint.getDistributionPoints()) {
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName == null || distributionPointName.getType() != 0) continue;
            GeneralName[] generalNameArray = GeneralNames.getInstance((Object)distributionPointName.getName()).getNames();
            for (int i = 0; i < generalNameArray.length; ++i) {
                if (generalNameArray[i].getTagNo() != 6) continue;
                String string = DERIA5String.getInstance((Object)generalNameArray[i].getName()).getString();
                arrayList.add(string);
            }
        }
        return arrayList;
    }
}

