/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ZeppelinBaseRESTExecutor {
    protected String userName = null;
    protected String password = null;
    protected static final String HYPHEN = "-";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String PROTOTYPE_HTTP = "http";
    protected static final String PROTOTYPE_HTTPS = "https";
    protected boolean isSSL = false;
    protected boolean isSSLEnabaled = false;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String COLONS = ":";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASIC = "Basic" + SPACE;
    protected static final String CONTENT_TYPE_KEY = "Content-Type";
    protected static final String CONTENT_TYPE_VALUE_JSON = "application/json";
    private long collectionTimeout = 120L;
    protected static final String REQUEST_METHOD_GET = "GET";
    protected static final String AUTHORIZATION = "Authorization";
    protected static final String CACHE_CONTROL = "Cache-Control";
    protected static final String CACHE_CONTROL_NO_CACHE = "no-cache";
    String protoType = "";
    boolean deep_debug = false;
    String baseURLString = null;
    String port = null;
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "ZeppelinBaseRESTExecutor";
    protected static final String LOG_FILE_NAME = "ZeppelinBaseLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "ZeppelinBaseRESTExecutorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "ZeppelinBaseLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 10.0;
    protected double debugLogSizeLimitInMB = 1.048576E7;
    private static final String ZEPPELIN_NOTEBOOK_SUFFIX = "/api/notebook";
    private static String ZEPPELIN_NOTEBOOK_DETAILS_SUFFIX = "/api/notebook";
    private static final String ZEPPELIN_REST_OUTPUT = "ZEPPELIN_REST_OUTPUT:";
    private static final String ZEPPELIN_NOTEBOOK_PREFIX = "ZEPPELIN_NOTEBOOK:";
    private static final String ZEPPELIN_PARAGRAPH_STATUS_PREFIX = "ZEPPELIN_PARAGRAPH_STATUS:";
    private static final String SEPERATOR_1 = "~#~";
    private static final String SEPERATOR_2 = "~!~";
    String className = this.getClass().getName();
    String targetHost = null;
    private static final int j = 124;
    String tmp_timeout = null;
    String reportingName = null;
    String entity = null;

    public ZeppelinBaseRESTExecutor(String[] stringArray) {
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                if (stringArray[i].equals("-reportingName") && i + 1 < stringArray.length) {
                    this.reportingName = new String(stringArray[++i]);
                    if (this.reportingName == null) continue;
                    this.reportingName = this.reportingName.trim();
                    continue;
                }
                if (stringArray[i].equals("-host") && i + 1 < stringArray.length) {
                    this.targetHost = new String(stringArray[++i]);
                    if (this.targetHost != null) {
                        this.targetHost = this.targetHost.trim();
                    }
                    this.logMessage = string + "Host        :" + this.targetHost;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-port") && i + 1 < stringArray.length) {
                    this.port = new String(stringArray[++i]);
                    if (this.isStringNull(this.port)) {
                        this.logMessage = string + "port is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "port        :" + this.port;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-username") && i + 1 < stringArray.length) {
                    this.userName = new String(stringArray[++i]);
                    if (this.isStringNull(this.userName)) {
                        this.logMessage = string + "User name is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.logMessage = string + "User name   :" + this.userName;
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-password") && i + 1 < stringArray.length) {
                    this.password = new String(stringArray[++i]);
                    if (this.isStringNull(this.password)) {
                        this.logMessage = string + "Password is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        continue;
                    }
                    this.password = this.password.trim();
                    this.password = this.decrypt(this.password);
                    this.logMessage = string + "Password    :*******";
                    this.printOut(this.logMessage);
                    this.logMessage = "";
                    continue;
                }
                if (stringArray[i].equals("-timeout") && i + 1 < stringArray.length) {
                    string2 = new String(stringArray[++i]);
                    this.printOut(string + "Timeout string is " + string2);
                    if (string2 != null && !string2.equals("120")) {
                        try {
                            this.collectionTimeout = Integer.parseInt(string2);
                            this.collectionTimeout *= 1000L;
                            this.printOut(string + "Timeout in Milliseconds is " + this.collectionTimeout);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.printOut(string + "Could not parse specified timeout " + string2 + ". Using 120 seconds");
                            this.collectionTimeout = 120000L;
                        }
                        continue;
                    }
                    this.collectionTimeout = 120000L;
                    continue;
                }
                if (stringArray[i].equals("-ssl") && i + 1 < stringArray.length) {
                    if ((string2 = new String(stringArray[++i])) != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes") || string2.equalsIgnoreCase("y"))) {
                        this.isSSL = true;
                        this.protoType = PROTOTYPE_HTTPS;
                        this.printOut(string + "Transport type is HTTPS");
                        continue;
                    }
                    this.isSSL = false;
                    this.protoType = PROTOTYPE_HTTP;
                    this.printOut(string + "Transport type is HTTP");
                    continue;
                }
                if (stringArray[i].equals("-entity") && i + 1 < stringArray.length) {
                    this.entity = new String(stringArray[++i]);
                    if (this.entity == null) continue;
                    this.entity = this.entity.trim();
                    continue;
                }
                if (!stringArray[i].equals("-log_size") || i + 1 >= stringArray.length) continue;
                if ((string2 = new String(stringArray[++i])) != null && string2.length() > 0) {
                    string2 = string2.trim();
                    try {
                        this.debugLogSizeLimitInMB = Double.parseDouble(string2);
                        this.debugLogSizeLimitInMB *= 1048576.0;
                    }
                    catch (Exception exception) {
                        this.printOut("[" + this.className + "]: [Constructor ]: strLogSizeLimitInMB : " + string2 + " ,exception :" + exception.toString());
                        this.debugLogSizeLimitInMB = 5000000.0;
                    }
                }
                this.printOut("[" + this.className + "]: [Constructor ]: debugLogSizeLimitInMB : " + this.debugLogSizeLimitInMB);
            }
            this.baseURLString = this.protoType + "://" + this.targetHost + COLONS + this.port;
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
    }

    public ArrayList getNotebookID(String string) {
        String string2 = "getNotebookID";
        string2 = this.methodNameTemplate(string2);
        this.printOut(string2 + "notebookJSON :" + string);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        JSONParser jSONParser = new JSONParser();
        JSONObject jSONObject = null;
        JSONArray jSONArray = null;
        JSONObject jSONObject2 = null;
        Object var8_8 = null;
        if (!this.isStringNull(string)) {
            try {
                jSONObject = (JSONObject)jSONParser.parse(string);
                this.printOut(string2 + "objJSON :" + jSONObject);
            }
            catch (ParseException parseException) {
                this.printOutStackTrace(string2 + "Error ", (Exception)((Object)parseException));
            }
            jSONArray = (JSONArray)jSONObject.get((Object)"body");
            if (!jSONArray.isEmpty() && jSONArray.size() >= 0) {
                for (int i = 0; i < jSONArray.size(); ++i) {
                    try {
                        jSONObject2 = (JSONObject)jSONArray.get(i);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    arrayList.add(jSONObject2.get((Object)"id"));
                }
            }
        }
        return arrayList;
    }

    protected void runThread(MonitoredThread monitoredThread, String string, long l) throws Exception {
        String string2 = "runThread";
        string2 = this.methodNameTemplate(string2);
        monitoredThread.start();
        long l2 = System.currentTimeMillis();
        long l3 = 20L;
        try {
            Thread.sleep(l3);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this.printOutStackTrace(string2, interruptedException);
        }
        long l4 = System.currentTimeMillis() - l2;
        while (monitoredThread.isAlive() && l4 < this.collectionTimeout) {
            this.printOut(string2 + "Thread " + string + " still alive");
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            l4 = System.currentTimeMillis() - l2;
        }
        boolean bl = false;
        String string3 = "";
        this.printOut(string2 + "mt.status   :" + monitoredThread.status);
        this.printOut(string2 + "mt.isAlive   :" + monitoredThread.isAlive());
        if (monitoredThread.isAlive()) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " timed out with exception.";
            } else {
                bl = true;
                string3 = " timed out.";
            }
        } else if (monitoredThread.status != 1) {
            if (monitoredThread.status == -1) {
                bl = true;
                string3 = " got done with exception.";
            } else {
                bl = true;
                string3 = " aborted without exception";
            }
        }
        this.printOut(string2 + "interruptThread   :" + bl);
        if (bl) {
            monitoredThread.interrupt();
            Thread.currentThread();
            Thread.yield();
            this.printOut(string2 + "Error: Thread " + string + " " + string3);
            this.putErrorMessageToLogfile("Thread " + string + string3);
            throw new Exception("Thread " + string + " " + string3);
        }
    }

    protected void collectDataFromZeppelinServer() {
        String string = "collectDataFromZeppelinServer";
        string = this.methodNameTemplate(string);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = NONE;
        ArrayList arrayList = new ArrayList();
        this.enableSSLForApacheZeppelinRESTAPI();
        long l = System.currentTimeMillis();
        this.printOut(string + "------------------------------------------------------------------------------------------------------------");
        try {
            DataCollectionThread dataCollectionThread = new DataCollectionThread(ZEPPELIN_NOTEBOOK_SUFFIX);
            this.runThread(dataCollectionThread, "createAndConnect", 20L);
            string2 = dataCollectionThread.getResponseString();
            arrayList = this.getNotebookID(string2);
            string2 = ZEPPELIN_NOTEBOOK_PREFIX + string2;
            this.printOut(string + "Client created and connected to " + this.targetHost + " service in " + (System.currentTimeMillis() - l) + "ms.");
            this.printOut(string + "Zeppelin Notebook JSON response >> " + string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace("Error while getting Zeppelin Notebook JSON response ,Exception details ", exception);
            return;
        }
        this.printOut(string + "------------------------------------------------------------------------------------------------------------");
        try {
            if (!this.isArrayListNull(arrayList)) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string6 = arrayList.get(i).toString();
                    if (string6.length() <= 0) continue;
                    ZEPPELIN_NOTEBOOK_DETAILS_SUFFIX = "/api/notebook/job/" + string6;
                    DataCollectionThread dataCollectionThread = new DataCollectionThread(ZEPPELIN_NOTEBOOK_DETAILS_SUFFIX);
                    this.runThread(dataCollectionThread, "createAndConnect", 20L);
                    string4 = dataCollectionThread.getResponseString();
                    string3 = string3 + string4 + SEPERATOR_2;
                }
                string3 = ZEPPELIN_PARAGRAPH_STATUS_PREFIX + string3;
                this.printOut(string + "Client created and connected to " + this.targetHost + " service in " + (System.currentTimeMillis() - l) + "ms.");
                this.printOut(string + "Zeppelin Paragraph status Detail JSON response >> " + string3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.printOutStackTrace("Error while getting Zeppelin Notebook Detail JSON response ,Exception details ", exception);
            return;
        }
        string5 = "ZEPPELIN_REST_OUTPUT:~#~" + string2 + SEPERATOR_1 + string3;
        System.out.println(string5);
    }

    public String replaceAll(String string, String string2, String string3) {
        String string4 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        try {
            string4 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            return string;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string4 = string4 + string3 + stringTokenizer.nextToken();
        }
        return string4;
    }

    public String decrypt(String string) {
        int n;
        if (string != null && string.length() < 2) {
            return string;
        }
        if (string != null && string.indexOf(COLONS) == -1) {
            return string;
        }
        ArrayList arrayList = this.myTokenizer(string, COLONS);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        int n2 = n = arrayList.size();
        byte[] byArray = new byte[n];
        String string2 = null;
        int n3 = n - 1;
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayList.get(i);
            int n4 = 0;
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                return string;
            }
            int n5 = 124 - n4 + n3 * 3;
            --n3;
            byArray[--n] = (byte)n5;
        }
        String string3 = new String(byArray);
        return string3;
    }

    private ArrayList myTokenizer(String string, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = 0;
        int n2 = string.indexOf(string2);
        while (n2 >= 0) {
            string3 = string.substring(n, n2);
            arrayList.add(string3);
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        string3 = string.substring(n);
        arrayList.add(string3);
        return arrayList;
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    void enableSSLForApacheZeppelinRESTAPI() {
        if (this.isSSL && !this.isSSLEnabaled) {
            String string = null;
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var4_4 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("SSL");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string = "[enableSSLForApacheZeppelinRESTAPI]";
                this.printOutStackTrace(string, noSuchAlgorithmException);
            }
            try {
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            }
            catch (KeyManagementException keyManagementException) {
                string = "[enableSSLForApacheZeppelinRESTAPI]";
                this.printOutStackTrace(string, keyManagementException);
            }
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
            this.isSSLEnabaled = true;
        }
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        ZeppelinBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        ZeppelinBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        ZeppelinBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void putErrorMessageToLogfile(String string) {
        ZeppelinBaseRESTExecutor.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            ZeppelinBaseRESTExecutor.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        ZeppelinBaseRESTExecutor zeppelinBaseRESTExecutor = new ZeppelinBaseRESTExecutor(stringArray);
        zeppelinBaseRESTExecutor.collectDataFromZeppelinServer();
    }

    class DataCollectionThread
    extends MonitoredThread {
        public String responseString = null;
        String urlSuffix = "";

        DataCollectionThread(String string) {
            this.urlSuffix = string;
        }

        public void run() {
            String string = "DataCollectionThread::run";
            string = ZeppelinBaseRESTExecutor.this.methodNameTemplate(string);
            try {
                this.setName("createAndConnect");
                String string2 = ZeppelinBaseRESTExecutor.this.baseURLString + this.urlSuffix;
                ZeppelinBaseRESTExecutor.this.printOut(string + "URL String   :" + string2);
                HttpURLConnection httpURLConnection = null;
                URL uRL = new URL(null, string2);
                String string3 = ZeppelinBaseRESTExecutor.this.userName + ZeppelinBaseRESTExecutor.COLONS + ZeppelinBaseRESTExecutor.this.password;
                String string4 = Base64Coder.encodeString(string3);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod(ZeppelinBaseRESTExecutor.REQUEST_METHOD_GET);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setConnectTimeout(15000);
                httpURLConnection.addRequestProperty(ZeppelinBaseRESTExecutor.CONTENT_TYPE_KEY, ZeppelinBaseRESTExecutor.CONTENT_TYPE_VALUE_JSON);
                httpURLConnection.setRequestProperty(ZeppelinBaseRESTExecutor.AUTHORIZATION, BASIC + string4);
                httpURLConnection.setRequestProperty(ZeppelinBaseRESTExecutor.CACHE_CONTROL, ZeppelinBaseRESTExecutor.CACHE_CONTROL_NO_CACHE);
                try {
                    httpURLConnection.connect();
                }
                catch (Exception exception) {
                    ZeppelinBaseRESTExecutor.this.printOutStackTrace(string + "Error while connect the server", exception);
                }
                int n = 0;
                try {
                    n = httpURLConnection.getResponseCode();
                    ZeppelinBaseRESTExecutor.this.logMessage = string + " and its Response code :" + n + " for the URL  :" + string2;
                    ZeppelinBaseRESTExecutor.this.printOut(ZeppelinBaseRESTExecutor.this.logMessage);
                    if (n > 300) {
                        ZeppelinBaseRESTExecutor.this.putInfoMessageToLogfile(ZeppelinBaseRESTExecutor.this.logMessage);
                    }
                    ZeppelinBaseRESTExecutor.this.logMessage = "";
                }
                catch (Exception exception) {
                    ZeppelinBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response code the server", exception);
                }
                InputStream inputStream = null;
                try {
                    inputStream = n == 200 ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
                    this.responseString = this.decodeResponse(inputStream);
                    this.status = 1;
                }
                catch (Exception exception) {
                    ZeppelinBaseRESTExecutor.this.printOutStackTrace(string + "Error while get the response info from the server", exception);
                }
                if (inputStream != null) {
                    this.status = 1;
                    ZeppelinBaseRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    ZeppelinBaseRESTExecutor.this.printOut(ZeppelinBaseRESTExecutor.this.logMessage);
                    ZeppelinBaseRESTExecutor.this.logMessage = "";
                    Map<String, List<String>> map = httpURLConnection.getHeaderFields();
                    ZeppelinBaseRESTExecutor.this.printOut(string + "getHeaderFields : " + map);
                    try {
                        inputStream.close();
                        inputStream = null;
                    }
                    catch (Exception exception) {
                        ZeppelinBaseRESTExecutor.this.printOutStackTrace(string + "Error while close the response", exception);
                    }
                }
                try {
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    ZeppelinBaseRESTExecutor.this.printOutStackTrace(string + "Error while disconnect", exception);
                }
                if (ZeppelinBaseRESTExecutor.this.deep_debug) {
                    ZeppelinBaseRESTExecutor.this.logMessage = string + " responseString :" + this.responseString;
                    ZeppelinBaseRESTExecutor.this.printOut(ZeppelinBaseRESTExecutor.this.logMessage);
                    ZeppelinBaseRESTExecutor.this.logMessage = "";
                }
            }
            catch (Exception exception) {
                ZeppelinBaseRESTExecutor.this.printOutStackTrace("Exception while delete the session ", exception);
                this.status = -1;
                exception.printStackTrace();
            }
        }

        protected String decodeResponse(InputStream inputStream) {
            String string = "decodeResponse";
            string = ZeppelinBaseRESTExecutor.this.methodNameTemplate(string);
            try {
                if (inputStream != null && inputStream.toString().trim().length() > 0) {
                    Scanner scanner = new Scanner(inputStream);
                    scanner.useDelimiter("\\A");
                    return scanner.hasNext() ? scanner.next() : "";
                }
                ZeppelinBaseRESTExecutor.this.logMessage = string + " Response is null or empty";
                ZeppelinBaseRESTExecutor.this.printOut(ZeppelinBaseRESTExecutor.this.logMessage);
                ZeppelinBaseRESTExecutor.this.putWarningMessageToLogfile(ZeppelinBaseRESTExecutor.this.logMessage);
                ZeppelinBaseRESTExecutor.this.logMessage = "";
            }
            catch (Exception exception) {
                ZeppelinBaseRESTExecutor.this.printOutStackTrace("Exception while decoding the  response", exception);
                exception.printStackTrace();
            }
            return null;
        }

        public String getResponseString() {
            String string = "getResponseString";
            string = ZeppelinBaseRESTExecutor.this.methodNameTemplate(string);
            this.responseString = ZeppelinBaseRESTExecutor.this.replaceAll(this.responseString, System.lineSeparator(), "");
            ZeppelinBaseRESTExecutor.this.printOut(string + "After decode for the method  " + string + "  ====> Response  : " + this.responseString);
            return this.responseString;
        }
    }

    abstract class MonitoredThread
    extends Thread {
        protected static final int UNSET = 0;
        protected static final int SUCCESS = 1;
        protected static final int ERR = -1;
        protected int status = 0;

        MonitoredThread() {
        }

        public abstract void run();
    }
}

