/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class WebServerTest
extends WebAdapterTest {
    private int connectionRateIndex = 0;
    private int requestRateIndex = 1;
    private int kbytesSentRateIndex = 2;
    private int kbytesRecvdRateIndex = 3;
    private int pctErrorsIndex = 4;
    private int pctAbortsIndex = 5;
    private int pct300sIndex = 6;
    private int pct400sIndex = 7;
    private int pct500sIndex = 8;
    private int numCurrentRequestsIndex = 9;
    private boolean debug = false;
    private int monitorPeriod = 0;
    private String fileName = null;
    private String index;
    private double[] totalResult;
    public long sharedMemPtr = -1L;
    private String shmString = null;
    private String hashCodeString = null;
    private String temp = null;
    ArrayList objectList = null;

    public native boolean detachSharedId(long var1);

    public native long checkShmid(int var1, boolean var2);

    public native boolean sendConfigInfo(int var1, long var2, int var4);

    public native boolean getResult(double[] var1, int var2, int var3, long var4);

    public static void main(String[] stringArray) {
        WebServerTest webServerTest = new WebServerTest(stringArray);
        webServerTest.executeTest();
        for (int i = 0; i < 5; ++i) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            webServerTest.executeTest();
        }
    }

    public WebServerTest(String[] stringArray) {
        super(stringArray);
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equalsIgnoreCase("-host")) {
                this.targetHost = new String(stringArray[++n]);
                bl = true;
                continue;
            }
            if (!stringArray[n].equalsIgnoreCase("-port")) continue;
            this.portNo = new String(stringArray[++n]);
            bl2 = true;
        }
        if (!bl || !bl2) {
            System.err.println("WebServerTest - incorrect arguments!");
            System.exit(-1);
        }
        this.numOutputFields = 10;
        this.totalResult = new double[this.numOutputFields];
        this.targetHost = new String(stringArray[1]);
        this.portNo = new String(stringArray[3]);
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase("-period")) continue;
            try {
                this.monitorPeriod = Integer.parseInt(stringArray[n + 1]);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        this.index = new String(this.siteName + siteAndInfoSeparator + infoFieldSeparator);
        this.hashCodeString = String.valueOf(this.hashCode());
        this.hashCodeString = this.hashCodeString.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTest() {
        if (this.debug) {
            System.out.println("STOPPING TEST with shmid " + this.shmId);
        }
        boolean bl = false;
        Hashtable hashtable = shmIdTestObjects;
        synchronized (hashtable) {
            this.objectList = (ArrayList)shmIdTestObjects.get(this.shmString);
            if (this.objectList != null && this.objectList.size() > 0 && this.objectList.contains(this.hashCodeString)) {
                int n = this.objectList.indexOf(this.hashCodeString);
                if (n != -1) {
                    this.objectList.remove(n);
                }
                if (this.objectList.size() == 0) {
                    bl = true;
                }
            }
        }
        this.shmId = -1;
        if (bl) {
            if (this.sharedMemPtr != -1L) {
                this.detachSharedId(this.sharedMemPtr);
            }
            hashtable = serverSharedId;
            synchronized (hashtable) {
                serverSharedId.remove(this.shmString);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTest() {
        if (this.sharedMemPtr != -1L) {
            this.detachSharedId(this.sharedMemPtr);
        }
        this.shmString = String.valueOf(this.shmId);
        this.shmId = -1;
        Hashtable hashtable = serverSharedId;
        synchronized (hashtable) {
            serverSharedId.remove(this.shmString);
        }
        hashtable = shmIdTestObjects;
        synchronized (hashtable) {
            shmIdTestObjects.remove(this.shmString);
        }
        this.shmString = String.valueOf(this.shmId);
    }

    public boolean getSharedId() {
        this.shmId = -1;
        super.searchFiles();
        this.shmString = String.valueOf(this.shmId);
        this.shmString = this.shmString.trim();
        return this.shmId != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeTest() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        this.initTest();
        if (!this.isFileExist()) {
            this.resetTest();
        }
        if (this.shmId == -1) {
            if (!this.getSharedId()) {
                this.errorMsg = "WebAdapterData file could not be opened for " + this.reportingName + ":" + this.portNo;
                this.updateAllResultSets();
                return false;
            }
            if (this.debug) {
                System.out.println("Shared mem Id " + this.shmId);
            }
            if (this.shmId == -1) {
                this.updateAllResultSets();
                return true;
            }
            try {
                Properties properties = serverSharedId;
                synchronized (properties) {
                    if (this.getExclusiveAccess()) {
                        if (!this.getAccess()) {
                            this.sharedMemPtr = this.checkShmid(this.shmId, false);
                            if (this.sharedMemPtr != -1L) {
                                String string = String.valueOf(this.sharedMemPtr);
                                serverSharedId.setProperty(this.shmString, string);
                            }
                        }
                    } else {
                        this.shmId = -1;
                        this.errorMsg = "getExclusiveAccess function failed ";
                        return false;
                    }
                    this.deleteLockFile();
                    if (this.sharedMemPtr == -1L) {
                        this.errorMsg = "Shared memory " + this.shmId + " not available for " + this.reportingName + ":" + this.portNo;
                        this.shmId = -1;
                        this.updateAllResultSets();
                        return false;
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                this.shmId = -1;
                this.errorMsg = "JNI Exception in checkShmid() ";
                if (this.debug) {
                    System.out.println("JNI Exception in checkShmid() for " + this.reportingName + ":" + this.portNo);
                    runtimeException.printStackTrace();
                }
                this.updateAllResultSets();
                return false;
            }
            if (this.getExclusiveAccess()) {
                if (!this.getAccess()) {
                    this.deleteLockFile();
                    this.shmId = -1;
                    return false;
                }
                if (!this.sendConfigInfo(this.shmId, this.sharedMemPtr, this.monitorPeriod)) {
                    this.resetTest();
                    this.updateAllResultSets();
                    this.deleteLockFile();
                    return false;
                }
                this.deleteLockFile();
            }
            try {
                if (this.getExclusiveAccess()) {
                    if (!this.getAccess()) {
                        this.deleteLockFile();
                        this.shmId = -1;
                        return false;
                    }
                    if (!this.getResult(this.totalResult, this.numStructures, this.shmId, this.sharedMemPtr)) {
                        this.resetTest();
                    }
                    this.deleteLockFile();
                }
            }
            catch (RuntimeException runtimeException) {
                this.resetTest();
                this.errorMsg = "JNI Exception in  getResult() for " + this.reportingName + ":" + this.portNo;
                if (this.debug) {
                    System.out.println("JNI Exception in getResult() ");
                    runtimeException.printStackTrace();
                }
                this.updateAllResultSets();
                return false;
            }
            this.updateAllResultSets();
            return true;
        }
        try {
            if (this.getExclusiveAccess()) {
                if (!this.getAccess()) {
                    this.shmId = -1;
                    this.deleteLockFile();
                    return false;
                }
                if (!this.getResult(this.totalResult, this.numStructures, this.shmId, this.sharedMemPtr)) {
                    if (this.debug) {
                        System.out.println("Shared memory Error for " + this.reportingName + ":" + this.portNo);
                    }
                    this.resetTest();
                    this.deleteLockFile();
                    return true;
                }
                this.deleteLockFile();
            }
        }
        catch (RuntimeException runtimeException) {
            this.resetTest();
            this.errorMsg = "JNI exception in getResult () for " + this.reportingName + ":" + this.portNo;
            if (this.debug) {
                System.out.println("JNI exception in getResult()");
                runtimeException.printStackTrace();
            }
            this.updateAllResultSets();
            return false;
        }
        if (this.totalResult[1] != 0.0) {
            d5 = this.totalResult[3] * 100.0 / this.totalResult[1];
            if (d5 < 0.0) {
                d5 = -5.0;
            }
            if ((d4 = this.totalResult[2] * 100.0 / this.totalResult[1]) < 0.0) {
                d4 = -5.0;
            }
            d3 = this.totalResult[7] * 100.0 / this.totalResult[1];
            d2 = this.totalResult[8] * 100.0 / this.totalResult[1];
            d = this.totalResult[9] * 100.0 / this.totalResult[1];
        } else {
            d5 = 0.0;
            d4 = 0.0;
            d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
        }
        if (this.timeSinceLastTest > 0.0) {
            double d6 = this.totalResult[0] / this.timeSinceLastTest;
            if (d6 < 0.0) {
                d6 = -5.0;
            }
            this.addValueToResultSet(this.index, this.connectionRateIndex, d6);
            d6 = this.totalResult[1] / this.timeSinceLastTest;
            if (d6 < 0.0) {
                d6 = -5.0;
            }
            this.addValueToResultSet(this.index, this.requestRateIndex, d6);
            double d7 = this.totalResult[4] / (this.timeSinceLastTest * 1024.0);
            if (d7 < 0.0) {
                d7 = -5.0;
            }
            this.addValueToResultSet(this.index, this.kbytesSentRateIndex, d7);
            d7 = this.totalResult[5] / (this.timeSinceLastTest * 1024.0);
            if (d7 < 0.0) {
                d7 = -5.0;
            }
            this.addValueToResultSet(this.index, this.kbytesRecvdRateIndex, d7);
        } else {
            this.addValueToResultSet(this.index, this.connectionRateIndex, -1.0);
            this.addValueToResultSet(this.index, this.requestRateIndex, -1.0);
            this.addValueToResultSet(this.index, this.kbytesSentRateIndex, -1.0);
            this.addValueToResultSet(this.index, this.kbytesRecvdRateIndex, -1.0);
        }
        this.addValueToResultSet(this.index, this.pctAbortsIndex, d4 > 100.0 ? 100.0 : d4);
        this.addValueToResultSet(this.index, this.pctErrorsIndex, d5 > 100.0 ? 100.0 : d5);
        this.addValueToResultSet(this.index, this.numCurrentRequestsIndex, -5.0);
        this.addValueToResultSet(this.index, this.pct300sIndex, d3 > 100.0 ? 100.0 : d3);
        this.addValueToResultSet(this.index, this.pct400sIndex, d2 > 100.0 ? 100.0 : d2);
        this.addValueToResultSet(this.index, this.pct500sIndex, d > 100.0 ? 100.0 : d);
        this.updateAllResultSets();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getAccess() {
        if (serverSharedId.containsKey(this.shmString)) {
            this.temp = serverSharedId.getProperty(this.shmString);
            this.sharedMemPtr = Long.parseLong(this.temp);
            Hashtable hashtable = shmIdTestObjects;
            synchronized (hashtable) {
                if (shmIdTestObjects.containsKey(this.shmString)) {
                    this.objectList = (ArrayList)shmIdTestObjects.get(this.shmString);
                    if (this.objectList != null && !this.objectList.contains(this.hashCodeString)) {
                        this.objectList.add(this.hashCodeString);
                    }
                } else {
                    this.objectList = new ArrayList();
                    this.objectList.add(this.hashCodeString);
                    shmIdTestObjects.put(this.shmString, this.objectList);
                }
            }
            return true;
        }
        return false;
    }

    static {
        System.loadLibrary("eg_reptr_total");
    }
}

