/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import com.eg.IPV6Helper;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WLJDBCTest
extends GenericTest {
    private double connectionsTotalCount_last = -5.0;
    private double leakedConnectionCount_last = -5.0;
    private double failuresToReconnectCount_last = -5.0;
    private Hashtable lastMeasures = new Hashtable();
    private Hashtable newLastMeasures = new Hashtable();
    private String s_useWarFile = "Yes";
    private String protocol = "t3";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    boolean isSsl = false;
    protected int weblogicVersion = 0;
    protected static final String EGURKHA_NAME = "egurkha";
    protected static final String EGURKHA_MONITOR = "monitoring";
    protected String user = "system";
    protected String password = "password";
    protected String server = "myserver";
    protected String ssl = "false";
    protected String url = "";
    private String tempHost = "";
    protected boolean useJMX = false;
    protected long jspTimeout = 60L;
    boolean useSSLTrustStoreFlag = false;
    String wlSSLTrustKeyStore = null;
    String customTrustKeyStoreFileName = null;
    String customTrustKeyStoreType = null;
    String customTrustKeyStorePassPhrase = null;

    public WLJDBCTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(12);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        String string2;
        String string3;
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.server = this.getValueForParam("server");
        this.ssl = this.getValueForParam("ssl");
        this.isSsl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("yes"));
        this.url = this.getValueForParam("url");
        this.s_useWarFile = this.getValueForParam("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
            if (this.isSsl) {
                this.wlSSLTrustKeyStore = this.getValueForParam("ssl_trust_key_store");
                System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is before check  " + this.wlSSLTrustKeyStore);
                if (this.wlSSLTrustKeyStore == null || this.wlSSLTrustKeyStore.equalsIgnoreCase("none") || this.wlSSLTrustKeyStore.equalsIgnoreCase("null") || this.wlSSLTrustKeyStore.trim().length() == 0) {
                    this.useSSLTrustStoreFlag = false;
                } else {
                    this.useSSLTrustStoreFlag = true;
                    this.wlSSLTrustKeyStore = this.wlSSLTrustKeyStore.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
                }
                this.customTrustKeyStoreFileName = this.getValueForParam("custom_trust_key_store_file_name");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is before check  " + this.customTrustKeyStoreFileName);
                if (this.customTrustKeyStoreFileName == null || this.customTrustKeyStoreFileName.equalsIgnoreCase("none") || this.customTrustKeyStoreFileName.equalsIgnoreCase("null") || this.customTrustKeyStoreFileName.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is null or none   ");
                } else {
                    this.customTrustKeyStoreFileName = this.customTrustKeyStoreFileName.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreFileName is " + this.customTrustKeyStoreFileName);
                }
                this.customTrustKeyStoreType = this.getValueForParam("custom_trust_key_store_type");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is before check  " + this.customTrustKeyStoreType);
                if (this.customTrustKeyStoreType == null || this.customTrustKeyStoreType.equalsIgnoreCase("none") || this.customTrustKeyStoreType.equalsIgnoreCase("null") || this.customTrustKeyStoreType.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is null or none  ");
                } else {
                    this.customTrustKeyStoreType = this.customTrustKeyStoreType.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStoreType is " + this.customTrustKeyStoreType);
                }
                this.customTrustKeyStorePassPhrase = this.getValueForParam("custom_trust_key_store_pass_phrase");
                System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is before check  " + this.customTrustKeyStorePassPhrase);
                if (this.customTrustKeyStorePassPhrase == null || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("none") || this.customTrustKeyStorePassPhrase.equalsIgnoreCase("null") || this.customTrustKeyStorePassPhrase.trim().length() == 0) {
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is null or none    ");
                } else {
                    this.customTrustKeyStorePassPhrase = this.customTrustKeyStorePassPhrase.trim();
                    System.out.println(this.reportingName + ":" + this.entity + " :  customTrustKeyStorePassPhrase is " + this.customTrustKeyStorePassPhrase);
                }
            }
        }
        String string4 = this.getValueForParam("encryptPass");
        if (string4 != null && string4.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
            string3 = this.entity + ":" + this.reportingName;
            System.out.println(string3 + " Encrypted password :" + this.password);
        }
        string3 = this.getValueForParam("snmpPort");
        String string5 = this.getValueForParam("community");
        this.newLastMeasures = new Hashtable();
        if (this.weblogicVersion == 0) {
            string2 = this.getValueForParam("version");
            if (!string2.equalsIgnoreCase("none")) {
                int n = string2.indexOf(".");
                if (n >= 0) {
                    string2 = string2.substring(0, n);
                }
                try {
                    this.weblogicVersion = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.weblogicVersion = 0;
                }
            }
            if (this.weblogicVersion == 0) {
                this.discovery();
            }
        }
        this.useJMX = (string2 = this.getValueForParam("useJMX")) != null && string2.trim().length() != 0 && !string2.equalsIgnoreCase("none") && !string2.equalsIgnoreCase("No") && !string2.equalsIgnoreCase("false");
        if (this.weblogicVersion >= 12) {
            this.useJMX = true;
        }
        System.out.println(this.getClass().getName() + ":" + this.reportingName + " UseJMX  == > " + this.useJMX);
        long l = this.measurePeriod / 1000L;
        long l2 = l / 3L;
        String string6 = this.getValueForParam("jspTimeout");
        if (string6 == null || string6.trim().length() == 0 || string6.equalsIgnoreCase("null") || string6.equalsIgnoreCase("none")) {
            this.jspTimeout = l2;
        } else {
            try {
                this.jspTimeout = Long.parseLong(string6);
                if (this.jspTimeout >= l) {
                    this.jspTimeout = l2;
                    System.out.println("[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values " + string6);
                    this.logToErrorFile("Info :", "[" + this.entity + "] : [" + this.reportingName + "] :  Configured JSP timeout is more than test frequceny, so setting default values ", string6);
                }
            }
            catch (Exception exception) {
                this.jspTimeout = l2;
            }
            this.timeout = this.jspTimeout * 1000L + 20000L;
        }
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "] : JSP timeout " + string6);
        if (this.weblogicVersion < 6) {
            WLJDBCTestUsingSNMP wLJDBCTestUsingSNMP = new WLJDBCTestUsingSNMP(this, this.targetHost, this.portNo, this.siteName, siteAndInfoSeparator, infoFieldSeparator, string3, string5);
            Hashtable hashtable2 = wLJDBCTestUsingSNMP.getMeasures();
            if (hashtable2 == null) {
                this.lastMeasures = new Hashtable();
                this.logToErrorFile("Error", "WLJDBCTest.computeMeasures", "Unable to get measures using SNMP");
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                String string8 = (String)hashtable2.get(string7);
                int n = string8.indexOf(",");
                Double d = new Double(string8.substring(0, n));
                string8 = string8.substring(n + 1);
                n = string8.indexOf(",");
                Double d2 = new Double(string8.substring(0, n));
                Double d3 = new Double(string8.substring(n + 1));
                Double d4 = new Double(-3.0);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(d4);
                arrayList.add(new Double(d2 / d * 100.0));
                arrayList.add(d);
                arrayList.add(d2);
                arrayList.add(d3);
                arrayList.add(d4);
                arrayList.add(d4);
                arrayList.add(d4);
                arrayList.add(d4);
                arrayList.add(d4);
                arrayList.add(d4);
                arrayList.add(d4);
                System.out.println(string7 + arrayList);
                this.addNewMeasure(string7, arrayList);
            }
            return;
        }
        this.protocol = this.isSsl ? "t3s" : "t3";
        ArrayList arrayList = null;
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "WLJDBCTest.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                this.lastMeasures = new Hashtable();
                this.addNewMeasure(null);
                return;
            }
            WLCommandExecute wLCommandExecute = new WLCommandExecute();
            if (this.useSSLTrustStoreFlag) {
                wLCommandExecute.setWebLogicSSLTrustKeyStore(this.wlSSLTrustKeyStore, this.customTrustKeyStoreFileName, this.customTrustKeyStoreType, this.customTrustKeyStorePassPhrase);
                System.out.println(this.reportingName + ":" + this.entity + " : Calling the method with SSL Truststore and  wlSSLTrustKeyStore is " + this.wlSSLTrustKeyStore);
            }
            if (this.useJMX) {
                String string9 = null;
                string = null;
                string9 = this.getValueForParam("adminServerHost");
                if (string9 == null || string9.trim().length() == 0 || string9.equalsIgnoreCase("none")) {
                    string9 = this.targetHost;
                }
                if ((string = this.getValueForParam("adminServerPort")) == null || string.trim().length() == 0 || string.equalsIgnoreCase("none")) {
                    string = this.portNo;
                }
                System.out.println(this.reportingName + ":WLJDBCTest : useJMX flag is " + this.useJMX + " so calling getWLJDBCTestUsingJMX");
                arrayList = wLCommandExecute.executeProgram(this.weblogicJarLoc, string9, string, this.user, this.password, this.server, this.protocol, "getWLJDBCTestUsingJMX");
            } else {
                System.out.println(this.reportingName + ":WLJDBCTest : useJMX flag is " + this.useJMX + " so calling getWLJDBCTest ");
                arrayList = wLCommandExecute.executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLJDBCTest");
            }
        } else {
            arrayList = this.returnMeasures();
            System.out.println("[" + this.reportingName + ":" + this.entity + "]  unparsedMeasures data :" + arrayList);
        }
        if (arrayList == null || arrayList.size() == 0) {
            System.out.println(this.reportingName + ":WLJDBCTest : Unparsed measures is null");
            this.lastMeasures = new Hashtable();
            this.addNewMeasure(null);
            return;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            int n2;
            string = (String)arrayList.get(i);
            if (string == null || (n2 = string.indexOf(":")) == -1 || (n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
            String string10 = string.substring(0, n2);
            string = string.substring(n2 + 1);
            try {
                n2 = string.indexOf(",");
                if (n2 == -1) continue;
                double d = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d5 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d6 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                String string11 = string.substring(0, n2);
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d7 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d8 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d9 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d10 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d11 = Double.parseDouble(string.substring(0, n2));
                if ((n2 = (string = string.substring(n2 + 1)).indexOf(",")) == -1) continue;
                double d12 = Double.parseDouble(string.substring(0, n2));
                double d13 = Double.parseDouble(string.substring(n2 + 1));
                this.populateLastMeasures(string10);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                System.out.println(this.reportingName + ":WLJDBCTest : poolState  ================> :" + string11);
                if (string11.equalsIgnoreCase("true") || string11.equalsIgnoreCase("Running")) {
                    arrayList2.add(new Double(100.0));
                } else {
                    arrayList2.add(new Double(0.0));
                }
                arrayList2.add(new Double(d6 / d5 * 100.0));
                arrayList2.add(new Double(d5));
                arrayList2.add(new Double(d6));
                arrayList2.add(new Double(d));
                arrayList2.add(new Double(d11));
                arrayList2.add(new Double(d12));
                if (this.connectionsTotalCount_last == -5.0) {
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                } else {
                    double d14 = d8 - this.connectionsTotalCount_last;
                    if (n2 >= 0 && this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d14 / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(0.0));
                    }
                    d14 = d10 - this.leakedConnectionCount_last;
                    if (n2 >= 0 && this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d14 / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(0.0));
                    }
                    d14 = d7 - this.failuresToReconnectCount_last;
                    if (n2 >= 0 && this.timeSinceLastTest > 0.0) {
                        arrayList2.add(new Double(d14 / this.timeSinceLastTest));
                    } else {
                        arrayList2.add(new Double(0.0));
                    }
                }
                this.connectionsTotalCount_last = d8;
                this.leakedConnectionCount_last = d10;
                this.failuresToReconnectCount_last = d7;
                arrayList2.add(new Double(d9 / 1000.0));
                arrayList2.add(new Double(d13));
                System.out.println(this.reportingName + ":WLJDBCTest : " + string10 + ":" + arrayList2);
                this.addNewMeasure(string10, arrayList2);
                this.saveLastMeasures(string10);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.logToErrorFile("Error", this.reportingName + ":WLJDBCTest.computeMeasures ", string10 + " : " + numberFormatException.toString());
                numberFormatException.printStackTrace();
            }
        }
        this.lastMeasures = this.newLastMeasures;
    }

    private void populateLastMeasures(String string) {
        if (!this.lastMeasures.isEmpty() && this.lastMeasures.containsKey(string)) {
            String string2 = (String)this.lastMeasures.get(string);
            int n = string2.indexOf(",");
            this.connectionsTotalCount_last = Double.parseDouble(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(",");
            this.leakedConnectionCount_last = Double.parseDouble(string2.substring(0, n));
            this.failuresToReconnectCount_last = Double.parseDouble(string2.substring(n + 1));
            return;
        }
        this.connectionsTotalCount_last = -5.0;
        this.leakedConnectionCount_last = -5.0;
        this.failuresToReconnectCount_last = -5.0;
    }

    private void saveLastMeasures(String string) {
        String string2 = this.connectionsTotalCount_last + "," + this.leakedConnectionCount_last + "," + this.failuresToReconnectCount_last;
        this.newLastMeasures.put(string, string2);
    }

    private ArrayList returnMeasures() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = null;
        String string2 = null;
        if (this.useJMX) {
            System.out.println(this.reportingName + ":WLJDBCTest : useJMX flag is " + this.useJMX + " so calling WLJDBCTestUsingJMX.jsp ");
            string = "WLJDBCTestUsingJMX";
        } else {
            System.out.println(this.reportingName + ":WLJDBCTest : useJMX flag is " + this.useJMX + " so calling WLJDBCTest.jsp ");
            string = "WLJDBCTest";
        }
        if (string.equalsIgnoreCase("WLJDBCTestUsingJMX")) {
            System.out.println("Calling WLJDBCTestUsingJMX.jsp...... ");
            object4 = this.url;
            if (((String)object4).endsWith("/") || ((String)object4).endsWith("\\")) {
                if (((String)object4).endsWith("/")) {
                    object4 = ((String)object4).substring(0, ((String)object4).length() - 1);
                    System.out.println((String)object4);
                }
                if (((String)object4).endsWith("\\")) {
                    object4 = ((String)object4).substring(0, ((String)object4).length() - 1);
                }
            }
            if ((object3 = this.getValueForParam("adminServerHost")) == null || ((String)object3).trim().length() == 0 || ((String)object3).equalsIgnoreCase("none")) {
                object3 = this.targetHost;
            }
            if ((object2 = this.getValueForParam("adminServerPort")) == null || ((String)object2).trim().length() == 0 || ((String)object2).equalsIgnoreCase("none")) {
                object2 = this.portNo;
            }
            System.out.println("WLJDBCTestUsingJMX  :Port :" + this.portNo + " changed into " + (String)object2 + " for WLJDBCTestUsingJMX");
            System.out.println("WLJDBCTestUsingJMX  :IP  :" + this.targetHost + " changed into " + (String)object3 + " for WLJDBCTestUsingJMX");
            object = "WLJDBCTestUsingJMX";
            try {
                string2 = this.url + "/egurkha/" + (String)object + ".jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + (String)object3 + "&port=" + (String)object2 + "&server=" + this.server + "&timeout=" + this.jspTimeout;
                System.out.println("[" + this.reportingName + ":" + this.entity + "] URL to hit " + string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        } else {
            try {
                string2 = this.url + "/egurkha/" + string + ".jsp" + "?name=" + EGURKHA_NAME + "&name1=" + EGURKHA_MONITOR + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&host=" + this.targetHost + "&port=" + this.portNo + "&server=" + this.server + "&timeout=" + this.jspTimeout;
                System.out.println("[" + this.reportingName + ":" + this.entity + "] URL to hit " + string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        object4 = null;
        object3 = null;
        if (this.isSsl) {
            object2 = EgSSL.getInstance();
            EgSSL.enableSSL();
            object = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var7_10 = null;
            try {
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                object3 = new URL(string2);
                object4 = (HttpURLConnection)((URL)object3).openConnection();
                ((URLConnection)object4).connect();
                ConnectionThread connectionThread = new ConnectionThread((HttpURLConnection)object4, false, "WLJDBCTest");
                ArrayList arrayList = null;
                int n = 0;
                boolean bl = this.checkForTimeout(connectionThread);
                if (bl) {
                    n = connectionThread.code;
                    arrayList = connectionThread.data;
                }
                connectionThread = null;
                ((HttpURLConnection)object4).disconnect();
                object4 = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (arrayList == null || arrayList.size() == 0) {
                    System.out.println("[" + this.reportingName + ":" + this.entity + "] no data ,so return null ");
                    return null;
                }
                System.out.println("[" + this.reportingName + ":" + this.entity + "]  Data :" + arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string3 = (String)arrayList.get(i);
                    if (string3.startsWith(string)) {
                        this.measures.add(string3);
                    }
                    if (string.indexOf("UsingJMX") <= -1) continue;
                    String string4 = string.substring(0, string.indexOf("UsingJMX"));
                    System.out.println("[" + this.reportingName + ":" + this.entity + "] after substring JSP file to hit :" + string4);
                    if (!string3.startsWith(string4)) continue;
                    System.out.println("[" + this.reportingName + ":" + this.entity + "] Measures to add the test file :" + string3);
                    this.measures.add(string3);
                }
            }
            catch (Exception exception) {
                System.out.println("[" + this.reportingName + ":" + this.entity + "]  Exception :" + exception);
                exception.printStackTrace();
                if (object4 != null) {
                    ((HttpURLConnection)object4).disconnect();
                }
                return null;
            }
        }
        try {
            object3 = new URL(string2);
            object4 = (HttpURLConnection)((URL)object3).openConnection();
            ((URLConnection)object4).connect();
            object2 = new ConnectionThread((HttpURLConnection)object4, false);
            object = null;
            int n = 0;
            boolean bl = this.checkForTimeout((ConnectionThread)object2);
            if (bl) {
                n = ((ConnectionThread)object2).code;
                object = ((ConnectionThread)object2).data;
            }
            object2 = null;
            ((HttpURLConnection)object4).disconnect();
            object4 = null;
            if (!bl || n != 200) {
                return null;
            }
            if (object == null || ((ArrayList)object).size() == 0) {
                System.out.println("[" + this.reportingName + ":" + this.entity + "] no data ,so return null ");
                return null;
            }
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string5 = (String)((ArrayList)object).get(i);
                if (string5.startsWith(string)) {
                    this.measures.add(string5);
                }
                if (string.indexOf("UsingJMX") <= -1) continue;
                String string6 = string.substring(0, string.indexOf("UsingJMX"));
                System.out.println("[" + this.reportingName + ":" + this.entity + "]  after substring JSP file to hit :" + string6);
                if (!string5.startsWith(string6)) continue;
                System.out.println("[" + this.reportingName + ":" + this.entity + "] Measures to add the test file :" + string5);
                this.measures.add(string5);
            }
        }
        catch (Exception exception) {
            System.out.println("[" + this.reportingName + ":" + this.entity + "]  Exception :" + exception);
            if (object4 != null) {
                ((HttpURLConnection)object4).disconnect();
            }
            return null;
        }
        System.out.println("[" + this.reportingName + ":" + this.entity + "]  Data as arraylist :" + this.measures);
        return this.measures;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                String string = "Inside checkForTimeout method << Timeout happened >> ,Due to [ totalSleepTime >= timeout ] condition satisfied ,totalSleepTime :" + l2 + " ,timeout :" + this.timeout + ", so returing false  ";
                System.out.println("[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : " + string);
                this.logToErrorFile("WARNING :", "[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : ", string);
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        String string = "Inside checkForTimeout method << Timeout happened >> ,Due to [ sleepTime <= 0 ] condition satisfied ,sleepTime :" + l3 + ", so returing false  ";
        System.out.println("[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : " + string);
        this.logToErrorFile("WARNING :", "[" + this.entity + "] : [" + this.reportingName + "]: [checkForTimeout] : ", string);
        return false;
    }

    protected void discovery() {
        long l;
        if (this.server == null) {
            this.server = "localhome";
        }
        this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
        if (this.url == null || this.url.equals("")) {
            this.url = Boolean.getBoolean(this.ssl) ? "https://" + this.tempHost + ":" + this.portNo : "http://" + this.tempHost + ":" + this.portNo;
        }
        WebLogicHelperThread webLogicHelperThread = new WebLogicHelperThread(this.targetHost, Integer.parseInt(this.portNo), Boolean.getBoolean(this.ssl));
        int n = 6;
        long l2 = 0L;
        long l3 = 5L;
        do {
            if (webLogicHelperThread.done) {
                this.weblogicVersion = webLogicHelperThread.version;
                return;
            }
            this.suspendForPeriod(l3);
            if ((l2 += l3) >= this.timeout) {
                webLogicHelperThread.stop();
                webLogicHelperThread = null;
                this.weblogicVersion = n;
                return;
            }
            l = l3 * 2L;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        webLogicHelperThread.stop();
        webLogicHelperThread = null;
        this.weblogicVersion = n;
    }
}

