/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;

class TuxBBDetailsTest
extends GenericTest {
    private String tuxDir = "";
    private String appDir = "";
    private String tuxConfig = "";
    private String bbstatsCmd = "";
    private String bbparmsCmd = "";
    private String exebbstats = "";
    private String exebbparms = "";
    private String debugFlag = "";
    private String sys_OS = "";
    private String[] envp = null;
    private boolean debug = false;

    public TuxBBDetailsTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(10);
        this.isDynamicInfoTest = true;
        this.tuxDir = this.getValueForParam("tuxdir");
        this.appDir = this.getValueForParam("appdir");
        this.tuxConfig = this.getValueForParam("tuxconfig");
        this.debugFlag = this.getValueForParam("debug");
        this.envp = new String[2];
        if (this.tuxDir == null || this.tuxDir.equalsIgnoreCase("NULL") || this.tuxDir.equalsIgnoreCase("none")) {
            this.tuxDir = "";
        }
        if (this.appDir == null || this.appDir.equalsIgnoreCase("NULL") || this.appDir.equalsIgnoreCase("none")) {
            this.appDir = "";
        }
        if (this.tuxConfig == null || this.tuxConfig.equalsIgnoreCase("NULL") || this.tuxConfig.equalsIgnoreCase("none")) {
            this.tuxConfig = "";
        }
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
        this.bbstatsCmd = "bbstats";
        this.bbparmsCmd = "bbparms";
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (this.sys_OS.trim().startsWith("WIN")) {
            this.tuxDir.replace('/', '\\');
            this.appDir.replace('/', '\\');
            this.tuxConfig.replace('/', '\\');
            this.exebbstats = EgInstallInfo.getInstallDir() + "\\lib\\tux.bat " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.bbstatsCmd;
            this.exebbparms = EgInstallInfo.getInstallDir() + "\\lib\\tux.bat " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.bbparmsCmd;
        } else {
            this.tuxDir.replace('\\', '/');
            this.appDir.replace('\\', '/');
            this.tuxConfig.replace('\\', '/');
            this.envp[0] = "PATH=" + EgInstallInfo.getInstallDir() + "/bin";
            this.envp[1] = "LD_LIBRARY_PATH=/usr/lib";
            this.exebbstats = EgInstallInfo.getInstallDir() + "/bin/tux.sh " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.bbstatsCmd;
            this.exebbparms = EgInstallInfo.getInstallDir() + "/bin/tux.sh " + this.tuxDir + " " + this.appDir + " " + this.tuxConfig + " " + this.bbparmsCmd;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        EgUtilities egUtilities = EgUtilities.createInstance();
        if (this.sys_OS.trim().startsWith("WIN")) {
            arrayList2 = egUtilities.getExecOutputLines(this.exebbparms);
            arrayList3 = egUtilities.getExecOutputLines(this.exebbstats);
        } else {
            arrayList2 = egUtilities.getExecOutputLinesForUnix(this.exebbparms, this.envp);
            arrayList3 = egUtilities.getExecOutputLinesForUnix(this.exebbstats, this.envp);
        }
        if (arrayList2 == null || arrayList2.size() == 0) {
            System.out.println("[TuxBBDetailsTest] Error in executing the command ..." + arrayList2);
            this.logToErrorFile("Error:", "TuxedoBBTest.computeMeasures", "BBParms measures not available");
            return;
        }
        ArrayList arrayList4 = (ArrayList)arrayList2.get(0);
        if (arrayList4 == null || arrayList4.size() == 0) {
            return;
        }
        for (int i = 0; i < arrayList4.size(); ++i) {
            String string8 = ((String)arrayList4.get(i)).trim();
            if (string8 == null || string8.trim().length() == 0) continue;
            if (string8.startsWith("MAXSERVERS")) {
                string = string8.substring(string8.indexOf(":") + 1).trim();
                continue;
            }
            if (string8.startsWith("MAXSERVICES")) {
                string2 = string8.substring(string8.indexOf(":") + 1).trim();
                continue;
            }
            if (!string8.startsWith("MAXINTERFACES")) continue;
            string3 = string8.substring(string8.indexOf(":") + 1).trim();
        }
        if (arrayList3 == null || arrayList3.size() == 0) {
            this.logToErrorFile("Error:", "TuxedoBBDetailsTest.computeMeasures", "Tuxedo BBStats measures not available");
            System.out.println("[TuxBBDetailsTest] Error in executing the command ..." + arrayList3);
            return;
        }
        ArrayList arrayList5 = (ArrayList)arrayList3.get(0);
        if (arrayList5 == null || arrayList5.size() == 0) {
            return;
        }
        int n = arrayList5.indexOf("> Current Bulletin Board Status:");
        boolean bl = false;
        try {
            for (int i = n; i < arrayList5.size(); ++i) {
                String string9 = ((String)arrayList5.get(i)).trim().toUpperCase();
                if (string9 == null || string9.trim().length() == 0) continue;
                if (string9 != null && string9.startsWith("> CURRENT BULLETIN BOARD STATUS:")) {
                    bl = true;
                    continue;
                }
                if (string9 != null && bl && string9.startsWith("CURRENT NUMBER OF SERVERS:")) {
                    string4 = string9.substring(string9.indexOf(":") + 1).trim();
                    continue;
                }
                if (string9 != null && bl && string9.startsWith("CURRENT NUMBER OF SERVICES:")) {
                    string5 = string9.substring(string9.indexOf(":") + 1).trim();
                    continue;
                }
                if (string9 != null && bl && string9.startsWith("CURRENT NUMBER OF INTERFACES:")) {
                    string7 = string9.substring(string9.indexOf(":") + 1).trim();
                    continue;
                }
                if (string9 == null || !bl || !string9.startsWith("CURRENT NUMBER OF REQUEST QUEUES:")) continue;
                string6 = string9.substring(string9.indexOf(":") + 1).trim();
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error:", "TuxedoBBDetailsTest.computeMeasures", "Tuxedo BBStats measures not available");
        }
        double d = Double.valueOf(string);
        double d2 = Double.valueOf(string2);
        double d3 = Double.valueOf(string3);
        double d4 = Double.valueOf(string4);
        double d5 = Double.valueOf(string5);
        double d6 = Double.valueOf(string7);
        double d7 = (d - d4) / d * 100.0;
        double d8 = (d2 - d5) / d2 * 100.0;
        double d9 = (d3 - d6) / d3 * 100.0;
        arrayList.add(new Double(string));
        arrayList.add(new Double(string2));
        arrayList.add(new Double(string3));
        arrayList.add(new Double(string4));
        arrayList.add(new Double(string5));
        arrayList.add(new Double(string7));
        arrayList.add(new Double(string6));
        arrayList.add(new Double(d7));
        arrayList.add(new Double(d8));
        arrayList.add(new Double(d9));
        if (this.debug) {
            System.out.println("[TuxBBDetailsTest]measureList:============================>" + arrayList);
        }
        this.addNewMeasure(arrayList);
    }

    public static void main(String[] stringArray) {
        TuxBBDetailsTest tuxBBDetailsTest = new TuxBBDetailsTest(stringArray);
        try {
            while (true) {
                tuxBBDetailsTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

