/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class TibSqlNetTest
extends GenericTest {
    public String tibSid = "";
    public String username = "";
    public String password = "";
    public String tibQuery = "";
    public double availability = 0.0;
    public double totRespTime = -5.0;
    public double connAvailability = -5.0;
    public double connRespTime = -5.0;
    public double queryAvailability = -5.0;
    public double queryRespTime = -5.0;
    public int noOfRecords = -5;
    public ArrayList tibSqlNetDDList = new ArrayList();
    private String ddLine = "";

    public TibSqlNetTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        this.tibQuery = this.getValueForParam("query");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        if (this.tibQuery == null || this.tibQuery.equalsIgnoreCase("NULL") || this.tibQuery.equalsIgnoreCase("none")) {
            this.tibQuery = "select * from v$instance";
        }
        if (this.timeout == 0L) {
            this.timeout = 2L * EgConfigInfo.msecPerMin;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        TibSqlNetHelper tibSqlNetHelper = new TibSqlNetHelper(this);
        boolean bl = this.checkForTimeout(tibSqlNetHelper);
        if (bl) {
            if (!this.isPassive) {
                this.ddLine = tibSqlNetHelper.tibSqlNetDDString;
                this.tibSqlNetDDList.add(this.ddLine);
            }
            arrayList.add(new Double(this.availability));
            arrayList.add(new Double(this.totRespTime));
            arrayList.add(new Double(this.connAvailability));
            arrayList.add(new Double(this.connRespTime));
            arrayList.add(new Double(this.queryAvailability));
            arrayList.add(new Double(this.queryRespTime));
            arrayList.add(new Double(this.noOfRecords));
        } else {
            if (!this.isPassive) {
                this.ddLine = tibSqlNetHelper.tibSqlNetDDString;
                if (this.ddLine != null && this.ddLine.length() > 0) {
                    this.tibSqlNetDDList.add(this.ddLine);
                }
            }
            arrayList.add(new Double(this.availability));
            arrayList.add(new Double(this.totRespTime));
            arrayList.add(new Double(this.connAvailability));
            arrayList.add(new Double(this.connRespTime));
            arrayList.add(new Double(this.queryAvailability));
            arrayList.add(new Double(this.queryRespTime));
            arrayList.add(new Double(this.noOfRecords));
        }
        this.addNewMeasure(arrayList);
    }

    private boolean checkForTimeout(TibSqlNetHelper tibSqlNetHelper) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            long l4 = System.currentTimeMillis();
            this.suspendForPeriod(l3);
            if (tibSqlNetHelper.done) {
                return true;
            }
            long l5 = System.currentTimeMillis();
            long l6 = l5 - l4;
            if (l6 < 0L) {
                l6 = l3;
            }
            if ((l2 += l6) >= this.timeout) {
                System.out.println("TibSqlNetTest_ex timeout happeneded ... " + l2);
                double d = this.timeout / 1000L;
                this.ddLine = "Timeout happened while establishing connection. Connection establishment time exceeded configured timeout value:" + d + " secs";
                tibSqlNetHelper.interrupt();
                Thread.currentThread();
                Thread.yield();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                tibSqlNetHelper.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        double d = this.timeout / 1000L;
        this.ddLine = "Timeout happened while establishing connection. Connection establishment time exceeded configured timeout value:" + d + " secs";
        tibSqlNetHelper.interrupt();
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        tibSqlNetHelper.stop();
        System.out.println("TibSqlNetTest_ex timeout happeneded ... " + l2);
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            if (l < EgAgentCommon.minimumSleep) {
                l = EgAgentCommon.minimumSleep;
            }
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    public static void main(String[] stringArray) {
        TibSqlNetTest tibSqlNetTest = new TibSqlNetTest(stringArray);
        tibSqlNetTest.computeMeasures(new Hashtable());
    }
}

