/*
 * Decompiled with CFR 0.152.
 */
import com.tmax.tibero.jdbc.ext.TbDataSource;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class TibDataFileTest
extends GenericTest {
    private String tibSid = "";
    private String username = "";
    private String password = "";
    private String queryStmt = "";
    private String includePath = "no";
    private Hashtable prevHash = new Hashtable();
    private double sum_prevTotalIo;

    public TibDataFileTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("username");
        this.password = this.getValueForParam("password");
        this.tibSid = this.getValueForParam("tibero_sid");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.tibSid == null || this.tibSid.equalsIgnoreCase("NULL") || this.tibSid.equalsIgnoreCase("none")) {
            this.tibSid = "";
        }
        this.includePath = this.getValueForParam("includepath");
        this.queryStmt = "SELECT /*+ rule */ df.file#,df.name,fs.phyrds,fs.phywrts,fs.phyblkrd,fs.phyblkwrt,fs.phyblkrd+fs.phyblkwrt as Total_ios FROM v$filestat fs,v$dbfile df WHERE fs.file#=df.file# ORDER BY fs.phyblkrd+fs.phyblkwrt desc";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        block24: {
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string = "jdbc:tibero:thin:@";
                String string2 = string + "" + this.targetHost + ":" + this.portNo + ":" + this.tibSid;
                System.out.println("URL::" + string2);
                TbDataSource tbDataSource = new TbDataSource();
                tbDataSource.setURL(string2);
                tbDataSource.setUser(this.username);
                tbDataSource.setPassword(this.password);
                System.out.println("Bef Connection");
                double d = 0.0;
                try {
                    connection = tbDataSource.getConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (connection == null) {
                    this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    this.logToErrorFile("Error :", this.entity + " Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                    exception.printStackTrace();
                    this.closeConn(connection);
                    this.closeRs(resultSet);
                    this.closeStmt(statement);
                    this.closeConn(connection);
                    return;
                }
                resultSet = statement.executeQuery(this.queryStmt);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                Hashtable<String, ArrayList<Double>> hashtable2 = new Hashtable<String, ArrayList<Double>>();
                while (resultSet.next()) {
                    arrayList = new ArrayList();
                    String string3 = resultSet.getString("NAME");
                    if (this.includePath.equalsIgnoreCase("no") || this.includePath.equalsIgnoreCase("false")) {
                        int n = string3.lastIndexOf("/");
                        if (n >= 0) {
                            string3 = new String(string3.substring(n + 1));
                        } else {
                            n = string3.lastIndexOf("\\");
                            string3 = new String(string3.substring(n + 1));
                        }
                    }
                    double d2 = resultSet.getDouble(5);
                    double d3 = resultSet.getDouble(6);
                    double d4 = resultSet.getDouble(7);
                    d += d4;
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    System.out.println(this.entity + " name::" + string3);
                    System.out.println(this.entity + " measureList::" + arrayList);
                    hashtable2.put(string3, arrayList);
                }
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
                if (hashtable2 != null && hashtable2.size() > 0) {
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        String string4 = (String)enumeration.nextElement();
                        if (this.prevHash != null && this.prevHash.size() > 0) {
                            ArrayList arrayList2 = (ArrayList)this.prevHash.get(string4);
                            ArrayList arrayList3 = (ArrayList)hashtable2.get(string4);
                            if (arrayList2 == null || arrayList3 == null) continue;
                            double d5 = (Double)arrayList3.get(0);
                            double d6 = (Double)arrayList3.get(1);
                            double d7 = (Double)arrayList3.get(2);
                            double d8 = (Double)arrayList2.get(0);
                            double d9 = (Double)arrayList2.get(1);
                            double d10 = (Double)arrayList2.get(2);
                            double d11 = d5 - d8;
                            double d12 = d6 - d9;
                            double d13 = d7 - d10;
                            double d14 = d - this.sum_prevTotalIo;
                            if (this.timeSinceLastTest > 0.0) {
                                if (d11 > 0.0) {
                                    d11 /= this.timeSinceLastTest;
                                }
                                if (d12 > 0.0) {
                                    d12 /= this.timeSinceLastTest;
                                }
                            }
                            double d15 = 0.0;
                            if (d14 > 0.0) {
                                d15 = d13 / d14 * 100.0;
                            }
                            arrayList = new ArrayList();
                            d11 = d11 < 0.0 ? -5.0 : d11;
                            d12 = d12 < 0.0 ? -5.0 : d12;
                            d15 = d15 < 0.0 ? -5.0 : d15;
                            arrayList.add(new Double(d11));
                            arrayList.add(new Double(d12));
                            arrayList.add(new Double(d15));
                        } else {
                            arrayList = new ArrayList();
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                            arrayList.add(new Double(-5.0));
                        }
                        System.out.println(this.entity + "key::" + string4 + " measureList::" + arrayList);
                        this.addNewMeasure(string4, arrayList);
                    }
                    this.sum_prevTotalIo = d;
                    this.prevHash = (Hashtable)hashtable2.clone();
                }
                this.closeRs(resultSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.tibSid, exception.toString());
                break block24;
            }
            finally {
                this.closeRs(resultSet);
                this.closeStmt(statement);
                this.closeConn(connection);
            }
            this.closeStmt(statement);
            this.closeConn(connection);
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        TibDataFileTest tibDataFileTest = new TibDataFileTest(stringArray);
        tibDataFileTest.computeMeasures(new Hashtable());
    }
}

