/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class SynNasStrPerfTest
extends EgSnmpGenericTest {
    private Hashtable prevIoReadInbyte = new Hashtable();
    private Hashtable prevIoWriteInbyte = new Hashtable();
    private Hashtable prevIORead = new Hashtable();
    private Hashtable prevIoWrite = new Hashtable();
    private static final double BYTE_TO_MB = 1048576.0;

    public SynNasStrPerfTest(String[] stringArray) {
        super(stringArray);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.setMeasureCount(5);
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.6574.101.1.1.2");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.6574.101.1.1.3");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.6574.101.1.1.4");
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.6574.101.1.1.5");
            Hashtable hashtable6 = this.getMeasure(".1.3.6.1.4.1.6574.101.1.1.6");
            Hashtable hashtable7 = this.getMeasure(".1.3.6.1.4.1.6574.101.1.1.8");
            if (hashtable2 == null || hashtable2.size() == 0) {
                this.logToErrorFile("Error :", "SynNasStrPerfTest error occured in Compute Measures for ", this.targetHost);
            }
            Hashtable hashtable8 = this.getDiff(hashtable3, this.prevIoReadInbyte, true);
            Hashtable hashtable9 = this.getDiff(hashtable4, this.prevIoWriteInbyte, true);
            Hashtable hashtable10 = this.getDiff(hashtable5, this.prevIORead, false);
            Hashtable hashtable11 = this.getDiff(hashtable6, this.prevIoWrite, false);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable7.get(string);
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(this.getValue(hashtable9, string));
                arrayList.add(this.getValue(hashtable8, string));
                arrayList.add(this.getValue(hashtable11, string));
                arrayList.add(this.getValue(hashtable10, string));
                arrayList.add(new Double(string3));
                System.out.println("[SynNasStrPerfTest]info===>" + string2 + "  measure===>" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
            this.prevIoReadInbyte = hashtable3;
            this.prevIoWriteInbyte = hashtable4;
            this.prevIORead = hashtable5;
            this.prevIoWrite = hashtable6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Hashtable getDiff(Hashtable hashtable, Hashtable hashtable2, boolean bl) {
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        if (hashtable == null || hashtable2 == null) {
            return hashtable3;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            String string3 = (String)hashtable2.get(string);
            if (string3 == null) {
                hashtable3.put(string, new Double(-5.0));
                continue;
            }
            if (string2 == null) continue;
            try {
                double d = -5.0;
                double d2 = this.getDoubleValue(string2);
                double d3 = this.getDoubleValue(string3);
                if (d2 >= 0.0 && d3 >= 0.0) {
                    d = d2 - d3;
                    if (bl) {
                        d /= 1048576.0;
                    }
                    d = this.timeSinceLastTest > 0.0 && d >= 0.0 ? (d /= this.timeSinceLastTest) : -5.0;
                }
                hashtable3.put(string, new Double(d));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashtable3;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "SynNasStrPerfTest error occured in getMeasures", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            System.out.println("Exception in getDoubleValueMethod:" + exception);
            exception.printStackTrace();
        }
        return d;
    }

    private Double getValue(Hashtable hashtable, String string) {
        Double d = new Double(-5.0);
        if (hashtable == null) {
            return d;
        }
        try {
            Double d2 = (Double)hashtable.get(string);
            if (d2 == null) {
                return d;
            }
            return d2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return d;
        }
    }

    public static void main(String[] stringArray) {
        SynNasStrPerfTest synNasStrPerfTest = new SynNasStrPerfTest(stringArray);
        synNasStrPerfTest.computeMeasures(new Hashtable());
    }
}

