/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Sun1HttpTest
extends SunOneAppServerBaseTest {
    double count_requests_last;
    double count_bytes_received_last;
    double count_2xx_last;
    double count_3xx_last;
    double count_4xx_last;
    double count_5xx_last;
    double count_other_last;
    Hashtable lastMeasures = new Hashtable();
    private double count_requests_temp = 0.0;
    double tmp;
    private String userName = null;
    private String password = null;
    private String adminPort = null;
    private boolean isThisFirstTime = true;
    private boolean needToPopulateAgain = false;
    private Vector virtualServers = new Vector();

    public static void main(String[] stringArray) {
        Sun1HttpTest sun1HttpTest = new Sun1HttpTest(stringArray);
        sun1HttpTest.executeTest();
    }

    public Sun1HttpTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(11);
        if (stringArray.length < 10) {
            System.err.println("Usage: Sun1HttpTest -appserverdir <appserver root dir> -user <userName> -password <password> -host <host> -adminport <portNo> -server <instanceName>");
            return;
        }
    }

    private Vector getVirtualServerNames(String string) {
        Object var2_2 = null;
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(os_specific_option);
        stringBuffer.append(asadminPath);
        stringBuffer.append(" list-virtual-servers ");
        stringBuffer.append(options);
        try {
            EgUtilities egUtilities = EgUtilities.createInstance();
            ArrayList arrayList = egUtilities.getExecOutputLines(stringBuffer.toString());
            if (arrayList == null || arrayList.size() < 2) {
                return null;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            if (arrayList2 == null || arrayList2.size() == 0) {
                return null;
            }
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                string2 = (String)arrayList2.get(i);
                if (string2.indexOf("WARNING:") > -1 || string2.indexOf("list-virtual-servers") > -1) continue;
                vector.add(string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    private String[] removeUnusefulLines(ArrayList arrayList) {
        String[] stringArray = new String[11];
        if (arrayList == null) {
            return null;
        }
        String string = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            if (string.indexOf("No matches resulted") > -1) {
                System.out.println("No output for Http Service!");
                stringArray[0] = "No output";
                return stringArray;
            }
            if (string.indexOf("countrequests-count") > -1) {
                stringArray[0] = string;
                continue;
            }
            if (string.indexOf("countbytesreceived-count") > -1) {
                stringArray[1] = string;
                continue;
            }
            if (string.indexOf("ratebytestransmitted-count") > -1) {
                stringArray[2] = string;
                return stringArray;
            }
            if (string.indexOf("maxbytetransmissionrate-count") > -1) {
                stringArray[3] = string;
                continue;
            }
            if (string.indexOf("countopenconnections-count") > -1) {
                stringArray[4] = string;
                continue;
            }
            if (string.indexOf("maxopenconnections-count") > -1) {
                stringArray[5] = string;
                continue;
            }
            if (string.indexOf("count2xx-count") > -1) {
                stringArray[6] = string;
                continue;
            }
            if (string.indexOf("count3xx-count") > -1) {
                stringArray[7] = string;
                continue;
            }
            if (string.indexOf("count4xx-count") > -1) {
                stringArray[8] = string;
                continue;
            }
            if (string.indexOf("count5xx-count") > -1) {
                stringArray[9] = string;
                continue;
            }
            if (string.indexOf("countother-count") <= -1) continue;
            stringArray[10] = string;
        }
        return stringArray;
    }

    private void parseMeasures5(String[] stringArray, ArrayList arrayList) {
        if (stringArray[0].indexOf("No output") > -1) {
            for (int i = 0; i < 11; ++i) {
                arrayList.add(new Double(-5.0));
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[0], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_requests_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else {
                this.count_requests_temp = this.tmp - this.count_requests_last;
                arrayList.add(new Double(this.count_requests_temp / this.timeSinceLastTest));
            }
            this.count_requests_last = this.tmp;
            stringTokenizer = new StringTokenizer(stringArray[1], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_bytes_received_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else {
                double d = this.tmp - this.count_bytes_received_last;
                arrayList.add(new Double(d / 1024.0 / this.timeSinceLastTest));
            }
            this.count_bytes_received_last = this.tmp;
            stringTokenizer = new StringTokenizer(stringArray[2], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp / 1024.0));
            stringTokenizer = new StringTokenizer(stringArray[3], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp / 1024.0));
            stringTokenizer = new StringTokenizer(stringArray[4], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp));
            stringTokenizer = new StringTokenizer(stringArray[5], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp));
            stringTokenizer = new StringTokenizer(stringArray[6], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_2xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_2xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_2xx_last = this.tmp;
            stringTokenizer = new StringTokenizer(stringArray[7], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_3xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_3xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_3xx_last = this.tmp;
            stringTokenizer = new StringTokenizer(stringArray[8], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_4xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_4xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_4xx_last = this.tmp;
            stringTokenizer = new StringTokenizer(stringArray[9], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_5xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_5xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_5xx_last = this.tmp;
            stringTokenizer = new StringTokenizer(stringArray[10], "=");
            stringTokenizer.nextToken();
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_other_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_other_last) / this.count_requests_temp * 100.0));
            }
            this.count_other_last = this.tmp;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Object var2_2 = null;
        if (this.isFirstTimeCheckVersion) {
            this.isSunJavaEnterpriseSystem5 = this.checkVersion(hashtable);
            this.isFirstTimeCheckVersion = false;
        }
        if (this.isSunJavaEnterpriseSystem5) {
            if (this.isThisFirstTime || this.needToPopulateAgain) {
                this.userName = (String)hashtable.get("user");
                this.password = (String)hashtable.get("password");
                this.adminPort = (String)hashtable.get("adminport");
                this.server = (String)hashtable.get("server");
                rootDirName = (String)hashtable.get("appserverdir");
                options = " --user " + this.userName + " --password " + this.password + " --host " + this.targetHost + " --port " + this.adminPort;
                this.isThisFirstTime = false;
                this.virtualServers = this.getVirtualServerNames(this.server);
                if (!Sun1HttpTest.verifyServerName(this.server)) {
                    // empty if block
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Enumeration enumeration = this.virtualServers.elements();
                while (enumeration.hasMoreElements()) {
                    ArrayList arrayList;
                    ArrayList arrayList2 = new ArrayList();
                    String string = (String)enumeration.nextElement();
                    this.populateLastMeasures(string);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(os_specific_option);
                    stringBuffer.append(asadminPath);
                    stringBuffer.append(" get ");
                    stringBuffer.append(options);
                    stringBuffer.append(" -m " + this.server);
                    stringBuffer.append(".http-service.");
                    stringBuffer.append(string);
                    stringBuffer.append(".request.* ");
                    EgUtilities egUtilities = EgUtilities.createInstance();
                    ArrayList arrayList3 = egUtilities.getExecOutputLines(stringBuffer.toString());
                    if (arrayList3 == null || arrayList3.size() < 2 || (arrayList = (ArrayList)arrayList3.get(0)) == null || arrayList.size() == 0) continue;
                    String[] stringArray = this.removeUnusefulLines(arrayList);
                    this.parseMeasures5(stringArray, arrayList2);
                    if (arrayList2.size() != 11) {
                        this.needToPopulateAgain = true;
                        return;
                    }
                    this.addNewMeasure(string, arrayList2);
                    this.saveLastMeasures(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (this.isThisFirstTime || this.needToPopulateAgain) {
                this.userName = (String)hashtable.get("user");
                this.password = (String)hashtable.get("password");
                this.adminPort = (String)hashtable.get("adminport");
                this.server = (String)hashtable.get("server");
                rootDirName = (String)hashtable.get("appserverdir");
                options = " --user " + this.userName + " --password " + this.password + " --host " + this.targetHost + " --port " + this.adminPort;
                this.isThisFirstTime = false;
                if (!Sun1HttpTest.verifyServerName(this.server)) {
                    return;
                }
            }
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(os_specific_option);
                stringBuffer.append(asadminPath);
                stringBuffer.append(" get -m ");
                stringBuffer.append(this.server);
                stringBuffer.append(".http-server.virtual-server.*");
                stringBuffer.append(options);
                EgUtilities egUtilities = EgUtilities.createInstance();
                ArrayList arrayList = egUtilities.getExecOutputLines(stringBuffer.toString());
                if (arrayList == null || arrayList.size() < 2) {
                    return;
                }
                ArrayList arrayList4 = (ArrayList)arrayList.get(0);
                if (arrayList4 == null || arrayList4.size() == 0) {
                    return;
                }
                this.processInputStream(arrayList4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void processInputStream(ArrayList arrayList) {
        String string = null;
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            string = (String)arrayList.get(i);
            if (!string.startsWith("Virtual Server:")) continue;
            ArrayList arrayList2 = new ArrayList();
            String string2 = string.trim().substring(16);
            this.populateLastMeasures(string2);
            int n = i + 1;
            int n2 = i;
            for (int j = n; j < arrayList.size(); ++j) {
                string = (String)arrayList.get(j);
                if (!this.parseMeasures(string, arrayList2)) continue;
                n2 = j;
                break;
            }
            i = n2;
            if (arrayList2.size() != 11) {
                this.needToPopulateAgain = true;
                return;
            }
            this.addNewMeasure(string2, arrayList2);
            this.saveLastMeasures(string2);
        }
    }

    private void populateLastMeasures(String string) {
        String string2;
        StringTokenizer stringTokenizer;
        if (!this.lastMeasures.isEmpty() && this.lastMeasures.containsKey(string) && (stringTokenizer = new StringTokenizer(string2 = (String)this.lastMeasures.get(string), ",")).countTokens() == 7) {
            this.count_requests_last = Double.parseDouble(stringTokenizer.nextToken());
            this.count_bytes_received_last = Double.parseDouble(stringTokenizer.nextToken());
            this.count_2xx_last = Double.parseDouble(stringTokenizer.nextToken());
            this.count_3xx_last = Double.parseDouble(stringTokenizer.nextToken());
            this.count_4xx_last = Double.parseDouble(stringTokenizer.nextToken());
            this.count_5xx_last = Double.parseDouble(stringTokenizer.nextToken());
            this.count_other_last = Double.parseDouble(stringTokenizer.nextToken());
            return;
        }
        this.count_requests_last = -1.0;
        this.count_bytes_received_last = -1.0;
        this.count_2xx_last = -1.0;
        this.count_3xx_last = -1.0;
        this.count_4xx_last = -1.0;
        this.count_5xx_last = -1.0;
        this.count_other_last = -1.0;
    }

    private void saveLastMeasures(String string) {
        String string2 = this.count_requests_last + "," + this.count_bytes_received_last + "," + this.count_2xx_last + "," + this.count_3xx_last + "," + this.count_4xx_last + "," + this.count_5xx_last + "," + this.count_other_last;
        this.lastMeasures.put(string, string2);
    }

    private boolean parseMeasures(String string, ArrayList arrayList) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        String string2 = stringTokenizer.nextToken();
        if (string2.trim().equals("CountRequests")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_requests_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else {
                this.count_requests_temp = this.tmp - this.count_requests_last;
                arrayList.add(new Double(this.count_requests_temp / this.timeSinceLastTest));
            }
            this.count_requests_last = this.tmp;
        } else if (string2.trim().equals("CountBytesReceived")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_bytes_received_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else {
                double d = this.tmp - this.count_bytes_received_last;
                arrayList.add(new Double(d / 1024.0 / this.timeSinceLastTest));
            }
            this.count_bytes_received_last = this.tmp;
        } else if (string2.trim().equals("RateBytesTransmitted")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp / 1024.0));
        } else if (string2.trim().equals("MaxByteTransmissionRate")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp / 1024.0));
        } else if (string2.trim().equals("CountOpenConnections")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp));
        } else if (string2.trim().equals("MaxOpenConnections")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            arrayList.add(new Double(this.tmp));
        } else if (string2.trim().equals("Count2xx")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_2xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_2xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_2xx_last = this.tmp;
        } else if (string2.trim().equals("Count3xx")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_3xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_3xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_3xx_last = this.tmp;
        } else if (string2.trim().equals("Count4xx")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_4xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_4xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_4xx_last = this.tmp;
        } else if (string2.trim().equals("Count5xx")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_5xx_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_5xx_last) / this.count_requests_temp * 100.0));
            }
            this.count_5xx_last = this.tmp;
        } else if (string2.trim().equals("CountOther")) {
            this.tmp = Double.parseDouble(stringTokenizer.nextToken());
            if (this.count_other_last == -1.0) {
                arrayList.add(new Double(-1.0));
            } else if (this.count_requests_temp == 0.0) {
                arrayList.add(new Double(0.0));
            } else {
                arrayList.add(new Double((this.tmp - this.count_other_last) / this.count_requests_temp * 100.0));
            }
            this.count_other_last = this.tmp;
            return true;
        }
        return false;
    }
}

