/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgCrypt;
import java.util.ArrayList;
import java.util.Hashtable;
import redis.clients.jedis.Jedis;

public class RedisValidator
extends EgServerValidator {
    private Hashtable validationErrorMap = new Hashtable();
    private Hashtable htValidatorList = new Hashtable();
    private ArrayList validationMsgs = null;
    private String[] params = null;
    private boolean isFromManager = false;
    private boolean passwordFlag = false;
    private boolean usernameFlag = false;

    /*
     * WARNING - void declaration
     */
    public RedisValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        System.out.println("RedisValidator constructor");
        if (stringArray != null && stringArray.length > 0) {
            this.params = new String[stringArray.length * 2 + 2];
            boolean n = false;
            for (int i = 0; i < stringArray.length; ++i) {
                void var3_4;
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                string2 = string2.trim();
                String string4 = "";
                String string5 = "";
                if (string2 != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                } else if (string2 != null && string2.equalsIgnoreCase("-Redis_password")) {
                    string4 = EgCrypt.decrypt(string3);
                    if (string4 != null && string4.length() > 0 && string4.endsWith("~EG~")) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-redis_passwordconfirmpassword")) {
                    string5 = EgCrypt.decrypt(string3);
                    if (string5 != null && string5.length() > 0 && string5.endsWith("~EG~")) {
                        string5 = string5.substring(0, string5.indexOf("~EG~"));
                    }
                } else if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.usernameFlag = string3 != null && string3.length() != 0 && !string3.equalsIgnoreCase("none");
                }
                this.params[var3_4] = string2;
                if (string2 != null && string2.equalsIgnoreCase("-Redis_password")) {
                    this.passwordFlag = string4 != null && string4.length() > 0 && !string4.equalsIgnoreCase("none");
                    this.params[++var3_4] = string4;
                } else if (string2 != null && string2.equalsIgnoreCase("-redis_passwordconfirmpassword")) {
                    this.params[++var3_4] = string5;
                } else {
                    System.out.println("RedisValidator args " + string2 + ":" + string3);
                    this.params[++var3_4] = string3;
                }
                this.validationMsgs = new ArrayList();
                ++var3_4;
            }
            this.params[var3_4] = "-egMeasHost";
            this.params[++var3_5] = "";
            System.out.println("RedisValidator args -egMeasHost: ");
        }
        boolean bl2 = this.checkRedisConnection(this.params);
        this.validate(bl2);
        this.isFromManager = bl;
    }

    public void validate(boolean bl) {
        try {
            System.out.println("RedisValidator validate method");
            if (!bl) {
                String string = (String)this.validationErrorMap.get("Redis_Connectivity");
                String string2 = "";
                System.out.println("RedisValidator if redisConnectivityMsg:" + string);
                if (string != null && string.length() > 0 && string.startsWith("JedisConnectionException:")) {
                    string = string.substring(string.indexOf("JedisConnectionException:") + 25, string.length());
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Port$#$NA");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$NA");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$NA");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$" + string);
                } else if (string != null && string.length() > 0 && string.startsWith("dataError:")) {
                    string = string.substring(string.indexOf("dataError:") + 10, string.length());
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Port$#$Failed");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$NA");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$NA");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$" + string);
                } else if (string != null && string.length() > 0 && (string.contains("NOAUTH Authentication") || string.contains("invalid"))) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$Failed");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$Failed");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$" + string);
                } else if (string != null && string.length() > 0 && string.contains("Failed to")) {
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Port$#$Failed");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$NA");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$NA");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$" + string);
                } else if (string != null && string.length() > 0 && string.contains("Exception:") && string.contains("Read timed out")) {
                    string = string.substring(string.indexOf("Exception:") + 10, string.length());
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    this.validationMsgs.add("SSL$#$Failed");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$NA");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$NA");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$" + string);
                } else {
                    if (string != null && string.length() > 0 && string.contains("Exception:")) {
                        string = string.substring(string.indexOf("Exception:") + 10, string.length());
                    }
                    this.validationMsgs.add("Host IP/Name$#$Failed");
                    this.validationMsgs.add("Port$#$Failed");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$Failed");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$Failed");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$" + string);
                }
            } else {
                String string = (String)this.validationErrorMap.get("Redis_Connectivity");
                System.out.println("RedisValidator else redisConnectivityMsg:" + string);
                if (string != null && string.length() > 0 && string.equalsIgnoreCase("connection ok with out authenication")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$OK");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$OK");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$OK");
                } else if (string != null && string.length() > 0 && string.equalsIgnoreCase("connection ok with authenication")) {
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                    if (this.passwordFlag && this.usernameFlag) {
                        this.validationMsgs.add("Redis Username/Password$#$OK");
                    } else if (this.passwordFlag) {
                        this.validationMsgs.add("Redis Password$#$OK");
                    }
                    this.validationMsgs.add("Redis Connectivity$#$OK");
                }
            }
            if (!this.isFromManager) {
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("RedisValidator checkRedisConnection method:");
        }
    }

    protected String findAndReplaceString(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string2.length();
        int n2 = string.length();
        while ((n2 = string.lastIndexOf(string2, n2 - 1)) > -1) {
            stringBuffer.replace(n2, n2 + n, string3);
        }
        return stringBuffer.toString();
    }

    public boolean checkRedisConnection(String[] stringArray) {
        Jedis jedis = null;
        try {
            System.out.println("RedisValidator checkRedisConnection method");
            RedisBase redisBase = new RedisBase(stringArray){};
            System.out.println("RedisBase method end");
            jedis = redisBase.getConnection();
            System.out.println("RedisValidator jedis connection end");
            String string = jedis.ping();
            System.out.println("RedisValidator strPing:" + string);
            this.htValidatorList = redisBase.hshValidatorList;
            System.out.println("RedisValidator htValidatorList:" + this.htValidatorList);
            String string2 = "";
            string2 = this.htValidatorList != null && this.htValidatorList.size() > 0 && this.htValidatorList.get("Connection") != null ? (String)this.htValidatorList.get("Connection") : "none";
            this.validationErrorMap.put("Redis_Connectivity", string2);
            System.out.println("RedisValidator validationErrorMap:" + this.validationErrorMap);
        }
        catch (Exception exception) {
            System.out.println("RedisValidator Exception : " + exception.getMessage());
            this.validationErrorMap.put("Redis_Connectivity", exception.getMessage());
            return false;
        }
        return jedis != null;
    }

    public ArrayList getValidationMsgs() {
        System.out.println("RedisValidator validationMsgs : " + this.validationMsgs);
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        try {
            RedisValidator redisValidator = new RedisValidator(stringArray, new Boolean(false));
            redisValidator.getValidationMsgs();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

