/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisPersisTest
extends RedisBase {
    private static final String REDIS_PERSISTENCE_COMMAND = "Persistence";
    private static final String indexSubject = "REDIS_PERSISTENCE_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_PERSISTENCE_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;

    public RedisPersisTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisPersistenceTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info("{} RedisPersistenceTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisPersistenceTest {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testStart);
            String string = this.getMetrics(REDIS_PERSISTENCE_COMMAND);
            if (string == null || string.length() <= 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Persistence Details is null or empty, hence sending -5 values for all measures", (Object)this.logPrefix);
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasurePersistence(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occured in computeMeasures method", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {}", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public void getRedisMeasurePersistence(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug("{} [getRedisMeasurePersistence]  metricObject is null or empty ,thus returning null", (Object)this.logPrefix);
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug("{} metricObject : {}", (Object)this.logPrefix, (Object)hashtable);
            logger.debug("{} measureIndexTable : {}", (Object)this.logPrefix, (Object)measureIndexTable);
            logger.debug("{} measureNameTable  : {}", (Object)this.logPrefix, (Object)measureNameTable);
            logger.debug("{} redisNameList     : {}", (Object)this.logPrefix, (Object)redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug("{} [getRedisMeasurePersistence] The Metric key and value table is : {}", (Object)this.logPrefix, (Object)hashtable2);
                }
                catch (Exception exception) {
                    logger.warn("{} [getRedisMeasurePersistence] Exception occured while fetching the values from testTable {}", (Object)this.logPrefix, (Object)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasurePersistence] Exception occured while getting fetching the values from metricTable ", (Object)this.logPrefix, (Object)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    double d = 0.0;
                    try {
                        d = n != 8 && n != 9 ? Double.parseDouble(object.toString()) : Double.parseDouble(EgUtils.convertMemoryValues(object.toString(), "B", "MB"));
                        d = d == -1.0 ? -5.0 : d;
                        arrayList.set(n, new Double(d));
                        logger.debug("{} [getRedisMeasurePersistence]  index : {} ==> metric name : {} value : {}", new Object[]{this.logPrefix, string2, n, d});
                    }
                    catch (Exception exception) {
                        logger.warn("{} [getRedisMeasurePersistence] Exception occured while parsing String to Double", (Object)this.logPrefix);
                    }
                }
                logger.info("{} [getRedisMeasurePersistence] The ArrayList  measure contains = {}", (Object)this.logPrefix, (Object)arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception occered in [getRedisMeasurePersistence] {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public static void main(String[] stringArray) {
        RedisPersisTest redisPersisTest = new RedisPersisTest(stringArray);
        redisPersisTest.computeMeasures(new Hashtable());
    }
}

