/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class RedisClientLgTest
extends RedisBase {
    boolean uploadStatus = false;
    public static final Hashtable flagDiscriptionTable = new Hashtable();
    private int max_clients = 20;
    private static final int MAX_CLIENT_LIMIT = 200;
    final String groupSeperator = ":";

    public RedisClientLgTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info("{} Initializing RedisClientByLongRunTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} RedisClientByLongRunTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.warn("{} Exception while initializing RedisClientByLongRunTest {}", (Object)this.logPrefix, (Object)exception);
        }
        String string = this.getValueForParam("Max_Clients");
        if (string != null && string.length() > 0) {
            try {
                this.max_clients = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.max_clients = 20;
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug("{} - {} ", (Object)this.logPrefix, (Object)this.testStart);
            this.getClientListByLongRun();
        }
        catch (Exception exception) {
            logger.warn(" {} Exception occured in computeMeasures method {}", (Object)this.logPrefix, (Object)exception);
        }
        finally {
            logger.debug("{} - {} ", (Object)this.logPrefix, (Object)this.testEnd);
        }
    }

    public ArrayList getClientDetails() {
        String string = this.getclientList();
        logger.debug("[RedisClientByLongRunTest] [getClientDetails] The Client List is :  \n {}", (Object)string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        ArrayList<AbstractMap> arrayList = new ArrayList<AbstractMap>();
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        HashMap hashMap = new HashMap();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.contains("cmd=replconf")) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " ");
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            int n = 0;
            int n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                String string3 = stringTokenizer2.nextToken();
                int n3 = string3.indexOf("=");
                if (n3 <= 0) continue;
                String string4 = string3.substring(0, n3);
                String string5 = string3.substring(n3 + 1);
                if (string4.equals("id")) {
                    n = Integer.parseInt(string5);
                }
                if (string4.equals("age")) {
                    n2 = Integer.parseInt(string5);
                }
                hashMap2.put(string4, string5);
            }
            treeMap.put(n, n2);
            hashMap.put(n, hashMap2);
        }
        if (treeMap.size() > 0 && hashMap.size() > 0) {
            arrayList.add(treeMap);
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    public boolean getClientListByLongRun() {
        ArrayList arrayList = null;
        boolean bl = false;
        try {
            arrayList = this.getClientDetails();
            if (arrayList == null || arrayList.size() == 0) {
                this.addNewMeasure(this.finalMeasures(this.measureCount));
                logger.info("{} Redis Client LIst Details is null or empty, hence sending -5 values for all measures ", (Object)this.logPrefix);
                return bl;
            }
            logger.debug("[{}:{}][RedisClientByLongRunTest] [generalClientList] The ClientDetails are {}", new Object[]{this.reportingName, this.portNo, arrayList});
            TreeMap treeMap = (TreeMap)this.valueSort((TreeMap)arrayList.get(0));
            HashMap hashMap = (HashMap)arrayList.get(1);
            int n = this.getMaxClient();
            int n2 = hashMap.size();
            n = n2 > n ? n : n2;
            Iterator iterator = treeMap.keySet().iterator();
            int n3 = 0;
            while (iterator.hasNext() && n3 < n) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9;
                String string10;
                ++n3;
                Integer n4 = (Integer)iterator.next();
                ArrayList arrayList2 = this.finalMeasures(this.measureCount);
                HashMap hashMap2 = (HashMap)hashMap.get(n4);
                String string11 = (String)hashMap2.get("id");
                if (string11 == null || string11.length() == 0) {
                    string11 = "-5";
                }
                String string12 = (String)hashMap2.get("addr");
                String string13 = string12.substring(0, string12.indexOf(":"));
                String string14 = string12.substring(string12.indexOf(":") + 1);
                if (string12 == null || string12.length() == 0) {
                    string13 = "-5";
                    string14 = "-5";
                }
                if ((string10 = (String)hashMap2.get("fd")) == null || string10.length() == 0) {
                    string10 = "-5";
                }
                if ((string9 = (String)hashMap2.get("name")) == null || string9.length() == 0) {
                    string9 = "-";
                }
                if ((string8 = (String)hashMap2.get("age")) == null || string8.length() == 0) {
                    string8 = "-5";
                }
                if ((string7 = (String)hashMap2.get("idle")) == null || string7.length() == 0) {
                    string7 = "-5";
                }
                String string15 = (String)hashMap2.get("flags");
                if ((string15 = (String)flagDiscriptionTable.get(string15)) == null || string15.length() == 0) {
                    string15 = "-";
                }
                if ((string6 = (String)hashMap2.get("db")) == null || string6.length() == 0) {
                    string6 = "-5";
                }
                if ((string5 = (String)hashMap2.get("sub")) == null || string5.length() == 0) {
                    string5 = "-5";
                }
                if ((string4 = (String)hashMap2.get("psub")) == null || string4.length() == 0) {
                    string4 = "-5";
                }
                if ((string3 = (String)hashMap2.get("multi")) == null || string3.length() == 0) {
                    string3 = "-";
                }
                String string16 = (String)hashMap2.get("qbuf");
                if ((string16 = EgUtils.convertMemoryValues(string16, "B", "MB")) == null || string16.length() == 0) {
                    string16 = "-";
                }
                String string17 = (String)hashMap2.get("qbuf-free");
                string17 = EgUtils.convertMemoryValues(string16, "B", "MB");
                if (string17 == null || string17.length() == 0) {
                    string17 = "-5";
                }
                String string18 = (String)hashMap2.get("obl");
                if ((string18 = EgUtils.convertMemoryValues(string18, "B", "MB")) == null || string18.length() == 0) {
                    string18 = "-5";
                }
                if ((string2 = (String)hashMap2.get("oll")) == null || string2.length() == 0) {
                    string2 = "-5";
                }
                String string19 = (String)hashMap2.get("omem");
                if ((string19 = EgUtils.convertMemoryValues(string19, "B", "MB")) == null || string19.length() == 0) {
                    string19 = "-5";
                }
                if ((string = (String)hashMap2.get("events")) == null || string.length() == 0) {
                    string = "-";
                } else if (string.equals("r")) {
                    string = "readable";
                } else if (string.equals("w")) {
                    string = "writable";
                }
                String string20 = (String)hashMap2.get("cmd");
                if (string20 == null || string20.length() == 0) {
                    string20 = "-";
                }
                arrayList2.set(0, new Double(string11));
                arrayList2.set(1, new Double(-5.0));
                arrayList2.set(2, new Double(string14));
                arrayList2.set(3, new Double(string10));
                arrayList2.set(4, new Double(string6));
                arrayList2.set(5, new Double(string8));
                arrayList2.set(6, new Double(string7));
                arrayList2.set(7, new Double(string5));
                arrayList2.set(8, new Double(string4));
                arrayList2.set(9, new Double(string16));
                arrayList2.set(10, new Double(string17));
                arrayList2.set(11, new Double(string18));
                arrayList2.set(12, new Double(string2));
                arrayList2.set(13, new Double(string19));
                int n5 = Integer.parseInt(string8);
                String string21 = this.getValueForParam("Max_Client_Age");
                int n6 = 1800;
                if (string21 != null && string21.length() > 0) {
                    n6 = Integer.parseInt(string21);
                    logger.debug("{} [getRedisMeasureClient] [getMaxClient] The maximum Age of clients in seconds: {} ", (Object)this.logPrefix, (Object)string21);
                }
                if (!string9.equals("-") && n5 > n6) {
                    this.addNewMeasure(string13 + ":" + string9, arrayList2);
                    logger.info("[{}:{}][RedisClientByLongRunTest] [generalClientList]  Client Name: {} , The ArrayList measure contains = {} : ", new Object[]{this.reportingName, this.portNo, string9, arrayList2});
                    continue;
                }
                if (n5 > n6) {
                    this.addNewMeasure(string13 + ":" + string11, arrayList2);
                    logger.info("[{}:{}][RedisClientByLongRunTest] [generalClientList] Client ID: {} , The ArrayList measure contains =  : {}", new Object[]{this.reportingName, this.portNo, string11, arrayList2});
                    continue;
                }
                logger.info("[{}:{}][RedisClientByLongRunTest] [generalClientList] **** No Long Running Clients in Redis ", (Object)this.reportingName, (Object)this.portNo);
                this.addNewMeasure(this.finalMeasures(this.measureCount));
            }
            bl = true;
        }
        catch (Exception exception) {
            this.addNewMeasure(this.finalMeasures(this.measureCount));
            logger.warn(" [{} : {} ][RedisClientByLongRunTest] [generalClientList] Exception while fetching the values {}", new Object[]{this.reportingName, this.portNo, exception});
        }
        return bl;
    }

    public int getMaxClient() {
        if (this.max_clients > 200) {
            this.max_clients = 200;
        }
        logger.debug("{} [getRedisMeasureClient] [getMaxClient] The maximum number of clients :  {}", (Object)this.logPrefix, (Object)this.max_clients);
        return this.max_clients;
    }

    private Map valueSort(final Map map) {
        Comparator comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                int n = ((Integer)map.get(object2)).compareTo((Integer)map.get(object));
                if (n == 0) {
                    return 1;
                }
                return n;
            }
        };
        TreeMap treeMap = new TreeMap(comparator);
        treeMap.putAll(map);
        return treeMap;
    }

    public static void main(String[] stringArray) {
        RedisClientLgTest redisClientLgTest = new RedisClientLgTest(null);
        redisClientLgTest.computeMeasures(new Hashtable());
    }

    static {
        flagDiscriptionTable.put("O", "Slave in monitor mode");
        flagDiscriptionTable.put("S", "Normal slave server");
        flagDiscriptionTable.put("M", "Master");
        flagDiscriptionTable.put("x", "MULTI/EXEC context");
        flagDiscriptionTable.put("b", "Waiting in a blocking operation");
        flagDiscriptionTable.put("i", "Waiting for a VM I/O");
        flagDiscriptionTable.put("d", "A watched keys has been modified - EXEC will fail");
        flagDiscriptionTable.put("c", "Connection to be closed after writing entire reply");
        flagDiscriptionTable.put("u", "Unblocked");
        flagDiscriptionTable.put("U", "Connected via a Unix domain socket");
        flagDiscriptionTable.put("r", "Readonly mode against a cluster node");
        flagDiscriptionTable.put("A", "Connection to be closed ASAP");
        flagDiscriptionTable.put("N", "No specific flag set");
    }
}

