/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;

public class RUMCollTest
extends RUMCollectorBaseTest {
    private static final double MINUS_FIVE = -5.0;
    private Hashtable failedBeaconsInfoTable = new Hashtable();
    private Hashtable ignoredBeaconsInfoTable = new Hashtable();
    private Hashtable discardedBeaconsInfoTable = new Hashtable();

    public RUMCollTest(String[] args) {
        super(args);
    }

    private ArrayList defaultValues(ArrayList a_measures, int length) {
        int i = 0;
        while (i < length) {
            a_measures.add(new Double(0.0));
            ++i;
        }
        return a_measures;
    }

    public ArrayList getDiscardedBeaconsInfo(String info) {
        ArrayList discardedBeaconsInfoList = (ArrayList)this.discardedBeaconsInfoTable.get(info);
        this.discardedBeaconsInfoTable.put(info, new ArrayList());
        return discardedBeaconsInfoList;
    }

    public void setDiscardedBeaconsInfo(Map discardedBeaconsInfoMap, String componentName) {
        try {
            if (discardedBeaconsInfoMap != null) {
                Iterator itr = discardedBeaconsInfoMap.keySet().iterator();
                ArrayList discardedBeaconsList = new ArrayList();
                while (itr.hasNext()) {
                    ArrayList<String> discardedBeaconsCountList = new ArrayList<String>();
                    String key = (String)itr.next();
                    discardedBeaconsCountList.add(key);
                    discardedBeaconsCountList.add((String)discardedBeaconsInfoMap.get(key));
                    discardedBeaconsList.add(discardedBeaconsCountList);
                }
                this.discardedBeaconsInfoTable.put(componentName, discardedBeaconsList);
            }
            logger.warn("The discardedBeaconsInfoTable = {} for {}", (Object)this.discardedBeaconsInfoTable);
        }
        catch (Exception e) {
            logger.error("[{}][{}][RUMCollTest][setDiscardedBeaconsInfo] exception occured while processing Discarded Beacons Reasons details: ", new Object[]{this.reportingName, this.entity, e});
        }
    }

    public ArrayList getFailedBeaconsInfo(String info) {
        ArrayList failedBeaconsInfoList = (ArrayList)this.failedBeaconsInfoTable.get(info);
        this.failedBeaconsInfoTable.put(info, new ArrayList());
        return failedBeaconsInfoList;
    }

    public void setFailedBeaconsInfo(Map failedBeaconsInfoMap, String componentName) {
        try {
            if (failedBeaconsInfoMap != null) {
                Iterator itr = failedBeaconsInfoMap.keySet().iterator();
                ArrayList failedBeaconsList = new ArrayList();
                while (itr.hasNext()) {
                    ArrayList<String> failedBeaconsCountList = new ArrayList<String>();
                    String key = (String)itr.next();
                    failedBeaconsCountList.add(key);
                    failedBeaconsCountList.add((String)failedBeaconsInfoMap.get(key));
                    failedBeaconsList.add(failedBeaconsCountList);
                }
                this.failedBeaconsInfoTable.put(componentName, failedBeaconsList);
            }
            logger.warn("The failedBeaconsInfoTable = {} for {}", (Object)this.failedBeaconsInfoTable);
        }
        catch (Exception e) {
            logger.error("[{}][{}][RUMCollTest][setFailedBeaconsInfo] exception occured while processing Failed Beacons Reasons details: ", new Object[]{this.reportingName, this.entity, e});
        }
    }

    public ArrayList getIgnoredBeaconsInfoList(String info) {
        ArrayList ignoredBeaconInfoList = (ArrayList)this.ignoredBeaconsInfoTable.get(info);
        this.ignoredBeaconsInfoTable.put(info, new ArrayList());
        return ignoredBeaconInfoList;
    }

    public void setIgnoredBeaconsInfoList(Map ignoredBeaconsInfoMap, String componentName) {
        try {
            if (ignoredBeaconsInfoMap != null) {
                Iterator itr = ignoredBeaconsInfoMap.keySet().iterator();
                ArrayList ignoredBeaconsList = new ArrayList();
                while (itr.hasNext()) {
                    ArrayList<String> ignoredBeaconCountList = new ArrayList<String>();
                    String key = (String)itr.next();
                    ignoredBeaconCountList.add(key);
                    ignoredBeaconCountList.add((String)ignoredBeaconsInfoMap.get(key));
                    ignoredBeaconsList.add(ignoredBeaconCountList);
                }
                this.ignoredBeaconsInfoTable.put(componentName, ignoredBeaconsList);
            }
            logger.warn("The IgnoredBeaconsInfoList = {}", (Object)this.ignoredBeaconsInfoTable);
        }
        catch (Exception e) {
            logger.error("[{}][{}][RUMCollTest][setIngnoredBeaconsInfoList] exception occured while processing Ignored Beacons Reasons details: ", new Object[]{this.reportingName, this.entity, e});
        }
    }

    public void computeMeasures(Hashtable params) {
        try {
            Hashtable SrvceNameGUIDCompNameMapping = testerInfo.getSrvceNameGUIDCompNameMapping();
            logger.debug("SrvceNameGUIDCompNameMapping :{}", (Object)SrvceNameGUIDCompNameMapping);
            Double measurementPeriodInMins = this.measurePeriod / 60000L;
            logger.debug("measurePeriod in RUMCollTestAgnt is {}", (Object)measurementPeriodInMins);
            try {
                String testName = this.getClass().getName();
                JSONObject rmdRDRInfo = this.httpCallToRUMMon(testName, null);
                logger.debug("[{}][{}][RUMCollTest][computeMeasures]  status and RDR Monitoring data/message: {}", new Object[]{this.reportingName, this.entity, rmdRDRInfo});
                if (rmdRDRInfo != null && rmdRDRInfo.containsKey((Object)"status")) {
                    String status = (String)rmdRDRInfo.get((Object)"status");
                    if (status.equals("success")) {
                        JSONObject RdrDataJObj = (JSONObject)rmdRDRInfo.get((Object)"data");
                        Iterator itr = RdrDataJObj.keySet().iterator();
                        while (itr.hasNext()) {
                            ArrayList a_measures = new ArrayList();
                            String key = (String)itr.next();
                            JSONObject RdrMetricsJObj = (JSONObject)RdrDataJObj.get((Object)key);
                            if (RdrMetricsJObj != null) {
                                if (RdrMetricsJObj.containsKey((Object)"rdr")) {
                                    JSONObject rmdJObj = (JSONObject)RdrMetricsJObj.get((Object)"rdr");
                                    if (rmdJObj != null) {
                                        a_measures.add((Double)rmdJObj.get((Object)"numberOfReqs"));
                                        Double numberOfReqs = (Double)rmdJObj.get((Object)"numberOfReqs");
                                        if (key.equalsIgnoreCase("summary")) {
                                            Double rapidRequestCount = (Double)rmdJObj.get((Object)"rapidRequests");
                                            Double reqsRate = (numberOfReqs + rapidRequestCount) / measurementPeriodInMins;
                                            a_measures.add(reqsRate);
                                        } else {
                                            Double reqsRate = numberOfReqs / measurementPeriodInMins;
                                            a_measures.add(reqsRate);
                                        }
                                        a_measures.add((Double)rmdJObj.get((Object)"reqsProcessingRate"));
                                        double totalReqs = (Double)rmdJObj.get((Object)"numberOfReqs");
                                        double ignoredReqs = (Double)rmdJObj.get((Object)"ignoredReqs");
                                        double discardedReqs = (Double)rmdJObj.get((Object)"discardedReqs");
                                        double failedReqsCount = (Double)rmdJObj.get((Object)"numberOfFailedReqs");
                                        double successfulReqs = 0.0;
                                        if (!key.equalsIgnoreCase("summary")) {
                                            successfulReqs = totalReqs - (ignoredReqs + discardedReqs + failedReqsCount);
                                            a_measures.add(successfulReqs);
                                        } else {
                                            long httpTestReqs = (Long)rmdJObj.get((Object)"httpTestRequests");
                                            double queueFullReqs = ((Long)rmdJObj.get((Object)"beaconsDiscardedDueToFullQueue")).longValue();
                                            discardedReqs = discardedReqs - (double)httpTestReqs - queueFullReqs;
                                            successfulReqs = totalReqs - (ignoredReqs + discardedReqs + failedReqsCount);
                                            a_measures.add(successfulReqs);
                                        }
                                        if (totalReqs > 0.0) {
                                            double successPercentage = successfulReqs / totalReqs * 100.0;
                                            a_measures.add(successPercentage);
                                        }
                                        if (key.equalsIgnoreCase("summary")) {
                                            a_measures.add((Double)rmdJObj.get((Object)"numberOfFailedReqs"));
                                            double failedReqsRate = failedReqsCount / measurementPeriodInMins;
                                            a_measures.add(failedReqsRate);
                                            a_measures.add((Double)rmdJObj.get((Object)"failedReqsPercent"));
                                        } else {
                                            int i = 0;
                                            while (i < 3) {
                                                a_measures.add(-5.0);
                                                ++i;
                                            }
                                        }
                                        a_measures.add((Double)rmdJObj.get((Object)"ignoredReqs"));
                                        Double ignoredReqsRate = ignoredReqs / measurementPeriodInMins;
                                        a_measures.add(ignoredReqsRate);
                                        a_measures.add((Double)rmdJObj.get((Object)"ignoredReqsPercent"));
                                        a_measures.add((Double)rmdJObj.get((Object)"discardedReqs"));
                                        Double discardedReqsRate = discardedReqs / measurementPeriodInMins;
                                        a_measures.add(discardedReqsRate);
                                        a_measures.add((Double)rmdJObj.get((Object)"discardedReqsPercent"));
                                        String componentName = this.getComponentName(key);
                                        if (componentName != null) {
                                            this.setIgnoredBeaconsInfoList((HashMap)rmdJObj.get((Object)"ignoredBeaconHashMap"), componentName);
                                            this.setDiscardedBeaconsInfo((HashMap)rmdJObj.get((Object)"discardedBeaconHashMap"), componentName);
                                        }
                                        if (key.equalsIgnoreCase("summary")) {
                                            this.setIgnoredBeaconsInfoList((HashMap)rmdJObj.get((Object)"ignoredBeaconHashMap"), "Summary");
                                            this.setFailedBeaconsInfo((HashMap)rmdJObj.get((Object)"failedBeaconHashMap"), "Summary");
                                            this.setDiscardedBeaconsInfo((HashMap)rmdJObj.get((Object)"discardedBeaconHashMap"), "Summary");
                                        }
                                    } else {
                                        a_measures = this.defaultValues(a_measures, 14);
                                    }
                                } else {
                                    a_measures = this.defaultValues(a_measures, 14);
                                }
                            }
                            if (key.equalsIgnoreCase("summary")) {
                                this.addNewMeasure(key, a_measures);
                                continue;
                            }
                            String componentName = this.getComponentName(key);
                            this.addNewMeasure(componentName, a_measures);
                        }
                    } else if (status.equals("fail")) {
                        logger.error("[{}][{}][RUMCollTest][computeMeasures] status: fail, message: {}", new Object[]{this.reportingName, this.entity, rmdRDRInfo.get((Object)"message")});
                        ArrayList a_measures = new ArrayList();
                        a_measures = this.defaultValues(a_measures, 14);
                        this.addNewMeasure("Summary", a_measures);
                    } else if (status.equals("error")) {
                        logger.error("[{}][{}][RUMCollTest][computeMeasures] status: error, message: {}", new Object[]{this.reportingName, this.entity, rmdRDRInfo.get((Object)"message")});
                    }
                }
            }
            catch (Exception e) {
                logger.error("[{}][{}][RUMCollTest][computeMeasures] Exception occured while processing RDR Monitoring details: ", new Object[]{this.reportingName, this.entity, e});
            }
        }
        catch (Exception ex) {
            logger.error("[{}][{}][RUMCollTest][computeMeasures] Exception in ComputeMeasures of RUMCollTest {}", new Object[]{this.reportingName, this.entity, ex});
        }
    }

    private String getComponentName(String key) {
        Hashtable SrvceNameGUIDCompNameMapping = testerInfo.getSrvceNameGUIDCompNameMapping();
        Set keys = SrvceNameGUIDCompNameMapping.keySet();
        for (String componentName : keys) {
            if (!SrvceNameGUIDCompNameMapping.get(componentName).equals(key)) continue;
            return componentName;
        }
        return null;
    }
}

