/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;

public class RUMAppTest
extends EgRUMBase {
    private Hashtable ddDataTable = null;
    private Hashtable ddResourceDataTable = null;
    private Hashtable ddErrorDataTable = null;
    private Hashtable measureDDAvailabilityMap = null;

    public RUMAppTest(String[] args) {
        super(args);
        this.setMeasureCount(this.measureCount);
        this.allowNegativeValues = new boolean[this.measureCount];
        int i = 0;
        while (i < this.measureCount) {
            this.allowNegativeValues[i] = false;
            ++i;
        }
        this.allowNegativeValues[0] = true;
        logger.info("[" + this.reportingName + "][" + this.entity + "] Test is initilized !!!");
    }

    public void computeMeasures(Hashtable paramList) {
        logger.debug("[" + this.reportingName + "][" + this.entity + "] #########################################");
        logger.debug("[" + this.reportingName + "][" + this.entity + "] IS STARTING !!!");
        this.measureDDAvailabilityMap = new Hashtable();
        this.ddResourceDataTable = new Hashtable();
        this.ddErrorDataTable = new Hashtable();
        boolean newCollectorUsed = false;
        try {
            newCollectorUsed = this.computeValues();
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Error occured during computingmeasurs method : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Error occured during computingmeasurs method : ", (Throwable)e);
        }
        EgRUMBase.siteRumTimeMap.put(this.reportingName, new Long(System.currentTimeMillis()));
        ArrayList measuresList = new ArrayList();
        if (this.isPerDayLimitExceeded()) {
            logger.debug("[" + this.reportingName + "][" + this.entity + "] Per day limit has been exceeded sending -100 for page views !!!");
            measuresList.add(new Double(-100.0));
            int i = 1;
            while (i < this.measureCount) {
                measuresList.add(minusFive);
                ++i;
            }
            measuresList = RUMAppTest.removeExtraMeasure(this.measureCount, measuresList);
            this.addNewMeasure(this.serviceName, measuresList);
            return;
        }
        if (newCollectorUsed) {
            Map applicationStatsMap = this.getApplicationStatisticsMap();
            this.updateRumAppDataFromNewCollector(applicationStatsMap, this.measureDDAvailabilityMap, 38);
            return;
        }
        try {
            this.ddDataTable = new Hashtable();
            Hashtable applicationStats = this.getApplicatonStatistics();
            String flag = (String)flagTable.get(this.reportingName);
            logger.debug("[" + this.reportingName + "][" + this.entity + "] flagTable is : " + flagTable);
            logger.debug("[" + this.reportingName + "][" + this.entity + "] isFlag is : " + flag);
            if (applicationStats != null && flag.equalsIgnoreCase("true")) {
                for (String key : applicationStats.keySet()) {
                    RUMSummaryData data = (RUMSummaryData)applicationStats.get(key);
                    double normalRequestCount = data.getSatisfiedRequestCount();
                    double toleratedRequestCount = data.getToleratedRequestCount();
                    Double apdex = new Double(-5.0);
                    if (data.getRequestCount() != 0.0) {
                        double totalapdex = (normalRequestCount + toleratedRequestCount / 2.0) / data.getRequestCount();
                        apdex = RUMAppTest.getDoubleValue(formatter.format(totalapdex), apdex);
                    }
                    measuresList = new ArrayList();
                    measuresList.add(data.getRequestCount());
                    measuresList.add(data.getSlowRequestCount());
                    measuresList.add(data.getErrorRequestCount());
                    measuresList.add(data.getAveragePageLoadTime());
                    measuresList.add(data.getAverageFrontEndTime());
                    measuresList.add(data.getPageRenderingTime());
                    measuresList.add(data.getAverageDocumentReadyTime());
                    measuresList.add(data.getDomDownloadTime());
                    measuresList.add(data.getDomProcessingTime());
                    measuresList.add(data.getAverageFirstByteTime());
                    measuresList.add(data.getAverageResponseAvailableTime());
                    measuresList.add(data.getAverageNetworkTime());
                    measuresList.add(data.getDNSLookUpTime());
                    measuresList.add(data.getTCPConnectionTime());
                    measuresList.add(data.getRequestPerMinute());
                    measuresList.add(data.getNormalPercentage());
                    measuresList.add(data.getSlowPercentage());
                    measuresList.add(data.getErrorPercentage());
                    measuresList.add(new Double(Double.parseDouble(data.getUserSession())));
                    measuresList.add(data.getSatisfiedRequestCount());
                    measuresList.add(data.getToleratedRequestCount());
                    measuresList.add(data.getFrustratedRequestCount());
                    measuresList.add(apdex);
                    Hashtable deviceStats = this.getDeviceStatistics();
                    if (deviceStats != null) {
                        RUMSummaryData tabletData;
                        RUMSummaryData mobileData;
                        RUMSummaryData desktopData = (RUMSummaryData)deviceStats.get("Desktop");
                        if (desktopData != null) {
                            measuresList.add(desktopData.getRequestCount());
                            if (desktopData.getRequestCount() > 0.0) {
                                this.measureDDAvailabilityMap.put("Desktop:" + this.serviceName, new Boolean(true));
                            }
                        } else {
                            measuresList.add(zeroDouble);
                        }
                        if ((mobileData = (RUMSummaryData)deviceStats.get("Mobile")) != null) {
                            measuresList.add(mobileData.getRequestCount());
                            if (mobileData.getRequestCount() > 0.0) {
                                this.measureDDAvailabilityMap.put("Mobile:" + this.serviceName, new Boolean(true));
                            }
                        } else {
                            measuresList.add(zeroDouble);
                        }
                        if ((tabletData = (RUMSummaryData)deviceStats.get("Tablet")) != null) {
                            measuresList.add(tabletData.getRequestCount());
                            if (tabletData.getRequestCount() > 0.0) {
                                this.measureDDAvailabilityMap.put("Tablet:" + this.serviceName, new Boolean(true));
                            }
                        } else {
                            measuresList.add(zeroDouble);
                        }
                    } else {
                        measuresList.add(zeroDouble);
                        measuresList.add(zeroDouble);
                        measuresList.add(zeroDouble);
                    }
                    measuresList.add(data.getAverageSslHandshakeTime());
                    measuresList.add(data.getAverageAppCacheTime());
                    measuresList.add(data.getAverageRedirectionTime());
                    measuresList.add(data.getAverageBrowserWaitTime());
                    measuresList.add(data.getAverageBrowserInitialReqTime());
                    measuresList.add(new Double(Double.parseDouble(data.getUniqueIPCount())));
                    logger.debug("-[" + this.reportingName + "][" + this.entity + "]-measuresList : " + measuresList);
                    this.ddDataTable.put(this.serviceName, data.getDDDataList());
                    this.ddResourceDataTable.put(this.serviceName, data.getDDResourceData());
                    this.ddErrorDataTable.put(this.serviceName, data.getDDErrorData());
                    if (this.healthyTopNDD_Limit != 0 && data.getRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("All:" + this.serviceName, new Boolean(true));
                    }
                    if (data.getSlowRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Slow:" + this.serviceName, new Boolean(true));
                    }
                    if (data.getErrorRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Error:" + this.serviceName, new Boolean(true));
                    }
                    if (data.getSatisfiedRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Satisfied:" + this.serviceName, new Boolean(true));
                    }
                    if (data.getToleratedRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Tolerating:" + this.serviceName, new Boolean(true));
                    }
                    if (data.getFrustratedRequestCount() > 0.0) {
                        this.measureDDAvailabilityMap.put("Frustrated:" + this.serviceName, new Boolean(true));
                    }
                    measuresList = RUMAppTest.removeExtraMeasure(this.measureCount, measuresList);
                    this.addNewMeasure(this.serviceName, measuresList);
                    logger.debug("[" + this.reportingName + "][" + this.entity + "] Successfully sent the measures !!!");
                }
            } else {
                logger.warn("Either the collector is down or there is no data to send !!!");
            }
        }
        catch (Exception e) {
            logger.error("[" + this.reportingName + "][" + this.entity + "] Iteration of specied hashtable failed : " + e.getMessage());
            logger.trace("[" + this.reportingName + "][" + this.entity + "] Iteration of specied hashtable failed : ", (Throwable)e);
        }
    }

    public boolean isDDAvailable(String measureColanInfo) {
        if (!this.measureDDAvailabilityMap.containsKey(measureColanInfo)) {
            return false;
        }
        return (Boolean)this.measureDDAvailabilityMap.get(measureColanInfo) != false;
    }

    public ArrayList getDDData(String info) {
        ArrayList dd = null;
        if (!this.isDDSent(this.entity)) {
            dd = (ArrayList)this.ddDataTable.remove(info);
        }
        return dd;
    }

    public ArrayList getDDResourceData(String info) {
        ArrayList dd = null;
        if (!this.isDDSent(this.entity)) {
            dd = (ArrayList)this.ddResourceDataTable.remove(info);
        }
        return dd;
    }

    public ArrayList getDDErrorData(String info) {
        ArrayList dd = null;
        if (!this.isDDSent(this.entity)) {
            dd = (ArrayList)this.ddErrorDataTable.remove(info);
        }
        return dd;
    }
}

