/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

class RSADataSourceTest
extends EgSnmpGenericTest {
    private Hashtable prevTotalRequest = new Hashtable();
    private Hashtable prevFailedRequest = new Hashtable();
    boolean isFirst = true;

    public RSADataSourceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasure(".1.3.6.1.4.1.2197.20.8.1.1");
            Hashtable hashtable3 = this.getMeasure(".1.3.6.1.4.1.2197.20.8.1.2");
            Hashtable hashtable4 = this.getMeasure(".1.3.6.1.4.1.2197.20.8.1.8");
            Hashtable hashtable5 = this.getMeasure(".1.3.6.1.4.1.2197.20.8.1.5");
            Hashtable hashtable6 = this.getMeasure(".1.3.6.1.4.1.2197.20.8.1.7");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Error :", "RSADataSourceTest error occured in getMeasure for targetHost:", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable5.get(string);
                String string4 = (String)hashtable6.get(string);
                if (string3 == null || string3.length() == 0) {
                    string3 = "-5";
                } else if (string3.indexOf("Gauge:") != -1) {
                    string3 = string3.substring(string3.indexOf(":") + 1);
                }
                if (string4 == null || string4.length() == 0) {
                    string4 = "-5";
                } else if (string4.indexOf("Gauge:") != -1) {
                    string4 = string4.substring(string4.indexOf(":") + 1);
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                if (this.prevTotalRequest != null && this.prevTotalRequest.size() > 0) {
                    String string5 = (String)hashtable3.get(string);
                    String string6 = (String)hashtable4.get(string);
                    String string7 = (String)this.prevTotalRequest.get(string);
                    String string8 = (String)this.prevFailedRequest.get(string);
                    double d = this.getDiff(string5, string7);
                    double d2 = this.getDiff(string6, string8);
                    double d3 = 0.0;
                    if (this.timeSinceLastTest > 0.0) {
                        d3 = d / this.timeSinceLastTest;
                    }
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(string3));
                    arrayList.add(new Double(string4));
                    System.out.println("[RSADataSourceTest] Info : " + string2 + " measureList: " + arrayList);
                    this.addNewMeasure(string2, arrayList);
                    continue;
                }
                arrayList = new ArrayList();
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(-5.0));
                arrayList.add(new Double(string3));
                arrayList.add(new Double(string4));
                System.out.println("[RSADataSourceTest] Info : " + string2 + " measureList: " + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
            this.prevTotalRequest = hashtable3;
            this.prevFailedRequest = hashtable4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private double getDiff(String string, String string2) {
        double d = -5.0;
        if (string == null || string2 == null) {
            return d;
        }
        try {
            if (string.indexOf("Gauge:") != -1) {
                string = string.substring(string.indexOf(":") + 1);
            }
            if (string2.indexOf("Gauge:") != -1) {
                string2 = string2.substring(string2.indexOf(":") + 1);
            }
            double d2 = this.getDoubleValue(string);
            double d3 = this.getDoubleValue(string2);
            if (d2 >= 0.0 && d3 >= 0.0) {
                d = d2 - d3;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    public Hashtable getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        try {
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    if (this.lhs[i].startsWith(".")) continue;
                    string2 = this.lhs[i];
                    string3 = this.rhs[i];
                    hashtable.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "RSADataSourceTest error occured in getMeasures", exception.toString());
            exception.printStackTrace();
        }
        return hashtable;
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }
}

