/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;

public class ProgressDbValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public boolean isConnectivityOk = true;
    public boolean isExternalTest = false;
    public boolean meAgentLess = false;
    private String ssl = "false";
    private String dbName = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    private boolean isUserPrevilegeDenied = false;
    private ArrayList previlegeDeniedTables = new ArrayList();

    public ProgressDbValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-database_name")) {
                    this.dbName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess != null && this.isAgentLess.equalsIgnoreCase("y")) {
                        this.meAgentLess = true;
                        continue;
                    }
                    this.isAgentLess = "false";
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.ssl = string3;
            }
        }
        this.validationMsgs = new ArrayList();
        this.validate();
    }

    public void validate() {
        try {
            if (!this.checkProgressDbConnectivity()) {
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("Progress Database Server Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("Progress Database Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port settings is incorrect");
                } else {
                    String string = (String)this.validationErrorMap.get("Progressdb_Connectivity");
                    if (this.isUserPrevilegeDenied) {
                        String string2 = "";
                        StringBuffer stringBuffer = new StringBuffer(string);
                        int n = this.previlegeDeniedTables.size();
                        stringBuffer.append(" due to : [ \"User '" + this.user + "' doesn't have SELECT permission to the following tables:\" ]");
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            string2 = (String)this.previlegeDeniedTables.get(i);
                            n2 = i + 1;
                            stringBuffer.append(" (" + n2 + ")." + string2);
                            if (i + 1 == n) continue;
                            stringBuffer.append(",");
                        }
                        string = stringBuffer.toString();
                        System.out.println("TESTING ::" + string);
                        this.validationMsgs.add("Progress Database Server Connectivity$#$OK");
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Port$#$OK");
                        this.validationMsgs.add("Privilege Validation$#$" + string);
                    } else {
                        this.validationMsgs.add("Progress Database Server Connectivity$#$" + string);
                        this.validationMsgs.add("Host IP/Name$#$OK");
                        this.validationMsgs.add("Port$#$OK");
                    }
                }
            } else {
                this.validationMsgs.add("Progress Database Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("Privilege Validation$#$OK");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkProgressDbConnectivity() {
        block13: {
            boolean bl = false;
            String string = "";
            Connection connection = null;
            Statement statement = null;
            ResultSet resultSet = null;
            String string2 = "com.ddtek.jdbc.openedge.OpenEdgeDriver";
            String string3 = "jdbc:datadirect:openedge://" + this.host + ":" + this.port + ";databaseName=" + this.dbName;
            try {
                block12: {
                    try {
                        this.host = IPV6Helper.getValidIPAddress(this.host);
                        Class.forName(string2);
                        connection = DriverManager.getConnection(string3, this.user, this.password);
                        if (connection == null) break block12;
                        this.checkProgressDBUserprivilege(connection);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        int n = sQLException.getErrorCode();
                        String string4 = sQLException.getMessage();
                        this.isConnectivityOk = false;
                        boolean bl2 = false;
                        if (n == -20228) {
                            bl = true;
                            string4 = "Access denied Authorization failed";
                        } else if (n == -20109) {
                            bl = true;
                            string4 = "Remote Database Name '" + this.dbName + "' is not valid";
                        }
                        if (bl) {
                            this.validationErrorMsg = string4.trim();
                        } else {
                            String string5 = this.getStackTraceAsString(sQLException);
                            if (string5 != null && string5.indexOf("[OpenEdge]") > 0) {
                                string5 = string5.substring(string5.indexOf("OpenEdge]") + 9, string5.length());
                                string = string5 = string5.substring(0, string5.indexOf(")") + 1);
                            } else {
                                string = string5;
                            }
                            this.validationErrorMsg = string;
                        }
                        this.validationErrorMap.put("Progressdb_Connectivity", this.validationErrorMsg);
                        Object var14_9 = null;
                        this.closeResultSet(resultSet);
                        this.closeStatement(statement);
                        this.closeConnnection(connection);
                        break block13;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Object var14_10 = null;
                        this.closeResultSet(resultSet);
                        this.closeStatement(statement);
                        this.closeConnnection(connection);
                    }
                }
                Object var14_8 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
            }
            catch (Throwable throwable) {
                Object var14_11 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
                throw throwable;
            }
        }
        return this.isConnectivityOk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkProgressDBUserprivilege(Connection connection) {
        Statement statement = null;
        ResultSet resultSet = null;
        boolean bl = false;
        String string = "";
        try {
            try {
                String string2;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("PUB.\"_ActAILog\"");
                arrayList.add("PUB.\"_ActBILog\"");
                arrayList.add("PUB.\"_ActIOFile\"");
                arrayList.add("PUB.\"_ActIndex\"");
                arrayList.add("PUB.\"_ActServer\"");
                arrayList.add("PUB.\"_Actbuffer\"");
                arrayList.add("PUB.\"_Area\"");
                arrayList.add("PUB.\"_AreaStatus\"");
                arrayList.add("PUB.\"_BuffStatus\"");
                arrayList.add("PUB.\"_Connect\"");
                arrayList.add("PUB.\"_Latch\"");
                arrayList.add("PUB.\"_LockReq\"");
                arrayList.add("PUB.\"_UserIO\"");
                arrayList.add("PUB.\"_UserLock\"");
                arrayList.add("PUB.\"_Logging\"");
                arrayList.add("PUB.\"_File\"");
                arrayList.add("PUB.\"_Trans\"");
                arrayList.add("PUB.\"_ActOther\"");
                arrayList.add("PUB.\"_Index\"");
                arrayList.add("PUB.\"_IndexStat\"");
                arrayList.add("PUB.\"_TableStat\"");
                arrayList.add("PUB.\"_DbStatus\"");
                System.out.println("ProgressDbValidator:: tableList::" + arrayList);
                try {
                    statement = connection.createStatement();
                }
                catch (Exception exception) {
                    String string3 = this.getStackTraceAsString(exception);
                    if (string3 != null && string3.indexOf("[OpenEdge]") > 0) {
                        string3 = string3.substring(string3.indexOf("OpenEdge]") + 9, string3.length());
                        string = string3 = string3.substring(0, string3.indexOf(")") + 1);
                    } else {
                        string = string3;
                    }
                    this.validationErrorMsg = string;
                    this.closeConnnection(connection);
                    this.isConnectivityOk = false;
                    Object var16_15 = null;
                    this.closeResultSet(resultSet);
                    this.closeStatement(statement);
                    this.closeConnnection(connection);
                    return;
                }
                String string4 = "";
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        string4 = (String)arrayList.get(i);
                        resultSet = statement.executeQuery("select top 1 * from " + string4);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                        int n = sQLException.getErrorCode();
                        String string5 = sQLException.getMessage();
                        this.isConnectivityOk = false;
                        this.isUserPrevilegeDenied = true;
                        System.out.println("ProgressDbValidator -->> Exception while checking permission for table::" + string4 + "errorCode:" + n + ":messageForErrorCode:" + string5);
                        if (n == -20228) {
                            bl = true;
                            string5 = "Access denied Authorization failed";
                        }
                        if (bl) {
                            this.validationErrorMsg = string5.trim();
                        } else {
                            string2 = this.getStackTraceAsString(sQLException);
                            if (string2 != null && string2.indexOf("[OpenEdge]") > 0) {
                                string2 = string2.substring(string2.indexOf("OpenEdge]") + 9, string2.length());
                                string = string2 = string2.substring(0, string2.indexOf(")") + 1);
                            } else {
                                string = string2;
                            }
                            this.validationErrorMsg = string;
                        }
                        this.validationErrorMap.put("Progressdb_Connectivity", this.validationErrorMsg);
                        this.previlegeDeniedTables.add(string4);
                    }
                }
                this.closeResultSet(resultSet);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add("PUB.\"_DbParams\"");
                arrayList2.add("PUB.\"_Startup\"");
                for (int i = 0; i < arrayList2.size(); ++i) {
                    try {
                        string4 = (String)arrayList2.get(i);
                        resultSet = statement.executeQuery("select top 1 * from " + string4);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        int n = sQLException.getErrorCode();
                        string2 = sQLException.getMessage();
                        boolean bl2 = false;
                        System.out.println("ProgressDbValidator -->> Exception while checking permission for table::" + string4 + "errorCode:" + n + ":messageForErrorCode:" + string2);
                        if (n == -20228) {
                            sQLException.printStackTrace();
                            this.isConnectivityOk = false;
                            this.isUserPrevilegeDenied = true;
                            bl = true;
                            string2 = "Access denied Authorization failed";
                        } else if (n == -210083) {
                            bl = true;
                            bl2 = true;
                        }
                        if (bl) {
                            if (!bl2) {
                                this.validationErrorMsg = string2.trim();
                            }
                        } else {
                            String string6 = this.getStackTraceAsString(sQLException);
                            if (string6 != null && string6.indexOf("[OpenEdge]") > 0) {
                                string6 = string6.substring(string6.indexOf("OpenEdge]") + 9, string6.length());
                                string = string6 = string6.substring(0, string6.indexOf(")") + 1);
                            } else {
                                string = string6;
                            }
                            this.validationErrorMsg = string;
                        }
                        this.validationErrorMap.put("Progressdb_Connectivity", this.validationErrorMsg);
                        if (bl2) continue;
                        this.previlegeDeniedTables.add(string4);
                    }
                }
                Object var16_16 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string7 = exception.getMessage();
                this.isConnectivityOk = false;
                String string8 = this.getStackTraceAsString(exception);
                if (string8 != null && string8.indexOf("[OpenEdge]") > 0) {
                    string8 = string8.substring(string8.indexOf("OpenEdge]") + 9, string8.length());
                    string = string8 = string8.substring(0, string8.indexOf(")") + 1);
                } else {
                    string = string8;
                }
                this.validationErrorMsg = string;
                Object var16_17 = null;
                this.closeResultSet(resultSet);
                this.closeStatement(statement);
                this.closeConnnection(connection);
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            this.closeResultSet(resultSet);
            this.closeStatement(statement);
            this.closeConnnection(connection);
            throw throwable;
        }
    }

    public ArrayList getValidationMsgs() {
        System.out.println("########getting Validation Hashtable---->" + this.validationMsgs);
        return this.validationMsgs;
    }

    public void closeConnnection(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
    }
}

