/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgExternalInfo;
import com.eg.IPV6Helper;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class PostgreSQLValidator
extends EgServerValidator {
    public String reportingName = "";
    public String test = "";
    public String host = "";
    public String port = "";
    public String user = "";
    public String password = "";
    public String domain = "";
    public String isAgentLess = "";
    public String alMode = "";
    public String alUser = "";
    public String alPassword = "";
    public String database = "";
    public String SSL = "";
    public boolean meAgentLess = false;
    public boolean isConnectivityOk = true;
    public String connectivityMsg = "";
    public String subject = "WORKING_TESTS";
    public String key = "";
    public String errorMsg = "error";
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public boolean isFromManager = false;
    public boolean isTargetIp = true;
    public ArrayList validationMsgs = null;
    public Hashtable validationErrorMap = new Hashtable();
    EgExternalInfo extInfo = new EgExternalInfo("agent");
    private String pgsqlDriver = "org.postgresql.Driver";

    public PostgreSQLValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String string2 = string.substring(0, string.indexOf(":"));
                String string3 = string.substring(string.indexOf(":") + 1);
                if ((string2 = string2.trim()) != null && string2.equalsIgnoreCase("-host")) {
                    this.host = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-port")) {
                    this.port = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-test")) {
                    this.test = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-username")) {
                    this.user = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-password")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.password = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-domain")) {
                    this.domain = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-agentless")) {
                    this.isAgentLess = string3;
                    if (this.isAgentLess == null || !this.isAgentLess.equalsIgnoreCase("y")) continue;
                    this.meAgentLess = true;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-almode")) {
                    this.alMode = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-aluser")) {
                    this.alUser = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-alpassword")) {
                    if ((string3 = EgCrypt.decrypt(string3)).indexOf("~EG~") != -1) {
                        string3 = string3.substring(0, string3.indexOf("~EG~"));
                    }
                    this.alPassword = string3;
                    continue;
                }
                if (string2 != null && string2.equalsIgnoreCase("-dbName")) {
                    this.database = string3;
                    continue;
                }
                if (string2 == null || !string2.equalsIgnoreCase("-ssl")) continue;
                this.SSL = string3;
            }
        }
        if (!this.isIpAddress(this.host)) {
            this.isTargetIp = false;
        }
        this.key = this.test + "#~#" + this.reportingName + ":" + this.port;
        this.validationMsgs = new ArrayList();
        if (this.extInfo.isRemoteBased(this.reportingName)) {
            this.meAgentLess = true;
        }
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        try {
            if (!this.checkPostgreSQLConnectivity()) {
                this.subject = "ERROR_TESTS";
                this.logMsgToStatusFile(this.subject, this.key, this.errorMsg);
                if (!this.isIPReachable()) {
                    this.validationMsgs.add("PostgreSQL Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$Host IP/Name  '" + this.host + "' is invalid or Host IP/Name is unreachable");
                    this.validationMsgs.add("Port$#$NA");
                } else if (!this.isPortReachable()) {
                    this.validationMsgs.add("PostgreSQL Connectivity$#$Failed");
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$Port is down or listener is down");
                } else {
                    String string = (String)this.validationErrorMap.get("PostgreSQL_Connectivity");
                    this.validationMsgs.add("PostgreSQL Connectivity$#$" + string);
                    this.validationMsgs.add("Host IP/Name$#$OK");
                    this.validationMsgs.add("Port$#$OK");
                }
                if (!this.isFromManager) {
                    return;
                }
            } else if (!this.checkPostgreSQLSuperUserRole()) {
                this.validationMsgs.add("PostgreSQL Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("User Monitoring Privilege$#$User doesn't have required privilege");
                if (!this.isFromManager) {
                    return;
                }
            } else {
                this.validationMsgs.add("PostgreSQL Connectivity$#$OK");
                this.validationMsgs.add("Host IP/Name$#$OK");
                this.validationMsgs.add("Port$#$OK");
                this.validationMsgs.add("User Monitoring Privilege$#$OK");
            }
            this.logMsgToStatusFile(this.subject, this.key, "OK#" + this.getCurrentTime());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ArrayList getValidationMsgs() {
        return this.validationMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean checkPostgreSQLConnectivity() {
        block14: {
            Connection connection;
            block13: {
                boolean bl = false;
                String string = "";
                connection = null;
                this.host = IPV6Helper.getValidIPAddress(this.host);
                connection = this.getConnection(this.host, this.port, this.user, this.password, this.database, this.SSL);
                if (connection != null) break block13;
                boolean bl2 = false;
                Object var7_6 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return bl2;
            }
            Object var7_7 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block14;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block14;
            {
                catch (Exception exception) {
                    boolean bl = false;
                    Object var7_8 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                    return bl;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkPostgreSQLSuperUserRole() {
        boolean bl;
        block19: {
            ResultSet resultSet;
            Statement statement;
            Connection connection;
            block18: {
                bl = false;
                connection = null;
                statement = null;
                resultSet = null;
                this.host = IPV6Helper.getValidIPAddress(this.host);
                connection = this.getConnection(this.host, this.port, this.user, this.password, this.database, this.SSL);
                if (connection == null) break block18;
                statement = connection.createStatement();
                String string = this.user.toLowerCase();
                String string2 = "SELECT rolname,rolsuper,rolinherit,rolcreaterole,rolcreatedb FROM pg_catalog.pg_roles where lower(rolname)='" + string + "'";
                resultSet = statement.executeQuery(string2);
                if (resultSet == null) break block18;
                while (resultSet.next()) {
                    String string3 = resultSet.getString("rolname");
                    boolean bl2 = resultSet.getBoolean("rolsuper");
                    if (!bl2) continue;
                    bl = true;
                }
                resultSet.close();
            }
            Object var10_10 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
                break block19;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block19;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var10_11 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                        break block19;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        return bl;
    }

    public boolean isIpAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            return false;
        }
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 <= 255 && n2 >= 0) continue;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(String string, String string2, String string3, String string4, String string5, String string6) {
        Connection connection = null;
        boolean bl = false;
        String string7 = "";
        Properties properties = new Properties();
        long l = System.currentTimeMillis();
        try {
            try {
                if (string3 == null || string3.equalsIgnoreCase("NULL") || string3.equalsIgnoreCase("none")) {
                    string3 = "";
                }
                if (string5 == null || string5.equalsIgnoreCase("NULL") || string5.equalsIgnoreCase("none")) {
                    string5 = "";
                }
                if (string4 == null || string4.equalsIgnoreCase("NULL") || string4.equalsIgnoreCase("none")) {
                    string4 = "";
                }
                String string8 = "jdbc:postgresql://" + string + ":" + string2 + "/" + string5;
                properties.setProperty("user", string3);
                properties.setProperty("password", string4);
                if (string6 != null && string6.equalsIgnoreCase("true")) {
                    properties.setProperty("ssl", string6);
                    properties.setProperty("sslfactory", "org.postgresql.ssl.NonValidatingFactory");
                }
                Class.forName(this.pgsqlDriver);
                connection = DriverManager.getConnection(string8, properties);
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                String string9 = sQLException.getMessage();
                this.isConnectivityOk = false;
                switch (n) {
                    case 0: {
                        if (string9 != null && string9.indexOf("does not support SSL") > -1) {
                            string9 = "The server does not support SSL";
                        } else if (string9 != null && string9.indexOf("password authentication failed") > -1) {
                            string9 = "Invalid username/password; logon denied";
                        } else if (string9 != null && string9.indexOf("database") > -1) {
                            string9 = "Invalid username/database; logon denied";
                        }
                        bl = true;
                    }
                }
                String string10 = this.getStackTraceAsString(sQLException);
                string7 = string10.substring(0, string10.indexOf("at"));
                this.validationErrorMsg = bl ? string9.trim() : string7;
                if (this.validationErrorMsg != null && this.validationErrorMsg.indexOf(":") > 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.validationErrorMsg, ":");
                    StringBuffer stringBuffer = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string11 = stringTokenizer.nextToken();
                        stringBuffer.append(string11.trim() + " ");
                    }
                    this.validationErrorMsg = stringBuffer.toString();
                    this.validationErrorMsg = this.validationErrorMsg.trim();
                }
                this.validationErrorMap.put("PostgreSQL_Connectivity", this.validationErrorMsg);
                this.errorMsg = string9.trim() + "#Stack Trace:" + sQLException.getMessage().trim() + " " + string10.trim() + "#" + this.getCurrentTime();
                Object var21_16 = null;
                return connection;
            }
            catch (Exception exception) {
                String string12 = this.getStackTraceAsString(exception);
                this.validationErrorMsg = string7;
                this.validationErrorMap.put("PostgreSQL_Connectivity", this.validationErrorMsg);
                this.errorMsg = "Stack Trace:" + exception.getMessage().trim() + " " + string12.trim() + "#" + this.getCurrentTime();
                Object var21_17 = null;
                return connection;
            }
            Object var21_15 = null;
            return connection;
        }
        catch (Throwable throwable) {
            Object var21_18 = null;
            return connection;
        }
    }

    public static void main(String[] stringArray) {
        PostgreSQLValidator postgreSQLValidator = new PostgreSQLValidator(stringArray, new Boolean(false));
    }
}

