/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class PepPrsJdbcConnTest
extends GenericTest {
    private String psAdmin_home = "";
    private String domain = "";
    private String cmd = "";
    private String exeCmc = "";
    private String debugFlag = "";
    private String sys_OS = "";
    private String[] envp = null;
    private boolean debug = false;

    public PepPrsJdbcConnTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.psAdmin_home = this.getValueForParam("psAdmin_home");
        this.domain = this.getValueForParam("domain");
        this.debugFlag = this.getValueForParam("debug");
        this.envp = new String[2];
        if (this.psAdmin_home == null || this.psAdmin_home.equalsIgnoreCase("NULL") || this.psAdmin_home.equalsIgnoreCase("none")) {
            this.psAdmin_home = "";
        }
        if (this.domain == null || this.domain.equalsIgnoreCase("NULL") || this.domain.equalsIgnoreCase("none")) {
            this.domain = "";
        }
        this.debug = this.debugFlag == null ? false : this.debugFlag != null && (this.debugFlag.equalsIgnoreCase("true") || this.debugFlag.equalsIgnoreCase("yes"));
        this.cmd = "printjdbcconnpool";
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (this.sys_OS.trim().startsWith("WIN")) {
            this.psAdmin_home.replace('/', '\\');
            this.exeCmc = EgInstallInfo.getInstallDir() + "\\lib\\PeopleProcessScheduler.bat " + this.psAdmin_home + " " + this.domain + " " + this.cmd;
        } else {
            this.psAdmin_home.replace('\\', '/');
            this.envp[0] = "PATH=" + EgInstallInfo.getInstallDir() + "/bin";
            this.envp[1] = "LD_LIBRARY_PATH=/usr/lib";
            this.exeCmc = EgInstallInfo.getInstallDir() + "/bin/PeopleProcessScheduler.sh " + this.psAdmin_home + " " + this.domain + " " + this.cmd;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        int n;
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        EgUtilities egUtilities = EgUtilities.createInstance();
        arrayList = this.sys_OS.trim().startsWith("WIN") ? egUtilities.getExecOutputLines(this.exeCmc) : egUtilities.getExecOutputLinesForUnix(this.exeCmc, this.envp);
        if (arrayList == null || arrayList.size() == 0) {
            this.logToErrorFile("Error:", "PepPrsJdbcConnTest.computeMeasures", "Jdbc connection details measures not available:" + this.targetHost + " reportingName:" + this.reportingName);
            System.out.println("[PepPrsJdbcConnTest] Error in executing the command ..." + this.exeCmc);
            return;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            string = (String)arrayList2.get(n);
            ++n2;
            if (string.startsWith("---------")) break;
        }
        try {
            for (n = n2; n < arrayList2.size(); ++n) {
                string = (String)arrayList2.get(n);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n3 = stringTokenizer.countTokens();
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = string3 + ":" + string2;
                double d = Double.valueOf(string5);
                double d2 = Double.valueOf(string7);
                double d3 = (d - d2) / d * 100.0;
                arrayList3.add(new Double(string6));
                arrayList3.add(new Double(string5));
                arrayList3.add(new Double(string7));
                arrayList3.add(new Double(d3));
                if (this.debug) {
                    System.out.println("[PepPrsJdbcConnTest] Info ======>" + string8 + "MeasureList=====>" + arrayList3);
                }
                this.addNewMeasure(string8, arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error:", "PepPrsJdbcConnTest.computeMeasures", "error occured:" + this.targetHost + " reportingName:" + this.reportingName + " errormsg:" + exception.toString());
        }
    }

    public static void main(String[] stringArray) {
        PepPrsJdbcConnTest pepPrsJdbcConnTest = new PepPrsJdbcConnTest(stringArray);
        try {
            while (true) {
                pepPrsJdbcConnTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

