/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

class PepAppJdbcConnTest
extends GenericTest {
    private String psAdmin_home = "";
    private String domain = "";
    private String cmd = "";
    private String exeCmc = "";
    private String sys_OS = "";
    private String[] envp = null;

    public PepAppJdbcConnTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.psAdmin_home = this.getValueForParam("psAdmin_home");
        this.domain = this.getValueForParam("domain");
        this.envp = new String[2];
        if (this.psAdmin_home == null || this.psAdmin_home.equalsIgnoreCase("NULL") || this.psAdmin_home.equalsIgnoreCase("none")) {
            this.psAdmin_home = "";
        }
        if (this.domain == null || this.domain.equalsIgnoreCase("NULL") || this.domain.equalsIgnoreCase("none")) {
            this.domain = "";
        }
        this.cmd = "printjdbcconnpool";
        this.sys_OS = System.getProperty("os.name").toUpperCase();
        if (this.sys_OS.trim().startsWith("WIN")) {
            this.psAdmin_home.replace('/', '\\');
            this.exeCmc = EgInstallInfo.getInstallDir() + "\\lib\\peoplesoft.bat " + this.psAdmin_home + " " + this.domain + " " + this.cmd;
        } else {
            this.psAdmin_home.replace('\\', '/');
            this.envp[0] = "PATH=" + EgInstallInfo.getInstallDir() + "/bin";
            this.envp[1] = "LD_LIBRARY_PATH=/usr/lib";
            this.exeCmc = EgInstallInfo.getInstallDir() + "/bin/peoplesoft.sh " + this.psAdmin_home + " " + this.domain + " " + this.cmd;
        }
        System.out.println(this.reportingName + ":" + this.entity + ":" + this.portNo + "  Constructor");
    }

    public void computeMeasures(Hashtable hashtable) {
        String string;
        int n;
        int n2 = 0;
        ArrayList arrayList = new ArrayList();
        EgUtilities egUtilities = EgUtilities.createInstance();
        System.out.println(this.reportingName + ":" + this.entity + ":" + this.portNo + "  === > inside computeMeasures");
        System.out.println(this.reportingName + ":" + this.entity + ":" + this.portNo + " psAdmin_home " + this.psAdmin_home);
        System.out.println(this.reportingName + ":" + this.entity + ":" + this.portNo + " domain " + this.domain);
        System.out.println(this.reportingName + ":" + this.entity + "  command    === >" + this.exeCmc);
        if (this.sys_OS.trim().startsWith("WIN")) {
            arrayList = egUtilities.getExecOutputLines(this.exeCmc);
        } else {
            System.out.println(this.reportingName + ":" + this.entity + ":" + this.portNo + "  sys_OS :" + this.sys_OS + ", so  calling getExecOutputLines");
            arrayList = egUtilities.getExecOutputLines(this.exeCmc);
        }
        if (arrayList == null || arrayList.size() == 0) {
            this.logToErrorFile("Error:", "PepAppJdbcConnTest.computeMeasures", "Jdbc connection details measures not available:" + this.targetHost + " reportingName:" + this.reportingName);
            System.out.println(this.reportingName + ":" + this.entity + " Error in executing the command ..." + this.exeCmc);
            return;
        }
        System.out.println(this.reportingName + ":" + this.entity + " jdbcConnList  ..." + arrayList);
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        System.out.println(this.reportingName + ":" + this.entity + "  output  =====>" + arrayList2);
        if (arrayList2 == null || arrayList2.size() == 0) {
            return;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            string = (String)arrayList2.get(n);
            ++n2;
            if (string.startsWith("---------")) break;
        }
        try {
            for (n = n2; n < arrayList2.size(); ++n) {
                string = (String)arrayList2.get(n);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n3 = stringTokenizer.countTokens();
                ArrayList<Double> arrayList3 = new ArrayList<Double>();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = string3 + ":" + string2;
                double d = Double.valueOf(string5);
                double d2 = Double.valueOf(string7);
                double d3 = (d - d2) / d * 100.0;
                arrayList3.add(new Double(string6));
                arrayList3.add(new Double(string5));
                arrayList3.add(new Double(string7));
                arrayList3.add(new Double(d3));
                System.out.println(this.reportingName + ":" + this.entity + "  measure List  =====>" + arrayList3);
                this.addNewMeasure(string8, arrayList3);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Error:", "PepAppJdbcConnTest.computeMeasures", "error occured:" + this.targetHost + " reportingName:" + this.reportingName + " errormsg:" + exception.toString());
            System.out.println(this.reportingName + ":" + this.entity + ":" + this.portNo + " inside computeMeasures error occured :" + exception);
        }
    }

    public static void main(String[] stringArray) {
        PepAppJdbcConnTest pepAppJdbcConnTest = new PepAppJdbcConnTest(stringArray);
        try {
            while (true) {
                pepAppJdbcConnTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

