/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

class OraPgaTest
extends GenericTest {
    private String oraSid = "";
    private String username = "";
    private String password = "";
    private int oraVersion = 11;
    private boolean isFirstTime = true;
    private boolean errorOccured = false;
    private boolean isOracle12c = false;
    private boolean isCDB = false;
    private int msgLogCounter = 0;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public OraPgaTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.username = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        Object object;
        Object object2;
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            object2 = new ArrayList();
            object2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (object2 != null && ((ArrayList)object2).size() > 2) {
                int n = (Integer)((ArrayList)object2).get(0);
                object = (String)((ArrayList)object2).get(1);
                if (((String)object).equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (n >= 12) {
                    this.isOracle12c = true;
                    string = (String)((ArrayList)object2).get(2);
                    if (string.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.oraVersion = n;
                this.isInitCheckNeeded = false;
            } else {
                if (this.msgLogCounter > 5 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO ", this.entity + " Couldn't able to find oracle version, versionList :" + object2, " targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
            }
        }
        if (this.isDataguardEnabled) {
            object2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug, this.reportingName);
            if (object2 == null || ((Hashtable)object2).size() == 0) {
                return;
            }
            ArrayList arrayList = (ArrayList)((Hashtable)object2).get(this.reportingName + ":" + this.oraSid);
            if (arrayList != null && arrayList.size() > 0) {
                object = (String)arrayList.get(2);
                string = (String)arrayList.get(3);
                if (!((String)object).equalsIgnoreCase("PRIMARY") && string.equalsIgnoreCase("MOUNTED")) {
                    return;
                }
            } else {
                return;
            }
        }
        object2 = null;
        Statement statement = null;
        object = null;
        double d = -5.0;
        String string2 = "select round(a.value/1024/1024,2) initial_pga_allocated_mb, round(b.value/1024/1024,2) current_pga_size_mb, c.value pga_hit_pct, case when a.value >0 then round((b.value/a.value)*100,2) else -5 end  as pga_usage_pct from v$pgastat a,v$pgastat b, v$pgastat c where a.name='aggregate PGA target parameter' and b.name='total PGA inuse' and c.name='cache hit percentage'";
        System.out.println(this.entity + " query :" + string2);
        try {
            if (this.isMultitenantDb && !this.isCDB) {
                if (this.msgLogCounter > 3 || this.msgLogCounter == 0) {
                    this.logToErrorFile("INFO", "OraPgaTest doesnot run for PDB : ", "targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                    this.msgLogCounter = 0;
                }
                ++this.msgLogCounter;
                return;
            }
            object2 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, debug);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("[OraPgaTest] compute Measure()", "failed to connect database", exception.toString());
            return;
        }
        if (object2 == null) {
            System.out.println("OraPgaTest Connection is null targetHost:" + this.targetHost + " CurrentTime:" + new Date());
            this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            return;
        }
        try {
            statement = object2.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "OraPgaTest Failed to Create Statement targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
            exception.printStackTrace();
            this.closeConn((Connection)object2);
            return;
        }
        try {
            try {
                String string3 = "";
                String string4 = "";
                double d2 = 0.0;
                double d3 = 0.0;
                double d4 = 0.0;
                if (this.oraVersion >= 11) {
                    string3 = "select round(VALUE/1024/1024,2) memory_target_SIZE_MB from v$parameter where name='memory_target'";
                    string4 = "select round(VALUE/1024/1024,2) SGA_target_SIZE_MB from v$parameter where name='sga_target'";
                    object = statement.executeQuery(string3);
                    while (object.next()) {
                        d2 = object.getDouble(1);
                    }
                    this.closeRs((ResultSet)object);
                    object = null;
                    object = statement.executeQuery(string4);
                    while (object.next()) {
                        d3 = object.getDouble(1);
                    }
                    this.closeRs((ResultSet)object);
                    object = null;
                }
                object = statement.executeQuery(string2);
                while (object.next()) {
                    double d5;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    d4 = object.getDouble(1);
                    double d6 = object.getDouble(2);
                    double d7 = object.getDouble(3);
                    d = this.oraVersion >= 11 ? ((d5 = d2 - d3) > 0.0 ? d6 / d5 * 100.0 : object.getDouble(4)) : object.getDouble(4);
                    d5 = -5.0;
                    if (d > 100.0) {
                        d = 100.0;
                        d5 = d6 - d4;
                    } else if (d < 100.0) {
                        d5 = 0.0;
                    }
                    arrayList.add(new Double(d6));
                    arrayList.add(new Double(d7));
                    arrayList.add(new Double(d));
                    if (this.measureCount > 3) {
                        if (d5 < 0.0) {
                            d5 = -5.0;
                        }
                        arrayList.add(new Double(d5));
                    }
                    System.out.println(this.entity + " measureList :" + arrayList);
                    this.addNewMeasure(arrayList);
                }
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn((Connection)object2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, exception.toString());
                System.out.println("Exception Occured in OraPgaTest.computeMeasures():" + exception.toString());
                Object var24_23 = null;
                this.closeRs((ResultSet)object);
                this.closeStmt(statement);
                this.closeConn((Connection)object2);
            }
            Object var24_22 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn((Connection)object2);
        }
        catch (Throwable throwable) {
            Object var24_24 = null;
            this.closeRs((ResultSet)object);
            this.closeStmt(statement);
            this.closeConn((Connection)object2);
            throw throwable;
        }
    }

    public double stringToDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        OraPgaTest oraPgaTest = new OraPgaTest(stringArray);
        oraPgaTest.computeMeasures(new Hashtable());
    }
}

