/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class NsDbCacheTest
extends GenericTest {
    private String s_search = "cn=monitor,cn=ldbm";
    private String s_dn = "none";
    private String s_pwd = "none";
    private String errorMsg = " ";
    private EgUtilities egutil = EgUtilities.createInstance();
    private double d_dbchehits = 0.0;
    private double d_dbcachetries = 0.0;
    private double d_dbcachepagein = 0.0;
    private double d_dbcachepageout = 0.0;
    private double d_pdbchehits = -1.0;
    private double d_pdbcachetries = -1.0;
    private double d_pdbcachepagein = -1.0;
    private double d_pdbcachepageout = -1.0;
    private boolean b_firstTime = true;

    public NsDbCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.s_dn = this.getValueForParam("distinguishedname");
        this.s_pwd = this.getValueForParam("password");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            String string = this.prepareCmd();
            ArrayList arrayList = this.egutil.getExecOutputLines(string);
            if (arrayList.size() != 2) {
                this.b_firstTime = true;
                return;
            }
            ArrayList arrayList2 = (ArrayList)arrayList.get(0);
            ArrayList arrayList3 = (ArrayList)arrayList.get(1);
            if (arrayList2 == null || arrayList3 == null) {
                this.b_firstTime = true;
                return;
            }
            if (arrayList2.size() == 0) {
                String string2 = (String)arrayList3.get(0);
                if (string2 != null) {
                    if (string2.indexOf("client connection failed!") >= 0) {
                        this.errorMsg = new String("Connection to the server failed");
                        System.out.println(this.errorMsg);
                        this.b_firstTime = true;
                        ArrayList<Double> arrayList4 = new ArrayList<Double>();
                        arrayList4.add(new Double(-1.0));
                        arrayList4.add(new Double(-1.0));
                        arrayList4.add(new Double(-1.0));
                        this.addNewMeasure(arrayList4);
                        arrayList4 = null;
                        this.d_pdbchehits = -1.0;
                        this.d_pdbcachetries = -1.0;
                        this.d_pdbcachepagein = -1.0;
                        this.d_pdbcachepageout = -1.0;
                        return;
                    }
                    System.out.println(" in else line =" + string2);
                    this.errorMsg = new String(this.targetHost + ":" + this.portNo + ": Object specified may be not existing in the directory");
                    System.out.println(this.errorMsg);
                    this.b_firstTime = true;
                    ArrayList<Double> arrayList5 = new ArrayList<Double>();
                    arrayList5.add(new Double(-1.0));
                    arrayList5.add(new Double(-1.0));
                    arrayList5.add(new Double(-1.0));
                    this.addNewMeasure(arrayList5);
                    System.out.println(arrayList5);
                    arrayList5 = null;
                    this.d_pdbchehits = -1.0;
                    this.d_pdbcachetries = -1.0;
                    this.d_pdbcachepagein = -1.0;
                    this.d_pdbcachepageout = -1.0;
                    return;
                }
            } else {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string3 = (String)arrayList2.get(i);
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ":");
                    if (stringTokenizer.countTokens() <= 1) continue;
                    String string4 = stringTokenizer.nextToken();
                    string4.trim();
                    if (string4.equals("dbchehits")) {
                        this.d_dbchehits = Long.parseLong(stringTokenizer.nextToken().trim());
                        bl = true;
                    } else if (string4.equals("dbcachetries")) {
                        this.d_dbcachetries = Long.parseLong(stringTokenizer.nextToken().trim());
                        bl2 = true;
                    } else if (string4.equals("dbcachepagein")) {
                        this.d_dbcachepagein = Long.parseLong(stringTokenizer.nextToken().trim());
                        bl3 = true;
                    } else if (string4.equals("dbcachepageout")) {
                        this.d_dbcachepageout = Long.parseLong(stringTokenizer.nextToken().trim());
                        bl4 = true;
                    }
                    if (bl && bl2 && bl3 && bl4) break;
                }
                ArrayList<Double> arrayList6 = new ArrayList<Double>();
                if (this.b_firstTime) {
                    this.b_firstTime = false;
                    arrayList6.add(new Double(-1.0));
                    arrayList6.add(new Double(-1.0));
                    arrayList6.add(new Double(-1.0));
                } else {
                    System.out.println("NsDbCacheTest");
                    System.out.println("dbchehits: c: " + this.d_dbchehits + "  p: " + this.d_pdbchehits);
                    System.out.println("dbcachetries: c: " + this.d_dbcachetries + "  p: " + this.d_pdbcachetries);
                    System.out.println("dbcachepagein: c: " + this.d_dbcachepagein + "  p: " + this.d_pdbcachepagein);
                    System.out.println("dbcachepageout: c: " + this.d_dbcachepageout + "  p: " + this.d_pdbcachepageout);
                    double d = this.d_dbchehits - this.d_pdbchehits;
                    double d2 = this.d_dbcachetries - this.d_pdbcachetries;
                    double d3 = this.d_dbcachepagein - this.d_pdbcachepagein;
                    double d4 = this.d_dbcachepageout - this.d_pdbcachepageout;
                    if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0) {
                        arrayList6.add(new Double(-1.0));
                        arrayList6.add(new Double(-1.0));
                        arrayList6.add(new Double(-1.0));
                    } else {
                        if (d2 == 0.0 || d == 0.0) {
                            arrayList6.add(new Double(100.0));
                        } else {
                            arrayList6.add(new Double(d / d2 * 100.0));
                        }
                        if (this.timeSinceLastTest > 0.0) {
                            arrayList6.add(new Double(d3 / this.timeSinceLastTest));
                            arrayList6.add(new Double(d4 / this.timeSinceLastTest));
                        } else {
                            arrayList6.add(new Double(-1.0));
                            arrayList6.add(new Double(-1.0));
                        }
                    }
                }
                this.d_pdbchehits = this.d_dbchehits;
                this.d_pdbcachetries = this.d_dbcachetries;
                this.d_pdbcachepagein = this.d_dbcachepagein;
                this.d_pdbcachepageout = this.d_dbcachepageout;
                this.addNewMeasure(arrayList6);
                arrayList6 = null;
            }
        }
        catch (Exception exception) {
            this.errorMsg = new String("Exception while executing NsDbCacheTest for target: " + this.targetHost);
            System.out.println(this.errorMsg);
            this.b_firstTime = true;
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(-1.0));
            arrayList.add(new Double(-1.0));
            arrayList.add(new Double(-1.0));
            this.addNewMeasure(arrayList);
        }
    }

    private String prepareCmd() {
        String string;
        String string2 = this.prepareCmd1();
        String string3 = System.getProperty("java.class.path");
        String string4 = " -cp \"" + string3 + "\"";
        String string5 = System.getProperty("java.home");
        boolean bl = System.getProperty("java.version").compareTo("1.5") > 0;
        String string6 = new EgAgentTimer(null, null, null).getOSName();
        if (string6.equalsIgnoreCase("Linux") || string6.equalsIgnoreCase("Solaris") || string6.equalsIgnoreCase("AIX") || string6.equalsIgnoreCase("HPUX")) {
            string = string5.substring(0, this.egutil.indexOfIgnoreCase(string5, "jre"));
            string5 = string6.equalsIgnoreCase("AIX") ? string5 + "/bin/java" : (bl ? string5 + "/bin/java -client" : string5 + "/bin/java");
        } else if (string6.startsWith("Windows")) {
            string = string5.substring(0, this.egutil.indexOfIgnoreCase(string5, "jre"));
            string5 = bl ? string5 + "\\bin\\java -client" : string5 + "\\bin\\java";
        }
        string = null;
        if (string6.equalsIgnoreCase("Linux") || string6.equalsIgnoreCase("Solaris") || string6.equalsIgnoreCase("HPUX") || string6.equalsIgnoreCase("AIX")) {
            string = string5 + string4 + string2;
        } else if (string6.startsWith("Windows")) {
            string = "cmd.exe /c " + string5 + string4 + string2;
        }
        string = string + " EgLdap -h " + this.targetHost + " -p " + this.portNo + " -b \"" + this.s_search + "\" -s base objectClass=*";
        this.s_dn.trim();
        this.s_pwd.trim();
        if (this.s_dn != null && !this.s_dn.equalsIgnoreCase("none")) {
            string = string + " -D \"" + this.s_dn + "\"";
        }
        if (this.s_pwd != null && !this.s_pwd.equalsIgnoreCase("none")) {
            string = string + " -w \"" + this.s_pwd + "\"";
        }
        return string;
    }

    private String prepareCmd1() {
        String string = "";
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)properties.get(string2);
            if (string2.indexOf("separator") >= 0 || string3.equals("")) continue;
            if (string3.endsWith("\\")) {
                int n = string3.length();
                string3 = string3.substring(0, n - 1);
            }
            if (string2.indexOf("sun.boot.library.path") < 0 && string2.indexOf(") java.runtime.version") < 0 && string2.indexOf("java.home") < 0 && string2.indexOf("java.version") < 0 && string2.indexOf("java.ext.dirs") < 0 && string2.indexOf("sun.boot.class.path") < 0) continue;
            if (string.equals("")) {
                string = "-D" + string2 + "=\"" + string3 + "\"";
                continue;
            }
            string = string + " -D" + string2 + "=\"" + string3 + "\"";
        }
        return string;
    }
}

