/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeHeapSpaceDetails;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeMemory;
import com.eg.apm.NodeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class NodeMemoryTest
extends NodeBase {
    public static final String[] propsOrder = new String[]{"enable_memory_profiling", "memory_dump_location"};
    private static final int NOT_AVAILABLE = -5;

    public NodeMemoryTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            logger.info("{} Initializing NodeMemoryTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{}  NodeMemoryTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{}  Exception while initializing NodeMemoryTest {} ", (Object)this.logPrefix, (Object)initException);
        }
    }

    public void computeMeasures(Hashtable params) {
        logger.debug("{} - params {} ", (Object)this.logPrefix, (Object)params);
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String siteId = "[" + this.reportingName + ":" + this.portNo + "]";
        this.getJvmGuid();
        try {
            HashMap<String, NodeInfra> workers;
            logger.debug("{} - params {} ", (Object)this.logPrefix, (Object)params.toString());
            this.checkForPropsChanges(propsOrder);
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{}  siteId: {}  is not available", (Object)this.logPrefix, (Object)siteId);
                return;
            }
            NodeInfraCluster nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            NodeInfra master = nodeInfraCluster.getMaster();
            if (master != null && master.isMaster()) {
                NodeMemory memory = master.getMemoryUsage();
                if (memory != null) {
                    this.addMeasures("Master", memory, master.getProcessID(), nodeInfraCluster.getWorkerCount());
                    master.setMemoryUsage(null);
                } else {
                    logger.debug("{} {}  Master - measure is null", (Object)this.logPrefix, (Object)siteId);
                }
            }
            if ((workers = nodeInfraCluster.getWorkers()) != null && workers.size() > 0) {
                Set<Map.Entry<String, NodeInfra>> set = workers.entrySet();
                for (Map.Entry<String, NodeInfra> mEntry : set) {
                    String key = mEntry.getKey();
                    NodeInfra infraByPid = mEntry.getValue();
                    NodeMemory memoryObj = infraByPid.getMemoryUsage();
                    if (memoryObj != null) {
                        String discriptorName = infraByPid.getMode().equalsIgnoreCase("STANDALONE") ? key : "Worker_" + key;
                        this.addMeasures(discriptorName, memoryObj, infraByPid.getProcessID(), -5);
                        infraByPid.setMemoryUsage(null);
                        continue;
                    }
                    logger.debug("{} ", (Object)this.logPrefix, (Object)siteId);
                }
            } else {
                logger.debug("{} {} Worker - measure is null", (Object)this.logPrefix, (Object)siteId);
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occured while collecting Memory : {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void addMeasures(String type, NodeMemory memoryObj, String processId, int workerCount) {
        try {
            ArrayList<Double> measures = new ArrayList<Double>();
            double maxHeap = NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memoryObj.getMaxHeap(), "B", "MB"));
            double heapUsed = NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memoryObj.getHeapUsed(), "B", "MB"));
            measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memoryObj.getRss(), "B", "MB")));
            measures.add(maxHeap);
            measures.add(heapUsed);
            measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memoryObj.getFreeHeap(), "B", "MB")));
            if (maxHeap > 0.0 && heapUsed > 0.0) {
                double percentage = heapUsed * 100.0 / maxHeap;
                measures.add(percentage);
            } else {
                measures.add(-5.0);
            }
            measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memoryObj.getExternal(), "B", "MB")));
            measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(memoryObj.getArrayBuffers(), "B", "MB")));
            measures.add(new Double(workerCount));
            NodeHeapSpaceDetails heapSpace = memoryObj.getHeapSpaceDetails();
            if (heapSpace != null) {
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getRead_only_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getNew_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getOld_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getCode_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getMap_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getLarge_object_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getCode_large_object_space(), "B", "MB")));
                measures.add(NodeUtils.formatDecimal(NodeUtils.convertMemoryValues(heapSpace.getNew_large_object_space(), "B", "MB")));
            } else {
                Double defaultValue = -5.0;
                int index = 0;
                while (index < 8) {
                    measures.add(defaultValue);
                    ++index;
                }
            }
            measures.add(new Double(processId));
            this.addNewMeasure(type, measures);
            logger.debug("{} Added measures for {} : {}", new Object[]{this.logPrefix, type, measures});
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while adding measures for NodeJs Memory Test : {}", (Object)this.logPrefix, (Object)e);
        }
    }
}

