/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMLanguage;
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeGC;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.org.slf4j.Logger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeGCtest
extends NodeBase {
    protected static final Logger logger = NodeBTMLogger.nodeLogger;
    private static int configuredMaxDD = 100;
    private Hashtable ddHash = null;
    public static final int NOT_AVAILABLE = -5;

    public NodeGCtest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            logger.info("{} Initializing NodeGCtest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeGCtest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{} Exception while initializing NodeGCtest {}", (Object)this.logPrefix, (Object)initException);
        }
    }

    @Override
    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        logger.debug("{} - Test cycle starting for the NodeID {} ", (Object)this.logPrefix, (Object)this.NodeID);
        try {
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{}  NodeID: {}  is not available", (Object)this.logPrefix, (Object)this.NodeID);
                return;
            }
            NodeInfraCluster nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            NodeInfra master = nodeInfraCluster.getMaster();
            if (master != null && master.isMaster()) {
                this.ddHash = new Hashtable();
                NodeGC[] gc = master.getGc();
                ArrayList gcDetailsList = this.prepareGcData(gc);
                HashMap<String, ArrayList<NodeGC[]>> arrayListOfGC = nodeInfraCluster.getNodeGcMap();
                this.mergeGcDetails(gcDetailsList, arrayListOfGC, "master");
                ArrayList garbageList = GarbageCollectionUtil.parseGCvalues(gcDetailsList, APMLanguage.NODEJS, this.timeSinceLastTest, this.numOutputFields, "master");
                if (garbageList != null && garbageList.size() > 0) {
                    Hashtable metricMap = (Hashtable)garbageList.get(0);
                    this.ddHash = (Hashtable)garbageList.get(1);
                    if (metricMap != null) {
                        Set keys = metricMap.keySet();
                        for (String infoString : keys) {
                            ArrayList metrics = (ArrayList)metricMap.get(infoString);
                            this.addFinalMeasureList(infoString, metrics);
                        }
                    }
                } else {
                    this.uploadValues("Minor GC:", "Total", 0);
                    this.uploadValues("Full GC:", "Total", 0);
                    this.uploadValues("NONE", "Summary", 0);
                }
                master.setGc(null);
            } else {
                HashMap<String, NodeInfra> workers = nodeInfraCluster.getWorkers();
                if (workers != null && workers.size() > 0) {
                    Set<Map.Entry<String, NodeInfra>> set = workers.entrySet();
                    Iterator<Map.Entry<String, NodeInfra>> iterator = set.iterator();
                    this.ddHash = new Hashtable();
                    while (iterator.hasNext()) {
                        Map.Entry<String, NodeInfra> mEntry = iterator.next();
                        String workerId = mEntry.getKey();
                        NodeInfra infraByPid = mEntry.getValue();
                        NodeGC[] gcObject = infraByPid.getGc();
                        if (gcObject == null) continue;
                        ArrayList gcDetailsList = this.prepareGcData(gcObject);
                        HashMap<String, ArrayList<NodeGC[]>> arrayListOfGC = nodeInfraCluster.getNodeGcMap();
                        this.mergeGcDetails(gcDetailsList, arrayListOfGC, workerId);
                        ArrayList garbageList = GarbageCollectionUtil.parseGCvalues(gcDetailsList, APMLanguage.NODEJS, this.timeSinceLastTest, this.numOutputFields, workerId);
                        if (garbageList != null && garbageList.size() > 0) {
                            Hashtable metricMap = (Hashtable)garbageList.get(0);
                            this.ddHash.putAll((Hashtable)garbageList.get(1));
                            if (metricMap != null) {
                                Set keys = metricMap.keySet();
                                for (String infoString : keys) {
                                    ArrayList metrics = (ArrayList)metricMap.get(infoString);
                                    this.addFinalMeasureList(infoString, metrics);
                                }
                            }
                        } else {
                            this.uploadValues("Minor GC:", "Total", 0);
                            this.uploadValues("Full GC:", "Total", 0);
                            this.uploadValues("NONE", "Summary", 0);
                        }
                        infraByPid.setGc(null);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("{}  error while paring the GC details : {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void addFinalMeasureList(String infoString, ArrayList metrics) {
        try {
            ArrayList<Double> finalMetrics = new ArrayList<Double>();
            int index = 0;
            while (index < metrics.size()) {
                double value = (Double)metrics.get(index);
                if (value > 0.0 || index == 1) {
                    finalMetrics.add(value);
                } else {
                    finalMetrics.add(-5.0);
                }
                this.addNewMeasure(infoString, finalMetrics);
                ++index;
            }
        }
        catch (Exception e) {
            logger.error("{}  error while finalizing measures for GC details test: {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void mergeGcDetails(ArrayList gcDetailsList, HashMap<String, ArrayList<NodeGC[]>> arrayListOfGC, String key) {
        try {
            ArrayList<NodeGC[]> indexedGcDetails;
            if (arrayListOfGC != null && arrayListOfGC.size() > 0 && (indexedGcDetails = arrayListOfGC.get(key)) != null && indexedGcDetails.size() > 0) {
                int index = 0;
                while (index < indexedGcDetails.size()) {
                    ArrayList gcList = this.prepareGcData(indexedGcDetails.remove(index));
                    gcDetailsList.addAll(gcList);
                    ++index;
                }
            }
        }
        catch (Exception e) {
            logger.error("{} error while merging the GC details : {} ", (Object)this.logPrefix, (Object)e);
        }
    }

    private ArrayList prepareGcData(NodeGC[] gcObject) {
        ArrayList finalList = new ArrayList();
        try {
            int index = 0;
            while (index < gcObject.length) {
                String gcType = gcObject[index].getType();
                ArrayList<Object> outerList = new ArrayList<Object>();
                Hashtable<String, Long> heapBeforeGcMap = new Hashtable<String, Long>();
                Hashtable<String, Long> heapAfterGcMap = new Hashtable<String, Long>();
                if (gcType != null && gcType.equals("MarkSweepCompact")) {
                    outerList.add("F");
                    outerList.add(NodeGCtest.convertTime(gcObject[index].getStarttime()));
                    outerList.add(gcObject[index].getDuration());
                    heapAfterGcMap.put(gcType, gcObject[index].getHeapAfterGc());
                    heapBeforeGcMap.put(gcType, gcObject[index].getHeapBeforeGc());
                    outerList.add(heapAfterGcMap);
                    outerList.add(heapBeforeGcMap);
                    finalList.add(outerList);
                } else {
                    outerList.add("M");
                    outerList.add(NodeGCtest.convertTime(gcObject[index].getStarttime()));
                    outerList.add(gcObject[index].getDuration());
                    heapAfterGcMap.put(gcType, gcObject[index].getHeapAfterGc());
                    heapBeforeGcMap.put(gcType, gcObject[index].getHeapBeforeGc());
                    outerList.add(heapAfterGcMap);
                    outerList.add(heapBeforeGcMap);
                    finalList.add(outerList);
                }
                ++index;
            }
        }
        catch (Exception e) {
            logger.error("{}  error while paring the GC details on the method preapreGcData: {} ", (Object)this.logPrefix, (Object)e);
        }
        return finalList;
    }

    private void uploadValues(String label, String descriptor, int i) {
        ArrayList<Double> al = new ArrayList<Double>();
        Double tmp = new Double(i);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        al.add(tmp);
        if (this.numOutputFields > 8) {
            al.add(tmp);
            al.add(tmp);
        }
        if (label.equals("NONE")) {
            this.addNewMeasure(descriptor, al);
        } else {
            this.addNewMeasure(String.valueOf(label) + descriptor, al);
        }
    }

    public static String convertTime(long time) {
        Date date = new Date(time);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", Locale.US);
        return dateFormat.format((Object)date);
    }

    protected ArrayList getDDMeasures(String info) {
        if (this.ddHash != null) {
            return (ArrayList)this.ddHash.get(info);
        }
        return null;
    }

    public int getMaximumDD() {
        return configuredMaxDD;
    }
}

