/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.NodeCPU;
import com.eg.apm.NodeCpuFunction;
import com.eg.apm.NodeCpuProfileParser;
import com.eg.apm.NodeDumpCluster;
import com.eg.apm.NodeDumps;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeCPUTest
extends NodeBase {
    public static final String[] propsOrder = new String[]{"enable_cpu_profiling", "cpu_profiling_duration_(ms)", "cpu_dump_location"};
    private int dump_dd_limit = 10;

    public NodeCPUTest(String[] args) {
        super(args);
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        try {
            logger.info("{} Initializing NodeCPUTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeCPUTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception initException) {
            logger.error("{} Exception while initializing {}", (Object)this.logPrefix, (Object)initException);
        }
        String maxLimit = this.getValueForParam("Top_N_Function_Details");
        if (maxLimit != null) {
            try {
                this.dump_dd_limit = Integer.parseInt(maxLimit);
                JavaBTMLogger.btmLogger.debug("{} Max DD capture for cpu dump is updated to {} : for JVM {}", new Object[]{this.loggerDispStr, this.dump_dd_limit, this.apmComponentGUID});
            }
            catch (Exception e) {
                this.dump_dd_limit = 10;
                JavaBTMLogger.btmLogger.debug("{} Max DD capture for cpu dump is  updated to {} : for JVM {}", new Object[]{this.loggerDispStr, this.dump_dd_limit, this.apmComponentGUID});
                JavaBTMLogger.btmLogger.error("Exception while parsing cpu dump DD limit {}", (Throwable)e);
            }
        }
    }

    @Override
    public void computeMeasures(Hashtable params) {
        this.getJvmGuid();
        logger.debug("{} - NodeCPU Test cycle starting ", (Object)this.logPrefix);
        String siteId = "[" + this.reportingName + ":" + this.portNo + "]";
        try {
            HashMap<String, NodeInfra> workers;
            NodeCPU cpuData;
            logger.debug("{} - params : {} nodeJvmGUID : {} ", new Object[]{this.logPrefix, params.toString(), this.apmComponentGUID});
            this.checkForPropsChanges(propsOrder);
            if (!this.nodeRepository.isInfraIdExists(this.apmComponentGUID)) {
                logger.debug("{} nodeJvmGUID: {} is not available", (Object)this.logPrefix, (Object)this.apmComponentGUID);
                return;
            }
            NodeInfraCluster nodeInfraCluster = this.nodeRepository.getInfraById(this.apmComponentGUID);
            NodeInfra master = nodeInfraCluster.getMaster();
            if (master != null && master.isMaster() && (cpuData = master.getCpuUsage()) != null) {
                this.addMeasures("Master", cpuData, master.getProcessID(), nodeInfraCluster.getWorkerCount());
                master.setCpuUsage(null);
            }
            if ((workers = nodeInfraCluster.getWorkers()) != null && workers.size() > 0) {
                Set<Map.Entry<String, NodeInfra>> set = workers.entrySet();
                for (Map.Entry<String, NodeInfra> mEntry : set) {
                    String key = mEntry.getKey();
                    NodeInfra infraByPid = mEntry.getValue();
                    NodeCPU cpuobj = infraByPid.getCpuUsage();
                    if (cpuobj == null) continue;
                    String discriptorName = infraByPid.getMode().equalsIgnoreCase("STANDALONE") ? key : "Worker_" + key;
                    this.addMeasures(discriptorName, cpuobj, infraByPid.getProcessID(), -5);
                    infraByPid.setCpuUsage(null);
                }
            } else {
                logger.debug("{} Worker - aggregated cpu usage is null", (Object)siteId);
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while collecting Node cpu object : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    private void addMeasures(String type, NodeCPU infraObj, String processId, int workerCount) {
        try {
            ArrayList<Double> measures = new ArrayList<Double>();
            measures.add(NodeUtils.formatDecimal(infraObj.getUserPct()));
            measures.add(NodeUtils.formatDecimal(infraObj.getSystemPct()));
            measures.add(NodeUtils.formatDecimal(infraObj.getUserTime()));
            measures.add(NodeUtils.formatDecimal(infraObj.getSystemTime()));
            measures.add(new Double(workerCount));
            measures.add(new Double(processId));
            this.addNewMeasure(type, measures);
            logger.debug("{} Added measures for {} : {}", new Object[]{this.logPrefix, type, measures});
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while adding measures for NodeJsCPU test : {}", (Object)this.logPrefix, (Object)e);
        }
    }

    public List<NodeCpuFunction> getWorkersDumpDetails() {
        NodeDumpCluster nodeDumpCluster = this.nodeRepository.getDumpById(this.apmComponentGUID);
        try {
            HashMap<String, NodeDumps> workers;
            if (nodeDumpCluster != null && (workers = nodeDumpCluster.getWorkers()) != null && workers.size() > 0) {
                Set<Map.Entry<String, NodeDumps>> set = workers.entrySet();
                for (Map.Entry<String, NodeDumps> mEntry : set) {
                    NodeDumps dumpByPid = mEntry.getValue();
                    String cpuDumpObj = dumpByPid.getDump();
                    if (cpuDumpObj == null) continue;
                    Object obj = new JSONParser().parse(cpuDumpObj);
                    JSONObject cpuProfile = (JSONObject)obj;
                    dumpByPid.setDump(null);
                    NodeCpuProfileParser cpuParser = new NodeCpuProfileParser();
                    cpuParser.parse(cpuProfile);
                    List<NodeCpuFunction> nodeCpuProfileHelper = cpuParser.getCpuIntensiveFunc(this.dump_dd_limit);
                    return nodeCpuProfileHelper;
                }
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while parsing cpu dump for workers ....", (Throwable)e);
        }
        return null;
    }

    public List<NodeCpuFunction> getMasterDumpDetails() {
        NodeDumpCluster nodeDumpCluster = this.nodeRepository.getDumpById(this.apmComponentGUID);
        try {
            String cpuDumpObj;
            NodeDumps nodeDumps;
            if (nodeDumpCluster != null && (nodeDumps = nodeDumpCluster.getMaster()) != null && nodeDumps.isMaster() && (cpuDumpObj = nodeDumps.getDump()) != null) {
                Object obj = new JSONParser().parse(cpuDumpObj);
                JSONObject cpuProfile = (JSONObject)obj;
                nodeDumps.setDump(null);
                NodeCpuProfileParser cpuParser = new NodeCpuProfileParser();
                cpuParser.parse(cpuProfile);
                return cpuParser.getCpuIntensiveFunc(this.dump_dd_limit);
            }
        }
        catch (Exception e) {
            logger.error("{} Exception occurred while parsing cpu dump for master ....", (Throwable)e);
        }
        return null;
    }
}

