/*
 * Decompiled with CFR 0.152.
 */
import com.eg.AgentLogger;
import com.eg.apm.APMLanguage;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.util.QueryMaskHelper;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public abstract class NodeBTMBase
extends NodeBase {
    protected static final String myDatePattern = "yyyy-MM-dd HH:mm:ss";
    protected static final SimpleDateFormat mySDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    protected static final String utcDatePattern = "yyyy-MM-dd HH:mm:ss";
    protected static final SimpleDateFormat utcSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
    protected String logPrefix = "NodeBTMBase";
    protected String loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + this.logPrefix + "]";
    protected static final String[] offloadPropsOrder = new String[]{"Monitoring_Mode", "Max_URL_Segments", "URL_Patterns", "Excluded_Patterns", "Key_Excluded_Patterns", "Slow_URL_Threshold", "Stalled_URL_Threshold", "Method_Exec_CutOff", "SQL_Exec_CutOff", "Max_Slow_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period", "Max_Healthy_URLs_Per_Test_Period", "Max_Stalled_URLs_Per_Test_Period", "Healthy_URL_Trace", "egMeasPeriod", "Pojo_Method_Tracing_Limit", "Pojo_Method_Tracing_Cutoff_Time", "Recursive_Method_Tracing_Limit", "Non-Pojo_Method_Tracing_Limit", "Exception_Stacktrace_Lines", "Included_Exceptions", "Ignored_Exceptions", "Ignored_Characters", "Max_Grouped_Urls_Per_Measure_Period", "Key_Max_Grouped_Urls_Per_Measure_Period", "Max_Sql_Queries_Per_Transaction", "Show_HTTPStatus", "Show_Cookies", "Show_Headers", "Enable_Thread_Cpu_Monitoring", "Enable_Thread_Contention_Monitoring", "Max_Mongodb_Query_Length", "Max_Sql_Error_Queries_Per_Transaction", "Exception_With_StackTrace_Capture_Limit", "Exception_FQEN_Capture_Limit", "Max_Exception_Trace_Limit"};
    protected String componentIDForFolderName = null;
    public static final HashMap MAPPING = new HashMap();
    private static long noneThresholdTransactionStalledLimit = 120000L;

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        finalUtcDateFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        MAPPING.put("Monitoring_Mode", "Monitoring_Mode");
        MAPPING.put("Max_URL_Segments", "Max_URL_Segments");
        MAPPING.put("Excluded_Patterns", "Excluded_Patterns");
        MAPPING.put("Slow_URL_Threshold", "Slow_URL_Threshold");
        MAPPING.put("Stalled_URL_Threshold", "Stalled_URL_Threshold");
        MAPPING.put("Method_Exec_CutOff", "Method_Exec_CutOff");
        MAPPING.put("SQL_Exec_CutOff", "SQL_Exec_CutOff");
        MAPPING.put("Max_Slow_URLs_Per_Test_Period", "Max_Slow_URLs_Per_Test_Period");
        MAPPING.put("Max_Error_URLs_Per_Test_Period", "Max_Error_URLs_Per_Test_Period");
        MAPPING.put("Max_Healthy_URLs_Per_Test_Period", "Max_Healthy_URLs_Per_Test_Period");
        MAPPING.put("Max_Stalled_URLs_Per_Test_Period", "Max_Stalled_URLs_Per_Test_Period");
        MAPPING.put("Healthy_URL_Trace", "Healthy_URL_Trace");
        MAPPING.put("egMeasPeriod", "egMeasPeriod");
        MAPPING.put("Key_Excluded_Patterns", "Manual_Excluded_Patterns");
        MAPPING.put("URL_Patterns", "URL_Patterns");
        MAPPING.put("Key_Max_Grouped_Urls_Per_Measure_Period", "MAX_MANUAL_GROUPED_URLS");
        MAPPING.put("Show_HTTPStatus", "HTTP_STATUS_CODE");
        MAPPING.put("Show_Cookies", "HTTP_COOKIES");
        MAPPING.put("Show_Headers", "HTTP_HEADERS");
        MAPPING.put("Enable_Thread_Cpu_Monitoring", "TRACK_CPU_TIME");
        MAPPING.put("Enable_Thread_Contention_Monitoring", "TRACK_BLOCKED_WAITED_TIME");
        MAPPING.put("Pojo_Method_Tracing_Limit", "MAX_POJO_CALL_TRACE_COUNT");
        MAPPING.put("Pojo_Method_Tracing_Cutoff_Time", "MAX_POJO_CALL_TRACE_TIME");
        MAPPING.put("Recursive_Method_Tracing_Limit", "RECURSION_TRACE_LIMIT");
        MAPPING.put("Non-Pojo_Method_Tracing_Limit", "MAX_POINTCUT_LIMIT");
        MAPPING.put("Exception_Stacktrace_Lines", "MAX_EXCEPTION_TRACE_LINE_COUNT");
        MAPPING.put("Included_Exceptions", "INCLUDE_EXCEPTIONS");
        MAPPING.put("Ignored_Exceptions", "IGNORE_EXCEPTIONS");
        MAPPING.put("Ignored_Characters", "Chars_TO_Exclude");
        MAPPING.put("Max_Grouped_Urls_Per_Measure_Period", "MAX_AUTO_GROUPED_URLS");
        MAPPING.put("Max_Sql_Queries_Per_Transaction", "MAX_SQL_QUERY_COUNT");
        MAPPING.put("Max_Mongodb_Query_Length", "MAX_MONGODB_QUERY_LENGTH");
        MAPPING.put("Max_Sql_Error_Queries_Per_Transaction", "MAX_SQL_ERROR_QUERY_COUNT");
        MAPPING.put("Exception_With_StackTrace_Capture_Limit", "MAX_EXCE_STACK_TRACE_CAPTURE_LIMIT");
        MAPPING.put("Exception_FQEN_Capture_Limit", "MAX_EXCE_FQEN_CAPTURE_LIMIT");
        MAPPING.put("Max_Exception_Trace_Limit", "MAX_EXCE_TRACE_COUNT_LIMIT");
    }

    public NodeBTMBase(String[] args) {
        super(args);
        this.fixedTestPeriod = true;
        this.componentIDForFolderName = String.valueOf(this.reportingName) + "_" + this.portNo;
        AgentLogger.testLogger.info("{} JVM GUID from eg_apmGuid.ini : {} ", (Object)this.loggerDispStr, (Object)this.apmComponentGUID);
        try {
            BTMOffloadAPMSocketConfiguration configuration = BTMOffloadAPMSocketConfiguration.getBTMOffloadAPMSocketConfiguration("eg_agentTests.ini");
            this.initComponentWatcher(APMLanguage.NODEJS, configuration);
        }
        catch (Exception e) {
            AgentLogger.testLogger.error("{} Exception in NodeBTMBase Constructor {}", (Object)this.loggerDispStr, (Object)e);
        }
    }

    protected Hashtable getModifiedThresholdPatterns(Hashtable currentTable, Hashtable previousTable) {
        Hashtable<String, String> resultTable = new Hashtable<String, String>();
        AgentLogger.testLogger.debug("{} - getModifiedThresholdPatterns : currentTable: {} \t  previousTable : {} ", new Object[]{this.loggerDispStr, currentTable, previousTable});
        if (currentTable != null && currentTable.size() > 0) {
            Set currentKeySet = currentTable.keySet();
            for (String currentKey : currentKeySet) {
                String currentValue = (String)currentTable.get(currentKey);
                if (currentKey.startsWith("+")) {
                    currentKey = currentKey.substring(1);
                }
                if (previousTable.containsKey(currentKey)) {
                    String previousValue = (String)previousTable.get(currentKey);
                    if (currentValue.equals(previousValue)) continue;
                    previousTable.put(currentKey, currentValue);
                    resultTable.put(currentKey, currentValue);
                    continue;
                }
                previousTable.put(currentKey, currentValue);
                resultTable.put(currentKey, currentValue);
            }
        }
        return resultTable;
    }

    protected HashMap getModifiedProps(HashMap currentPropsTable, HashMap previousPropsTable) {
        HashMap<String, String> resultTable = new HashMap<String, String>();
        AgentLogger.testLogger.debug("{} - getModifiedThresholdPatterns : currentTable: {} \t  previousTable : {} ", new Object[]{this.loggerDispStr, currentPropsTable, previousPropsTable});
        if (currentPropsTable != null && currentPropsTable.size() > 0) {
            Set currentKeySet = currentPropsTable.keySet();
            for (String currentKey : currentKeySet) {
                String currentValue = (String)currentPropsTable.get(currentKey);
                if (previousPropsTable.containsKey(currentKey)) {
                    String previousValue = (String)previousPropsTable.get(currentKey);
                    if (currentValue.equals(previousValue)) continue;
                    resultTable.put(currentKey, currentValue);
                    continue;
                }
                resultTable.put(currentKey, currentValue);
            }
        }
        return resultTable;
    }

    protected HashMap updateThresholds(Hashtable modifiedThreshPatterns, String entity) {
        HashMap<String, String> threshTable = null;
        if (modifiedThreshPatterns != null && modifiedThreshPatterns.size() > 0) {
            Set keys = modifiedThreshPatterns.keySet();
            Iterator patternItr = keys.iterator();
            threshTable = new HashMap<String, String>();
            threshTable.put("Threshold", entity);
            while (patternItr.hasNext()) {
                String patternName = (String)patternItr.next();
                String thresholdValue = (String)modifiedThreshPatterns.get(patternName);
                if (entity.equalsIgnoreCase("NodeTransTest")) {
                    threshTable.put("Thresh4B>" + patternName, thresholdValue);
                    continue;
                }
                if (!entity.equalsIgnoreCase("KNodeTransTest")) continue;
                threshTable.put("Thresh4KB>" + patternName, thresholdValue);
            }
        }
        return threshTable;
    }

    protected long getMaxStalledLimit4None() {
        return noneThresholdTransactionStalledLimit;
    }

    public String[] getQueryResult(String queryString) {
        String[] result = new String[3];
        boolean callableStmtFound = false;
        if (queryString == null) {
            result[0] = "-";
            result[1] = "-";
            result[2] = "-";
            return result;
        }
        if (queryString.startsWith("{")) {
            queryString = queryString.substring(queryString.indexOf("{") + 1, queryString.lastIndexOf("}"));
            callableStmtFound = true;
        }
        try {
            List<String> queryList = QueryMaskHelper.maskAndParseSQL(queryString);
            if (queryList != null && queryList.size() > 0) {
                result[0] = queryList.get(1);
                result[1] = queryList.get(0);
                result[1] = result[1].toUpperCase();
                if (this.sqlMaskFlag) {
                    result[2] = queryList.get(2);
                    if (callableStmtFound) {
                        StringBuilder callableQryBuilder = new StringBuilder();
                        callableQryBuilder.append("{");
                        callableQryBuilder.append(result[2]);
                        callableQryBuilder.append("}");
                        result[2] = callableQryBuilder.toString();
                        result[1] = "STORED PROCEDURE";
                    }
                } else {
                    result[2] = queryString;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception occurred while parsing SQL");
        }
        return result;
    }
}

