/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import com.egurkha.util.EgUtilities;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;

public class KafkaValidator
extends EgServerValidator {
    protected String jndiName = "jmxrmi";
    protected String jvmPort = "";
    protected String userName = "";
    protected String password = "";
    protected String reportingName = null;
    private JMXConnector jmxConnector = null;
    private RMIConnector rmiConnector = null;
    protected MBeanServerConnection beanServerConnection = null;
    private JMXServiceURL jmxService = null;
    private final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected boolean isSSL = false;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final String SPACE = new String(" ");
    protected static final String BASIC = "Basic" + SPACE;
    protected static long collectionTimeout = 120L;
    String logMessage = "";
    String strLogSizeLimitInMB = null;
    protected static final String TEST_NAME = "KafkaValidator";
    protected static final String LOG_FILE_NAME = "KafkaValidatorLog";
    protected static final String INI_ENTRY_FOR_LOG_FILE_SIZE = "KafkaValidatorLogSizeLimitInMB";
    protected static final String DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/" + "KafkaValidatorLog";
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    protected static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss.SSS";
    protected static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");
    protected static final double MB_TO_BYTES = 1048576.0;
    protected static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double debugLogSizeLimitInMB = 1048576.0;
    String protoType = "";
    boolean deep_debug = false;
    String port = null;
    String tmp_timeout = null;
    String entity = this.getClass().getName();
    EgUtilities egutil = EgUtilities.createInstance();
    String javaOptions = "java";
    String heapDumpPath = null;
    public String validationMsg = "";
    public String validationErrorMsg = "";
    public ArrayList validationMsgs = null;
    public boolean isFromManager = false;
    String className = this.getClass().getName();

    public KafkaValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-host")) {
                    this.host = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-port")) {
                    if (this.port != null && this.port.trim().length() != 0 && !this.port.equalsIgnoreCase(NULL) && !this.port.equalsIgnoreCase(NONE)) continue;
                    this.port = string4.trim();
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-Jmx_Remote_Port")) {
                    this.jvmPort = string4.trim();
                    if (this.isStringNull(this.jvmPort)) {
                        this.logMessage = string + "JMX JVM Port  is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        this.jvmPort = NONE;
                        continue;
                    }
                    this.logMessage = string + "JMX JVM Port " + this.jvmPort;
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-Jmx_user")) {
                    this.userName = string4.trim();
                    if (this.userName == null || this.userName.trim().length() == 0 || this.userName.equalsIgnoreCase(NULL) || this.userName.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "JMX User  is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        this.userName = NONE;
                        continue;
                    }
                    this.logMessage = string + "JMX User name " + this.userName;
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string3 != null && string3.equalsIgnoreCase("-Jmx_password")) {
                    if ((string4 = EgCrypt.decrypt(string4)).indexOf("~EG~") != -1) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                    this.password = string4;
                    if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
                        this.logMessage = string + "JMX Password  is null or empty ";
                        this.printOut(this.logMessage);
                        this.putWarningMessageToLogfile(this.logMessage);
                        this.logMessage = "";
                        this.password = NONE;
                        continue;
                    }
                    this.logMessage = string + "JMX password  : *********";
                    this.printOut(this.logMessage);
                    continue;
                }
                if (string3 == null || !string3.equalsIgnoreCase("-rptname")) continue;
                this.reportingName = string4.trim();
            }
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
            this.strLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", INI_ENTRY_FOR_LOG_FILE_SIZE);
            if (this.strLogSizeLimitInMB != null && this.strLogSizeLimitInMB.length() > 0) {
                this.strLogSizeLimitInMB = this.strLogSizeLimitInMB.trim();
                try {
                    this.debugLogSizeLimitInMB = Double.parseDouble(this.strLogSizeLimitInMB);
                    this.debugLogSizeLimitInMB *= 1048576.0;
                    this.printOut(string + "strLogSizeLimitInMB value in bytes : " + this.debugLogSizeLimitInMB);
                }
                catch (Exception exception) {
                    this.debugLogSizeLimitInMB = 1048576.0;
                }
            } else {
                this.debugLogSizeLimitInMB = 1048576.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "*******************************************************************************");
        this.printOut(string + "Kafka host           :" + this.host);
        this.printOut(string + "Kafka port           :" + this.port);
        this.printOut(string + "Kafka JMX port       :" + this.jvmPort);
        this.printOut(string + "Kafka username       :" + this.userName);
        this.printOut(string + "Kafka password       :**********");
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "JMX Port$#$NA");
        } else if (!this.isSpecificPortReachable(this.jvmPort)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "JMX Port$#$JMX Port " + this.jvmPort + " is down or listener is down");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "JMX Port$#$OK");
            this.checkKafkaConnectivity();
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkKafkaConnectivity() {
        String string = "checkKafkaConnectivity";
        string = this.methodNameTemplate(string);
        String string2 = "";
        if (!this.connectToJVM(this.userName, this.password)) {
            this.printOut(string + "Could not connect to JVM  , so returned with null ");
            this.validationMsgs.add(2, "Kafka Connection$#$Connection to JVM is not established,check the credentials ");
            return;
        }
        try {
            this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
            String string3 = "kafka.controller:type=KafkaController,name=ControllerState";
            string2 = "Value";
            ObjectName objectName = new ObjectName(string3);
            String string4 = "" + this.beanServerConnection.getAttribute(objectName, string2);
            this.printOut(string + "attributeName  :" + string2);
            this.printOut(string + "attributevalue :" + string4);
            this.validationMsgs.add(2, "Kafka Connection$#$OK");
        }
        catch (Exception exception) {
            this.logMessage = string + "Error while iterating mbeandata  ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
        finally {
            this.closeJVMConn();
            this.logMessage = string + "[Finally :]" + "Reached finally block ";
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
    }

    private JMXServiceURL createJMXServiceURL() {
        JMXServiceURL jMXServiceURL;
        String string = "createJMXServiceURL";
        string = this.methodNameTemplate(string);
        try {
            jMXServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.jvmPort + "/jmxrmi");
        }
        catch (MalformedURLException malformedURLException) {
            this.logMessage = string + " Failed to create JMXServiceURL(service:jmx:rmi:///jndi/rmi://" + this.host + ":" + this.jvmPort + "/jmxrmi) , " + malformedURLException.toString();
            this.printOutStackTrace(this.logMessage, malformedURLException);
            this.logMessage = "";
            this.closeJVMConn();
            return null;
        }
        return jMXServiceURL;
    }

    protected boolean connectToJVM(String string, String string2) {
        String string3 = "connectToJVM";
        string3 = this.methodNameTemplate(string3);
        boolean bl = false;
        int n = 300;
        this.beanServerConnection = null;
        try {
            Object object;
            this.jmxService = this.createJMXServiceURL();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            int n2 = n / 5;
            if (n2 < 30000) {
                n2 = 30000;
            }
            hashMap.put("jmx.remote.protocol.provider.pkgs", "com.sun.jmx.remote.protocol");
            if (n2 > 0) {
                hashMap.put("jmx.remote.x.request.waiting.timeout", Long.toString(n2));
            }
            boolean bl2 = false;
            if (string.equalsIgnoreCase(NONE) || string2.equalsIgnoreCase(NONE)) {
                try {
                    this.jmxConnector = this.connectWithTimeout(this.jmxService, n2, TimeUnit.MILLISECONDS, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    this.logMessage = string3 + " - jmxService :" + this.jmxService + " Exception occured :";
                    this.printOutStackTrace(this.logMessage, iOException);
                    this.logMessage = "";
                }
            } else {
                object = new String[]{string, string2};
                hashMap.put("jmx.remote.credentials", object);
                try {
                    this.jmxConnector = this.connectWithTimeout(this.jmxService, n2, TimeUnit.MILLISECONDS, hashMap);
                }
                catch (IOException iOException) {
                    bl2 = true;
                    this.logMessage = string3 + " - jmxService :" + this.jmxService + " Exception occured with credentials :";
                    this.printOutStackTrace(this.logMessage, iOException);
                    this.logMessage = "";
                }
            }
            if (bl2) {
                try {
                    object = new EgSslRMIClientSocketFactory(this.host, Integer.parseInt(this.jvmPort), n2);
                    Registry registry = LocateRegistry.getRegistry(this.host, Integer.parseInt(this.jvmPort), (RMIClientSocketFactory)object);
                    RMIServer rMIServer = (RMIServer)registry.lookup(this.jndiName);
                    this.rmiConnector = new RMIConnector(rMIServer, hashMap);
                    this.rmiConnector.connect(hashMap);
                    this.beanServerConnection = this.rmiConnector.getMBeanServerConnection();
                }
                catch (Exception exception) {
                    this.logMessage = string3 + " - jmxService :" + this.jmxService + " Exception occured SSL Block :";
                    this.printOut(this.logMessage);
                    this.printOutStackTrace(this.logMessage, exception);
                    this.logMessage = "";
                }
            } else {
                this.beanServerConnection = this.jmxConnector.getMBeanServerConnection();
            }
            if (this.beanServerConnection == null) {
                this.logMessage = string3 + "  Connection to JVM is not established ";
                this.printOut(this.logMessage);
                this.logMessage = "";
                this.closeJVMConn();
                return false;
            }
            bl = true;
        }
        catch (Exception exception) {
            this.logMessage = string3 + " - jmxService :" + this.jmxService + " Exception occured due to :";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            this.closeJVMConn();
            return false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JMXConnector connectWithTimeout(final JMXServiceURL jMXServiceURL, long l, TimeUnit timeUnit, final Map map) throws IOException {
        String string = "connectWithTimeout";
        string = this.methodNameTemplate(string);
        final ArrayBlockingQueue<String> arrayBlockingQueue = new ArrayBlockingQueue<String>(1);
        ExecutorService executorService = Executors.newSingleThreadExecutor(this.daemonThreadFactory);
        executorService.submit(new Runnable(){

            public void run() {
                try {
                    JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL, map);
                    if (!arrayBlockingQueue.offer(jMXConnector)) {
                        jMXConnector.close();
                    }
                }
                catch (Throwable throwable) {
                    arrayBlockingQueue.offer(throwable);
                }
            }
        });
        Object var9_8 = null;
        try {
            var9_8 = arrayBlockingQueue.poll(l, timeUnit);
            if (var9_8 == null && !arrayBlockingQueue.offer("")) {
                var9_8 = arrayBlockingQueue.take();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(l, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (var9_8 == null) {
            this.logMessage = string + "JMX Connection timed out: " + jMXServiceURL;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        if (var9_8 instanceof JMXConnector) {
            return var9_8;
        }
        try {
            throw (Throwable)var9_8;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
    }

    protected void closeJVMConn() {
        String string = "closeJVMConn";
        string = this.methodNameTemplate(string);
        try {
            if (this.beanServerConnection != null) {
                this.beanServerConnection = null;
            }
        }
        catch (Exception exception) {
            this.logMessage = string + "Error in closing beanServerConnection ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
            return;
        }
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
            }
        }
        catch (Exception exception) {
            this.logMessage = string + "Error in closing connection in jmxConnector ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
            return;
        }
        try {
            if (this.rmiConnector != null) {
                this.rmiConnector.close();
            }
        }
        catch (Exception exception) {
            this.logMessage = string + "Error in closing connection in rmiConnector ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
            exception.printStackTrace();
            return;
        }
    }

    protected boolean isStringNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE);
    }

    protected boolean isArrayListNull(ArrayList arrayList) {
        return arrayList == null || arrayList.isEmpty() || arrayList.size() == 0;
    }

    protected boolean isHashtableNull(Hashtable hashtable) {
        return hashtable == null || hashtable.isEmpty() || hashtable.size() == 0;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string);
    }

    public void printOut(String string, boolean bl) {
        if (this.debugLogSizeLimitInMB > 0.0) {
            KafkaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            KafkaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putInfoMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            KafkaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void putWarningMessageToLogfile(String string) {
        System.out.println(" >> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string);
        if (this.debugLogSizeLimitInMB > 0.0) {
            KafkaValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.debugLogSizeLimitInMB);
        }
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            KafkaValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    public static void main(String[] stringArray) {
        KafkaValidator kafkaValidator = new KafkaValidator(stringArray, new Boolean(false));
        kafkaValidator.getValidationMsgs();
    }
}

