/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMExceptionObject;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.Status;
import com.eg.apm.util.UrlParamMaskHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExceptionsTest
extends APMBase {
    protected Hashtable ddSourceTable;
    private static final int MAX_GROUPED_URL_SIZE = 50;
    private static final Double ZERO_VALUE = 0.0;
    protected boolean isRootCauseExceptionTracking = false;
    private static final String SUMMARY = "Summary";

    public JavaExceptionsTest(String[] args) {
        super(args);
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + "JavaExceptionsTest" + "]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        String isExceptionDepthTracking = this.getValueForParam("Enable_RootCause_Exception_Tracking");
        if (isExceptionDepthTracking != null && isExceptionDepthTracking.equalsIgnoreCase("true")) {
            this.isRootCauseExceptionTracking = true;
            this.setCauseExceptionTracingTable(this.apmComponentGUID, this.isRootCauseExceptionTracking);
            JavaBTMLogger.btmLogger.debug("{} root cause exception tracking is enable : {} \t {} ", new Object[]{this.loggerDispStr, this.isRootCauseExceptionTracking, this.apmComponentGUID});
        } else {
            this.setCauseExceptionTracingTable(this.apmComponentGUID, this.isRootCauseExceptionTracking);
            JavaBTMLogger.btmLogger.debug("{} root cause exception tracking is disable : {} \t {} ", new Object[]{this.loggerDispStr, this.isRootCauseExceptionTracking, this.apmComponentGUID});
        }
    }

    @Override
    public void computeMeasures(Hashtable paramList) {
        boolean heartBeating;
        this.getJvmGuid();
        APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(this.apmComponentGUID);
        if (component == null) {
            return;
        }
        ArrayList<APMExceptionObject> exceptionSourceList = component.getAPMExceptions();
        boolean bl = heartBeating = component.getHeartbeatStatus() == Status.HEART_BEATING;
        if (exceptionSourceList == null && heartBeating) {
            ArrayList summaryResultList = this.createDefaultValueList();
            JavaBTMLogger.btmLogger.debug("{} = {}  Sent addNewMeasure: {} = {}", new Object[]{this.loggerDispStr, this.entity, SUMMARY, summaryResultList});
            this.addNewMeasure(SUMMARY, summaryResultList);
            return;
        }
        if (exceptionSourceList == null) {
            return;
        }
        this.ddSourceTable = new Hashtable();
        long testFrequency = this.measurePeriod / 1000L / 60L;
        double totalExceptionCount = 0.0;
        HashMap<String, Double> callCountDetailsMap = new HashMap<String, Double>();
        JavaBTMLogger.btmLogger.debug("{}  {} received exception details list ", (Object)this.loggerDispStr, (Object)this.entity);
        int index = 0;
        while (index < exceptionSourceList.size()) {
            APMExceptionObject javaAPMExceptionObj = exceptionSourceList.get(index);
            String requestGUID = javaAPMExceptionObj.getReqGUID();
            String pattern = javaAPMExceptionObj.getPatternString();
            String requestType = javaAPMExceptionObj.getReqType();
            ArrayList exceptionList = javaAPMExceptionObj.getExceptionList();
            int innerIndex = 0;
            while (innerIndex < exceptionList.size()) {
                int descriptorIndex;
                totalExceptionCount += 1.0;
                String descriptor = null;
                String[] exceptionDetailsArray = (String[])exceptionList.get(innerIndex);
                descriptor = this.isRootCauseExceptionTracking ? ((descriptor = exceptionDetailsArray[descriptorIndex = this.getDiscriptorIndex(exceptionDetailsArray)]) == null ? exceptionDetailsArray[0] : descriptor) : exceptionDetailsArray[0];
                try {
                    if (callCountDetailsMap.size() >= 50) {
                        this.prepareDescriptorDetails("Others", callCountDetailsMap, requestType, requestGUID, exceptionDetailsArray, pattern);
                    } else {
                        this.prepareDescriptorDetails(descriptor, callCountDetailsMap, requestType, requestGUID, exceptionDetailsArray, pattern);
                    }
                }
                catch (Exception e) {
                    JavaBTMLogger.btmLogger.error("{} exception occur while preparing descriptor & DD data for Exception Test :{} ", (Object)this.loggerDispStr, (Object)e);
                }
                ++innerIndex;
            }
            ++index;
        }
        if (callCountDetailsMap != null && callCountDetailsMap.size() > 0) {
            Iterator descriptorIterator = callCountDetailsMap.entrySet().iterator();
            while (descriptorIterator.hasNext()) {
                ArrayList<Double> resultList = new ArrayList<Double>();
                Map.Entry e = descriptorIterator.next();
                String descriptor = (String)e.getKey();
                Double totalExceCall = (Double)e.getValue();
                Double callPerMin = totalExceCall / (double)testFrequency;
                Double avgPerMin = minusFive;
                Double percentage = totalExceCall / totalExceptionCount * 100.0;
                resultList.add(totalExceCall);
                resultList.add(callPerMin);
                resultList.add(avgPerMin);
                resultList.add(percentage);
                resultList.add(minusFive);
                JavaBTMLogger.btmLogger.debug("{} == {}   Sent addNewMeasure: {} ", new Object[]{this.loggerDispStr, this.entity, descriptor});
                this.addNewMeasure(descriptor, resultList);
            }
        }
        ArrayList<Double> summaryResultList = new ArrayList<Double>();
        if (totalExceptionCount > 0.0) {
            Double callPerMin = totalExceptionCount / (double)testFrequency;
            Double avgPerMin = minusFive;
            Double percentage = minusFive;
            Double uniqueException = callCountDetailsMap.size();
            summaryResultList.add(totalExceptionCount);
            summaryResultList.add(callPerMin);
            summaryResultList.add(avgPerMin);
            summaryResultList.add(percentage);
            summaryResultList.add(uniqueException);
            JavaBTMLogger.btmLogger.debug("{} == {}   Sent addNewMeasure: SUMMARY {} ", new Object[]{this.loggerDispStr, this.entity, summaryResultList});
            this.addNewMeasure(SUMMARY, summaryResultList);
        }
    }

    private int getDiscriptorIndex(String[] exceptionArray) {
        int descriptorIndex = 0;
        int i = 2;
        while (i < exceptionArray.length) {
            if (exceptionArray[i] == null) {
                return i - 2;
            }
            descriptorIndex = i;
            i += 2;
        }
        return descriptorIndex;
    }

    private void prepareDescriptorDetails(String descriptor, HashMap<String, Double> callCountDetailsMap, String reqType, String eGGUID, String[] exceptionDetailsArray, String pattern) {
        if (callCountDetailsMap.containsKey(descriptor)) {
            double count = callCountDetailsMap.get(descriptor);
            callCountDetailsMap.put(descriptor, count += 1.0);
            ArrayList finalList = (ArrayList)this.ddSourceTable.get(descriptor);
            ArrayList innerList = this.prepareDDData(reqType, eGGUID, exceptionDetailsArray, pattern, descriptor);
            finalList.add(innerList);
            this.ddSourceTable.put(descriptor, finalList);
        } else {
            callCountDetailsMap.put(descriptor, 1.0);
            ArrayList innerList = this.prepareDDData(reqType, eGGUID, exceptionDetailsArray, pattern, descriptor);
            ArrayList<ArrayList> finalList = new ArrayList<ArrayList>();
            finalList.add(innerList);
            this.ddSourceTable.put(descriptor, finalList);
        }
    }

    private ArrayList prepareDDData(String requestType, String eGGUID, String[] exceptionDetailsArray, String pattern, String descriptor) {
        ArrayList<String> resultList = new ArrayList<String>();
        String eGGuid = eGGUID.substring(0, eGGUID.indexOf("#~#"));
        String nodeOrder = eGGUID.substring(eGGUID.indexOf("#~#") + 3);
        resultList.add(eGGuid);
        resultList.add(nodeOrder);
        resultList.add(requestType);
        resultList.add(pattern);
        try {
            if (exceptionDetailsArray.length == 4) {
                String exceptionMesssage = null;
                exceptionMesssage = this.isRootCauseExceptionTracking && descriptor.equals(exceptionDetailsArray[2]) ? exceptionDetailsArray[3] : exceptionDetailsArray[1];
                resultList.add(this.getMessage(exceptionMesssage == null ? "-" : exceptionMesssage));
                int i = 0;
                while (i < 6) {
                    resultList.add("-");
                    resultList.add("-");
                    ++i;
                }
            } else {
                String exceptionMesssage;
                String exceptionFQCN;
                int descriptorIndex;
                int index = 0;
                while (index < 6) {
                    descriptorIndex = index * 2;
                    exceptionFQCN = exceptionDetailsArray[descriptorIndex];
                    exceptionMesssage = exceptionDetailsArray[descriptorIndex + 1];
                    if (descriptor.equals(exceptionFQCN)) {
                        exceptionMesssage = exceptionMesssage == null ? "-" : exceptionMesssage;
                        resultList.add(this.getMessage(exceptionMesssage));
                        break;
                    }
                    ++index;
                }
                index = 0;
                while (index < 6) {
                    descriptorIndex = index * 2;
                    exceptionFQCN = exceptionDetailsArray[descriptorIndex];
                    exceptionMesssage = exceptionDetailsArray[descriptorIndex + 1];
                    if (exceptionFQCN == null) {
                        exceptionFQCN = "-";
                    }
                    if (exceptionMesssage == null) {
                        exceptionMesssage = "-";
                    }
                    resultList.add(exceptionFQCN);
                    resultList.add(this.getMessage(exceptionMesssage));
                    ++index;
                }
            }
        }
        catch (Exception e) {
            JavaBTMLogger.btmLogger.error("{} {}  exception occur while preparing java exception dd details :  {} ", new Object[]{this.loggerDispStr, this.entity, e});
        }
        JavaBTMLogger.btmLogger.debug("{} {}  java exception dd details list for pattern {} prepared ", new Object[]{this.loggerDispStr, this.entity, pattern});
        return resultList;
    }

    private String getMessage(String causeException) {
        String maskedExceptionMessage = null;
        if ((causeException.contains("\n") || causeException.contains("\r")) && (causeException = causeException.replaceAll("(\\r\\n|\\n|\\r)", "  ")).endsWith("Stacktrace:")) {
            causeException = causeException.substring(0, causeException.lastIndexOf("Stacktrace:"));
        }
        if (this.exceptionParamsMaskFlag) {
            maskedExceptionMessage = UrlParamMaskHelper.maskURLParams(causeException);
        }
        String string = causeException = maskedExceptionMessage == null ? causeException : maskedExceptionMessage;
        if (causeException.length() >= 2048) {
            return String.valueOf(causeException.substring(0, 2045)) + "...";
        }
        return causeException;
    }

    private ArrayList createDefaultValueList() {
        ArrayList<Double> defaultList = new ArrayList<Double>();
        defaultList.add(ZERO_VALUE);
        defaultList.add(ZERO_VALUE);
        defaultList.add(minusFive);
        defaultList.add(minusFive);
        defaultList.add(ZERO_VALUE);
        return defaultList;
    }

    public ArrayList getDDDetails(String patDesc) {
        ArrayList result = null;
        if (this.ddSourceTable != null && this.ddSourceTable.size() > 0) {
            result = (ArrayList)this.ddSourceTable.get(patDesc);
        }
        JavaBTMLogger.btmLogger.debug("{} Method getDDDetails returns : ", (Object)this.loggerDispStr);
        return result;
    }
}

