/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.IniFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Scanner;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class JEUSValidator
extends EgServerValidator {
    private String username = null;
    private String password = null;
    private String exportName = null;
    private String listenerPort = null;
    public String reportingName = null;
    public String entity = null;
    public String timeout = null;
    public String validationMsg = null;
    public String validationErrorMsg = null;
    protected String server_name = null;
    protected String logMessage = "";
    protected static final int ASCII_CODE_FOR_SPACE = 32;
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 15000;
    protected static final int DEFAULT_READ_TIMEOUT = 60000;
    protected static final String SPACE = new String(" ");
    protected static final String METHOD_GET = "GET";
    protected static final String AUTHORIZATION_KEY = "Authorization";
    protected static final String CONTENT_TYPE_KEY = "Accept";
    protected static final String CONTENT_TYPE_VALUE = "application/json";
    protected static final String CACHE_CONTROL_KEY = "Cache-Control";
    protected static final String CACHE_CONTROL_VALUE = "no-cache";
    protected static final String BASIC = "Basic" + SPACE;
    protected static final String DEBUG = "DEBUG    ";
    protected static final String ERROR = "ERROR    ";
    protected static final String INFO = "INFO     ";
    protected static final String CRITICAL = "CRITICAL ";
    protected static final String WARNING = "WARNING  ";
    public boolean isParamEligible = true;
    public boolean isExternalTest = false;
    public boolean isFromManager = false;
    public ArrayList validationMsgs = null;
    private String strJEUSValidatorLogSizeLimitInMB = null;
    private static final double MB_TO_BYTES = 1048576.0;
    private static final double DEBUG_LOG_FILE_SIZE_IN_MB = 1.0;
    protected double jeusValidatorLogSizeLimitInMB = 1048576.0;
    protected static final String JEUS_VALIDATOR_DEBUG_LOG_LOCATION = EgInstallInfo.getInstallDir() + "/agent/logs/JeusValidatorLog";
    private static final String EG_TIME_FORMAT = "dd/MM/yyyy HH:mm:ss";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    String className = this.getClass().getName();

    public JEUSValidator(String[] stringArray, Boolean bl) {
        super(stringArray);
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.indexOf(":"));
                String string4 = string2.substring(string2.indexOf(":") + 1);
                if ((string3 = string3.trim()) != null && string3.equalsIgnoreCase("-username")) {
                    this.username = string4.trim();
                    if (this.ifStringIsNull(this.username)) {
                        this.username = "none";
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-password")) {
                    if ((string4 = EgCrypt.decrypt(string4)).indexOf("~EG~") != -1) {
                        string4 = string4.substring(0, string4.indexOf("~EG~"));
                    }
                    this.password = string4.trim();
                    if (this.ifStringIsNull(this.password)) {
                        this.password = "none";
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-server_name")) {
                    this.server_name = string4.trim();
                    if (this.ifStringIsNull(this.server_name)) {
                        this.server_name = "none";
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-export_name")) {
                    this.exportName = string4.trim();
                    if (this.ifStringIsNull(this.exportName)) {
                        this.exportName = "none";
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-listener_port")) {
                    this.listenerPort = string4.trim();
                    if (this.ifStringIsNull(this.listenerPort)) {
                        this.listenerPort = "9736";
                    }
                } else if (string3 != null && string3.equalsIgnoreCase("-rptname")) {
                    this.reportingName = string4.trim();
                } else if (string3 != null && string3.equalsIgnoreCase("-timeout_seconds")) {
                    this.timeout = string4.trim();
                }
                IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini", false);
                this.strJEUSValidatorLogSizeLimitInMB = iniFile.getValue("AGENT_SETTINGS", "jeusValidatorLogSizeLimitInMB");
                if (this.strJEUSValidatorLogSizeLimitInMB != null && this.strJEUSValidatorLogSizeLimitInMB.length() > 0) {
                    this.strJEUSValidatorLogSizeLimitInMB = this.strJEUSValidatorLogSizeLimitInMB.trim();
                    try {
                        this.jeusValidatorLogSizeLimitInMB = Double.parseDouble(this.strJEUSValidatorLogSizeLimitInMB);
                        this.jeusValidatorLogSizeLimitInMB *= 1048576.0;
                        this.printOut(string + "jeusValidatorLogSizeLimitInMB value in bytes : " + this.jeusValidatorLogSizeLimitInMB);
                    }
                    catch (Exception exception) {
                        this.printOut(string + "Conversion error for strJEUSValidatorLogSizeLimitInMB value to bytes : " + this.strJEUSValidatorLogSizeLimitInMB + " ,exception :" + exception.toString());
                        this.jeusValidatorLogSizeLimitInMB = 1048576.0;
                    }
                    continue;
                }
                this.jeusValidatorLogSizeLimitInMB = 1048576.0;
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("[" + this.className + "]: [Constructor ]: error ", exception);
        }
        this.entity = this.className;
        if (this.ifStringIsNull(this.port)) {
            this.printOut(string + "Port value is null from argument,so port value as default 9736 ");
            this.port = "9736";
        }
        this.validationMsgs = new ArrayList();
        this.validate();
        this.isFromManager = bl;
    }

    public void validate() {
        String string = "validate";
        string = this.methodNameTemplate(string);
        this.printOut(string + "JEUS User Name     :" + this.username);
        this.printOut(string + "JEUS Password      :" + "*************");
        this.printOut(string + "JEUS Host Name     :" + this.host);
        this.printOut(string + "JEUS Port Name     :" + this.port);
        this.printOut(string + "JEUS Server Name   :" + this.server_name);
        this.printOut(string + "JEUS Export Name   :" + this.exportName);
        this.printOut(string + "JEUS Listener Port :" + this.listenerPort);
        this.printOut(string + "VALIDATION PROCESS STARTED ");
        if (!this.isIPReachable()) {
            this.validationMsgs.add(0, "Host IP/Name$#$Host IP/Name is invalid or Host IP/Name is unreachable");
            this.validationMsgs.add(1, "Port$#$NA");
            this.validationMsgs.add(2, "User/Password$#$NA");
            this.validationMsgs.add(3, "JEUS Server Connectivity$#$NA");
        } else if (!this.isSpecificPortReachable(this.port)) {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$Port " + this.port + " is down or listener is down");
            this.validationMsgs.add(2, "User/Password$#$NA");
            this.validationMsgs.add(3, "JEUS Server Connectivity$#$NA");
        } else {
            this.validationMsgs.add(0, "Host IP/Name$#$OK");
            this.validationMsgs.add(1, "Port$#$OK");
            if (this.ifStringIsNull(this.username) || this.ifStringIsNull(this.password)) {
                this.validationErrorMsg = "Please provide valid User/Password.";
                this.validationMsgs.add("User/Password$#$" + this.validationErrorMsg);
                this.validationMsgs.add("JEUS Server Connectivity$#$NA");
                return;
            }
            if (this.ifStringIsNull(this.server_name)) {
                this.validationErrorMsg = "Please provide valid server name.";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("JEUS Server Connectivity$#$" + this.validationErrorMsg);
            } else {
                this.checkJEUSConnectivity();
            }
        }
        this.printOut(string + "VALIDATION PROCESS ENDED");
        if (!this.isFromManager) {
            return;
        }
    }

    public void checkJEUSConnectivity() {
        CharSequence charSequence;
        String string = "checkJEUSConnectivity";
        string = this.methodNameTemplate(string);
        Hashtable hashtable = new Hashtable();
        HttpURLConnection httpURLConnection = null;
        URL uRL = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        int n = 0;
        String string5 = "";
        boolean bl2 = false;
        try {
            charSequence = new StringBuffer();
            charSequence.append("{");
            charSequence.append("\"jeusadmin\": {");
            charSequence.append("\"command\": \"server-info\",");
            charSequence.append("\"options\":[");
            charSequence.append("\"-server " + this.server_name + "\"");
            charSequence.append("],");
            charSequence.append("\"argument\": null");
            charSequence.append("}");
            charSequence.append("}");
            string2 = charSequence.toString();
        }
        catch (Exception exception) {
            this.logMessage = string + "Exception raised ";
            this.printOutStackTrace(this.logMessage, exception);
            this.logMessage = "";
        }
        try {
            uRL = new URL("http://" + this.host + ":" + this.port + "/jsonCommand/command.json");
            this.printOut(string + "Endpoint URL  :" + uRL);
        }
        catch (MalformedURLException malformedURLException) {
            this.logMessage = string + " MalformedURLException ";
            this.printOutStackTrace(this.logMessage, malformedURLException);
            this.logMessage = "";
        }
        try {
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            this.printOut(string + "Connection opened " + httpURLConnection);
        }
        catch (IOException iOException) {
            this.logMessage = string + " HttpURLConnection  error ";
            this.printOutStackTrace(this.logMessage, iOException);
            this.logMessage = "";
        }
        try {
            httpURLConnection.setRequestMethod(METHOD_GET);
        }
        catch (ProtocolException protocolException) {
            this.logMessage = string + " Your HTTP connection does not support  setRequestMethod ";
            this.printOutStackTrace(this.logMessage, protocolException);
            this.logMessage = "";
        }
        charSequence = this.username + ":" + this.password;
        String string6 = Base64Coder.encodeString((String)charSequence);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.addRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(60000);
        httpURLConnection.addRequestProperty(AUTHORIZATION_KEY, BASIC + string6);
        JEUSValidatorConnectionThread jEUSValidatorConnectionThread = new JEUSValidatorConnectionThread(httpURLConnection, string2);
        bl = this.checkForTimeout(jEUSValidatorConnectionThread);
        hashtable = this.getServerStateData(jEUSValidatorConnectionThread.responseString);
        if (hashtable != null && !hashtable.isEmpty() && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration != null && enumeration.hasMoreElements()) {
                ArrayList arrayList;
                String string7 = (String)enumeration.nextElement();
                if (!string7.equals("eg_jues_error")) {
                    arrayList = (ArrayList)hashtable.get(string7);
                    string3 = (String)arrayList.get(0);
                    string4 = (String)arrayList.get(1);
                    this.printOut(string + "serverName " + string3);
                    this.printOut(string + "serverStatus " + string4);
                    continue;
                }
                arrayList = (ArrayList)hashtable.get(string7);
                string5 = (String)arrayList.get(0);
                bl2 = true;
            }
        }
        if (bl) {
            n = jEUSValidatorConnectionThread.code;
            if (n == 200) {
                this.validationMsgs.add("User/Password$#$OK");
                if (!bl2) {
                    this.getServerStatus(string3, string4);
                } else {
                    this.validationMsgs.add("JEUS Server Connectivity$#$" + string5);
                }
            } else if (n == 500) {
                this.validationErrorMsg = "Error 500 - No Response from server due to internal server error";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("JEUS Server Connectivity$#$" + this.validationErrorMsg);
            } else if (n == 404) {
                this.validationErrorMsg = "Error 404 - No Response from server";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("JEUS Server Connectivity$#$" + this.validationErrorMsg);
            } else if (n == 503) {
                this.validationErrorMsg = "Error 503 - The server is currently unavailable or not started";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("JEUS Server Connectivity$#$" + this.validationErrorMsg);
            } else if (n == 401) {
                this.validationErrorMsg = "Error 401 - Unauthorized: Access is denied due to invalid credentials";
                this.validationMsgs.add("User/Password$#$" + this.validationErrorMsg);
                this.validationMsgs.add("JEUS Server Connectivity$#$NA");
            } else {
                this.validationErrorMsg = "Timing out or invalid response code";
                this.validationMsgs.add("User/Password$#$NA");
                this.validationMsgs.add("JEUS Server Connectivity$#$" + this.validationErrorMsg);
            }
        }
        if (!bl || n != 200) {
            this.logMessage = string + " Timing out or invalid response code:" + n;
            this.printOut(this.logMessage);
            this.logMessage = "";
        }
        httpURLConnection.disconnect();
    }

    private Hashtable getServerStateData(String string) {
        String string2 = "getServerStateData";
        string2 = this.methodNameTemplate(string2);
        Hashtable hashtable = new Hashtable();
        JSONObject jSONObject = new JSONObject();
        if (string != null && string.length() > 0) {
            JSONParser jSONParser = new JSONParser();
            try {
                jSONObject = (JSONObject)jSONParser.parse(string);
                this.printOut(string2 + " totalresultobj  " + jSONObject);
            }
            catch (ParseException parseException) {
                this.logMessage = string2 + "Error in JSON text parse to Object ";
                this.printOutStackTrace(this.logMessage, (Exception)((Object)parseException));
                this.logMessage = "";
                return hashtable;
            }
            JSONObject jSONObject2 = null;
            JSONArray jSONArray = null;
            JSONObject jSONObject3 = null;
            JSONArray jSONArray2 = null;
            JSONArray jSONArray3 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                jSONObject2 = (JSONObject)jSONObject.get((Object)"jeusadmin-result");
                if (jSONObject2.containsKey((Object)"data")) {
                    jSONArray = (JSONArray)jSONObject2.get((Object)"data");
                    jSONObject3 = (JSONObject)jSONArray.get(0);
                    jSONArray2 = (JSONArray)jSONObject3.get((Object)"column-names");
                    for (int i = 0; i < jSONArray2.size(); ++i) {
                        arrayList.add(jSONArray2.get(i).toString());
                    }
                    jSONArray3 = (JSONArray)jSONObject3.get((Object)"rows");
                    JSONObject jSONObject4 = null;
                    for (int i = 0; i < jSONArray3.size(); ++i) {
                        String string3 = null;
                        JSONArray jSONArray4 = null;
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        jSONObject4 = (JSONObject)jSONArray3.get(i);
                        string3 = (String)jSONObject4.get((Object)"row-key");
                        jSONArray4 = (JSONArray)jSONObject4.get((Object)"values");
                        for (int j = 0; j < jSONArray4.size(); ++j) {
                            String string4 = jSONArray4.get(j).toString();
                            arrayList2.add(string4);
                        }
                        hashtable.put(string3, arrayList2);
                    }
                    this.printOut(string2 + "columnNames " + arrayList);
                    this.printOut(string2 + "rows " + jSONArray3);
                } else if (jSONObject2.containsKey((Object)"error")) {
                    String string5 = null;
                    String string6 = "" + jSONObject2.get((Object)"error");
                    this.printOut(string2 + "Error  :" + string6);
                    string5 = "" + jSONObject2.get((Object)"message");
                    if (string5.indexOf("The server") > -1 && string5.indexOf("does not exist in domain.xml") > -1) {
                        this.printOut(string2 + "Error message :The server does not exist in domain");
                        String string7 = "The server " + this.server_name + " does not exist in domain.xml";
                        ArrayList<String> arrayList3 = new ArrayList<String>();
                        arrayList3.add(string7);
                        hashtable.put("eg_jues_error", arrayList3);
                    }
                }
            }
            catch (Exception exception) {
                this.logMessage = string2 + "Error in JSON object ";
                this.printOutStackTrace(this.logMessage, exception);
                this.logMessage = "";
                return hashtable;
            }
            this.printOut(string2 + "currMeasureHT " + hashtable);
        }
        return hashtable;
    }

    protected String decodeResponse(InputStream inputStream) {
        try {
            Scanner scanner = new Scanner(inputStream);
            scanner.useDelimiter("\\A");
            return scanner.hasNext() ? scanner.next() : "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    private boolean checkForTimeout(JEUSValidatorConnectionThread jEUSValidatorConnectionThread) {
        long l;
        String string = "checkForTimeout";
        string = this.methodNameTemplate(string);
        long l2 = 0L;
        long l3 = 250L;
        long l4 = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriod(l3);
            if (jEUSValidatorConnectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= l4) {
                this.logMessage = string + "Timed out and hence going to kill the thread :" + System.currentTimeMillis();
                this.printOut(this.logMessage);
                this.logMessage = "";
                jEUSValidatorConnectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                this.logMessage = string + " Timed out and killed the thread :" + System.currentTimeMillis();
                this.logMessage = "";
                jEUSValidatorConnectionThread.stop();
                return false;
            }
            l = l3;
            if (l4 - l2 >= l) continue;
            l = l4 - l2;
        } while ((l3 = l) > 0L);
        this.logMessage = string + " sleepTime less than zero in checkForTimeout :" + System.currentTimeMillis();
        this.printOut(this.logMessage);
        this.logMessage = "";
        jEUSValidatorConnectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        jEUSValidatorConnectionThread.stop();
        return false;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    private void getServerStatus(String string, String string2) {
        String string3 = "getServerStatus";
        string3 = this.methodNameTemplate(string3);
        int n = 0;
        int n2 = 0;
        String string4 = "RUNNING";
        String string5 = "";
        String string6 = "";
        String string7 = "(";
        String string8 = ")";
        try {
            this.printOut(string3 + "ServerName & ServerStatus is good :" + (!this.ifStringIsNull(string) && !this.ifStringIsNull(string2)));
            if (!this.ifStringIsNull(string) && !this.ifStringIsNull(string2)) {
                string = string.trim();
                string2 = string2.trim();
                if (string.contains(string7) && string.contains(string8)) {
                    n = string.indexOf(string7);
                    string5 = string.substring(0, n);
                } else {
                    string5 = string;
                }
                if (string2.contains(string7) && string2.contains(string8)) {
                    n2 = string2.indexOf(string7);
                    string6 = string2.substring(0, n2);
                } else {
                    string6 = string2;
                }
                if (!this.ifStringIsNull(string5) && !this.ifStringIsNull(string6)) {
                    if (string5.equals(this.server_name) && string6.equalsIgnoreCase(string4)) {
                        this.validationMsgs.add("JEUS Server Connectivity$#$OK");
                    } else {
                        this.validationMsgs.add("JEUS Server Connectivity$#$Server status is " + string6);
                    }
                }
                this.printOut(string3 + "After validation, server Name     :" + string5);
                this.printOut(string3 + "After validation, server Status   :" + string6);
            } else {
                this.printOut(string3 + "Server Name is Null");
                this.printOut(string3 + "Server Status is Null");
                this.validationMsgs.add("JEUS Server Connectivity$#$The server does not exist in domain");
            }
        }
        catch (Exception exception) {
            this.printOutStackTrace("Error", exception);
            this.validationMsgs.add("JEUS Server Connectivity$#$The server does not exist in domain");
        }
    }

    public ArrayList getValidationMsgs() {
        String string = "getValidationMsgs";
        string = this.methodNameTemplate(string);
        this.printOut(string + "validation ArrayList :" + this.validationMsgs);
        this.printOut(string + "*******************************************************************************");
        return this.validationMsgs;
    }

    protected boolean ifStringIsNull(String string) {
        return string == null || string.trim().length() == 0 || string.equalsIgnoreCase("NONE") || string.equalsIgnoreCase("null");
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, false);
    }

    public void printOut(String string, boolean bl) {
        JEUSValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + DEBUG + " ] : >> " + string, this.jeusValidatorLogSizeLimitInMB);
        System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] :>> " + string);
    }

    public void putErrorMessageToLogfile(String string) {
        JEUSValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + ERROR + " ] : >> " + string, this.jeusValidatorLogSizeLimitInMB);
    }

    public void putInfoMessageToLogfile(String string) {
        JEUSValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + INFO + " ] : >> " + string, this.jeusValidatorLogSizeLimitInMB);
    }

    public void putWarningMessageToLogfile(String string) {
        JEUSValidator.debugLogToFile(">> [ " + MY_SDF.format(new Date()) + " ] : [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + WARNING + " ] : >> " + string, this.jeusValidatorLogSizeLimitInMB);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public static synchronized void debugLogToFile(String string, double d) {
        try {
            PrintWriter printWriter = null;
            String string2 = JEUS_VALIDATOR_DEBUG_LOG_LOCATION;
            File file = new File(string2);
            if (file.exists() && (double)file.length() >= d) {
                String string3 = string2 + ".1";
                File file2 = new File(string3);
                if (file2.exists()) {
                    file2.delete();
                }
                EgInstallInfo.fileRename(string2, string3);
            }
            try {
                printWriter = new PrintWriter(new FileWriter(string2, true));
            }
            catch (Exception exception) {
                if (printWriter != null) {
                    printWriter.close();
                }
                printWriter = null;
                return;
            }
            printWriter.println(string);
            printWriter.close();
        }
        catch (Exception exception) {
            JEUSValidator.debugLogToFile("[debugLogToFile] : Exception is : " + exception.toString(), d);
        }
    }

    public static void main(String[] stringArray) {
        JEUSValidator jEUSValidator = new JEUSValidator(stringArray, new Boolean(false));
        jEUSValidator.getValidationMsgs();
    }

    class JEUSValidatorConnectionThread
    extends Thread {
        private HttpURLConnection connection;
        private String methodName = "[JEUSValidatorConnectionThread :run] :";
        private byte[] encodedRequest = null;
        public String responseString = null;
        public boolean done = false;
        public int code = 0;

        public JEUSValidatorConnectionThread(HttpURLConnection httpURLConnection, String string) {
            this.connection = httpURLConnection;
            this.encodedRequest = string.getBytes();
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block30: {
                IOException iOException6222;
                InputStream inputStream;
                OutputStream outputStream;
                block27: {
                    InputStream inputStream2;
                    block26: {
                        outputStream = null;
                        inputStream = null;
                        inputStream2 = null;
                        try {
                            outputStream = this.connection.getOutputStream();
                            outputStream.write(this.encodedRequest);
                            outputStream.flush();
                        }
                        catch (IOException iOException2) {
                            JEUSValidator.this.logMessage = this.methodName + "Exception raised in getoutputStream ";
                            JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException2);
                            JEUSValidator.this.logMessage = "";
                            if (outputStream == null) break block26;
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException3) {
                                JEUSValidator.this.logMessage = this.methodName + "Exception raised in while close getoutputStream ";
                                JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException3);
                                JEUSValidator.this.logMessage = "";
                            }
                        }
                    }
                    try {
                        JEUSValidator.this.logMessage = this.methodName + " and its Response code :" + this.connection.getResponseCode();
                        JEUSValidator.this.logMessage = "";
                    }
                    catch (IOException iOException4) {
                        JEUSValidator.this.logMessage = this.methodName + " Error ";
                        JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException4);
                        JEUSValidator.this.logMessage = "";
                        return;
                    }
                    try {
                        this.code = this.connection.getResponseCode();
                        JEUSValidator.this.printOut(this.methodName + "Response Code :" + this.code);
                        if (this.code == 200) {
                            inputStream = this.connection.getInputStream();
                        }
                        inputStream2 = this.connection.getErrorStream();
                        JEUSValidator.this.printOut(this.methodName + "Response before decode :" + inputStream);
                        JEUSValidator.this.printOut(this.methodName + "error Response before decode :" + this.connection.getErrorStream());
                    }
                    catch (IOException iOException5) {
                        JEUSValidator.this.logMessage = this.methodName + " response  exception ";
                        JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException5);
                        JEUSValidator.this.logMessage = "";
                        return;
                    }
                    this.responseString = JEUSValidator.this.decodeResponse(inputStream);
                    JEUSValidator.this.printOut(this.methodName + "After decode for the method  " + this.methodName + "  ====> Response  :" + this.responseString);
                    Object var7_9 = null;
                    if (outputStream == null) break block27;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException6222) {
                        JEUSValidator.this.logMessage = this.methodName + "Exception raised in while close getoutputStream ";
                        JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException6222);
                        JEUSValidator.this.logMessage = "";
                    }
                }
                if (null != inputStream) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException6222) {
                        JEUSValidator.this.logMessage = this.methodName + "  response close error ";
                        JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException6222);
                        JEUSValidator.this.logMessage = "";
                        return;
                    }
                }
                break block30;
                {
                    catch (Exception exception) {
                        IOException iOException72222;
                        JEUSValidator.this.logMessage = this.methodName + " response after decode , Error ";
                        JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, exception);
                        JEUSValidator.this.logMessage = "";
                        Object var7_10 = null;
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException72222) {
                                JEUSValidator.this.logMessage = this.methodName + "Exception raised in while close getoutputStream ";
                                JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException72222);
                                JEUSValidator.this.logMessage = "";
                            }
                        }
                        if (null != inputStream) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException72222) {
                                JEUSValidator.this.logMessage = this.methodName + "  response close error ";
                                JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException72222);
                                JEUSValidator.this.logMessage = "";
                                return;
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    IOException iOException82222;
                    Object var7_11 = null;
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException82222) {
                            JEUSValidator.this.logMessage = this.methodName + "Exception raised in while close getoutputStream ";
                            JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException82222);
                            JEUSValidator.this.logMessage = "";
                        }
                    }
                    if (null != inputStream) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException82222) {
                            JEUSValidator.this.logMessage = this.methodName + "  response close error ";
                            JEUSValidator.this.printOutStackTrace(JEUSValidator.this.logMessage, iOException82222);
                            JEUSValidator.this.logMessage = "";
                            return;
                        }
                    }
                    throw throwable;
                }
            }
            this.done = true;
        }
    }
}

