/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IIBMsgElpMaxTest
extends GenericTest
implements MqttCallback {
    public static final boolean cleanSession = Boolean.parseBoolean(System.getProperty("cleanSession", "false"));
    public static final int QoS = Integer.parseInt(System.getProperty("QoS", "1"));
    private static final String JSON_OBJECT_PARSING_EXCEPTION_MESSAGE = "JSONException while parsing JSONObjects :";
    protected static final String NULL = "null";
    protected static final String NONE = "none";
    protected static final String MAXIMUM_ELAPSED_TIME = "MaximumElapsedTime";
    static final String[] MQTT_TOPICS = new String[]{"IBM/IntegrationBus/+/Statistics/JSON/#"};
    protected String logMessage = null;
    private static final String EG_TIME_FORMAT = "MM/dd/yyyy HH:mm:ss a";
    private static final SimpleDateFormat MY_SDF = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a");
    protected static final String HYPHEN = "-";
    protected static final double DEFAULT_MINUS_FIVE = -5.0;
    protected static final double DEFAULT_MINUS_ONE = -1.0;
    protected static final double BYTES_TO_KB = 1024.0;
    protected static final double BYTES_TO_MB = 1048576.0;
    protected static final double BYTES_TO_GB = 1.073741824E9;
    protected static final double KB_TO_MB = 1024.0;
    protected static final double MB_TO_GB = 1024.0;
    protected String user = "";
    protected String password = "";
    protected String ssl = "";
    boolean isSSL = false;
    boolean usingJKS = false;
    ArrayList prevMeasureList = new ArrayList();
    MqttClient client;
    Hashtable resultData = new Hashtable();
    protected String mqttPort = "";
    private String caCertFile = "";
    private String clientCertFile = "";
    private String clientKeyFile = "";
    private String clientKeyPassword = "";
    private String mqttHostIP = "";
    boolean hostIPNotConnected = false;

    public IIBMsgElpMaxTest(String[] stringArray) {
        super(stringArray);
        this.isNewDynamicInfoTest = true;
        String string = "Constructor";
        string = this.methodNameTemplate(string);
        this.mqttHostIP = this.targetHost;
        this.user = this.getValueForParam("user");
        if (this.user == null || this.user.trim().length() == 0 || this.user.equalsIgnoreCase(NULL) || this.user.equalsIgnoreCase(NONE)) {
            this.logMessage = string + " MQTT broker User is null or empty : " + this.user;
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.user = NONE;
        } else {
            this.logMessage = string + " MQTT broker User is :" + this.user;
            this.printOut(this.logMessage);
        }
        this.password = this.getValueForParam("password");
        if (this.password == null || this.password.trim().length() == 0 || this.password.equalsIgnoreCase(NULL) || this.password.equalsIgnoreCase(NONE)) {
            this.logMessage = string + " MQTT broker password is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.password = NONE;
        } else {
            this.logMessage = string + " MQTT broker password is ******** ";
            this.printOut(this.logMessage);
        }
        this.mqttPort = this.getValueForParam("mqtt_port");
        if (this.mqttPort == null || this.mqttPort.trim().length() == 0 || this.mqttPort.equalsIgnoreCase(NULL) || this.mqttPort.equalsIgnoreCase(NONE)) {
            this.logMessage = string + " MQTT broker port is null or empty ";
            this.printOut(this.logMessage);
            this.putWarningMessageToLogfile(this.logMessage);
            this.logMessage = "";
            this.password = NONE;
        } else {
            this.logMessage = string + " MQTT broker port  is :" + this.mqttPort;
            this.printOut(this.logMessage);
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-password")) continue;
            String string = EgCrypt.decrypt(stringArray[i + 1]);
            if (string.indexOf("~EG~") != -1) {
                string = string.substring(0, string.indexOf("~EG~"));
            }
            stringArray[i + 1] = string;
            break;
        }
        IIBMsgElpMaxTest iIBMsgElpMaxTest = new IIBMsgElpMaxTest(stringArray);
        iIBMsgElpMaxTest.debugComputeMeasures(null, true);
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        block33: {
            Object object;
            String string = "debugComputeMeasures";
            string = this.methodNameTemplate(string);
            this.resultData = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Hashtable hashtable3 = new Hashtable();
            Hashtable hashtable4 = new Hashtable();
            this.printOut(string + "mqttHostIP  1:" + this.mqttHostIP);
            try {
                object = new MqttConnectOptions();
                object.setCleanSession(true);
                if (this.user != null && !this.user.equalsIgnoreCase(NONE) && this.password != null & !this.password.equalsIgnoreCase(NONE)) {
                    object.setUserName(this.user);
                    object.setPassword(this.password.toCharArray());
                }
                if (this.isSSL) {
                    this.client = new MqttClient("ssl://" + this.mqttHostIP + ":" + this.mqttPort, "egurkha");
                    if (this.usingJKS) {
                        object.setSocketFactory((SocketFactory)this.getSocketFactoryForJKS(this.caCertFile, this.clientKeyPassword));
                    } else {
                        object.setSocketFactory((SocketFactory)this.getSocketFactory(this.caCertFile, this.clientCertFile, this.clientKeyFile, this.clientKeyPassword));
                    }
                } else {
                    this.client = new MqttClient("tcp://" + this.mqttHostIP + ":" + this.mqttPort, "egurkha");
                }
                this.client.connect((MqttConnectOptions)object);
                for (int i = 0; i < MQTT_TOPICS.length; ++i) {
                    this.printOut(string + "Topic : " + MQTT_TOPICS[i] + " using QoS " + QoS + ". Clean session is " + cleanSession);
                    this.client.setCallback((MqttCallback)this);
                    this.client.subscribe(MQTT_TOPICS[i], QoS);
                    this.client.unsubscribe(MQTT_TOPICS[i]);
                }
                this.client.disconnect();
            }
            catch (Exception exception) {
                this.mqttHostIP = "localhost";
                this.printOutStackTrace(string + "Error in IOException in client connection and assiging as localhost", exception);
                this.printOut(string + "mqttHostIP  2:" + this.mqttHostIP);
                try {
                    MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                    mqttConnectOptions.setCleanSession(true);
                    mqttConnectOptions.setUserName(this.user);
                    mqttConnectOptions.setPassword(this.password.toCharArray());
                    if (this.isSSL) {
                        this.client = new MqttClient("ssl://" + this.mqttHostIP + ":" + this.mqttPort, "egurkha");
                        if (this.usingJKS) {
                            mqttConnectOptions.setSocketFactory((SocketFactory)this.getSocketFactoryForJKS(this.caCertFile, this.clientKeyPassword));
                        } else {
                            mqttConnectOptions.setSocketFactory((SocketFactory)this.getSocketFactory(this.caCertFile, this.clientCertFile, this.clientKeyFile, this.clientKeyPassword));
                        }
                    } else {
                        this.client = new MqttClient("tcp://" + this.mqttHostIP + ":" + this.mqttPort, "egurkha");
                    }
                    this.client.connect(mqttConnectOptions);
                    for (int i = 0; i < MQTT_TOPICS.length; ++i) {
                        this.printOut(string + "Topic : " + MQTT_TOPICS[i] + " using QoS " + QoS + ". Clean session is " + cleanSession);
                        this.client.setCallback((MqttCallback)this);
                        this.client.subscribe(MQTT_TOPICS[i], QoS);
                        this.client.unsubscribe(MQTT_TOPICS[i]);
                    }
                    this.client.disconnect();
                }
                catch (IOException iOException) {
                    this.printOutStackTrace(string + "Error in IOException in client connection could not connect the mqtt server ", iOException);
                    this.mqttHostIP = "localhost";
                }
                catch (Exception exception2) {
                    this.printOutStackTrace(string + "Error in Exception in client connection ,could not connect the mqtt server ", exception2);
                    this.mqttHostIP = "localhost";
                }
            }
            this.client = null;
            this.printOut(string + "Reuslt  " + this.resultData);
            this.printOut(string + "mqttHostIP  3:" + this.mqttHostIP);
            if (this.resultData == null || this.resultData.isEmpty() || this.resultData.size() == 0) {
                this.printOut(string + "Result data is null or empty ");
            } else {
                object = this.resultData.keys();
                if (object != null && object.hasMoreElements()) {
                    while (object != null && object.hasMoreElements()) {
                        Enumeration enumeration;
                        String string2 = (String)object.nextElement();
                        if (string2 == null || string2.trim().length() <= 0) continue;
                        String string3 = "" + this.resultData.get(string2);
                        this.printOut(string + "Topic name " + string2 + "  , Message :" + string3);
                        Hashtable hashtable5 = this.parseJSONData(string3);
                        if (hashtable5 == null || hashtable5.isEmpty() || hashtable5.size() <= 0 || (enumeration = hashtable5.keys()) == null || !enumeration.hasMoreElements()) continue;
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            String string4 = (String)enumeration.nextElement();
                            ArrayList arrayList = (ArrayList)hashtable5.get(string4);
                            this.printOut(string + "Info  " + string4 + "  , MeasureArrayList :" + arrayList);
                            if (bl) continue;
                            this.addNewMeasure(string4, arrayList);
                        }
                    }
                }
            }
            Object var15_21 = null;
            try {
                if (this.client != null) {
                    this.client.disconnect();
                }
                break block33;
            }
            catch (Exception exception) {}
            break block33;
            {
                catch (Exception exception) {
                    this.printOutStackTrace("Error ", exception);
                    Object var15_22 = null;
                    try {
                        if (this.client != null) {
                            this.client.disconnect();
                        }
                        break block33;
                    }
                    catch (Exception exception3) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                try {
                    if (this.client != null) {
                        this.client.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    Hashtable parseJSONData(String string) {
        String string2 = "parseJSONData";
        string2 = this.methodNameTemplate(string2);
        Hashtable hashtable = new Hashtable();
        if (string != null && string.length() > 0) {
            JSONParser jSONParser = new JSONParser();
            JSONObject jSONObject = null;
            try {
                jSONObject = (JSONObject)jSONParser.parse(string);
                this.printOut(string2 + "jsonObject   :" + jSONObject);
                JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"WMQIStatisticsAccounting");
                this.printOut(string2 + "WMQIStatisticsAccounting   :" + jSONObject2);
                String string3 = this.getValueFromJSONObject(jSONObject2, "RecordType");
                this.printOut(string2 + "RecordType   :" + string3);
                if (string3.equalsIgnoreCase("Archive")) {
                    JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"MessageFlow");
                    String string4 = this.getValueFromJSONObject(jSONObject3, "BrokerLabel");
                    String string5 = this.getValueFromJSONObject(jSONObject3, "ExecutionGroupName");
                    String string6 = this.getValueFromJSONObject(jSONObject3, "MessageFlowName");
                    this.printOut(string2 + "brokerLabel   :" + string4);
                    this.printOut(string2 + "executionGroupName   :" + string5);
                    this.printOut(string2 + "msgFlowName   :" + string6);
                    double d = this.getDoubleValueFromJSONObject(jSONObject3, MAXIMUM_ELAPSED_TIME);
                    String string7 = string4 + "/" + string5 + "/" + string6;
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(d));
                    hashtable.put(string7, arrayList);
                } else {
                    this.printOut(string2 + "RecordType   :" + string3 + ",so data parsing not processed ,returning with null data");
                }
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
        this.printOut(string2 + "Final dataHashtable   to return :" + hashtable);
        return hashtable;
    }

    protected double getDoubleValueFromJSONObject(JSONObject jSONObject, String string) {
        double d = 0.0;
        String string2 = "[getDoubleValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut(string2 + "jsonObject is  null or empty for the parameter :" + string);
                return d;
            }
            String string3 = "" + jSONObject.get((Object)string);
            d = this.convertToDouble(string3);
        }
        catch (Exception exception) {
            this.logMessage = string2 + JSON_OBJECT_PARSING_EXCEPTION_MESSAGE;
            this.printOutStackTrace(this.logMessage, exception);
            exception.printStackTrace();
            return d;
        }
        return d;
    }

    protected String getValueFromJSONObject(JSONObject jSONObject, String string) {
        String string2 = HYPHEN;
        String string3 = "[getValueFromJSONObject] :";
        try {
            if (jSONObject == null) {
                this.printOut(string3 + "jsonObject is  null or empty for the parameter :" + string);
                return string2;
            }
            String string4 = "" + jSONObject.get((Object)string);
            string2 = string4 == null || string4.trim().length() == 0 || string4.equalsIgnoreCase(NULL) || string4.equalsIgnoreCase(NONE) ? HYPHEN : string4.trim();
        }
        catch (Exception exception) {
            string2 = HYPHEN;
            this.logMessage = string3 + JSON_OBJECT_PARSING_EXCEPTION_MESSAGE;
            this.printOutStackTrace(this.logMessage, exception);
            exception.printStackTrace();
        }
        return string2;
    }

    protected String validateString(String string) {
        return this.validateString(string, HYPHEN);
    }

    protected String validateString(String string, String string2) {
        String string3 = string2;
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase(NULL) || string.equalsIgnoreCase(NONE)) {
            string3 = string2;
        } else {
            try {
                string3 = string.trim();
            }
            catch (Exception exception) {
                string3 = string2;
            }
        }
        return string3;
    }

    public void connectionLost(Throwable throwable) {
        String string = "connectionLost";
        string = this.methodNameTemplate(string);
        try {
            this.printOut(string + "Connection lost \" with cause \"" + throwable.getMessage() + "\" Reason code " + ((MqttException)throwable).getReasonCode() + "\" Cause \"" + ((MqttException)throwable).getCause() + "\"");
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error connectionLost", exception);
        }
    }

    public void messageArrived(String string, MqttMessage mqttMessage) {
        String string2 = "messageArrived";
        string2 = this.methodNameTemplate(string2);
        try {
            this.printOut(string2 + "Message: " + mqttMessage.toString() + " topic : " + string);
            this.resultData.put(string, mqttMessage.toString());
        }
        catch (Exception exception) {
            this.printOutStackTrace(string2 + "Error ", exception);
        }
    }

    public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
        String string = "deliveryComplete";
        string = this.methodNameTemplate(string);
        try {
            this.printOut(string + "Delivery token \"" + iMqttDeliveryToken.hashCode() + "\" received by instance ");
        }
        catch (Exception exception) {
            this.printOutStackTrace(string + "Error ", exception);
        }
    }

    protected double convertToDouble(String string) {
        String string2 = "convertToDouble";
        string2 = this.methodNameTemplate(string2);
        double d = 0.0;
        if (string == null || string.trim().length() <= 0) {
            return d;
        }
        string = string.trim();
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d = -5.0;
        }
        return d;
    }

    protected double roundDouble(double d, int n) {
        String string = "roundDouble";
        string = this.methodNameTemplate(string);
        double d2 = 0.0;
        try {
            Object object;
            Object object2 = "";
            if (n <= 0) {
                object2 = object = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            } else {
                String string2;
                object = "";
                if (d < 0.0) {
                    object = (String)object + HYPHEN;
                    d = -d;
                }
                if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
                    int n2 = (int)d;
                    object = (String)object + n2;
                    d -= (double)n2;
                } else {
                    object = (String)object + "0";
                }
                if (d > 0.0) {
                    String string3 = "" + (int)((d += 1.0) * Math.pow(10.0, n));
                    object = (String)object + "." + string3.substring(1);
                }
                object2 = (string2 = EgDbInfo.formatValue((String)object)) == null || string2.trim().length() == 0 ? object : string2;
            }
            object = new Double((String)object2);
            d2 = ((Double)object).isNaN() ? 0.0 : (Double)object;
        }
        catch (Exception exception) {
            this.printOut(string + "Error in  roundDouble method :" + exception.toString());
            this.putErrorMessageToLogfile("Error in  roundDouble method :" + exception.toString());
        }
        return d2;
    }

    protected String methodNameTemplate(String string) {
        return "[" + string + "] :";
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.reportingName + " ] : [ " + this.entity + " ] : [ " + MY_SDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + string3);
        this.putErrorMessageToLogfile(string2 + string3);
    }

    protected SSLSocketFactory getSocketFactory(String string, String string2, String string3, String string4) throws Exception {
        String string5 = "getSocketFactory";
        string5 = this.methodNameTemplate(string5);
        try {
            KeyPair keyPair;
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pEMParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(IIBMsgElpMaxTest.readBytesFromFile(string))));
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)pEMParser.readObject();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder);
            pEMParser.close();
            pEMParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(IIBMsgElpMaxTest.readBytesFromFile(string2))));
            X509CertificateHolder x509CertificateHolder2 = (X509CertificateHolder)pEMParser.readObject();
            X509Certificate x509Certificate2 = new JcaX509CertificateConverter().getCertificate(x509CertificateHolder2);
            pEMParser.close();
            pEMParser = new PEMParser((Reader)new InputStreamReader(new ByteArrayInputStream(IIBMsgElpMaxTest.readBytesFromFile(string3))));
            Object object = pEMParser.readObject();
            char[] cArray = string4.toCharArray();
            PEMDecryptorProvider pEMDecryptorProvider = new JcePEMDecryptorProviderBuilder().build(cArray);
            JcaPEMKeyConverter jcaPEMKeyConverter = new JcaPEMKeyConverter();
            if (object instanceof PEMEncryptedKeyPair) {
                this.printOut(string5 + "Encrypted key - we will use provided password");
                keyPair = jcaPEMKeyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair(pEMDecryptorProvider));
            } else {
                this.printOut(string5 + "Unencrypted key - no password needed");
                keyPair = jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object);
            }
            pEMParser.close();
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
            keyStore.setCertificateEntry("ca-certificate", x509Certificate);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(null, null);
            keyStore2.setCertificateEntry("certificate", x509Certificate2);
            keyStore2.setKeyEntry("private-key", keyPair.getPrivate(), string4.toCharArray(), new Certificate[]{x509Certificate2});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore2, string4.toCharArray());
            SSLContext sSLContext = SSLContext.getInstance("TLSv1");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new IIBMQTTException(string5, exception);
        }
    }

    protected SSLSocketFactory getSocketFactoryForJKS(String string, String string2) throws Exception {
        String string3 = "getSocketFactoryForJKS";
        string3 = this.methodNameTemplate(string3);
        try {
            char[] cArray = string2.toCharArray();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(new FileInputStream(string), cArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, cArray);
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(new FileInputStream(string), cArray);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keyStore2);
            SSLContext sSLContext = SSLContext.getInstance("SSLv3");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            return sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            throw new IIBMQTTException(string3, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] readBytesFromFile(String string) {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        File file = new File(string);
        byArray = new byte[(int)file.length()];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        Object var5_5 = null;
        if (fileInputStream == null) return byArray;
        try {
            fileInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byArray;
        {
            catch (IOException iOException) {
                iOException.printStackTrace();
                Object var5_6 = null;
                if (fileInputStream == null) return byArray;
                try {
                    fileInputStream.close();
                    return byArray;
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                return byArray;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw throwable;
        }
    }

    public class IIBMQTTException
    extends Exception {
        public IIBMQTTException(String string) {
            IIBMsgElpMaxTest.this.printOutStackTrace(string + " MQTT Exception occured", null);
        }

        public IIBMQTTException(String string, Throwable throwable) {
            IIBMsgElpMaxTest.this.printOutStackTrace(string + " MQTT Exception occured", (Exception)throwable);
        }

        public IIBMQTTException(String string, String string2) {
            IIBMsgElpMaxTest.this.printOutStackTrace(string + " " + string2, null);
        }
    }
}

