/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class IBMDb2TransTest
extends GenericTest {
    private static final int MEASURES_COUNT = 3;
    private String user;
    private String password;
    private String dbName;
    private Hashtable lastValues;
    private ArrayList activeDatabases;
    private String db2Version = "8.1";
    private String ssl = "";

    public IBMDb2TransTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.lastValues = new Hashtable();
        this.ssl = this.getValueForParam("ssl");
        this.ssl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("y") || this.ssl.trim().equalsIgnoreCase("yes")) ? "true" : "false";
    }

    public static void main(String[] stringArray) {
        IBMDb2TransTest iBMDb2TransTest = new IBMDb2TransTest(stringArray);
        iBMDb2TransTest.computeMeasures(new Hashtable());
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = this.getTransactionStats();
        if (hashtable2 == null || hashtable2.size() == 0) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable2.get(string);
            if (this.activeDatabases.contains(string)) {
                this.addNewMeasure(string, arrayList);
                continue;
            }
            this.addNewMeasure(string, this.getNotAvailableMeasures());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTransactionStats() {
        double d = -5.0;
        double d2 = -5.0;
        double d3 = -5.0;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable hashtable = new Hashtable();
        DB2JdbcHelper dB2JdbcHelper = null;
        if (this.ssl.equalsIgnoreCase("true")) {
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName, this.ssl);
            connection = dB2JdbcHelper.getConnection();
        } else {
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
        }
        if (connection == null) {
            System.out.println("Error in getting database connection");
            return null;
        }
        String string = dB2JdbcHelper.getDbSnapshotFunction(connection);
        System.out.println("snapshotTable for " + this.entity + " = " + string);
        String string2 = "SELECT \tDB_NAME, COMMIT_SQL_STMTS, INT_COMMITS,ROLLBACK_SQL_STMTS,INT_ROLLBACKS,INT_DEADLOCK_ROLLBACKS FROM TABLE(" + string + ") AS T";
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            this.activeDatabases = new ArrayList();
            ArrayList<Double> arrayList = null;
            while (resultSet.next()) {
                String string3 = resultSet.getString("DB_NAME");
                double d4 = resultSet.getDouble("COMMIT_SQL_STMTS");
                double d5 = resultSet.getDouble("INT_COMMITS");
                double d6 = resultSet.getDouble("ROLLBACK_SQL_STMTS");
                double d7 = resultSet.getDouble("INT_ROLLBACKS");
                double d8 = resultSet.getDouble("INT_DEADLOCK_ROLLBACKS");
                this.activeDatabases.add(string3);
                ArrayList<Double> arrayList2 = (ArrayList<Double>)this.lastValues.get(string3);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Double>(5);
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d6));
                    arrayList2.add(new Double(d7));
                    arrayList2.add(new Double(d8));
                } else {
                    double d9 = (Double)arrayList2.get(0);
                    double d10 = (Double)arrayList2.get(1);
                    double d11 = (Double)arrayList2.get(2);
                    double d12 = (Double)arrayList2.get(3);
                    double d13 = (Double)arrayList2.get(4);
                    d = this.timeSinceLastTest > 0.0 ? (d4 - d9 + (d5 - d10)) / this.timeSinceLastTest : -5.0;
                    d = d < 0.0 ? -5.0 : d;
                    d2 = this.timeSinceLastTest > 0.0 ? (d6 - d11 + (d7 - d12) + (d8 - d13)) / this.timeSinceLastTest : -5.0;
                    d2 = d2 < 0.0 ? -5.0 : d2;
                    d3 = this.timeSinceLastTest > 0.0 ? (d4 - d9 + (d6 - d11)) / this.timeSinceLastTest : -5.0;
                    d3 = d3 < 0.0 ? -5.0 : d3;
                    arrayList2.set(0, new Double(d4));
                    arrayList2.set(1, new Double(d5));
                    arrayList2.set(2, new Double(d6));
                    arrayList2.set(3, new Double(d7));
                    arrayList2.set(4, new Double(d8));
                }
                this.lastValues.put(string3, arrayList2);
                arrayList = new ArrayList<Double>(3);
                arrayList.add(new Double(d));
                arrayList.add(new Double(d2));
                arrayList.add(new Double(d3));
                hashtable.put(string3, arrayList);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception occured in IBMDb2TransTest " + exception);
        }
        finally {
            dB2JdbcHelper.closeStatement(statement);
            dB2JdbcHelper.closeResultSet(resultSet);
        }
        dB2JdbcHelper.closeConnection(connection);
        return hashtable;
    }

    private ArrayList getNotAvailableMeasures() {
        ArrayList<Double> arrayList = new ArrayList<Double>(3);
        for (int i = 0; i < 3; ++i) {
            arrayList.add(new Double(-5.0));
        }
        return arrayList;
    }
}

