/*
 * Decompiled with CFR 0.152.
 */
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class IBMDS8KRPUtilTest
extends SANRAIDBase {
    private static final int IBM_DS_8K_ARRAY_POOL_MEASURE_COUNT = 9;
    private static String fieldSep = new String("");
    private static String sync0 = new String("x");
    private CIMClient client = null;
    private UserPrincipal principal = null;
    private PasswordCredential credential = null;
    private CIMNameSpace ns = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBMDS8KRPUtilTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
        String string = this.protocol + "://" + this.targetHost + ":" + this.port + "/" + this.namespace;
        this.ns = new CIMNameSpace(string);
        this.printOut("Host - " + this.ns.getHost() + "  || Port - " + this.ns.getPort() + " || Scheme - " + this.ns.getScheme() + " || NameSpace - " + this.ns.getNameSpace());
        this.principal = new UserPrincipal(this.userName);
        this.credential = new PasswordCredential(this.password);
        if (fieldSep.length() == 0) {
            String string2 = sync0;
            synchronized (string2) {
                if (fieldSep.length() == 0) {
                    EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
                    fieldSep = egTesterInfo.getDDSeparator1();
                }
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Enumeration enumeration = null;
        Hashtable<String, ArrayList<Double>> hashtable2 = null;
        CIMInstance cIMInstance = null;
        ArrayList<Double> arrayList = null;
        String string = null;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        if (this.storageUniqueName == null || this.storageUniqueName.trim().length() == 0) {
            this.printOut("Storage name does not match,please re-enter ");
            return;
        }
        try {
            this.client = new CIMClient(this.ns, (Principal)this.principal, (Object)this.credential);
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
        }
        String string2 = "IBMTSDS_RankPool";
        try {
            enumeration = this.client.enumerateInstances(new CIMObjectPath(string2), true, false);
        }
        catch (Exception exception) {
            this.printOut("Exception : " + exception);
            exception.printStackTrace();
        }
        try {
            while (enumeration != null && enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                if (debug) {
                    this.printOut("statistic1  :" + cIMInstance);
                }
                if (cIMInstance == null) continue;
                arrayList = new ArrayList<Double>();
                d = this.getPropertyValue(cIMInstance, "HealthState", true);
                try {
                    Vector vector = this.getVectorValue(cIMInstance, "OperationalStatus");
                    n = -5;
                    n2 = -5;
                    n = Integer.parseInt(vector.get(0).toString());
                    if (vector.size() > 1) {
                        n2 = Integer.parseInt(vector.get(1).toString());
                    }
                }
                catch (Exception exception) {
                    this.printOut("Exception while processing  operational status" + exception);
                    this.logToErrorFile("[ERROR]", this.reportingName, this.entity + "  Exception while processing  operational status");
                }
                double d2 = 0.0;
                try {
                    Vector vector = this.getVectorValue(cIMInstance, "RAIDLevel");
                    d2 = -5.0;
                    d2 = Integer.parseInt(vector.get(0).toString());
                }
                catch (Exception exception) {
                    this.printOut("Exception while processing  RAID Level" + exception);
                    this.logToErrorFile("[ERROR]", this.reportingName, this.entity + "  Exception while processing  RAID Level");
                }
                double d3 = this.getPropertyValue(cIMInstance, "TotalManagedSpace", true);
                double d4 = this.getPropertyValue(cIMInstance, "RemainingManagedSpace", true);
                double d5 = d3 - d4;
                double d6 = d5 / d3 * 100.0;
                double d7 = d4 / d3 * 100.0;
                d3 /= 1.073741824E9;
                d3 = this.roundDouble(d3, 2);
                d4 /= 1.073741824E9;
                d4 = this.roundDouble(d4, 2);
                d5 /= 1.073741824E9;
                d5 = this.roundDouble(d5, 2);
                string = this.getPropertyValue(cIMInstance, "ElementName");
                if (debug) {
                    this.printOut("Rank Pool Element name :" + string);
                    this.printOut("Rank Pool HealthState   :" + d);
                    this.printOut("Rank Pool Operational Status :" + n);
                    this.printOut("Rank Pool Detailed Status :" + n2);
                    this.printOut("Rank Pool totalManagedSpace   :" + d3);
                    this.printOut("Rank Pool remainingManagedSpace   :" + d4);
                    this.printOut("Rank Pool usedSpace :" + d5);
                    this.printOut("Rank Pool usedPCT :" + d6);
                    this.printOut("Rank Pool freePCT :" + d7);
                    this.printOut("Rank Pool raidLevel :" + d2);
                }
                d = this.getHealthStatusIndex((int)d);
                n = this.getOperationalStatusIndex(n);
                n2 = this.getDetailedOperationalStatusIndex(n2);
                arrayList.add(new Double(d));
                arrayList.add(new Double(n));
                arrayList.add(new Double(n2));
                arrayList.add(new Double(d3));
                arrayList.add(new Double(d4));
                arrayList.add(new Double(d5));
                arrayList.add(new Double(d6));
                arrayList.add(new Double(d7));
                arrayList.add(new Double(d2));
                hashtable2 = new Hashtable<String, ArrayList<Double>>();
                if (string == null || string.trim().length() <= 0) continue;
                hashtable2.put(string, arrayList);
            }
            this.client.close();
            if (debug) {
                this.printOut("Measure datas are :");
            }
            Enumeration enumeration2 = hashtable2.keys();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                ArrayList arrayList2 = (ArrayList)hashtable2.get(string3);
                if (debug) {
                    this.printOut("Key   :" + string3);
                    this.printOut("Value :" + arrayList2);
                }
                this.addNewMeasure(string3, arrayList2);
            }
        }
        catch (Exception exception) {
            this.printOut("Exception : " + exception);
            this.logToErrorFile("[ERROR]", this.reportingName, this.entity + "  Exception : " + exception);
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Usage :<Test_name> -host <SMIS_agent_IP> -user <SMIS_agent_CIM_Server_username> -password <SMIS_agent_CIM_Server_password> -ssl <ssl> -CIM_Server_Port <CIM_Server_Port> -isEmbedded <SMIS_agent_embeded> -serialNumber <Storage_System_SerialNumber> -nameSpace <Namespace>\n e.g :<Test_name> -host 192.168.8.55 -user admin -password admin -ssl false -CIM_Server_Port 5988 -isEmbedded no -serialNumber FCNMM094900059 -nameSpace /root/emc ");
        IBMDS8KRPUtilTest iBMDS8KRPUtilTest = new IBMDS8KRPUtilTest(stringArray);
        iBMDS8KRPUtilTest.computeMeasures(new Hashtable());
    }
}

