/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;

public class IBMDB2RepBase
extends GenericTest {
    public String user;
    public String password;
    public String dbName;
    private String sys_OS = "";
    private long lastTime = 0L;
    private static Hashtable lastTimeHash = new Hashtable();
    public static Hashtable metricHash = new Hashtable();
    private static String metricSync = new String("metricSync");
    protected static String myDatePattern = "dd/MM/yy hh:mm:ss a";
    protected static SimpleDateFormat mySDF = new SimpleDateFormat(myDatePattern);
    private static Hashtable syncHash = new Hashtable();
    protected String ssl = "";

    public IBMDB2RepBase(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(this.measureCount);
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.dbName = this.getValueForParam("database");
        this.ssl = this.getValueForParam("ssl");
        this.ssl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("y") || this.ssl.trim().equalsIgnoreCase("yes")) ? "true" : "false";
        try {
            this.setLastExectionTime();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR :", this.entity, " Exception occured in constructor for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " dbName :" + this.dbName);
            this.printOut(this.entity + " Exception occured in constructor :" + exception.toString());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectMetrics() {
        String string;
        String string2 = "";
        String string3 = this.reportingName + ":" + this.portNo;
        string2 = (String)syncHash.get(string3);
        if (string2 == null) {
            string = metricSync;
            synchronized (string) {
                syncHash.put(string3, string3);
                string2 = string3;
            }
        }
        string = string2;
        synchronized (string) {
            this.getLastExectionTime();
            long l = System.currentTimeMillis();
            long l2 = l - this.lastTime;
            long l3 = (long)(0.9 * (double)this.measurePeriod);
            boolean bl = false;
            bl = l2 >= l3;
            if (bl) {
                this.getDatabases(this.reportingName + ":" + this.portNo);
                this.lastTime = System.currentTimeMillis();
                this.setLastExectionTime();
            }
        }
    }

    private void setLastExectionTime() {
        lastTimeHash.put(this.reportingName, new Long(this.lastTime));
    }

    private void getLastExectionTime() {
        Long l = (Long)lastTimeHash.get(this.reportingName);
        this.lastTime = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getDatabases(String string) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        DB2JdbcHelper dB2JdbcHelper = null;
        if (this.ssl.equalsIgnoreCase("true")) {
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName, this.ssl);
            connection = dB2JdbcHelper.getConnection();
        } else {
            dB2JdbcHelper = new DB2JdbcHelper(this.targetHost, this.portNo, this.user, this.password, this.dbName);
            connection = dB2JdbcHelper.getConnection();
        }
        if (connection == null) {
            this.logToErrorFile("ERROR :", this.entity, " Connection is null for targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " dbName :" + this.dbName);
            this.printOut(this.entity + " Connection is null");
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        try {
            statement = connection.createStatement();
        }
        catch (Exception exception) {
            this.logToErrorFile("ERROR:", this.entity + " Failed to Create Statement targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " dbName :" + this.dbName, exception.toString());
            this.closeSt(statement);
            this.closeConn(connection);
            exception.printStackTrace();
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
                return;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            return;
        }
        String string2 = "select substr(db_name, 1, 8) as dbname, hadr_role, hadr_state, hadr_connect_status,hadr_local_host,hadr_remote_host,hadr_heartbeat,hadr_syncmode  from table (snap_get_hadr (cast (null as varchar(128)), 0)) as t";
        this.printOut(this.entity + " dbQuery :" + string2 + " targetHost :" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " dbName :" + this.dbName);
        resultSet = statement.executeQuery(string2);
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = this.reportingName + ":" + this.portNo;
        Hashtable hashtable = new Hashtable();
        while (resultSet.next()) {
            string3 = resultSet.getString(1);
            string4 = resultSet.getString(2);
            string5 = resultSet.getString(3);
            string6 = resultSet.getString(4);
            string7 = resultSet.getString(5);
            string8 = resultSet.getString(6);
            string9 = resultSet.getString(7);
            string10 = resultSet.getString(8);
            if (string3 != null && string3.trim().length() > 0) {
                string3 = string3.trim();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(new String(string4));
            arrayList.add(new String(string5));
            arrayList.add(new String(string6));
            arrayList.add(new String(string7));
            arrayList.add(new String(string8));
            arrayList.add(new String(string9));
            arrayList.add(new String(string10));
            hashtable.put(string3, arrayList);
        }
        metricHash.put(string11, hashtable);
        this.printOut(this.entity + " metricHash :" + metricHash);
        this.closeRs(resultSet);
        this.closeSt(statement);
        this.closeConn(connection);
        return;
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            try {
                this.closeRs(resultSet);
                this.closeSt(statement);
                this.closeConn(connection);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            resultSet = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeSt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeConn(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            connection = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double getDoubleVal(Double d) {
        double d2 = 0.0;
        if (d != null) {
            d2 = d;
        }
        return d2;
    }

    public double getDiff(double d, double d2) {
        double d3 = -5.0;
        if (!(d >= 0.0) || !(d2 >= 0.0) || !(d >= d2) || (d3 = d - d2) > 0.0) {
            // empty if block
        }
        return d3;
    }

    public void printOut(String string) {
        this.printOut(string, true);
    }

    public void printOut(String string, boolean bl) {
        if (bl) {
            System.out.println(" >> [ " + this.entity + " ] : [ " + this.reportingName + " ] : [ " + mySDF.format(new Date()) + " ] : >> " + string);
        }
    }

    public void putErrorMessageToLogfile(String string) {
        this.logToErrorFile("ERROR :", this.reportingName + " : " + this.entity, string);
    }

    public void putInfoMessageToLogfile(String string) {
        this.logToErrorFile("INFO :", this.reportingName + " : " + this.entity, string);
    }

    public void putWarningMessageToLogfile(String string) {
        this.logToErrorFile("WARNING :", this.reportingName + " : " + this.entity, string);
    }

    public void printOutStackTrace(String string, Exception exception) {
        String string2 = "[StackTrace] :" + string + " :";
        String string3 = null;
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string3 = stringWriter.toString();
            printWriter.close();
        }
        catch (Exception exception2) {
            string3 = exception.toString();
        }
        this.printOut(string2 + exception.toString());
        this.putErrorMessageToLogfile(string2 + string3);
    }

    public String getDDValue(String string) {
        string = string == null || string.trim().length() == 0 ? "-" : string.trim();
        return string;
    }

    public static void main(String[] stringArray) {
        IBMDB2RepBase iBMDB2RepBase = new IBMDB2RepBase(stringArray);
        while (true) {
            int n = 0;
            ++n;
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            iBMDB2RepBase.getDatabases("");
        }
    }
}

