/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HwFanTest
extends EgSnmpGenericTest {
    private static String fanSpeed = ".1.3.6.1.4.1.674.10892.1.700.12.1.6";
    private static String fanName = ".1.3.6.1.4.1.674.10892.1.700.12.1.8";
    private static String state = ".1.3.6.1.4.1.674.10892.1.700.12.1.4";
    private static String status = ".1.3.6.1.4.1.674.10892.1.700.12.1.5";
    private static String oid = ".1.3.6.1.4.1.674.10892.1.700.12.1";
    private boolean isDell = false;
    private boolean isCpq = false;
    private boolean isIbm = false;
    private static int numMeasures = 2;
    private static String cpqFanSpeed = ".1.3.6.1.4.1.232.6.2.6.6.1.7";
    private static String cpqFanStatus = ".1.3.6.1.4.1.232.6.2.6.6.1.5";
    private static String cpqFtFanSpeed = ".1.3.6.1.4.1.232.6.2.6.7.1.6";
    private static String cpqFtFanStatus = ".1.3.6.1.4.1.232.6.2.6.7.1.9";
    private static String ibmFanName = ".1.3.6.1.4.1.2.6.159.1.1.80.5.1.1";
    private static String ibmFanSpeed = ".1.3.6.1.4.1.2.6.159.1.1.80.5.1.2";
    private static String ibmFanStatus = ".1.3.6.1.4.1.2.6.159.1.1.80.5.1.20";
    private boolean isAix = false;

    public static void main(String[] stringArray) {
        HwFanTest hwFanTest = new HwFanTest(stringArray);
        hwFanTest.computeMeasures(new Hashtable());
    }

    public HwFanTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.isDynamicInfoTest = true;
        String string = System.getProperty("os.name");
        if (string != null && string.equalsIgnoreCase("aix")) {
            this.isAix = true;
        }
    }

    private double getValue(int n) {
        if (this.lhs == null || this.lhs.length == 0) {
            return -5.0;
        }
        double d = -5.0;
        try {
            d = Double.parseDouble(this.rhs[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d < 0.0) {
            d = -5.0;
        }
        return d;
    }

    public void runAixTest() {
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines("/usr/lpp/diagnostics/bin/uesensor -a");
        if (arrayList == null) {
            return;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            if (string == null || string.trim().length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            if (stringTokenizer.countTokens() != 5) {
                System.out.println("Fan speed values are not obtained properly. " + string);
                continue;
            }
            if (!stringTokenizer.nextToken().equals("9001")) continue;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            String string6 = string5 + ":" + string2;
            double d = -5.0;
            try {
                d = Double.parseDouble(string4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int n = 1;
            if (string3.equals("11")) {
                n = 1;
            } else if (string3.equals("10")) {
                n = 2;
            } else if (string3.equals("9")) {
                n = 2;
            } else if (string3.equals("12")) {
                n = 3;
            } else if (string3.equals("13")) {
                n = 4;
            }
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            arrayList3.add(new Double(d));
            arrayList3.add(new Double(n));
            this.addNewMeasure(string6, arrayList3);
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        if (!this.meAgentless && this.isAix) {
            this.runAixTest();
            return;
        }
        boolean bl = false;
        if (this.isDell || this.isCpq || this.isIbm) {
            bl = true;
        }
        if (this.isDell || !bl) {
            this.runDellFanTest();
        }
        if (!this.isDell && this.isCpq && !this.isIbm || !bl) {
            this.runCpqFanTest();
        }
        if (!this.isDell && !this.isCpq && this.isIbm || !bl) {
            this.runIbmFanTest();
        }
    }

    private void runCpqFanTest() {
        ArrayList<Double> arrayList;
        Double d;
        double d2;
        double d3;
        double d4;
        int n;
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
        boolean bl = false;
        if (this.runSnmpCmdForOid(cpqFanSpeed) && this.lhs != null && this.lhs.length > 0) {
            bl = true;
            this.isCpq = true;
            for (n = 0; n < this.lhs.length; ++n) {
                d4 = this.getValue(n);
                hashtable.put(this.lhs[n], new Double(d4));
            }
            if (this.runSnmpCmdForOid(cpqFanStatus) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d4 = this.getValue(n);
                    if (d4 <= 2.0) {
                        hashtable2.put(this.lhs[n], new Double(1.0));
                        continue;
                    }
                    if (d4 == 3.0) {
                        hashtable2.put(this.lhs[n], new Double(3.0));
                        continue;
                    }
                    hashtable2.put(this.lhs[n], new Double(4.0));
                }
            }
        }
        if (this.runSnmpCmdForOid(cpqFtFanSpeed) && this.lhs != null && this.lhs.length > 0) {
            bl = true;
            this.isCpq = true;
            for (n = 0; n < this.lhs.length; ++n) {
                d4 = this.getValue(n);
                hashtable3.put(this.lhs[n], new Double(d4));
            }
            System.out.println("FS2 is " + hashtable3);
            if (this.runSnmpCmdForOid(cpqFtFanStatus) && this.lhs != null) {
                for (n = 0; n < this.lhs.length; ++n) {
                    d4 = this.getValue(n);
                    if (d4 <= 2.0) {
                        hashtable4.put(this.lhs[n], new Double(1.0));
                        continue;
                    }
                    if (d4 == 3.0) {
                        hashtable4.put(this.lhs[n], new Double(3.0));
                        continue;
                    }
                    hashtable4.put(this.lhs[n], new Double(4.0));
                }
            }
            System.out.println("State 2 is " + hashtable4);
        }
        this.isCpq = bl;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            d3 = (Double)hashtable.get(string);
            d2 = -5.0;
            d = (Double)hashtable2.get(string);
            if (d != null) {
                d2 = d;
            }
            arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d2));
            this.addNewMeasure(string, arrayList);
        }
        enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            d3 = (Double)hashtable3.get(string);
            d2 = -5.0;
            d = (Double)hashtable4.get(string);
            if (d != null) {
                d2 = d;
            }
            arrayList = new ArrayList();
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d2));
            this.addNewMeasure(string, arrayList);
        }
    }

    private void runDellFanTest() {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, Double> hashtable3 = new Hashtable<String, Double>();
        Hashtable<String, Double> hashtable4 = new Hashtable<String, Double>();
        this.isDell = false;
        if (this.runSnmpCmdForOid(oid)) {
            if (this.lhs == null) {
                return;
            }
            this.isDell = true;
            for (int i = 0; i < this.lhs.length; ++i) {
                if (this.lhs[i].startsWith("6.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    hashtable.put(this.lhs[i], new Double(this.getValue(i)));
                    continue;
                }
                if (this.lhs[i].startsWith("8.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    hashtable2.put(this.lhs[i], this.rhs[i]);
                    continue;
                }
                if (this.lhs[i].startsWith("4.")) {
                    this.lhs[i] = this.lhs[i].substring(2);
                    hashtable3.put(this.lhs[i], new Double(this.getValue(i)));
                    continue;
                }
                if (!this.lhs[i].startsWith("5.")) continue;
                this.lhs[i] = this.lhs[i].substring(2);
                hashtable4.put(this.lhs[i], new Double(this.getValue(i)));
            }
        } else {
            this.isDell = false;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2 == null) continue;
            double d = (Double)hashtable.get(string);
            double d2 = (Double)hashtable3.get(string);
            if (d2 != 2.0) continue;
            double d3 = (Double)hashtable4.get(string);
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            double d4 = -1.0;
            if (d3 == 3.0) {
                d4 = 1.0;
            } else if (d3 == 4.0 || d3 == 7.0) {
                d4 = 2.0;
            } else if (d3 == 6.0 || d3 == 9.0) {
                d4 = 3.0;
            } else if (d3 == 5.0 || d3 == 8.0 || d3 == 10.0) {
                d4 = 4.0;
            }
            arrayList.add(new Double(d4));
            this.addNewMeasure(string2, arrayList);
        }
    }

    private void runIbmFanTest() {
        int n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
        this.isIbm = false;
        if (this.runSnmpCmdForOid(ibmFanName)) {
            if (this.lhs == null) {
                return;
            }
            this.isIbm = true;
            for (n = 0; n < this.lhs.length; ++n) {
                hashtable.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            this.isIbm = false;
        }
        if (!this.isIbm) {
            return;
        }
        this.isIbm = false;
        if (this.runSnmpCmdForOid(ibmFanSpeed)) {
            if (this.lhs == null) {
                return;
            }
            this.isIbm = true;
            for (n = 0; n < this.lhs.length; ++n) {
                hashtable2.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            this.isIbm = false;
        }
        if (!this.isIbm) {
            return;
        }
        this.isIbm = false;
        if (this.runSnmpCmdForOid(ibmFanStatus)) {
            if (this.lhs == null) {
                return;
            }
            this.isIbm = true;
            for (n = 0; n < this.lhs.length; ++n) {
                hashtable3.put(this.lhs[n], this.rhs[n]);
            }
        } else {
            this.isIbm = false;
        }
        if (!this.isIbm) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2 == null) continue;
            double d = -1.0;
            try {
                d = Double.parseDouble((String)hashtable2.get(string));
            }
            catch (Exception exception) {
                continue;
            }
            String string3 = (String)hashtable3.get(string);
            double d2 = -5.0;
            if (string3 != null && !string3.equalsIgnoreCase("null")) {
                d2 = string3.equalsIgnoreCase("OK") || string3.equalsIgnoreCase("Normal") ? 1.0 : (string3.equalsIgnoreCase("Warning") || string3.equalsIgnoreCase("Pred Fail") ? 3.0 : (string3.equalsIgnoreCase("Degraded") || string3.equalsIgnoreCase("Error") ? 4.0 : -5.0));
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            this.addNewMeasure(string2, arrayList);
        }
    }
}

