/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.APMComponent;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMStatusCodeObject;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStatusCodeTest
extends APMBase {
    private static final Double ZERO_VALUE = 0.0;
    private static final Double MINUS_VALUE = -5.0;
    private static final String SUMMARY = "Summary";
    private ArrayList<String> specificStatusTrackingList = new ArrayList();
    private static final String STATUS = " status";
    private static final String TOTAL_REQUEST_COUNT = "TOTAL_REQUEST_COUNT";
    private static final String TOTAL_REDIRECT_COUNT = "TOTAL_REDIRECT_COUNT";
    private static final String REDIRECTED = "_Redirected";
    private long maxDDLimit = 10L;
    protected Hashtable ddSourceTable = null;

    public HttpStatusCodeTest(String[] args) {
        super(args);
        String maxLimit;
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [" + "HttpResponseStatusTest" + "]";
        this.needAgentlessDD = true;
        this.isNewDynamicInfoTest = true;
        String specificStatusString = this.getValueForParam("Specific_Status_Code_List");
        if (specificStatusString != null && !specificStatusString.equalsIgnoreCase("None")) {
            StringTokenizer str = new StringTokenizer(specificStatusString, ",");
            while (str.hasMoreElements()) {
                String specificStatus = (String)str.nextElement();
                this.specificStatusTrackingList.add(specificStatus);
            }
            JavaBTMLogger.btmLogger.debug("{} Specific status code tracking list updated with {} : for JVM {}", new Object[]{this.loggerDispStr, this.specificStatusTrackingList, this.apmComponentGUID});
        }
        if ((maxLimit = this.getValueForParam("Max_Per_Status_Code_DD_Limit")) != null) {
            try {
                this.maxDDLimit = Long.parseLong(maxLimit);
                JavaBTMLogger.btmLogger.debug("{} Max DD capture for each status code descriptor is  updated to {} : for JVM {}", new Object[]{this.loggerDispStr, this.maxDDLimit, this.apmComponentGUID});
            }
            catch (Exception e) {
                this.maxDDLimit = 10L;
                JavaBTMLogger.btmLogger.error("{} Max DD capture for each status code descriptor is  updated to {} : for JVM {}", new Object[]{this.loggerDispStr, this.maxDDLimit, this.apmComponentGUID});
                JavaBTMLogger.btmLogger.error("Exception while parsing javaStatusCodeTest DD limit {}", (Throwable)e);
            }
        }
    }

    @Override
    public void computeMeasures(Hashtable paramList) {
        String descriptor;
        boolean heartBeating;
        this.getJvmGuid();
        APMComponent component = APMComponentIDRepository.getRepository().getAPMComponent(this.apmComponentGUID);
        if (component == null) {
            return;
        }
        ArrayList<APMStatusCodeObject> statusCodeSourceList = component.getAPMStatusCode();
        HashMap<String, Double> callCountDetailsMap = new HashMap<String, Double>();
        HashMap<String, Double> redirectedCallCountDetailsMap = new HashMap<String, Double>();
        this.ddSourceTable = new Hashtable();
        long testFrequency = this.measurePeriod / 1000L / 60L;
        JavaBTMLogger.btmLogger.info("{}  {} received status code details list : {} specificStatusTrackingList : {} ", new Object[]{this.loggerDispStr, this.entity, statusCodeSourceList, this.specificStatusTrackingList});
        boolean bl = heartBeating = component.getHeartbeatStatus() == Status.HEART_BEATING;
        if (statusCodeSourceList == null && heartBeating) {
            ArrayList summarResultList = this.createDefaultValueList();
            int index = 2;
            while (index <= 5) {
                String zeroValueDescriptor = this.getDisplayDescriptor(String.valueOf(index));
                this.addNewMeasure(zeroValueDescriptor, summarResultList);
                ++index;
            }
        } else if (statusCodeSourceList != null) {
            int index = 0;
            while (index < statusCodeSourceList.size()) {
                APMStatusCodeObject apmStatusCodeObject = statusCodeSourceList.get(index);
                String statusCode = apmStatusCodeObject.getStatusCode();
                descriptor = this.getDisplayDescriptor(statusCode);
                if (descriptor == null) {
                    JavaBTMLogger.btmLogger.warn("{}  {} unable to process this request because descriptor is null for status code : {} ", new Object[]{this.loggerDispStr, this.entity, statusCode});
                } else {
                    boolean isSpecific = this.specificStatusTrackingList.contains(statusCode);
                    if (apmStatusCodeObject.isStatus404Redirect()) {
                        double request404Count = apmStatusCodeObject.getStatus404Count();
                        double request404RedirectCount = apmStatusCodeObject.getStatus404RedirectCount();
                        this.update404CallCountDetails(descriptor, request404Count, request404RedirectCount, callCountDetailsMap, redirectedCallCountDetailsMap);
                    } else {
                        boolean isErrorRedirectRequest = apmStatusCodeObject.isErrorRedirectRequest();
                        if (isSpecific) {
                            String specificDescriptor = this.getSpecificDisplayDescriptor(statusCode);
                            this.updateCallCountDetails(specificDescriptor, callCountDetailsMap, isErrorRedirectRequest, redirectedCallCountDetailsMap, apmStatusCodeObject, true);
                            this.updateCallCountDetails(descriptor, callCountDetailsMap, isErrorRedirectRequest, redirectedCallCountDetailsMap, apmStatusCodeObject, false);
                        } else {
                            this.updateCallCountDetails(descriptor, callCountDetailsMap, isErrorRedirectRequest, redirectedCallCountDetailsMap, apmStatusCodeObject, true);
                        }
                    }
                }
                ++index;
            }
        }
        JavaBTMLogger.btmLogger.trace("{}  {} callCountDetailsMap {}  redirectedCallCountDetailsMap {} ", new Object[]{this.loggerDispStr, this.entity, callCountDetailsMap, redirectedCallCountDetailsMap});
        this.calculateSummaryAllDetails(callCountDetailsMap, redirectedCallCountDetailsMap, testFrequency);
        if (callCountDetailsMap != null && callCountDetailsMap.size() > 0) {
            Iterator<Map.Entry<String, Double>> descriptorIterator = callCountDetailsMap.entrySet().iterator();
            while (descriptorIterator.hasNext()) {
                ArrayList<Double> resultList = new ArrayList<Double>();
                Map.Entry<String, Double> e = descriptorIterator.next();
                descriptor = e.getKey();
                Double totalcount = e.getValue();
                String redirectDiscriptor = String.valueOf(descriptor) + REDIRECTED;
                Double errorRedirectedCount = redirectedCallCountDetailsMap.remove(redirectDiscriptor);
                errorRedirectedCount = errorRedirectedCount == null ? 0.0 : errorRedirectedCount;
                Double callPerMin = totalcount / (double)testFrequency;
                resultList.add(totalcount);
                resultList.add(callPerMin);
                resultList.add(errorRedirectedCount);
                resultList.add(MINUS_VALUE);
                resultList.add(MINUS_VALUE);
                resultList.add(MINUS_VALUE);
                resultList.add(MINUS_VALUE);
                this.addNewMeasure(descriptor, resultList);
            }
        }
    }

    private void calculateSummaryAllDetails(HashMap<String, Double> callCountDetailsMap, HashMap<String, Double> redirectedCallCountDetailsMap, long testFrequency) {
        HashMap allDetailsMap = new HashMap();
        if (callCountDetailsMap != null && callCountDetailsMap.size() > 0) {
            double totalRequestCount = callCountDetailsMap.remove(TOTAL_REQUEST_COUNT);
            Double totalRedirectCount = redirectedCallCountDetailsMap.get(TOTAL_REDIRECT_COUNT);
            ArrayList<Double> resultList = new ArrayList<Double>();
            resultList.add(totalRequestCount);
            resultList.add(totalRequestCount / (double)testFrequency);
            if (totalRedirectCount == null) {
                totalRedirectCount = 0.0;
            }
            resultList.add(totalRedirectCount);
            int index = 2;
            while (index <= 5) {
                String descriptor = this.getDisplayDescriptor(String.valueOf(index));
                Double thisCount = callCountDetailsMap.get(descriptor);
                if (thisCount == null) {
                    resultList.add(ZERO_VALUE);
                } else {
                    double percentage = thisCount * 100.0 / totalRequestCount;
                    resultList.add(percentage);
                }
                ++index;
            }
            this.addNewMeasure("All Responses", resultList);
        }
    }

    private void prepareDDDetails(String descriptor, APMStatusCodeObject apmStatusCodeObject) {
        if (this.ddSourceTable != null && this.ddSourceTable.containsKey(descriptor)) {
            ArrayList finalList = (ArrayList)this.ddSourceTable.get(descriptor);
            ArrayList innerList = this.getDDData(apmStatusCodeObject);
            finalList.add(innerList);
            this.ddSourceTable.put(descriptor, finalList);
        } else {
            ArrayList innerList = this.getDDData(apmStatusCodeObject);
            ArrayList<ArrayList> finalList = new ArrayList<ArrayList>();
            finalList.add(innerList);
            this.ddSourceTable.put(descriptor, finalList);
        }
    }

    private ArrayList getDDData(APMStatusCodeObject apmStatusCodeObject) {
        ArrayList<String> resultList = new ArrayList<String>();
        String eGGUID = apmStatusCodeObject.getReqGUID();
        String eGGuid = eGGUID.substring(0, eGGUID.indexOf("#~#"));
        String nodeOrder = eGGUID.substring(eGGUID.indexOf("#~#") + 3);
        resultList.add(eGGuid);
        resultList.add(nodeOrder);
        resultList.add(apmStatusCodeObject.getPatternString());
        resultList.add(apmStatusCodeObject.getStatusMesage());
        resultList.add(apmStatusCodeObject.getStatusCode());
        JavaBTMLogger.btmLogger.trace("{} DDD data is prepared for status code {} {}", new Object[]{this.loggerDispStr, apmStatusCodeObject.getStatusCode(), resultList});
        return resultList;
    }

    private void update404CallCountDetails(String descriptor, double request404Count, double request404RedirectCount, HashMap<String, Double> callCountDetailsMap, HashMap<String, Double> redirectedCallCountDetailsMap) {
        if (callCountDetailsMap.containsKey(descriptor)) {
            double count = callCountDetailsMap.get(descriptor);
            double total = count + request404Count;
            callCountDetailsMap.put(descriptor, total);
        } else {
            callCountDetailsMap.put(descriptor, request404Count);
        }
        this.updateCallCountDetails(redirectedCallCountDetailsMap, String.valueOf(descriptor) + REDIRECTED, request404RedirectCount);
        this.updateCallCountDetails(redirectedCallCountDetailsMap, TOTAL_REDIRECT_COUNT, request404RedirectCount);
        this.updateCallCountDetails(callCountDetailsMap, TOTAL_REQUEST_COUNT, request404Count);
    }

    private void updateCallCountDetails(String descriptor, HashMap<String, Double> callCountDetailsMap, boolean isErrorRedirectRequest, HashMap<String, Double> redirectedCallCountDetailsMap, APMStatusCodeObject apmStatusCodeObject, boolean isCapture) {
        if (callCountDetailsMap.containsKey(descriptor)) {
            double count = callCountDetailsMap.get(descriptor);
            if (count < (double)this.maxDDLimit && isCapture) {
                this.prepareDDDetails(descriptor, apmStatusCodeObject);
            }
            callCountDetailsMap.put(descriptor, count += 1.0);
        } else {
            if (isCapture) {
                this.prepareDDDetails(descriptor, apmStatusCodeObject);
            }
            callCountDetailsMap.put(descriptor, 1.0);
        }
        if (isErrorRedirectRequest) {
            this.updateCallCountDetails(redirectedCallCountDetailsMap, String.valueOf(descriptor) + REDIRECTED, 1.0);
            this.updateCallCountDetails(redirectedCallCountDetailsMap, TOTAL_REDIRECT_COUNT, 1.0);
        }
        if (isCapture) {
            this.updateCallCountDetails(callCountDetailsMap, TOTAL_REQUEST_COUNT, 1.0);
        }
    }

    private void updateCallCountDetails(HashMap<String, Double> detailsMap, String keyType, double count) {
        Double totalCount = detailsMap.get(keyType);
        if (totalCount == null) {
            detailsMap.put(keyType, count);
        } else {
            totalCount = totalCount + count;
            detailsMap.put(keyType, totalCount);
        }
    }

    private String getDisplayDescriptor(String statusCode) {
        if (statusCode.startsWith("2")) {
            return "HTTP 2xx Status:Summary";
        }
        if (statusCode.startsWith("3")) {
            return "HTTP 3xx Status:Summary";
        }
        if (statusCode.startsWith("4")) {
            return "HTTP 4xx Status:Summary";
        }
        if (statusCode.startsWith("5")) {
            return "HTTP 5xx Status:Summary";
        }
        return null;
    }

    private String getSpecificDisplayDescriptor(String statusCode) {
        if (statusCode.startsWith("2")) {
            return "HTTP 2xx Status:" + statusCode + STATUS;
        }
        if (statusCode.startsWith("3")) {
            return "HTTP 3xx Status:" + statusCode + STATUS;
        }
        if (statusCode.startsWith("4")) {
            return "HTTP 4xx Status:" + statusCode + STATUS;
        }
        if (statusCode.startsWith("5")) {
            return "HTTP 5xx Status:" + statusCode + STATUS;
        }
        return null;
    }

    private ArrayList createDefaultValueList() {
        ArrayList<Double> defaultList = new ArrayList<Double>();
        defaultList.add(ZERO_VALUE);
        defaultList.add(ZERO_VALUE);
        defaultList.add(ZERO_VALUE);
        defaultList.add(MINUS_VALUE);
        defaultList.add(MINUS_VALUE);
        defaultList.add(MINUS_VALUE);
        defaultList.add(MINUS_VALUE);
        return defaultList;
    }

    public ArrayList getStatusCodeDDDetails(String patDesc) {
        ArrayList result = null;
        if (this.ddSourceTable != null && this.ddSourceTable.size() > 0) {
            result = (ArrayList)this.ddSourceTable.get(patDesc);
        }
        JavaBTMLogger.btmLogger.trace("{} Method getDDDetails returns {} ", (Object)this.loggerDispStr, result);
        return result;
    }
}

