/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IniFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class FcSwSensorTest
extends EgSnmpGenericTest {
    private static String sensorNameOid = ".1.3.6.1.3.94.1.8.1.3";
    private static String sensorStatusOid = ".1.3.6.1.3.94.1.8.1.4";
    private static String sensorMessageOid = ".1.3.6.1.3.94.1.8.1.6";
    private static String sensorCharOid = ".1.3.6.1.3.94.1.8.1.8";
    private static String sensorTypeOid = ".1.3.6.1.3.94.1.8.1.7";
    public Hashtable ddSenMsg = new Hashtable();
    public Hashtable ddType = new Hashtable();
    public Hashtable ddChar = new Hashtable();
    public Hashtable ddStatus = new Hashtable();
    public Hashtable ddStateId = new Hashtable();
    private double version_d = 5.6;
    boolean debug = false;

    public FcSwSensorTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.isDynamicInfoTest = true;
        String string = this.getValueForParam("debug");
        if (string == null) {
            this.debug = false;
        }
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            this.debug = true;
        }
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/eg_tests.ini");
        String string2 = iniFile.getValue("MANAGER_SETTINGS", "ManagerVersion");
        if (this.debug) {
            System.out.println("[FcSwSensorTest] version :" + string2);
        }
        if (string2 != null && !string2.equals("")) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
            if (this.debug) {
                System.out.println("[FcSwConnUnitTest] Manager Version After substring :" + string2);
            }
            try {
                this.version_d = Double.parseDouble(string2);
            }
            catch (Exception exception) {
                this.version_d = 5.6;
                System.out.println("[FcSwSensorTest] Exception e:" + exception);
            }
        }
    }

    private int getInteger(String string) {
        if (string == null || string.length() == 0) {
            return -5;
        }
        int n = -5;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -5;
        }
        return n;
    }

    private String getStatusMsg(int n) {
        switch (n) {
            case 1: {
                return "unknown";
            }
            case 2: {
                return "other";
            }
            case 3: {
                return "ok";
            }
            case 4: {
                return "warning";
            }
            case 5: {
                return "failed";
            }
        }
        return "-";
    }

    private String getCharacteristic(int n) {
        switch (n) {
            case 1: {
                return "unknown";
            }
            case 2: {
                return "other";
            }
            case 3: {
                return "temperature";
            }
            case 4: {
                return "Pressure";
            }
            case 5: {
                return "EMF";
            }
            case 6: {
                return "Current value";
            }
            case 7: {
                return "Air flow";
            }
            case 8: {
                return "Frequency";
            }
            case 9: {
                return "Power";
            }
            case 10: {
                return "Door";
            }
        }
        return "-";
    }

    private String getSensorType(int n) {
        switch (n) {
            case 1: {
                return "unknown";
            }
            case 2: {
                return "other";
            }
            case 3: {
                return "Battery";
            }
            case 4: {
                return "Fan";
            }
            case 5: {
                return "Power Supply";
            }
            case 6: {
                return "Transmitter";
            }
            case 7: {
                return "Enclosure";
            }
            case 8: {
                return "Board";
            }
            case 9: {
                return "Receiver";
            }
        }
        return "-";
    }

    public void freeTest() {
        this.ddSenMsg = new Hashtable();
        this.ddType = new Hashtable();
        this.ddChar = new Hashtable();
        this.ddStatus = new Hashtable();
        this.ddStateId = new Hashtable();
    }

    public void computeMeasures(Hashtable hashtable) {
        if (this.version_d > 5.2) {
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable5 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable6 = new Hashtable<String, String>();
            this.freeTest();
            if (this.debug) {
                System.out.println("Manager Version : " + this.version_d + " from FcSwSensorTest Agent side ");
            }
            try {
                String string;
                int n;
                int n2;
                if (!this.runSnmpCmdForOid(sensorNameOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable2.put(this.lhs[n2], this.rhs[n2]);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Name ===> " + hashtable2.size());
                }
                if (!this.runSnmpCmdForOid(sensorTypeOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    n = this.getInteger(this.rhs[n2].trim());
                    string = this.getSensorType(n);
                    hashtable5.put(this.lhs[n2], string);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Type ===> " + hashtable5.size());
                }
                if (!this.runSnmpCmdForOid(sensorStatusOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable3.put(this.lhs[n2], this.rhs[n2]);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Type ===> " + hashtable3.size());
                }
                if (!this.runSnmpCmdForOid(sensorMessageOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    hashtable4.put(this.lhs[n2], this.rhs[n2]);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Type ===> " + hashtable4.size());
                }
                if (!this.runSnmpCmdForOid(sensorCharOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n2 = 0; n2 < this.lhs.length; ++n2) {
                    n = this.getInteger(this.rhs[n2].trim());
                    string = this.getCharacteristic(n);
                    hashtable6.put(this.lhs[n2], string);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Characteristic ===> " + hashtable6.size());
                }
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    string = (String)hashtable2.get(string2);
                    String string3 = (String)hashtable3.get(string2);
                    String string4 = (String)hashtable5.get(string2);
                    String string5 = (String)hashtable4.get(string2);
                    String string6 = (String)hashtable6.get(string2);
                    if (string == null || string.trim().length() == 0 || string3 == null || string4 == null || string5 == null || string6 == null) continue;
                    String string7 = this.replace(string, "#", "_");
                    string7 = this.replace(string7, " ", "");
                    int n3 = this.getInteger(string3);
                    String string8 = this.getStatusMsg(n3);
                    if (n3 == 1) {
                        n3 = 2;
                    } else if (n3 == 2) {
                        n3 = 3;
                    } else if (n3 == 3) {
                        n3 = 100;
                    } else if (n3 == 4) {
                        n3 = 1;
                    } else if (n3 == 5) {
                        n3 = 0;
                    }
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(n3));
                    this.addNewMeasure(string7, arrayList);
                    this.ddSenMsg.put(string7, string5);
                    this.ddType.put(string7, string4);
                    this.ddChar.put(string7, string6);
                    this.ddStatus.put(string7, string8);
                    this.ddStateId.put(string7, string3);
                    if (!this.debug) continue;
                    System.out.println("[FcSwSensorTest] ===> " + string7 + " ===> " + arrayList);
                    System.out.println("[FcSwSensorTest] DD Results ===> " + string7 + " ===> " + string5);
                    System.out.println("[FcSwSensorTest] DD Results ===> " + string7 + " ===> " + string4);
                    System.out.println("[FcSwSensorTest] DD Results ===> " + string7 + " ===> " + string6);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("[FcSwSensorTest].computeMeasures()", "Exception ", exception.toString());
            }
        } else {
            if (this.debug) {
                System.out.println("[FcSwSensorTest]Else block Inside 5.2 Agent code segment");
            }
            Hashtable<String, String> hashtable7 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable8 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable9 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable10 = new Hashtable<String, String>();
            Hashtable<String, String> hashtable11 = new Hashtable<String, String>();
            this.freeTest();
            try {
                String string;
                int n;
                int n4;
                if (!this.runSnmpCmdForOid(sensorNameOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n4 = 0; n4 < this.lhs.length; ++n4) {
                    hashtable7.put(this.lhs[n4], this.rhs[n4]);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Name ===> " + hashtable7.size());
                }
                if (!this.runSnmpCmdForOid(sensorTypeOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n4 = 0; n4 < this.lhs.length; ++n4) {
                    n = this.getInteger(this.rhs[n4].trim());
                    string = this.getSensorType(n);
                    hashtable10.put(this.lhs[n4], string);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Type ===> " + hashtable10.size());
                }
                if (!this.runSnmpCmdForOid(sensorStatusOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n4 = 0; n4 < this.lhs.length; ++n4) {
                    hashtable8.put(this.lhs[n4], this.rhs[n4]);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Type ===> " + hashtable8.size());
                }
                if (!this.runSnmpCmdForOid(sensorMessageOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n4 = 0; n4 < this.lhs.length; ++n4) {
                    hashtable9.put(this.lhs[n4], this.rhs[n4]);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Type ===> " + hashtable9.size());
                }
                if (!this.runSnmpCmdForOid(sensorCharOid)) {
                    return;
                }
                if (this.lhs == null || this.lhs.length == 0) {
                    return;
                }
                for (n4 = 0; n4 < this.lhs.length; ++n4) {
                    n = this.getInteger(this.rhs[n4].trim());
                    string = this.getCharacteristic(n);
                    hashtable11.put(this.lhs[n4], string);
                }
                if (this.debug) {
                    System.out.println("[FcSwSensorTest] Sensor Characteristic ===> " + hashtable11.size());
                }
                Enumeration enumeration = hashtable7.keys();
                while (enumeration.hasMoreElements()) {
                    String string9 = (String)enumeration.nextElement();
                    string = (String)hashtable7.get(string9);
                    String string10 = (String)hashtable8.get(string9);
                    String string11 = (String)hashtable10.get(string9);
                    String string12 = (String)hashtable9.get(string9);
                    String string13 = (String)hashtable11.get(string9);
                    if (string == null || string.trim().length() == 0 || string10 == null || string11 == null || string12 == null || string13 == null) continue;
                    String string14 = this.replace(string, "#", "_");
                    string14 = this.replace(string14, " ", "");
                    int n5 = this.getInteger(string10);
                    String string15 = this.getStatusMsg(n5);
                    n5 = n5 == 3 ? 1 : (n5 == 4 || n5 == 5 ? 0 : 2);
                    ArrayList<Double> arrayList = new ArrayList<Double>();
                    arrayList.add(new Double(n5));
                    this.addNewMeasure(string14, arrayList);
                    this.ddSenMsg.put(string14, string12);
                    this.ddType.put(string14, string11);
                    this.ddChar.put(string14, string13);
                    this.ddStatus.put(string14, string15);
                    this.ddStateId.put(string14, string10);
                    if (!this.debug) continue;
                    System.out.println("[FcSwSensorTest] ===> " + string14 + " ===> " + arrayList);
                    System.out.println("[FcSwSensorTest] DD Results ===> " + string14 + " ===> " + string12);
                    System.out.println("[FcSwSensorTest] DD Results ===> " + string14 + " ===> " + string11);
                    System.out.println("[FcSwSensorTest] DD Results ===> " + string14 + " ===> " + string13);
                }
            }
            catch (Exception exception) {
                this.logToErrorFile("[FcSwSensorTest].computeMeasures()", "Exception ", exception.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        FcSwSensorTest fcSwSensorTest = new FcSwSensorTest(stringArray);
        fcSwSensorTest.computeMeasures(new Hashtable());
    }
}

