/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgDateInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Hashtable;

public class FSandBxUptimeTest
extends EgSnmpGenericTest {
    private static String oid = ".1.3.6.1.4.1.12356.118.3.1.8";
    private double currSysuptime = 0.0;
    private double prevSysuptime = 0.0;
    private DataOutputStream dos = null;
    private DataInputStream dis = null;
    private File f = null;
    private String installdir = EgInstallInfo.getInstallDir() + "/agent/logs/sandboxuptime_" + this.reportingName + ".log";
    private static EgDateInfo dateInfo = new EgDateInfo();

    public FSandBxUptimeTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(3);
        this.f = new File(this.installdir);
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        boolean bl = false;
        String string = null;
        double d = 0.0;
        long l = this.f.lastModified();
        try {
            bl = this.runSnmpCmdForOid(oid);
            if (!bl) {
                return;
            }
            if (bl) {
                string = this.rhs[0].trim();
                d = string != null && string.trim().length() > 0 ? Double.parseDouble(string) / 100.0 : 0.0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logToErrorFile("Exception :", "Exception occured in computeMeasures for ", this.targetHost);
        }
        if (d <= 0.0) {
            this.currSysuptime = 0.0;
            this.measures.add(new Double(-5.0));
            this.measures.add(new Double(-5.0));
            this.measures.add(new Double(-5.0));
            this.addNewMeasure(this.measures);
            return;
        }
        if (this.currSysuptime == 0.0 && !this.f.exists()) {
            this.currSysuptime = d;
            this.measures.add(new Double(0.0));
            this.measures.add(new Double(-5.0));
            double d2 = this.currSysuptime / 60.0;
            this.measures.add(new Double(d2));
            this.addNewMeasure(this.measures);
            this.writeDoubleToFile(this.currSysuptime);
            return;
        }
        if (!this.f.exists()) {
            this.currSysuptime = d;
            this.measures.add(new Double(0.0));
            this.measures.add(new Double(-5.0));
            double d3 = this.currSysuptime / 60.0;
            this.measures.add(new Double(d3));
            this.addNewMeasure(this.measures);
            this.writeDoubleToFile(this.currSysuptime);
            return;
        }
        this.currSysuptime = d;
        this.prevSysuptime = this.readDoubleFromFile();
        if (this.currSysuptime < this.prevSysuptime) {
            this.measures.add(new Double(1.0));
            this.measures.add(new Double(this.currSysuptime));
            double d4 = this.currSysuptime / 60.0;
            this.measures.add(new Double(d4));
        } else {
            this.measures.add(new Double(0.0));
            this.measures.add(new Double(this.currSysuptime - this.prevSysuptime));
            double d5 = this.currSysuptime / 60.0;
            this.measures.add(new Double(d5));
        }
        this.prevSysuptime = this.currSysuptime;
        this.writeDoubleToFile(this.currSysuptime);
        this.addNewMeasure(this.measures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDoubleToFile(double d) {
        try {
            this.dos = new DataOutputStream(new FileOutputStream(this.f));
            this.dos.writeDouble(d);
            this.dos.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dos.close();
            }
            catch (Exception exception) {}
            this.dos = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readDoubleFromFile() {
        double d = 0.0;
        try {
            if (!this.f.exists()) {
                double d2 = -5.0;
                return d2;
            }
            this.dis = new DataInputStream(new FileInputStream(this.f));
            d = this.dis.readDouble();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                this.dis.close();
            }
            catch (Exception exception) {}
            this.dis = null;
        }
        return d;
    }

    public static void main(String[] stringArray) {
        FSandBxUptimeTest fSandBxUptimeTest = new FSandBxUptimeTest(stringArray);
        fSandBxUptimeTest.computeMeasures(new Hashtable());
    }
}

