/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EgXmlConfig {
    static char[] charsToEncode = new char[]{':', '=', '%', '>', ',', '[', ']', '/', '#'};
    private static BitSet needToEncode = new BitSet(256);
    private Hashtable availableTagsAndAttributes = new Hashtable();
    private Hashtable data = new Hashtable();
    private String strFilePath = "";
    private List requiredList = new ArrayList(1);
    Properties tagNamesAndInfo = null;

    public static String encodeString(String string) {
        int n = 10;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (!needToEncode.get(c)) {
                stringBuffer.append(c);
                continue;
            }
            try {
                outputStreamWriter.write(c);
                outputStreamWriter.flush();
            }
            catch (IOException iOException) {
                byteArrayOutputStream.reset();
                continue;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            for (int j = 0; j < byArray.length; ++j) {
                stringBuffer.append('%');
                stringBuffer.append(Integer.toHexString(byArray[j]));
            }
            byteArrayOutputStream.reset();
        }
        return stringBuffer.toString();
    }

    public static String decodeString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(i + 1, i + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    i += 2;
                    continue block5;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public EgXmlConfig(String string) {
        this.strFilePath = string;
    }

    public String getFilePath() {
        return this.strFilePath;
    }

    public void setFilePath(String string) {
        this.strFilePath = string;
    }

    public void setInfoAttributeForTag(String string, String string2) {
    }

    public void setTagInfo(String string, String string2) {
        Hashtable hashtable;
        if (this.tagNamesAndInfo == null) {
            this.tagNamesAndInfo = new Properties();
        }
        if ((hashtable = this.makeTagInfo(string2)) == null || hashtable.size() == 0) {
            return;
        }
        this.tagNamesAndInfo.put(string, hashtable);
    }

    private Hashtable makeTagInfo(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String string2 = "";
        String string3 = "";
        String string4 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= 0) continue;
            string3 = string2.substring(0, n);
            string4 = string2.substring(n + 1);
            if (string3.equals("info-finder") && !string4.startsWith(">")) {
                string4 = ">{attribute-node}" + string4;
            }
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    private Document getDocument() throws Exception {
        if (this.strFilePath == null || this.strFilePath.length() == 0) {
            throw new Exception("XML Path is not valid..............");
        }
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(this.strFilePath);
        }
        catch (SAXException sAXException) {
            System.err.println("'" + this.strFilePath + "' is NOT wellformed.\n" + sAXException.toString());
            return null;
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            return null;
        }
        return document;
    }

    private void getAvailableAttributes(Node node) {
        int n;
        NodeList nodeList = null;
        String string = node.getNodeName();
        ArrayList<String> arrayList = (ArrayList<String>)this.availableTagsAndAttributes.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.availableTagsAndAttributes.put(string, arrayList);
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n2 = namedNodeMap.getLength();
        String string2 = "";
        Node node2 = null;
        for (n = 0; n < n2; ++n) {
            node2 = namedNodeMap.item(n);
            string2 = node2.getNodeName();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        if (node.hasChildNodes()) {
            nodeList = node.getChildNodes();
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                if (nodeList.item(i).getNodeType() == 8 || nodeList.item(i).getNodeType() == 3) continue;
                this.getAvailableAttributes(nodeList.item(i));
            }
        }
    }

    public void displayAvailableTagsAndAttributes() {
        Document document = null;
        try {
            document = this.getDocument();
        }
        catch (Exception exception) {
            return;
        }
        if (document == null) {
            return;
        }
        Element element = document.getDocumentElement();
        if (element != null) {
            this.getAvailableAttributes(element);
            Enumeration enumeration = this.availableTagsAndAttributes.keys();
            String string = "";
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
            }
            this.availableTagsAndAttributes = null;
        }
    }

    public void setRequired(String[] stringArray) {
        this.requiredList = Arrays.asList(stringArray);
    }

    public static String getOnlyTagPath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ">");
        String string2 = "";
        String string3 = "";
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf("[");
            if (n2 > 0) {
                string3 = string3.substring(0, n2);
            }
            string2 = i == n - 1 ? string2 + string3 : string2 + string3 + ">";
        }
        return string2;
    }

    private Hashtable getAttributesFrom(Node node) {
        if (node == null) {
            return null;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        NamedNodeMap namedNodeMap = node.getAttributes();
        int n = namedNodeMap.getLength();
        String string = "";
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            Node node2 = namedNodeMap.item(i);
            string2 = node2.getNodeValue();
            string = node2.getNodeName();
            hashtable.put(string, string2);
        }
        return hashtable;
    }

    private boolean canProceed(Node node, String string) {
        boolean bl;
        block15: {
            Object object;
            if (node == null) {
                return false;
            }
            String string2 = node.getNodeName();
            String string3 = EgXmlConfig.getOnlyTagPath(string);
            bl = true;
            if (this.requiredList.size() == 0) {
                bl = true;
            } else {
                bl = false;
                int n = this.requiredList.size();
                object = "";
                for (int i = 0; i < n; ++i) {
                    object = (String)this.requiredList.get(i);
                    if (!((String)object).startsWith(string3)) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                return bl;
            }
            if (this.tagNamesAndInfo == null) {
                return bl;
            }
            Hashtable hashtable = (Hashtable)this.tagNamesAndInfo.get(string2);
            if (hashtable == null) {
                return bl;
            }
            object = this.getAttributesFrom(node);
            String string4 = (String)hashtable.get("criteria");
            if (string4 == null) break block15;
            string4 = string4.substring(1, string4.length() - 1);
            String string5 = "";
            String string6 = "";
            String string7 = "";
            StringTokenizer stringTokenizer = null;
            if (string4.indexOf("&") > 0) {
                stringTokenizer = new StringTokenizer(string4, "&");
                bl = true;
                while (stringTokenizer.hasMoreTokens()) {
                    String string8;
                    string7 = stringTokenizer.nextToken();
                    int n = string7.indexOf("=");
                    if (n > 0) {
                        string5 = string7.substring(0, n);
                        string6 = string7.substring(n + 1);
                    }
                    if ((string8 = (String)((Hashtable)object).get(string5)) == null) {
                        bl = false;
                    } else {
                        if (string6.trim().equalsIgnoreCase(string8.trim())) continue;
                        bl = false;
                    }
                    break;
                }
            } else {
                stringTokenizer = new StringTokenizer(string4, "|");
                bl = false;
                while (stringTokenizer.hasMoreTokens()) {
                    String string9;
                    string7 = stringTokenizer.nextToken();
                    int n = string7.indexOf("=");
                    if (n > 0) {
                        string5 = string7.substring(0, n);
                        string6 = string7.substring(n + 1);
                    }
                    if ((string9 = (String)((Hashtable)object).get(string5)) == null || !string6.trim().equalsIgnoreCase(string9.trim())) continue;
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private void getConfig(Node node, String string) {
        int n;
        Object object;
        String string2 = "";
        String string3 = null;
        String string4 = null;
        String string5 = "";
        Node node2 = null;
        boolean bl = this.canProceed(node, string);
        if (bl) {
            object = this.findInfoString(node);
            string = string + (String)object;
            if (node.hasAttributes()) {
                String string6;
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n2 = namedNodeMap.getLength();
                String string7 = "";
                for (n = 0; n < n2; ++n) {
                    node2 = namedNodeMap.item(n);
                    string3 = node2.getNodeValue();
                    string4 = node2.getNodeName();
                    string7 = EgXmlConfig.encodeString(string4) + "=" + EgXmlConfig.encodeString(string3);
                    string2 = string2 == null || string2.length() == 0 ? string7 : string2 + "," + string7;
                }
                String string8 = this.getTextNodeValuesForTag(node);
                if (!string8.equalsIgnoreCase("")) {
                    string2 = string2.equalsIgnoreCase("") ? string8 : string2 + "," + string8;
                }
                if (!(string6 = this.getAttributeNodeValuesForTag(node)).equalsIgnoreCase("")) {
                    string2 = string2.equalsIgnoreCase("") ? string6 : string2 + "," + string6;
                }
                if (string4 != null && string3 != null) {
                    ArrayList<String> arrayList = (ArrayList<String>)this.data.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>(1);
                    }
                    arrayList.add(string2);
                    this.data.put(string, arrayList);
                }
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = nodeList.item(n);
                if (object.getNodeType() == 8 || object.getNodeType() == 3) continue;
                this.getConfig((Node)object, string + ">" + object.getNodeName());
            }
        }
    }

    private String findInfoString(Node node) {
        if (node == null) {
            return "";
        }
        String string = node.getNodeName();
        if (this.tagNamesAndInfo == null) {
            return "";
        }
        Hashtable hashtable = (Hashtable)this.tagNamesAndInfo.get(string);
        if (hashtable == null) {
            return "";
        }
        String string2 = (String)hashtable.get("info-finder");
        if (string2 == null) {
            string2 = "{attribute-node}Name";
        }
        int n = -1;
        String string3 = "";
        n = string2.indexOf(">{attribute-node}");
        if (n >= 0) {
            if (!node.hasAttributes()) {
                return "";
            }
            String string4 = string2.substring(">{attribute-node}".length());
            Node node2 = node.getAttributes().getNamedItem(string4);
            if (node2 == null) {
                return "";
            }
            String string5 = node2.getNodeValue();
            return "[" + string4 + "=" + EgXmlConfig.encodeString(string5) + "]";
        }
        n = string2.indexOf(">{text-node}");
        if (n >= 0) {
            String string6 = string2.substring(">{text-node}".length());
            NodeList nodeList = ((Element)node).getElementsByTagName(string6);
            if (nodeList == null || nodeList.getLength() == 0) {
                return "";
            }
            Node node3 = nodeList.item(0).getFirstChild();
            if (node3 == null) {
                return "";
            }
            if (node3.getNodeType() != 3) {
                return "";
            }
            String string7 = node3.getNodeValue().trim();
            return "[" + string6 + "=" + EgXmlConfig.encodeString(string7) + "]";
        }
        return "";
    }

    private NodeList getNodeListFromTagPath(Node node, String string) {
        String string2 = "";
        int n = string.indexOf(">");
        NodeList nodeList = null;
        if (n > 0) {
            string2 = string.substring(0, n);
            nodeList = ((Element)node).getElementsByTagName(string2);
            if (nodeList == null || nodeList.getLength() == 0) {
                return null;
            }
            Node node2 = nodeList.item(0);
            if (node2 == null) {
                return null;
            }
            string2 = string.substring(n + 1);
            nodeList = ((Element)node2).getElementsByTagName(string2);
        } else {
            nodeList = ((Element)node).getElementsByTagName(string);
        }
        return nodeList;
    }

    private String getInnerTextNodeValue(Node node, String string) {
        if (node == null) {
            return null;
        }
        int n = (string = string.trim()).indexOf("[");
        if (n <= 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        string3 = string3.substring(1, string3.length() - 1);
        NodeList nodeList = this.getNodeListFromTagPath(node, string2);
        n = string2.indexOf(">");
        Object var7_7 = null;
        String string4 = "";
        string4 = n > 0 ? string2.substring(n + 1) : string2;
        if (nodeList == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "=");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        int n2 = nodeList.getLength();
        int n3 = arrayList.size();
        String string5 = "";
        String string6 = "";
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            string6 = "";
            for (int j = 0; j < n3; ++j) {
                String string7 = (String)arrayList.get(j);
                String string8 = this.getTextNodeValue(node2, string7).trim();
                if (string8.length() == 0) {
                    string8 = "-";
                }
                string8 = EgXmlConfig.decodeString(string8);
                string6 = j == n3 - 1 ? string6 + string8 : string6 + string8 + ":";
            }
            string5 = i == n2 - 1 ? string5 + string6 : string5 + string6 + ", ";
        }
        return EgXmlConfig.encodeString(string5);
    }

    private String getTextNodeValue(Node node, String string) {
        NodeList nodeList;
        if (node == null) {
            return "";
        }
        boolean bl = false;
        if ((string = string.trim()).startsWith("(") && string.endsWith(")")) {
            bl = true;
            if (string.startsWith("(") && string.endsWith(")")) {
                string = string.substring(1, string.length() - 1);
            }
        }
        if ((nodeList = ((Element)node).getElementsByTagName(string)) == null || nodeList.getLength() == 0) {
            return "";
        }
        String string2 = "";
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i).getFirstChild();
            if (node2 == null || node2.getNodeType() != 3) continue;
            String string3 = node2.getNodeValue().trim();
            if (!bl) {
                string2 = string3;
                break;
            }
            string2 = i == n - 1 ? string2 + string3 : string2 + string3 + "#";
        }
        return EgXmlConfig.encodeString(string2);
    }

    private String getAttributeNodeValuesForTag(Node node) {
        if (node == null) {
            return "";
        }
        String string = node.getNodeName();
        if (this.tagNamesAndInfo == null) {
            return "";
        }
        Hashtable hashtable = (Hashtable)this.tagNamesAndInfo.get(string);
        if (hashtable == null) {
            return "";
        }
        String string2 = (String)hashtable.get("attribute-node-config-tags");
        if (string2 == null || string2.trim().length() == 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            int n2;
            String string4 = stringTokenizer.nextToken();
            string4 = string4.trim();
            String string5 = "";
            int n3 = string4.indexOf("[");
            if (n3 <= 0 || (n2 = string4.indexOf("]")) <= 0) continue;
            String string6 = string4.substring(0, n3);
            String string7 = string4.substring(n3 + 1, n2);
            NodeList nodeList = ((Element)node).getElementsByTagName(string6);
            if (nodeList == null || nodeList.getLength() == 0 || (n = nodeList.getLength()) <= 0) continue;
            Node node2 = nodeList.item(0);
            String string8 = "";
            if (node2 != null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string7, ":");
                Hashtable hashtable2 = this.getAttributesFrom(node2);
                while (stringTokenizer2.hasMoreTokens()) {
                    string8 = stringTokenizer2.nextToken();
                    string5 = (String)hashtable2.get(string8);
                }
            }
            if (string5 == null || string5.trim().length() == 0) {
                string5 = "-";
            }
            if (string5.equalsIgnoreCase("")) continue;
            if (!stringTokenizer.hasMoreTokens()) {
                string3 = string3 + string8 + "=" + string5;
                continue;
            }
            string3 = string3 + string8 + "=" + string5 + ",";
        }
        return string3;
    }

    private String getTextNodeValuesForTag(Node node) {
        if (node == null) {
            return "";
        }
        String string = node.getNodeName();
        if (this.tagNamesAndInfo == null) {
            return "";
        }
        Hashtable hashtable = (Hashtable)this.tagNamesAndInfo.get(string);
        if (hashtable == null) {
            return "";
        }
        String string2 = (String)hashtable.get("text-node-config-tags");
        if (string2 == null || string2.trim().length() == 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            string4 = string4.trim();
            String string5 = "";
            if (string4.endsWith("]")) {
                string5 = this.getInnerTextNodeValue(node, string4);
            } else {
                string5 = this.getTextNodeValue(node, string4);
                if (string5.trim().length() == 0) {
                    string5 = "-";
                }
                if (string4.startsWith("(") && string4.endsWith(")")) {
                    string4 = string4.substring(1, string4.length() - 1);
                }
            }
            if (!stringTokenizer.hasMoreTokens()) {
                string3 = string3 + string4 + "=" + string5;
                continue;
            }
            string3 = string3 + string4 + "=" + string5 + ",";
        }
        return string3;
    }

    public Hashtable getData(Hashtable hashtable) throws Exception {
        this.data = hashtable;
        return this.getData();
    }

    public Hashtable getData() throws Exception {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        this.getConfig(element, element.getNodeName());
        return this.data;
    }

    public void displayXMLFileMeasures() {
        Object object;
        Object object2;
        try {
            object2 = this.getDocument();
            if (object2 == null) {
                return;
            }
            object = object2.getDocumentElement();
            if (object == null) {
                return;
            }
            this.getConfig((Node)object, EgXmlConfig.encodeString(object.getNodeName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.data != null) {
            object2 = this.data.keys();
            object = "";
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                ArrayList arrayList = (ArrayList)this.data.get(object);
                if (arrayList != null) {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        System.out.println("\t\t" + arrayList.get(i));
                    }
                    continue;
                }
                System.out.println("\t\t" + arrayList);
            }
        }
    }

    public void displayXMLFileConfig(Hashtable hashtable) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            String string = "";
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                ArrayList arrayList = (ArrayList)hashtable.get(string);
                if (arrayList != null) {
                    int n = arrayList.size();
                    for (int i = 0; i < n; ++i) {
                        System.out.println("\t\t" + arrayList.get(i));
                    }
                    continue;
                }
                System.out.println("\t\t" + arrayList);
            }
        }
    }

    public static Hashtable getConfigList(Hashtable hashtable, String string, String[] stringArray) {
        if (hashtable == null) {
            return null;
        }
        List<String> list = Arrays.asList(stringArray);
        Enumeration enumeration = hashtable.keys();
        String string2 = "";
        Hashtable hashtable2 = new Hashtable();
        while (enumeration.hasMoreElements()) {
            String string3;
            int n;
            string2 = (String)enumeration.nextElement();
            ArrayList arrayList = (ArrayList)hashtable.get(string2);
            String string4 = "";
            if (arrayList != null) {
                string4 = (String)arrayList.get(0);
            } else {
                System.out.println("-");
            }
            String string5 = EgXmlConfig.getOnlyTagPath(string2);
            if (!string.equals(string5)) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ">");
            String string6 = "";
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = "";
            int n2 = stringTokenizer.countTokens();
            for (int i = 0; i < n2; ++i) {
                string6 = stringTokenizer.nextToken();
                n = string6.indexOf("[");
                if (n > 0) {
                    String string12 = string6.substring(0, n);
                    string3 = string6.substring(n);
                    string3 = string3.substring(1, string3.length() - 1);
                    n = string3.indexOf("=");
                    string8 = "";
                    string9 = "";
                    if (n > 0) {
                        string8 = string3.substring(0, n);
                        string9 = string3.substring(n + 1);
                    }
                    string11 = string9;
                } else {
                    string11 = string6;
                }
                string10 = i == n2 - 1 ? string10 + string11 : string10 + string11 + ">";
            }
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (n = 0; n < list.size(); ++n) {
                arrayList2.add("-");
            }
            string6 = string4;
            stringTokenizer = new StringTokenizer(string6, ",");
            String string13 = "";
            int n3 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                string13 = stringTokenizer.nextToken();
                n3 = string13.lastIndexOf("=");
                if (n3 < 0) continue;
                string3 = string13.substring(0, n3);
                String string14 = string13.substring(n3 + 1);
                if ("".equals(string14)) {
                    string14 = "-";
                }
                if (!list.contains(string3)) continue;
                n3 = list.indexOf(string3);
                arrayList2.set(n3, EgXmlConfig.decodeString(string14));
            }
            hashtable2.put(EgXmlConfig.decodeString(string10), arrayList2);
        }
        return hashtable2;
    }

    public static Hashtable getConfigListAll(Hashtable hashtable, String string, String[] stringArray) {
        if (hashtable == null) {
            return null;
        }
        List<String> list = Arrays.asList(stringArray);
        Enumeration enumeration = hashtable.keys();
        String string2 = "";
        Hashtable hashtable2 = new Hashtable();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if ("Domain".equals(string2)) continue;
            ArrayList arrayList = (ArrayList)hashtable.get(string2);
            String string3 = "";
            for (int i = 0; i < arrayList.size(); ++i) {
                string3 = (String)arrayList.get(i);
                String string4 = EgXmlConfig.getOnlyTagPath(string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ">");
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                String string9 = "";
                String string10 = "";
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int j = 0; j < list.size(); ++j) {
                    arrayList2.add("-");
                }
                string5 = string3;
                stringTokenizer = new StringTokenizer(string5, ",");
                String string11 = "";
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    string11 = stringTokenizer.nextToken();
                    n = string11.lastIndexOf("=");
                    if (n < 0) continue;
                    String string12 = string11.substring(0, n);
                    String string13 = string11.substring(n + 1);
                    if ("".equals(string13)) {
                        string13 = "-";
                    }
                    if (!list.contains(string12)) continue;
                    if ("Name".equalsIgnoreCase(string12)) {
                        string9 = string13;
                    }
                    n = list.indexOf(string12);
                    arrayList2.set(n, EgXmlConfig.decodeString(string13));
                }
                hashtable2.put(string9, arrayList2);
            }
        }
        return hashtable2;
    }

    private void getConfigAll(Node node, String string, String string2) {
        int n;
        Object object;
        String string3 = "";
        String string4 = null;
        String string5 = null;
        String string6 = "";
        Node node2 = null;
        String[] stringArray = new String[]{"Server", "Application", "Cluster", "WebServer", "SSL", "MailSession", "JMSConnectionFactory", "ServerStart", "Domain", "JDBCConnectionPool", "JDBCTxDataSource", "JDBCTxDataSource", "JDBCDataSource", "SNMPAgent", "COM", "JTA", "WebAppComponent"};
        String string7 = this.findInfoStringAll(node);
        string = string + string7;
        if (node.hasAttributes()) {
            String string8;
            object = node.getAttributes();
            int n2 = object.getLength();
            String string9 = "";
            for (n = 0; n < n2; ++n) {
                node2 = object.item(n);
                string4 = node2.getNodeValue();
                string5 = node2.getNodeName();
                string9 = EgXmlConfig.encodeString(string5) + "=" + EgXmlConfig.encodeString(string4);
                string3 = string3 == null || string3.length() == 0 ? string9 : string3 + "," + string9;
            }
            String string10 = this.getTextNodeValuesForTag(node);
            if (!string10.equalsIgnoreCase("")) {
                string3 = string3.equalsIgnoreCase("") ? string10 : string3 + "," + string10;
            }
            if (!(string8 = this.getAttributeNodeValuesForTag(node)).equalsIgnoreCase("")) {
                string3 = string3.equalsIgnoreCase("") ? string8 : string3 + "," + string8;
            }
            if (string5 != null && string4 != null) {
                ArrayList<String> arrayList = (ArrayList<String>)this.data.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(1);
                }
                arrayList.add(string3);
                this.data.put(string, arrayList);
            }
        }
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (n = 0; n < nodeList.getLength(); ++n) {
                object = nodeList.item(n);
                String string11 = object.getNodeName();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equalsIgnoreCase(string11) || !string2.equals(string11)) continue;
                    this.getConfigAll((Node)object, string + ">" + string11, string2);
                }
            }
        }
    }

    private String findInfoStringAll(Node node) {
        if (node == null) {
            return "";
        }
        String string = node.getNodeName();
        if (this.tagNamesAndInfo == null) {
            return "";
        }
        Hashtable hashtable = (Hashtable)this.tagNamesAndInfo.get(string);
        if (hashtable == null) {
            return "";
        }
        String string2 = (String)hashtable.get("info-finder");
        if (string2 == null) {
            string2 = "{attribute-node}Name";
        }
        int n = 1;
        String string3 = "";
        n = string2.indexOf(">{attribute-node}");
        if (n >= 0) {
            if (!node.hasAttributes()) {
                return "";
            }
            String string4 = string2.substring(">{attribute-node}".length());
            Node node2 = node.getAttributes().getNamedItem(string4);
            if (node2 == null) {
                return "";
            }
            String string5 = node2.getNodeValue();
            return "[" + string4 + "=" + EgXmlConfig.encodeString(string5) + "]";
        }
        n = string2.indexOf(">{text-node}");
        if (n >= 0) {
            String string6 = string2.substring(">{text-node}".length());
            NodeList nodeList = ((Element)node).getElementsByTagName(string6);
            if (nodeList == null || nodeList.getLength() == 0) {
                return "";
            }
            Node node3 = nodeList.item(0).getFirstChild();
            if (node3 == null) {
                return "";
            }
            if (node3.getNodeType() != 3) {
                return "";
            }
            String string7 = node3.getNodeValue().trim();
            return "[" + string6 + "=" + EgXmlConfig.encodeString(string7) + "]";
        }
        return "";
    }

    public Hashtable getDataAll(String string) throws Exception {
        Document document = this.getDocument();
        if (document == null) {
            return null;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            return null;
        }
        this.getConfigAll(element, element.getNodeName(), string);
        return this.data;
    }

    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n < 2) {
            return;
        }
        if (stringArray[0].equals("-dm")) {
            EgXmlConfig egXmlConfig = new EgXmlConfig(stringArray[1]);
            egXmlConfig.displayXMLFileMeasures();
        } else if (stringArray[0].equals("-data")) {
            EgXmlConfig egXmlConfig = new EgXmlConfig(stringArray[1]);
            String[] stringArray2 = new String[]{"Domain>Server>ServerStart"};
            try {
                egXmlConfig.setRequired(stringArray2);
                Hashtable hashtable = egXmlConfig.getDataAll("ServerStart");
                egXmlConfig.displayXMLFileConfig(hashtable);
                String[] stringArray3 = new String[]{"Name", "DriverName", "Properties", "TestConnectionsOnReserve", "TestTableName", "URL", "InitialCapacity", "CapacityIncrement", "InactiveConnectionTimeoutSeconds", "RollbackLocalTxUponConnClose", "SqlStmtProfilingEnabled", "MaxCapacity", "Password", "RefreshMinutes", "ShrinkPeriodMinutes", "ShrinkingEnabled", "TestConnectionsOnRelease", "URL"};
                Hashtable hashtable2 = EgXmlConfig.getConfigListAll(hashtable, "Domain>Adfdfdfdpplication", stringArray3);
                Enumeration enumeration = hashtable2.keys();
                String string = "";
                while (enumeration.hasMoreElements()) {
                    string = (String)enumeration.nextElement();
                    System.out.println(string + "============>" + hashtable2.get(string));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray[0].equals("-dta")) {
            EgXmlConfig egXmlConfig = new EgXmlConfig(stringArray[1]);
            egXmlConfig.displayAvailableTagsAndAttributes();
        }
    }

    static {
        int n = charsToEncode.length;
        for (int i = 0; i < n; ++i) {
            needToEncode.set(charsToEncode[i]);
        }
    }
}

