/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import com.eg.EgTesterInfo;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public abstract class EgTomcatBase
extends EgJMXBase {
    protected boolean viaJmx;
    private String ssl;
    private boolean isSsl;
    private String encryptPass;
    private String tomcatUser;
    private String tomcatPassword;
    private String url;
    private HttpURLConnection u;
    private URL up;
    private String urlString;
    private ConnectionThread ct;
    protected int version;
    String domain = null;
    String nodeName = null;
    private static final HashMap configuredDomains;
    private static final Hashtable nodeNameDomainMapping;
    private static final HashMap entityMap;
    private Hashtable prevMeasure = new Hashtable();
    private static boolean ShowNewServletDescriptor;
    private int expctdTmctStrtTmInMS = 900000;

    public EgTomcatBase(String[] stringArray) {
        super(stringArray);
        this.nodeName = this.reportingName + ":" + this.portNo;
        String string = this.getValueForParam("measurement_mode");
        if (string != null && (string.equalsIgnoreCase("no") || string.equalsIgnoreCase("false"))) {
            this.viaJmx = true;
        }
        if (!this.viaJmx) {
            String string2;
            this.ssl = this.getValueForParam("ssl");
            this.tomcatUser = this.getValueForParam("username");
            this.tomcatPassword = this.getValueForParam("password");
            this.url = this.getValueForParam("url");
            this.encryptPass = this.getValueForParam("encryptPass");
            if (this.tomcatUser == null || this.tomcatUser.equalsIgnoreCase("none")) {
                this.tomcatUser = "";
            }
            if (this.tomcatPassword == null || this.tomcatPassword.equalsIgnoreCase("none")) {
                this.tomcatPassword = "";
            }
            if (this.ssl != null && (this.ssl.equalsIgnoreCase("true") || this.ssl.equalsIgnoreCase("yes"))) {
                this.isSsl = true;
            }
            if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
                this.tomcatPassword = EgCrypt.encrypt(this.tomcatPassword, true);
            }
            this.tomcatUser = URLEncoder.encode(this.tomcatUser);
            if (this.url != null && this.url.length() > 0 && !this.url.equalsIgnoreCase("none") && this.url.indexOf("://") > -1) {
                this.urlString = this.url;
                if (this.isContainerApp && this.strContainerId != null && this.strContainerId.length() > 0) {
                    string2 = this.strContainerId.toLowerCase();
                    if (this.urlString != null && this.urlString.toLowerCase().indexOf(string2) > 0) {
                        this.urlString = EgTomcatBase.findAndReplaceInfoString(this.urlString, this.strContainerId, this.targetHost);
                    }
                }
            } else {
                this.urlString = this.isSsl ? "https://" + this.targetHost : "http://" + this.targetHost;
                if (this.portNo != null && !this.portNo.equalsIgnoreCase("null")) {
                    this.urlString = this.urlString + ":" + this.portNo;
                }
            }
            if (this.isSsl) {
                this.enableSsl();
            }
            if (entityMap.containsKey(this.entity)) {
                string2 = (String)entityMap.get(this.entity);
                this.urlString = this.urlString + "/" + string2;
            }
        } else if (this.domain == null && nodeNameDomainMapping.containsKey(this.nodeName)) {
            this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findDomainName() {
        block6: {
            String[] stringArray = null;
            try {
                if (!this.connect()) break block6;
                stringArray = this.beanServerConnection.getDomains();
                boolean bl = false;
                if (stringArray == null || stringArray.length < 0) break block6;
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    if (!configuredDomains.containsKey(string)) continue;
                    bl = true;
                    this.domain = string;
                    nodeNameDomainMapping.put(this.nodeName, string);
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList getDataFromUrlConnection() {
        ArrayList arrayList = null;
        try {
            this.up = new URL(this.urlString);
            this.u = (HttpURLConnection)this.up.openConnection();
            if (this.tomcatUser.length() > 0) {
                String string = this.tomcatUser + ":" + EgCrypt.decrypt(this.tomcatPassword);
                String string2 = Base64Coder.encodeString(string);
                this.u.setRequestProperty("Authorization", "Basic " + string2);
            }
            this.u.connect();
            this.ct = new ConnectionThread(this.u, false);
            int n = 0;
            boolean bl = this.checkForTimeout(this.ct);
            if (bl) {
                n = this.ct.code;
                if (n != 200) {
                    System.err.println("Error in Tomcat server ..." + n);
                }
                arrayList = this.ct.data;
            }
        }
        catch (Exception exception) {
            arrayList = null;
            System.err.println("Exception in EgTomcatBase of getDataFromUrlConnection ..." + exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            this.ct = null;
            this.u.disconnect();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getResults(String string) {
        Hashtable<String, Hashtable<Object, Object>> hashtable;
        block35: {
            if (this.domain == null) {
                if (nodeNameDomainMapping.containsKey(this.nodeName)) {
                    this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
                } else {
                    this.findDomainName();
                }
            }
            if (this.domain == null) {
                System.out.println("[EgTomcatBase] - Unable to find the MBean domain for the Node :" + this.nodeName + "  & Entity :" + this.entity);
                return null;
            }
            hashtable = new Hashtable<String, Hashtable<Object, Object>>();
            try {
                if (this.connect()) {
                    ObjectName objectName = new ObjectName(this.domain + string);
                    Set<ObjectInstance> set = this.beanServerConnection.queryMBeans(objectName, null);
                    for (ObjectInstance objectInstance : set) {
                        Hashtable<String, String> hashtable2;
                        ObjectName objectName2 = objectInstance.getObjectName();
                        String string2 = objectName2.toString();
                        if (this.entity.equalsIgnoreCase("TomcatConnectorTest") || this.entity.equalsIgnoreCase("TomcatThreadTest")) {
                            string2 = string2.substring(string2.lastIndexOf("=") + 1);
                        } else if (this.entity.equalsIgnoreCase("TomcatAppTest")) {
                            if (string2.contains("path=")) {
                                string2 = objectName2.getKeyProperty("path");
                            } else if (string2.contains("context=")) {
                                string2 = objectName2.getKeyProperty("context");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatJspTest")) {
                            if (string2.contains("WebModule=")) {
                                string2 = objectName2.getKeyProperty("WebModule");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatServletTest")) {
                            if (string2.contains("name=") && string2.contains("WebModule=")) {
                                string2 = objectName2.getKeyProperty("name");
                                if (ShowNewServletDescriptor) {
                                    hashtable2 = objectName2.getKeyProperty("WebModule");
                                    string2 = (String)((Object)hashtable2) + "#" + string2;
                                }
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatCacheTest")) {
                            string2 = string2.contains("type=WebResourceRoot") ? string2.substring(string2.indexOf("/"), string2.lastIndexOf(",")) : string2.substring(string2.lastIndexOf("=") + 1);
                        } else if (this.entity.equalsIgnoreCase("TomcatDataSrcTest")) {
                            hashtable2 = objectName2.getKeyPropertyList();
                            if (hashtable2.containsKey("connectionpool")) continue;
                            if (string2.contains("name=")) {
                                string2 = objectName2.getKeyProperty("name");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatExecutorTest") && string2.contains("name=")) {
                            string2 = objectName2.getKeyProperty("name");
                        }
                        hashtable2 = new Hashtable();
                        MBeanInfo mBeanInfo = this.beanServerConnection.getMBeanInfo(objectName2);
                        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                        String string3 = "";
                        Object object = "";
                        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                            try {
                                string3 = mBeanAttributeInfoArray[i].getName();
                                object = this.beanServerConnection.getAttribute(objectName2, string3);
                                if (string3.equals("null")) continue;
                                if (object.equals("null")) {
                                }
                            }
                            catch (Exception exception) {}
                            continue;
                            hashtable2.put(string3, (String)object);
                        }
                        hashtable.put(string2, hashtable2);
                    }
                    break block35;
                }
                this.domain = null;
                nodeNameDomainMapping.remove(this.nodeName);
            }
            catch (Exception exception) {
                System.out.println("Exception in TomacatBase server connection ..." + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getResults(String string, String string2) {
        Hashtable hashtable;
        block12: {
            hashtable = new Hashtable();
            try {
                if (this.connect()) {
                    ObjectName objectName = new ObjectName(string + string2);
                    Set<ObjectInstance> set = this.beanServerConnection.queryMBeans(objectName, null);
                    for (ObjectInstance objectInstance : set) {
                        String string3;
                        ObjectName objectName2 = objectInstance.getObjectName();
                        String string4 = string3 = objectName2.toString();
                        Hashtable<String, String> hashtable2 = objectName2.getKeyPropertyList();
                        if (hashtable2.containsKey("connectionpool")) continue;
                        if (string3.contains("name=")) {
                            string3 = objectName2.getKeyProperty("name");
                        }
                        Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
                        MBeanInfo mBeanInfo = this.beanServerConnection.getMBeanInfo(objectName2);
                        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                        String string5 = "";
                        Object object = "";
                        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                            try {
                                string5 = mBeanAttributeInfoArray[i].getName();
                                object = this.beanServerConnection.getAttribute(objectName2, string5);
                                if (string5.equals("null")) continue;
                                if (object.equals("null")) {
                                }
                            }
                            catch (Exception exception) {}
                            continue;
                            hashtable3.put(string5, object);
                        }
                        hashtable3.put("modelerType", string4);
                        hashtable.put(string3, hashtable3);
                    }
                    break block12;
                }
                string = null;
                nodeNameDomainMapping.remove(this.nodeName);
            }
            catch (Exception exception) {
                System.out.println("Exception in TomacatBase server connection ..." + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
        return hashtable;
    }

    protected Hashtable getResultsForConfig(String string) {
        this.obtainDomain();
        Hashtable hashtable = this.getResultsForConfig(this.domain, string);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getResultsForConfig(String string, String string2) {
        Hashtable hashtable;
        block35: {
            if (string == null) {
                System.out.println("[EgTomcatBase] - Unable to find the MBean domain for the Node :" + this.nodeName + "  & Entity :" + this.entity);
                return null;
            }
            hashtable = new Hashtable();
            try {
                this.domain = string;
                if (this.connect()) {
                    ObjectName objectName = new ObjectName(string + string2);
                    Set<ObjectInstance> set = this.beanServerConnection.queryMBeans(objectName, null);
                    for (ObjectInstance objectInstance : set) {
                        ObjectName objectName2 = objectInstance.getObjectName();
                        String string3 = objectName2.toString();
                        if (this.entity.equalsIgnoreCase("TomcatContext_cf") || this.entity.equalsIgnoreCase("TomcatNameResources_cf") || this.entity.equalsIgnoreCase("TomcatValve_cf") || this.entity.equalsIgnoreCase("TomcatResources_cf")) {
                            if (string3.contains("name=")) {
                                string3 = objectName2.getKeyProperty("name");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatConnector_cf")) {
                            if (string3.contains("port=")) {
                                string3 = objectName2.getKeyProperty("port");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatEnvironment_cf")) {
                            if (string3.contains("name=") && string3.contains("resourcetype=")) {
                                string3 = objectName2.getKeyProperty("resourcetype") + (string3.contains("path=") ? " > " + objectName2.getKeyProperty("path") : "") + (string3.contains("host=") ? " > " + objectName2.getKeyProperty("host") : "") + " > " + objectName2.getKeyProperty("name");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatHost_cf")) {
                            if (string3.contains("host=")) {
                                string3 = objectName2.getKeyProperty("host");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatRoles_cf")) {
                            if (string3.contains("rolename=")) {
                                string3 = objectName2.getKeyProperty("rolename");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatService_cf")) {
                            if (string3.contains("serviceName=")) {
                                string3 = objectName2.getKeyProperty("serviceName");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatGroups_cf")) {
                            if (string3.contains("groupname=")) {
                                string3 = objectName2.getKeyProperty("groupname");
                            }
                        } else if (this.entity.equalsIgnoreCase("TomcatUsers_cf") && string3.contains("username=")) {
                            string3 = objectName2.getKeyProperty("username");
                        }
                        Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                        MBeanInfo mBeanInfo = this.beanServerConnection.getMBeanInfo(objectName2);
                        MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
                        String string4 = "";
                        Object object = "";
                        for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                            try {
                                string4 = mBeanAttributeInfoArray[i].getName();
                                object = this.beanServerConnection.getAttribute(objectName2, string4);
                                if (string4 == null || object == null || string4.equals("null")) continue;
                                if (object.equals("null")) {
                                }
                            }
                            catch (Exception exception) {}
                            continue;
                            hashtable2.put(string4, object);
                        }
                        if (!this.isMBeanSrvrUpForLastXtime(this.expctdTmctStrtTmInMS)) {
                            throw new Exception("Latest up time of the Tomcat is less than " + this.expctdTmctStrtTmInMS + " milliseconds. So, skipping this test run to provide stability period after Tomcat start up.");
                        }
                        hashtable.put(string3, hashtable2);
                    }
                    break block35;
                }
                this.domain = null;
                nodeNameDomainMapping.remove(this.nodeName);
            }
            catch (Exception exception) {
                this.domain = null;
                nodeNameDomainMapping.remove(this.nodeName);
                System.out.println("Exception in TomacatBase server connection ..." + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
        return hashtable;
    }

    private void obtainDomain() {
        if (this.domain == null) {
            if (nodeNameDomainMapping.containsKey(this.nodeName)) {
                this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
            } else {
                this.findDomainName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getJvmTestDetails() {
        Hashtable<String, Double> hashtable;
        block25: {
            hashtable = new Hashtable<String, Double>();
            try {
                if (!this.connect()) break block25;
                ClassLoadingMXBean classLoadingMXBean = null;
                try {
                    classLoadingMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=ClassLoading", ClassLoadingMXBean.class);
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    exception.printStackTrace();
                }
                ThreadMXBean threadMXBean = null;
                try {
                    threadMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=Threading", ThreadMXBean.class);
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    exception.printStackTrace();
                }
                RuntimeMXBean runtimeMXBean = null;
                try {
                    runtimeMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=Runtime", RuntimeMXBean.class);
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    exception.printStackTrace();
                }
                double d = -5.0;
                double d2 = -5.0;
                double d3 = -5.0;
                double d4 = -5.0;
                double d5 = -5.0;
                double d6 = 0.0;
                double d7 = -5.0;
                try {
                    d = classLoadingMXBean.getLoadedClassCount();
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d = -5.0;
                }
                try {
                    d2 = classLoadingMXBean.getTotalLoadedClassCount();
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d2 = -5.0;
                }
                try {
                    d3 = classLoadingMXBean.getUnloadedClassCount();
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d3 = -5.0;
                }
                try {
                    d4 = threadMXBean.getDaemonThreadCount();
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d4 = -5.0;
                }
                try {
                    d5 = threadMXBean.getThreadCount();
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d5 = -5.0;
                }
                try {
                    long[] lArray = threadMXBean.findMonitorDeadlockedThreads();
                    d6 = lArray.length;
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d6 = 0.0;
                }
                try {
                    d7 = runtimeMXBean.getUptime();
                }
                catch (Exception exception) {
                    System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                    d7 = -5.0;
                }
                hashtable.put("LoadedClassCount", new Double(d));
                hashtable.put("TotalLoadedClassCount", new Double(d2));
                hashtable.put("UnloadedClassCount", new Double(d3));
                hashtable.put("DaemonThreadCount", new Double(d4));
                hashtable.put("ThreadCount", new Double(d5));
                hashtable.put("DedlockThreads", new Double(d6));
                hashtable.put("Uptime", new Double(d7));
            }
            catch (Exception exception) {
                System.out.println("Exception in EgTomcatBase of getJvmTestDetails" + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getJvmMemoryPoolDetails() {
        Hashtable hashtable;
        block28: {
            hashtable = new Hashtable();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            try {
                Object object;
                Object object2;
                Object object3;
                if (!this.connect()) break block28;
                Set<ObjectName> set = this.beanServerConnection.queryNames(new ObjectName("java.lang:type=MemoryPool,*"), null);
                long l = -5L;
                long l2 = -5L;
                long l3 = -5L;
                long l4 = -5L;
                long l5 = -5L;
                int n = -5;
                long l6 = -5L;
                long l7 = -5L;
                long l8 = -5L;
                long l9 = -5L;
                long l10 = -5L;
                long l11 = -5L;
                Iterator<ObjectName> iterator = set.iterator();
                while (iterator.hasNext()) {
                    object2 = object3 = iterator.next();
                    object = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, ((ObjectName)object2).toString(), MemoryPoolMXBean.class);
                    arrayList = new ArrayList();
                    if (object == null) continue;
                    String string = object.getName();
                    MemoryUsage memoryUsage = object.getUsage();
                    try {
                        l = memoryUsage.getMax();
                    }
                    catch (Exception exception) {
                        l = -5L;
                    }
                    try {
                        l2 = memoryUsage.getUsed();
                    }
                    catch (Exception exception) {
                        l2 = -5L;
                    }
                    try {
                        l3 = memoryUsage.getCommitted();
                    }
                    catch (Exception exception) {
                        l3 = -5L;
                    }
                    try {
                        l4 = memoryUsage.getInit();
                    }
                    catch (Exception exception) {
                        l4 = -5L;
                    }
                    l5 = l3 - l2;
                    arrayList.add(new Long(l2));
                    arrayList.add(new Long(l5));
                    arrayList.add(new Long(l4));
                    arrayList.add(new Long(n));
                    hashtable.put(string, arrayList);
                }
                object3 = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, "java.lang:type=Memory", MemoryMXBean.class);
                object2 = object3.getHeapMemoryUsage();
                object = object3.getNonHeapMemoryUsage();
                try {
                    n = object3.getObjectPendingFinalizationCount();
                }
                catch (Exception exception) {
                    n = -5;
                }
                try {
                    l6 = ((MemoryUsage)object2).getInit();
                }
                catch (Exception exception) {
                    l6 = -5L;
                }
                try {
                    l7 = ((MemoryUsage)object2).getUsed();
                }
                catch (Exception exception) {
                    l7 = -5L;
                }
                try {
                    l8 = ((MemoryUsage)object2).getCommitted();
                }
                catch (Exception exception) {
                    l8 = -5L;
                }
                l5 = l8 - l7;
                arrayList = new ArrayList();
                arrayList.add(new Long(l7));
                arrayList.add(new Long(l5));
                arrayList.add(new Long(l6));
                arrayList.add(new Long(n));
                hashtable.put("Heap Memory", arrayList);
                try {
                    l9 = ((MemoryUsage)object).getInit();
                }
                catch (Exception exception) {
                    l9 = -5L;
                }
                try {
                    l10 = ((MemoryUsage)object).getUsed();
                }
                catch (Exception exception) {
                    l10 = -5L;
                }
                try {
                    l11 = ((MemoryUsage)object).getCommitted();
                }
                catch (Exception exception) {
                    l11 = -5L;
                }
                l5 = l11 - l10;
                arrayList = new ArrayList();
                arrayList.add(new Long(l10));
                arrayList.add(new Long(l5));
                arrayList.add(new Long(l9));
                arrayList.add(new Long(n));
                hashtable.put("Nonheap Memory", arrayList);
            }
            catch (Exception exception) {
                System.out.println("Exception in EgTomcatBase of getJvmMemoryPoolDetails..." + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getJvmGarbageDetails() {
        Hashtable hashtable;
        block10: {
            hashtable = new Hashtable();
            try {
                if (!this.connect()) break block10;
                Set<ObjectName> set = this.beanServerConnection.queryNames(new ObjectName("java.lang:type=GarbageCollector,*"), null);
                for (ObjectName objectName : set) {
                    ObjectName objectName2 = objectName;
                    GarbageCollectorMXBean garbageCollectorMXBean = ManagementFactory.newPlatformMXBeanProxy(this.beanServerConnection, objectName2.toString(), GarbageCollectorMXBean.class);
                    if (garbageCollectorMXBean == null) continue;
                    String string = "";
                    long l = -5L;
                    long l2 = -5L;
                    ArrayList<Long> arrayList = new ArrayList<Long>();
                    string = garbageCollectorMXBean.getName();
                    try {
                        l = garbageCollectorMXBean.getCollectionCount();
                    }
                    catch (Exception exception) {
                        l = -5L;
                    }
                    try {
                        l2 = garbageCollectorMXBean.getCollectionTime();
                    }
                    catch (Exception exception) {
                        l2 = -5L;
                    }
                    arrayList.add(new Long(l));
                    arrayList.add(new Long(l2));
                    hashtable.put(string, arrayList);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in EgTomcatBase of getJvmGarbageDetails..." + exception.getMessage());
                exception.printStackTrace();
            }
            finally {
                this.disconnect();
            }
        }
        return hashtable;
    }

    protected double parsingOfDouble(String string) {
        double d = -5.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (Exception exception) {
            System.out.println("Exception occur in parseDouble");
            exception.printStackTrace();
            d = -5.0;
            return d;
        }
        return d;
    }

    private void enableSsl() {
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var3_3 = null;
        try {
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            System.out.println("Exception in EgTomcatBase of enableSsl ... " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            long l = (long)d;
            string = string + l;
            d -= (double)l;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (long)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        this.timeout = 2L * EgConfigInfo.msecPerMin;
        do {
            if (l3 < EgAgentCommon.minimumSleep) {
                l3 = EgAgentCommon.minimumSleep;
            }
            this.suspendForPeriodTime(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    private void suspendForPeriodTime(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTomcatVersion(String string, String string2) {
        int n = -1;
        String string3 = "";
        if (this.domain == null) {
            if (nodeNameDomainMapping.containsKey(this.nodeName)) {
                this.domain = (String)nodeNameDomainMapping.get(this.nodeName);
            } else {
                this.findDomainName();
            }
        }
        if (this.domain == null) {
            System.out.println("[EgTomcatBase] - Unable to find the MBean domain for the Node :" + this.nodeName + "  & Entity :" + this.entity);
            return n;
        }
        try {
            if (this.connect()) {
                ObjectName objectName = new ObjectName(this.domain + string);
                if (this.beanServerConnection != null) {
                    string3 = (String)this.beanServerConnection.getAttribute(objectName, string2);
                }
                if (string3 != null && string3.length() > 0) {
                    string3 = string3.substring(string3.indexOf("/") + 1, string3.indexOf("."));
                    n = Integer.parseInt(string3);
                }
            } else {
                this.domain = null;
                nodeNameDomainMapping.remove(this.nodeName);
            }
        }
        catch (Exception exception) {
            n = 6;
        }
        finally {
            this.disconnect();
        }
        return n;
    }

    protected double getCurrentMinusPrevious(String string, double d) {
        double d2 = d;
        if (this.prevMeasure != null && this.prevMeasure.containsKey(string)) {
            Double d3 = (Double)this.prevMeasure.get(string);
            if (d3 != null) {
                double d4 = Double.parseDouble(d3.toString());
                if (d4 >= 0.0) {
                    d2 = d >= d4 ? d - d4 : d;
                }
                this.prevMeasure.put(string, new Double(d));
            }
        } else {
            this.prevMeasure.put(string, new Double(d));
        }
        return d2;
    }

    private boolean isMBeanSrvrUpForLastXtime(int n) {
        boolean bl = false;
        long l = -1L;
        Object object = null;
        try {
            ObjectName objectName = new ObjectName("java.lang:type=Runtime");
            if (this.beanServerConnection != null) {
                object = this.beanServerConnection.getAttribute(objectName, "Uptime");
                if (object != null) {
                    l = new Long(object.toString());
                }
                if (l != -1L && l >= (long)n) {
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    static {
        Object object;
        configuredDomains = new HashMap();
        nodeNameDomainMapping = new Hashtable();
        entityMap = new HashMap();
        ShowNewServletDescriptor = false;
        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
        String string = egTesterInfo.getJmxDomainName();
        if (string != null && string.length() > 0) {
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                configuredDomains.put(string2, string2);
            }
        } else {
            System.out.println("[EgTomcatBase] - Not able to find the list of configured domain names, assigning default value");
            configuredDomains.put("Catalina", "Catalina");
        }
        object = egTesterInfo.getValueFor("DD_ROWS", "ShowNewTomcatServletDescriptor");
        if (object != null && ((String)object).length() > 0 && (((String)object).equalsIgnoreCase("yes") || ((String)object).equalsIgnoreCase("true"))) {
            ShowNewServletDescriptor = true;
        }
        entityMap.put("TomcatCacheTest", "egtomcat/CacheCatalina.jsp");
        entityMap.put("TomcatThreadTest", "egtomcat/ThreadpoolCatalina.jsp?extraMeasures=true");
        entityMap.put("TomcatAppTest", "egtomcat/CatalinaManager.jsp?extraMeasures=true");
        entityMap.put("TomcatConnectorTest", "egtomcat/CatalinaGlobalReqProcessor.jsp");
        entityMap.put("TomcatJspTest", "egtomcat/CatalinaJspMonitor.jsp?extraMeasures=true");
        entityMap.put("TomcatServletTest", "egtomcat/J2eeType.jsp?extraMeasures=true&newServletDescriptor=" + ShowNewServletDescriptor);
        entityMap.put("JVMDetailsTest", "egtomcat/JVMDetails.jsp");
        entityMap.put("JVMGarbageTest", "egtomcat/GarbageCollector.jsp");
        entityMap.put("JVMMemoryTest", "egtomcat/MemoryPool.jsp");
        entityMap.put("UtilityExecutorTest", "egtomcat/CatalinaUtilityExecutor.jsp");
        entityMap.put("TomcatExecutorTest", "egtomcat/CatalinaExecutor.jsp");
        entityMap.put("TomcatDataSrcTest", "egtomcat/CatalinaDataSource.jsp");
        entityMap.put("TomcatConnector_cf", "egtomcat/ConnectorConfigDetails.jsp");
        entityMap.put("TomcatEngine_cf", "egtomcat/EngineConfigDetails.jsp");
        entityMap.put("TomcatHost_cf", "egtomcat/HostConfigDetails.jsp");
        entityMap.put("TomcatRoles_cf", "egtomcat/UserRolesConfigDetails.jsp");
        entityMap.put("TomcatResource_cf", "egtomcat/ResourceConfigDetails.jsp");
        entityMap.put("TomcatValve_cf", "egtomcat/ValveConfigDetails.jsp");
        entityMap.put("TomcatService_cf", "egtomcat/ServiceConfigDetails.jsp");
        entityMap.put("TomcatUsers_cf", "egtomcat/UserConfigDetails.jsp");
        entityMap.put("TomcatRealm_cf", "egtomcat/RealmConfigDetails.jsp");
        entityMap.put("TomcatEnvironment_cf", "egtomcat/EnvironmentConfigDetails.jsp");
        entityMap.put("TomcatCluster_cf", "egtomcat/TomcatClusterDetails.jsp");
        entityMap.put("TomcatContext_cf", "egtomcat/TomcatContextDetails.jsp");
        entityMap.put("TomcatGroups_cf", "egtomcat/GroupsConfigDetails.jsp");
        entityMap.put("TomcatNameResources_cf", "egtomcat/NameResourceParameterDetails.jsp");
        entityMap.put("TomcatResources_cf", "egtomcat/ContextParameterDetails.jsp");
    }
}

