/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;

public class EgSqlTest
extends EgSmartTest {
    private String driver;
    private String url;
    private String dbhost;
    private String dbport;
    private String sid;
    private String user;
    private String password;
    private String type;
    private String database;
    private String query;
    private String domain = "none";
    private String instance = "default";
    private String ssl = "false";
    private String info;
    private Connection conn;
    private Statement stmt;
    private CallableStatement cstmt;
    private ResultSet rs;
    private ResultSetMetaData rsmd;
    private boolean isNTLMv2 = false;
    private String charset = "";
    private String encryptPassword = "";
    private String serviceName = "";

    public EgSqlTest(String[] stringArray) {
        super(stringArray);
        Hashtable hashtable = this.params;
        if (!hashtable.containsKey("driver")) {
            this.setErrorMessage("Driver not defined");
            return;
        }
        this.driver = (String)hashtable.get("driver");
        if (!hashtable.containsKey("dbhost")) {
            this.setErrorMessage("DB Host not defined");
            return;
        }
        this.dbhost = (String)hashtable.get("dbhost");
        if (!hashtable.containsKey("dbport")) {
            this.setErrorMessage("DB Port not defined");
            return;
        }
        this.dbport = (String)hashtable.get("dbport");
        if (!hashtable.containsKey("type")) {
            this.setErrorMessage("Db Type not defined");
            return;
        }
        this.type = (String)hashtable.get("type");
        if (!hashtable.containsKey("user")) {
            this.setErrorMessage("User not defined");
            return;
        }
        this.user = (String)hashtable.get("user");
        if (!hashtable.containsKey("password")) {
            this.setErrorMessage("Password not defined");
            return;
        }
        this.password = (String)hashtable.get("password");
        this.dbhost = IPV6Helper.getValidIPAddress(this.dbhost);
        if (this.type.equals("Oracle")) {
            if (!hashtable.containsKey("sid")) {
                this.setErrorMessage("SID not defined");
                return;
            }
            this.sid = (String)hashtable.get("sid");
            this.serviceName = (String)hashtable.get("servicename");
            boolean bl = false;
            bl = this.serviceName != null && this.serviceName.trim().length() != 0 && !this.serviceName.equalsIgnoreCase("NULL") && !this.serviceName.equalsIgnoreCase("none");
            if (bl) {
                this.url = "jdbc:oracle:thin:@" + this.dbhost + ":" + this.dbport + "/" + this.serviceName;
            } else {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                ArrayList arrayList = ConnectionManager.checkOracleVersion(this.entity, this.dbhost, this.dbport, this.sid, this.user, this.password, debug);
                if (arrayList != null && arrayList.size() > 2) {
                    int n = (Integer)arrayList.get(0);
                    String string = (String)arrayList.get(1);
                    if (string.equalsIgnoreCase("true")) {
                        bl2 = true;
                    }
                    if (n >= 12) {
                        bl4 = true;
                        String string2 = (String)arrayList.get(2);
                        if (string2.equalsIgnoreCase("true")) {
                            bl3 = true;
                        }
                    }
                }
                this.url = bl3 && !bl2 ? "jdbc:oracle:thin:@" + this.dbhost + ":" + this.dbport + "/" + this.sid : "jdbc:oracle:thin:@" + this.dbhost + ":" + this.dbport + ":" + this.sid;
            }
            this.info = (String)hashtable.get("info");
            if (this.info != null && this.info.length() > 0) {
                this.setSid(this.sid);
            }
        } else if (this.type.equals("MsSql")) {
            if (!hashtable.containsKey("database")) {
                this.setErrorMessage("Database not defined");
                return;
            }
            if (!hashtable.containsKey("instance")) {
                this.setErrorMessage("Instance not defined");
                return;
            }
            this.database = (String)hashtable.get("database");
            this.domain = (String)hashtable.get("domain");
            this.instance = (String)hashtable.get("instance");
            this.ssl = (String)hashtable.get("ssl");
            String string = (String)hashtable.get("isntlmv2");
            this.isNTLMv2 = string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes"));
            if (this.domain == null || this.domain.length() == 0) {
                this.domain = "none";
            }
            if (this.ssl == null || this.ssl.length() == 0) {
                this.ssl = "false";
            }
            this.url = "jdbc:jtds:sqlserver://" + this.dbhost + ":" + this.dbport + "/" + this.database;
            this.url = this.instance == null || this.instance.length() == 0 || this.instance.equalsIgnoreCase("default") || this.instance.equalsIgnoreCase("none") ? "jdbc:jtds:sqlserver://" + this.dbhost + ":" + this.dbport + "/" + this.database : "jdbc:jtds:sqlserver://" + this.dbhost + "/" + this.database + ";instance=" + this.instance;
            if ("true".equalsIgnoreCase(this.ssl)) {
                this.url = this.url + ";ssl=request";
            }
        } else if (this.type.equals("Sybase")) {
            if (!hashtable.containsKey("database")) {
                this.setErrorMessage("Database not defined");
                return;
            }
            this.database = (String)hashtable.get("database");
            this.url = "jdbc:sybase:Tds:" + this.dbhost + ":" + this.dbport + "/" + this.database;
            if (!hashtable.containsKey("Charset")) {
                this.setErrorMessage("Database not defined");
                return;
            }
            this.charset = (String)hashtable.get("Charset");
            if (this.charset == null || this.charset.trim().length() == 0 || this.charset.equalsIgnoreCase("NULL") || this.charset.equalsIgnoreCase("none")) {
                String string;
                this.charset = string = "iso_1";
            }
            if (!hashtable.containsKey("Encrypt_password")) {
                this.setErrorMessage("Encrypt password not defined");
                return;
            }
            this.encryptPassword = (String)hashtable.get("Encrypt_password");
            this.encryptPassword = this.encryptPassword != null && (this.encryptPassword.trim().equalsIgnoreCase("y") || this.encryptPassword.trim().equalsIgnoreCase("yes") || this.encryptPassword.trim().equalsIgnoreCase("true")) ? "true" : "false";
        } else if (this.type.equals("MySql") || this.type.equals("MariaDB")) {
            if (!hashtable.containsKey("database")) {
                this.setErrorMessage("Database not defined");
                return;
            }
            this.database = (String)hashtable.get("database");
            this.url = this.type.equals("MySql") ? "jdbc:mysql://" + this.dbhost + ":" + this.dbport + "/" + this.database + "?useSSL=false&serverTimezone=UTC" : "jdbc:mysql://" + this.dbhost + ":" + this.dbport + "/" + this.database + "?serverTimezone=UTC";
        } else if (this.type.equals("PostGres")) {
            if (!hashtable.containsKey("database")) {
                this.setErrorMessage("Database not defined");
                return;
            }
            this.database = (String)hashtable.get("database");
            this.url = "jdbc:postgresql://" + this.dbhost + ":" + this.dbport + "/" + this.database;
        } else if (this.type.equals("DB2")) {
            if (!hashtable.containsKey("database")) {
                this.setErrorMessage("Database not defined");
                return;
            }
            this.database = (String)hashtable.get("database");
            if (!hashtable.containsKey("ssl")) {
                this.setErrorMessage("ssl not defined");
                return;
            }
            this.ssl = (String)hashtable.get("ssl");
            this.url = this.ssl.equalsIgnoreCase("true") ? "jdbc:db2://" + this.dbhost + ":" + this.dbport + "/" + this.database + ":sslConnection=true;" : "jdbc:db2://" + this.dbhost + ":" + this.dbport + "/" + this.database;
        } else if (this.type.equals("SAP HANA")) {
            this.url = "jdbc:sap://" + this.dbhost + ":" + this.dbport + "?reconnect=false";
        } else {
            if (!hashtable.containsKey("url")) {
                this.setErrorMessage("URL not defined");
                return;
            }
            this.url = (String)hashtable.get("url");
        }
    }

    public String translateSql(String string, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = "";
        if (string.indexOf("<<") != -1) {
            while (string.indexOf("<<", n2) != -1) {
                if (string.indexOf("<<<", n2) != -1) {
                    stringBuffer = stringBuffer.append(string.substring(n2, string.indexOf("<<", n2) + 1));
                    n3 = string.indexOf("<<<", n2) + 3;
                    n4 = string.indexOf(">>", n2);
                    string2 = string.substring(n3, n4);
                } else {
                    stringBuffer = stringBuffer.append(string.substring(n2, string.indexOf("<<", n2)));
                    n3 = string.indexOf("<<", n2) + 2;
                    n4 = string.indexOf(">>", n2);
                    string2 = string.substring(n3, n4);
                }
                if (hashtable.get(string2) == null) {
                    return "";
                }
                stringBuffer = stringBuffer.append((String)hashtable.get(string2));
                n = string.indexOf("<<", n2);
                if (string.indexOf("<<", n2 = string.indexOf(">>", n) + 2) != -1) continue;
                stringBuffer = stringBuffer.append(string.substring(n2));
            }
        } else {
            return string;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        if (!this.loadMethods()) {
            return;
        }
        this.query = this.getQuery().trim();
        this.query = this.translateSql(this.query, hashtable);
        boolean bl = false;
        String string = "";
        String string2 = "";
        if (this.query.length() >= 6) {
            string = this.query.substring(0, 6);
            string2 = this.query.substring(0, 4);
        }
        if (string.equalsIgnoreCase("select")) {
            bl = true;
        } else if (string2.equalsIgnoreCase("with")) {
            bl = true;
        }
        if (this.query == null || this.query.length() == 0) {
            this.setErrorMessage("Query not defined");
            return;
        }
        this.conn = this.connect();
        if (this.conn == null) {
            return;
        }
        int n = 0;
        String string3 = null;
        try {
            Object object;
            if (bl) {
                this.stmt = this.conn.createStatement();
                this.rs = this.stmt.executeQuery(this.query);
            } else if (this.type.equals("MsSql")) {
                object = "{call " + this.query + " }";
                this.cstmt = this.conn.prepareCall((String)object);
                this.rs = this.cstmt.executeQuery();
            } else if (this.type.equals("Oracle")) {
                object = "{ call ? := " + this.query + " }";
                this.cstmt = this.conn.prepareCall((String)object);
                this.cstmt.registerOutParameter(1, -10);
                this.cstmt.execute();
                this.rs = (ResultSet)this.cstmt.getObject(1);
            } else if (!this.type.equals("Sybase")) {
                this.setErrorMessage("You have provided an unsupported query statement (select) or you have chosen an unsupported database type");
                return;
            }
            this.rsmd = this.rs.getMetaData();
            n = this.rsmd.getColumnCount();
            if (!this.isConfigTest) {
                if (n == this.measureCount) {
                    this.isDescriptorBased = false;
                } else if (n == this.measureCount + 1) {
                    this.isDescriptorBased = true;
                } else {
                    this.setErrorMessage("Incorrect number of measures");
                    return;
                }
            }
            if (!this.loadMethods()) {
                return;
            }
            object = null;
            while (this.rs.next()) {
                object = new ArrayList();
                for (int i = 1; i <= n; ++i) {
                    if (this.isDescriptorBased && i == 1) {
                        string3 = this.rs.getString(i);
                        if (string3 != null && string3.length() != 0) continue;
                        this.setErrorMessage("Error executing query :  Invalid Descriptor  : " + string3);
                        return;
                    }
                    if (!this.isConfigTest) {
                        ((ArrayList)object).add(new Double(this.rs.getDouble(i)));
                        continue;
                    }
                    ((ArrayList)object).add(this.rs.getString(i));
                }
                if (this.isDescriptorBased) {
                    if (!this.isConfigTest) {
                        object = this.processMeasures(string3, (ArrayList)object);
                    }
                    if (object == null || ((ArrayList)object).size() == 0) {
                        return;
                    }
                    if (!this.isConfigTest) {
                        this.addNewMeasure(string3, (ArrayList)object);
                        continue;
                    }
                    this.addNewMeasure(string3, (ArrayList)object, true);
                    continue;
                }
                if (!this.isConfigTest) {
                    object = this.processMeasures((ArrayList)object);
                }
                if (object == null || ((ArrayList)object).size() == 0) {
                    return;
                }
                if (!this.isConfigTest) {
                    this.addNewMeasure((ArrayList)object);
                    break;
                }
                this.addNewMeasure((ArrayList)object, true);
                break;
            }
            this.closeRs(this.rs);
            if (bl) {
                this.closeStmt(this.stmt);
            } else {
                this.closeCallableStmt(this.cstmt);
            }
            this.closeConn(this.conn);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.setErrorMessage("Error executing query : " + exception.toString());
        }
        finally {
            this.closeRs(this.rs);
            this.closeStmt(this.stmt);
            this.closeCallableStmt(this.cstmt);
            this.closeConn(this.conn);
        }
    }

    private void closeCallableStmt(CallableStatement callableStatement) {
        if (callableStatement != null) {
            try {
                callableStatement.close();
                callableStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
                statement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeConn(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection connect() {
        try {
            Class.forName(this.driver);
            Connection connection = null;
            Properties properties = new Properties();
            if (!this.domain.equalsIgnoreCase("none")) {
                properties.put("user", this.user);
                properties.put("password", this.password);
                properties.put("domain", this.domain);
                properties.put("useNTLMv2", this.isNTLMv2 + "");
            } else {
                properties.put("user", this.user);
                properties.put("password", this.password);
                if (this.type.equalsIgnoreCase("Sybase")) {
                    properties.put("Charset", this.charset);
                    properties.put("Encrypt_password", this.encryptPassword);
                }
            }
            connection = DriverManager.getConnection(this.url, properties);
            return connection;
        }
        catch (Exception exception) {
            this.setErrorMessage(exception.toString());
            return null;
        }
    }
}

