/*
 * Decompiled with CFR 0.152.
 */
public class EgResultSet {
    public String index;
    public String[] measurementNames;
    public String[] values;
    public Threshold[] thresholds;
    public boolean flag;
    private static int numRoundingPlaces = 4;
    private static double tenPowMinusPlace = Math.pow(10.0, -numRoundingPlaces);
    private static double tenPowPlace = Math.pow(10.0, numRoundingPlaces);

    public EgResultSet(String string, int n) {
        this.index = new String(string);
        this.measurementNames = new String[n];
        this.values = new String[n];
        this.thresholds = new Threshold[n];
        for (int i = 0; i < this.measurementNames.length; ++i) {
            this.thresholds[i] = null;
        }
        this.flag = false;
    }

    public void initialize() {
        this.flag = false;
    }

    public void addValue(int n, double d) {
        this.values[n] = this.round(d);
        if (this.thresholds[n] == null) {
            this.thresholds[n] = new Threshold("-1", "-1", 1, 1, false);
        }
        this.thresholds[n].computeThreshold(Double.parseDouble(this.values[n]));
        this.flag = true;
    }

    public void addValue(int n, double d, boolean bl) {
        this.values[n] = this.round(d);
        if (this.thresholds[n] == null) {
            this.thresholds[n] = new Threshold("-1", "-1", 1, 1, false);
        }
        if (bl) {
            this.thresholds[n].computeThreshold(Double.parseDouble(this.values[n]), bl);
        } else {
            this.thresholds[n].computeThreshold(Double.parseDouble(this.values[n]));
        }
        this.flag = true;
    }

    public void addFinalValue(int n, double d) {
        this.values[n] = this.round(d);
        if (this.thresholds[n] == null) {
            this.thresholds[n] = new Threshold("-1", "-1", 1, 1, false);
        }
        this.thresholds[n].setGoodState();
        this.flag = false;
    }

    public void addValue(int n, String string) {
        this.values[n] = string;
        this.flag = true;
    }

    public void initializeThresholds(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray, int[] nArray2) {
        this.measurementNames = stringArray;
        if (stringArray == null || stringArray.length == 0) {
            if (this.thresholds == null) {
                return;
            }
            for (int i = 0; i < this.thresholds.length; ++i) {
                this.thresholds[i] = new Threshold("-999999999", "-999999999", -1, -1, false);
            }
            return;
        }
        for (int i = 0; i < stringArray.length && i < this.thresholds.length && i < nArray.length; ++i) {
            if (this.thresholds[i] == null || nArray[i] <= 0) {
                boolean bl = nArray[i] > 0;
                this.thresholds[i] = new Threshold(stringArray2[i], stringArray3[i], nArray[i], nArray2[i], bl);
                continue;
            }
            if (this.thresholds[i].windowSize != nArray[i]) {
                this.thresholds[i] = new Threshold(stringArray2[i], stringArray3[i], nArray[i], nArray2[i], true);
                continue;
            }
            this.thresholds[i].updateThreshold(stringArray2[i], stringArray3[i], nArray2[i]);
        }
    }

    private String round(double d) {
        String string;
        String string2 = "";
        if (d < 0.0) {
            string2 = string2 + "-";
            d = -d;
        }
        if ((d += 0.5 * tenPowMinusPlace) > 1.0) {
            long l = (long)d;
            string2 = string2 + l;
            d -= (double)l;
        } else {
            string2 = string2 + "0";
        }
        if (d > 0.0) {
            String string3 = "" + (long)((d += 1.0) * tenPowPlace);
            string2 = string2 + "." + string3.substring(1);
        }
        if ((string = EgDbInfo.formatValue(string2)) == null || string.trim().length() == 0) {
            return string2;
        }
        return string;
    }
}

