/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class EgAggregateHelper {
    private static int maxBurst = 25;
    private static AgentClusterHelper agentClusterHelper = null;
    private static EgMainAgent parent = null;
    private boolean useProxy = false;
    private boolean authentication = false;
    private String proxyUser = "none";
    private String proxyPassword = "none";
    private String urlString = null;
    private boolean useGZIP = false;

    public EgAggregateHelper() {
        EgTesterInfo egTesterInfo = new EgTesterInfo("agent");
        double d = egTesterInfo.getManagerVersion();
        double d2 = egTesterInfo.getGZIPSupportedVersion();
        if (d >= d2) {
            this.useGZIP = true;
        }
    }

    public Hashtable getAggregateData(Vector vector) {
        HttpURLConnection httpURLConnection = null;
        try {
            String string = this.getManagerURL();
            if (string == null || string.trim().length() == 0) {
                return null;
            }
            httpURLConnection = this.getConnection(string);
            if (httpURLConnection == null) {
                return null;
            }
            ArrayList<Vector> arrayList = new ArrayList<Vector>();
            arrayList.add(vector);
            ConnectionThread connectionThread = null;
            connectionThread = this.useGZIP ? new ConnectionThread(httpURLConnection, true, null, true, null, arrayList, false) : new ConnectionThread(httpURLConnection, true, null, false, null, arrayList, true);
            ArrayList arrayList2 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                if (connectionThread.code == 200 && connectionThread.done && (arrayList2 = connectionThread.data) != null && arrayList2.size() > 0) {
                    Hashtable hashtable = (Hashtable)arrayList2.get(0);
                    return hashtable;
                }
            }
            connectionThread = null;
            if (!bl) {
                return null;
            }
            if (n != 200) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    public Hashtable getDataForMainTest(Hashtable hashtable) {
        HttpURLConnection httpURLConnection = null;
        try {
            String string = this.getManagerURL();
            if (string == null || string.trim().length() == 0) {
                return null;
            }
            httpURLConnection = this.getConnection(string);
            if (httpURLConnection == null) {
                return null;
            }
            ArrayList<Hashtable> arrayList = new ArrayList<Hashtable>();
            arrayList.add(hashtable);
            ConnectionThread connectionThread = null;
            connectionThread = this.useGZIP ? new ConnectionThread(httpURLConnection, true, null, true, null, arrayList, false) : new ConnectionThread(httpURLConnection, true, null, false, null, arrayList, true);
            ArrayList arrayList2 = null;
            int n = 0;
            boolean bl = this.checkForTimeout(connectionThread);
            if (bl) {
                n = connectionThread.code;
                if (connectionThread.code == 200 && connectionThread.done && (arrayList2 = connectionThread.data) != null && arrayList2.size() > 0) {
                    Hashtable hashtable2 = (Hashtable)arrayList2.get(0);
                    return hashtable2;
                }
            }
            connectionThread = null;
            if (!bl) {
                return null;
            }
            if (n != 200) {
                return null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return null;
    }

    private String getManagerURL() {
        if (EgInstallInfo.isClusterSupported) {
            if (agentClusterHelper == null) {
                agentClusterHelper = AgentClusterHelper.getInstance();
            }
            parent = agentClusterHelper.getParent();
            this.useProxy = EgMainAgent.isProxySet;
            if (this.useProxy) {
                this.proxyUser = EgMainAgent.proxyUsername;
                this.proxyPassword = EgMainAgent.proxyPassword;
                this.authentication = EgMainAgent.isAuthenticationRequired;
            }
            com.eg.EgConfigInfo cfr_ignored_0 = EgAggregateHelper.parent.configInfo;
            this.urlString = new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + com.eg.EgConfigInfo.egMgrUrl + "com.eg.AggregateHelperServlet");
        } else {
            this.useProxy = EgMainAgent.isProxySet;
            if (this.useProxy) {
                this.proxyUser = EgMainAgent.proxyUsername;
                this.proxyPassword = EgMainAgent.proxyPassword;
                this.authentication = EgMainAgent.isAuthenticationRequired;
            }
            this.urlString = new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + "/final/servlet/com.eg.AggregateHelperServlet");
        }
        return this.urlString;
    }

    private HttpURLConnection getConnection(String string) {
        URL uRL;
        if (string == null) {
            return null;
        }
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        HttpURLConnection httpURLConnection = null;
        Object var4_5 = null;
        try {
            if (this.useProxy) {
                int n = 0;
                try {
                    if (EgMainAgent.proxyPort != null) {
                        n = Integer.parseInt(EgMainAgent.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(EgMainAgent.proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            if (this.useGZIP) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-gzip");
                httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
            } else {
                httpURLConnection.setRequestProperty("Content-Type", "text/html");
            }
            return httpURLConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout * 2L;
        long l3 = EgConfigInfo.msecPerMin * 5L;
        if ((l2 = l2 * (long)maxBurst / 25L) > l3) {
            l2 = l3;
        } else if (l2 < EgConfigInfo.msecPerMin) {
            l2 = EgConfigInfo.msecPerMin;
        }
        long l4 = 0L;
        long l5 = 250L;
        do {
            long l6 = System.currentTimeMillis();
            if (l5 < EgAgentCommon.minimumSleep) {
                l5 = EgAgentCommon.minimumSleep;
            } else if (l5 > EgAgentCommon.maxSleep) {
                l5 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.currentThread();
                Thread.sleep(l5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connectionThread.done) {
                return true;
            }
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l6;
            if ((l4 += l8) >= l2 || l8 < 0L) {
                connectionThread.interrupt();
                try {
                    Thread.currentThread();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectionThread.stop();
                return false;
            }
            l = l5;
            if (l2 - l4 >= l) continue;
            l = l2 - l4;
        } while ((l5 = l) > 0L);
        connectionThread.interrupt();
        try {
            Thread.currentThread();
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }

    public String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString(string3);
        return "Basic " + string4;
    }
}

