/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.ConnectionThread;
import com.eg.EgConfigInfo;
import com.eg.EgSSL;
import com.eg.IniFile;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Random;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class EgAgentAutoUpgrade {
    private boolean isProxySet1 = false;
    private String os = null;
    private String agentID = null;
    private String agentVersion = null;
    private String filePath = null;
    private String urlString = null;
    private String hostName = null;
    private String installDir = null;
    private String packageName = null;
    private String proxyUserName = null;
    private String proxyPassword = null;
    private String proxyHost = null;
    private String proxyPort = null;
    private String sslFlag = null;
    private boolean highSecurity = false;
    private boolean agentInfoUploaded = false;
    private boolean isAuthenticationRequired = false;
    private String fileSeparator = System.getProperty("file.separator");
    public static String egAgentAutoUpgradeOut = null;
    private static String s_errorlog = "";
    private boolean updatedLastPackageIDThroughServlet = false;

    public EgAgentAutoUpgrade() {
        String string;
        Properties properties = EgCheckAgent.loadEgCounterIniFile();
        this.agentID = properties.getProperty("AgentID");
        this.agentVersion = properties.getProperty("AgentVersion");
        this.urlString = properties.getProperty("URLString");
        this.installDir = properties.getProperty("EgInstallDir");
        this.os = properties.getProperty("AgentOS");
        this.agentInfoUploaded = new Boolean(properties.getProperty("AgentInfoUploaded"));
        String string2 = properties.getProperty("IsAuthenticationRequired");
        if (string2 != null && string2.equalsIgnoreCase("true")) {
            this.isAuthenticationRequired = true;
        }
        if ((string = properties.getProperty("HighSecurity")) != null && string.equalsIgnoreCase("true")) {
            this.highSecurity = true;
        }
        this.sslFlag = properties.getProperty("Ssl");
        this.enableSSL();
        String string3 = properties.getProperty("IsProxySet");
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            this.isProxySet1 = true;
            this.proxyHost = properties.getProperty("ProxyHost");
            this.proxyPort = properties.getProperty("ProxyPort");
            if (this.isAuthenticationRequired) {
                this.proxyUserName = properties.getProperty("ProxyUsername");
                this.proxyPassword = properties.getProperty("ProxyPassword");
                if (this.proxyPassword != null && this.proxyPassword.length() > 0) {
                    this.proxyPassword = EgCrypt.decrypt(this.proxyPassword);
                }
            }
        }
        if (!this.agentInfoUploaded) {
            this.agentInfoUploaded = this.uploadAgentInfo();
        }
        if (!this.installDir.endsWith(System.getProperty("file.separator"))) {
            this.installDir = this.installDir + System.getProperty("file.separator");
        }
        egAgentAutoUpgradeOut = this.installDir + this.fileSeparator + "agent" + this.fileSeparator + "logs" + this.fileSeparator + "autoupgrade.log";
        s_errorlog = this.installDir + this.fileSeparator + "agent" + this.fileSeparator + "logs" + this.fileSeparator + "error_log";
    }

    public void downloadPackage() {
        if (!this.agentInfoUploaded) {
            this.writeToAgentAutoUpgradeLog("Agent startup info has not been uploaded to Manager");
            this.logToErrorFile("ERROR", "AgentAutoUpgrade", "Agent startup info has not been uploaded to Manager");
            this.writeToAgentAutoUpgradeLog("Upgrade process can not continue...");
            this.logToErrorFile("ERROR", "AgentAutoUpgrade", "Upgrade process can not continue...");
            return;
        }
        URL uRL = null;
        HttpURLConnection httpURLConnection = null;
        try {
            uRL = EgCheckAgent.isDa ? new URL(this.urlString + "com.eg.UpgradeServlet?type=da") : new URL(this.urlString + "com.eg.UpgradeServlet");
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return;
        }
        try {
            String string;
            Object object;
            httpURLConnection = this.getConnection(uRL);
            if (httpURLConnection == null) {
                this.writeToAgentAutoUpgradeLog("EgAgentAutoUpgrade : Unable to connect the eG manager...");
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1");
            arrayList.add(this.agentID);
            arrayList.add(this.os);
            try {
                object = EgCheckAgent.loadEgCounterIniFile();
                string = ((Properties)object).getProperty("AgentAliasName");
                if (string != null && string.length() > 0) {
                    arrayList.add(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (EgCheckAgent.isDa) {
                object = EgCheckAgent.loadEgCounterIniFile();
                string = ((Properties)object).getProperty("LastUpgradedPackage");
                String string2 = ((Properties)object).getProperty("AgentVersion");
                arrayList.add("" + string);
                arrayList.add("" + string2);
            }
            object = new DownloadUpgradeFile(httpURLConnection, arrayList, egAgentAutoUpgradeOut);
            boolean bl = this.checkForTimeout((DownloadUpgradeFile)object, true);
            int n = 0;
            if (bl) {
                n = ((DownloadUpgradeFile)object).code;
            }
            if (n == 200) {
                if (((DownloadUpgradeFile)object).respData == 0) {
                    this.filePath = ((DownloadUpgradeFile)object).filePath;
                    if (!this.installAndUpdateAgentConfigXml()) {
                        this.updateEgCounterForFailedUpgrade();
                    }
                } else {
                    this.updateEgCounterForFailedUpgrade();
                }
            } else {
                this.updateEgCounterForFailedUpgrade();
            }
            httpURLConnection = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.resetUpgradeNowFlag();
    }

    private boolean installAndUpdateAgentConfigXml() {
        URL uRL;
        AgentPackageInstaller agentPackageInstaller = new AgentPackageInstaller(this.filePath, this.os, this.installDir);
        if (!agentPackageInstaller.installThePackage()) {
            this.writeToAgentAutoUpgradeLog("EgAgentAutoUpgrade : Installation failed");
            this.logToErrorFile("ERROR", "EgAgentAutoUpgrade", "Installation Failed");
            return false;
        }
        Properties properties = EgCheckAgent.loadEgCounterIniFile();
        EgDateInfo egDateInfo = new EgDateInfo();
        long l = egDateInfo.egetUTCDate(false);
        properties.setProperty("LastUpgradedPackage", this.packageName);
        properties.setProperty("LastUpgradedTime", l + "");
        EgCheckAgent.storeEgCounterIniFile(properties);
        this.writeToAgentAutoUpgradeLog("EgAgentAutoUpgrade : Installation successful");
        if (EgCheckAgent.isDa || !this.updatedLastPackageIDThroughServlet) {
            return true;
        }
        String string = this.urlString + "com.eg.UpgradeServlet";
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.writeToAgentAutoUpgradeLog("Malformed URL " + string);
            return false;
        }
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.getConnection(uRL);
            if (httpURLConnection == null) {
                this.writeToAgentAutoUpgradeLog("EgAgentAutoUpgrade : Unable to connect the eG manager...");
                return false;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("2");
            arrayList.add(this.agentID);
            arrayList.add(this.packageName);
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false, null, false, arrayList, null, 0);
            boolean bl = this.checkForTimeout(connectionThread, true);
            int n = 0;
            if (bl) {
                n = connectionThread.code;
            }
            if (n == 200) {
                this.writeToAgentAutoUpgradeLog("Package Name has been updated");
            } else {
                this.writeToAgentAutoUpgradeLog("Package name has not been updated");
            }
            httpURLConnection = null;
        }
        catch (Exception exception) {
            this.writeToAgentAutoUpgradeLog("Exception while updating package name" + exception.toString());
            this.logToErrorFile("ERROR", "EgAgentAutoUpgrade", "Exception while updating package name" + exception.toString());
        }
        return true;
    }

    public String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString(string3);
        return "Basic " + string4;
    }

    private void suspendForPeriod(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int getFile(HttpURLConnection httpURLConnection) {
        InputStream inputStream = null;
        FilterInputStream filterInputStream = null;
        FileOutputStream fileOutputStream = null;
        boolean bl = false;
        try {
            inputStream = httpURLConnection.getInputStream();
            if (inputStream == null) {
                return 1;
            }
            byte[] byArray = new byte[4];
            filterInputStream = new DataInputStream(inputStream);
            ((DataInputStream)filterInputStream).read(byArray);
            String string = new String(byArray);
            if (string.equals("RC01")) {
                this.writeToAgentAutoUpgradeLog("Auto upgrade is disabled");
                filterInputStream.close();
                return 1;
            }
            if (string.equals("RC05")) {
                this.writeToAgentAutoUpgradeLog("No package to upgrade");
                filterInputStream.close();
                return 1;
            }
            if (string.equals("RC02") || string.equals("RC03") || string.equals("RC04")) {
                this.writeToAgentAutoUpgradeLog("Attempt to download upgrade package has resulted in an error code of " + string);
                filterInputStream.close();
                return 1;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(new String(byArray));
            byArray = new byte[1];
            int n = 0;
            boolean bl2 = false;
            while (true) {
                ((DataInputStream)filterInputStream).read(byArray);
                if (new String(byArray).equals("$")) break;
                if (n > 100) {
                    bl2 = true;
                    break;
                }
                stringBuffer.append(new String(byArray));
                ++n;
            }
            if (bl2) {
                this.writeToAgentAutoUpgradeLog("Data Stream would be corrupted. Attempt to download upgrade package failed");
                this.logToErrorFile("ERROR", "AgentAutoUpgrade", "Data Stream would be corrupted. Attempt to download upgrade package failed");
                filterInputStream.close();
                return 1;
            }
            this.packageName = stringBuffer.toString();
            this.writeToAgentAutoUpgradeLog("Going to download " + this.packageName);
            File file = new File(EgInstallInfo.getInstallDir() + System.getProperty("file.separator") + "agent" + System.getProperty("file.separator") + this.packageName);
            this.filePath = file.getAbsolutePath();
            fileOutputStream = new FileOutputStream(file);
            int n2 = 0;
            int n3 = 1024;
            byte[] byArray2 = new byte[n3];
            while ((n2 = ((DataInputStream)filterInputStream).read(byArray2)) != -1) {
                fileOutputStream.write(byArray2, 0, n2);
            }
            fileOutputStream.close();
            filterInputStream.close();
            this.writeToAgentAutoUpgradeLog("File has been downloaded and is available for install");
            return 0;
        }
        catch (Exception exception) {
            System.out.println(exception);
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            exception.printStackTrace();
            return 1;
        }
    }

    private void updateEgCounterForFailedUpgrade() {
        Properties properties = EgCheckAgent.loadEgCounterIniFile();
        int n = 0;
        int n2 = 288;
        try {
            n = Integer.parseInt(properties.getProperty("UpgradeCounter"));
            --n;
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        try {
            n2 = Integer.parseInt(properties.getProperty("StartUpgradeProcessAt"));
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 288;
        }
        IniFile iniFile = new IniFile(this.installDir + "agent" + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "eg_tests.ini");
        IniFile iniFile2 = new IniFile(this.installDir + "agent" + System.getProperty("file.separator") + "config" + System.getProperty("file.separator") + "eg_autoupgrade.ini");
        String string = iniFile2.getValue("AGENT_SETTINGS", "AutoUpgradeInterval");
        if (string == null || string.equals("")) {
            string = iniFile.getValue("AGENT_SETTINGS", "AutoUpgradeInterval");
        }
        int n3 = 288;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 288;
        }
        Random random = new Random();
        n2 = random.nextInt(n3);
        if (n2 > n3) {
            n2 -= n3;
        }
        properties.setProperty("UpgradeCounter", new Integer(n).toString());
        properties.setProperty("StartUpgradeProcessAt", new Integer(n2).toString());
        EgCheckAgent.storeEgCounterIniFile(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadAgentInfo() {
        HttpURLConnection httpURLConnection;
        block8: {
            URL uRL;
            Properties properties = EgCheckAgent.loadEgCounterIniFile();
            String string = properties.getProperty("isProxySet");
            String string2 = this.urlString + "com.eg.AgentInfoServlet";
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                this.writeToAgentAutoUpgradeLog("Malformed URL " + string2);
                return false;
            }
            httpURLConnection = null;
            httpURLConnection = this.getConnection(uRL);
            if (httpURLConnection != null) break block8;
            this.writeToAgentAutoUpgradeLog("EgAgentAutoUpgrade : Unable to connect the eG manager...");
            boolean bl = false;
            return bl;
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("AgentStartup");
            arrayList.add(this.agentID);
            arrayList.add(this.hostName);
            arrayList.add(this.os);
            arrayList.add(this.agentVersion);
            ConnectionThread connectionThread = new ConnectionThread(httpURLConnection, false, null, false, arrayList, null, 0);
            if (!this.checkForTimeout(connectionThread, true) && connectionThread.code == 404) {
                this.agentInfoUploaded = false;
            }
            connectionThread = null;
        }
        catch (Exception exception) {
            this.writeToAgentAutoUpgradeLog("Exception while writing agent startup info to AgentInfoServlet" + exception.toString());
            exception.printStackTrace();
            this.agentInfoUploaded = false;
        }
        return this.agentInfoUploaded;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout;
        long l3 = 0L;
        long l4 = 250L;
        do {
            long l5 = System.currentTimeMillis();
            this.suspendForPeriod(l4);
            if (connectionThread.done) {
                return true;
            }
            long l6 = System.currentTimeMillis();
            long l7 = l6 - l5;
            if ((l3 += l7) >= l2 || l7 < 0L) {
                connectionThread.interrupt();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l4;
            if (l2 - l3 >= l) continue;
            l = l2 - l3;
        } while ((l4 = l) > 0L);
        connectionThread.interrupt();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public synchronized void writeToAgentAutoUpgradeLog(String string) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string2 = egDateInfo.egetDate(false);
        File file = new File(egAgentAutoUpgradeOut);
        if (file.exists() && file.length() >= 1000000L) {
            EgInstallInfo.fileRename(egAgentAutoUpgradeOut, egAgentAutoUpgradeOut + ".1");
        }
        try {
            printWriter = new PrintWriter(new FileWriter(egAgentAutoUpgradeOut, true));
        }
        catch (Exception exception) {
            System.err.println("writeToAgentAutoUpgradeLog: Cannot open log file ");
            return;
        }
        printWriter.println(string2 + " : " + string);
        printWriter.close();
    }

    public void logToErrorFile(String string, String string2, String string3) {
        PrintWriter printWriter;
        EgDateInfo egDateInfo = new EgDateInfo();
        String string4 = egDateInfo.egetDate(false);
        try {
            printWriter = new PrintWriter(new FileWriter(s_errorlog, true));
        }
        catch (Exception exception) {
            System.err.println("Cannot open log file ");
            return;
        }
        String string5 = new String(string4 + " " + string + " " + string2 + ": " + string3);
        printWriter.println(string5);
        printWriter.close();
    }

    public boolean setProxy(String string, String string2) {
        boolean bl = false;
        if (this.sslFlag == null || this.sslFlag.equals("false")) {
            String string3 = null;
            String string4 = null;
            String string5 = null;
            try {
                string3 = (String)System.getProperties().get("proxySet");
                string4 = (String)System.getProperties().get("proxyHost");
                string5 = (String)System.getProperties().get("proxyPort");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", string);
                System.getProperties().put("proxyPort", string2);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                System.getProperties().put("proxySet", string3);
                System.getProperties().put("proxyHost", string4);
                System.getProperties().put("proxyPort", string5);
            }
        } else {
            String string6 = null;
            String string7 = null;
            String string8 = null;
            try {
                string7 = (String)System.getProperties().get("https.proxyHost");
                string8 = (String)System.getProperties().get("https.proxyPort");
                string6 = (String)System.getProperties().get("https.proxySet");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                System.getProperties().put("https.proxySet", "true");
                System.getProperties().put("https.proxyHost", string);
                System.getProperties().put("https.proxyPort", string2);
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
                exception.printStackTrace();
                System.getProperties().put("https.proxySet", string6);
                System.getProperties().put("https.proxyHost", string7);
                System.getProperties().put("https.proxyPort", string8);
            }
        }
        return bl;
    }

    private void enableSSL() {
        if (this.sslFlag != null && this.sslFlag.equals("true")) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_3 = null;
            if (!this.highSecurity) {
                try {
                    MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                    KeyManager[] keyManagerArray = null;
                    TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                    SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                    HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                    HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private HttpURLConnection getConnection(URL uRL) {
        HttpURLConnection httpURLConnection = null;
        try {
            int n;
            if (this.isProxySet1) {
                n = 0;
                try {
                    if (this.proxyPort != null) {
                        n = Integer.parseInt(this.proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(this.proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
            n = 0;
            httpURLConnection.setRequestProperty("Content-length", "" + n);
            if (this.isProxySet1 && this.isAuthenticationRequired) {
                Authenticator.setDefault(new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(EgAgentAutoUpgrade.this.proxyUserName, EgAgentAutoUpgrade.this.proxyPassword.toCharArray());
                    }
                });
            }
        }
        catch (Exception exception) {
            httpURLConnection = null;
            System.out.println("Exception occured while getting HTTP connection for the URL :" + uRL);
            this.writeToAgentAutoUpgradeLog("Exception occured while getting HTTP connection for the URL :" + uRL);
            exception.printStackTrace();
        }
        return httpURLConnection;
    }

    public boolean checkForTimeout(ConnectionThread connectionThread, boolean bl) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout;
        long l3 = EgConfigInfo.msecPerMin * 3L;
        if (l2 < l3) {
            l2 = l3;
        }
        long l4 = 0L;
        long l5 = 250L;
        do {
            long l6 = System.currentTimeMillis();
            this.suspendForPeriod(l5);
            if (connectionThread.done) {
                return true;
            }
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l6;
            if ((l4 += l8) >= l2 || l8 < 0L) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l5;
            if (l2 - l4 >= l) continue;
            l = l2 - l4;
        } while ((l5 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public boolean checkForTimeout(DownloadUpgradeFile downloadUpgradeFile, boolean bl) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout;
        long l3 = EgConfigInfo.msecPerMin * 60L * 12L;
        if (l2 < l3) {
            l2 = l3;
        }
        long l4 = 0L;
        long l5 = 250L;
        do {
            long l6 = System.currentTimeMillis();
            this.suspendForPeriod(l5);
            if (downloadUpgradeFile.done) {
                return true;
            }
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l6;
            if ((l4 += l8) >= l2 || l8 < 0L) {
                downloadUpgradeFile.interrupt();
                Thread.currentThread();
                Thread.yield();
                downloadUpgradeFile.stop();
                return false;
            }
            l = l5;
            if (l2 - l4 >= l) continue;
            l = l2 - l4;
        } while ((l5 = l) > 0L);
        downloadUpgradeFile.interrupt();
        Thread.currentThread();
        Thread.yield();
        downloadUpgradeFile.stop();
        return false;
    }

    private void resetUpgradeNowFlag() {
        System.out.println("Calling ResetUPgradeNow Method...");
        Properties properties = EgCheckAgent.loadEgCounterIniFile();
        String string = properties.getProperty("AgentID");
        if (string == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        int n = string.indexOf(":");
        while (n > -1) {
            vector.add(string.substring(0, n));
            string = string.substring(n + 1);
            n = string.indexOf(":");
        }
        vector.add(string);
        String string2 = EgInstallInfo.getInstallDir();
        string2 = string2 + (string2.endsWith(System.getProperty("file.separator")) ? "" : System.getProperty("file.separator"));
        String string3 = string2 + "agent" + System.getProperty("file.separator") + "config" + System.getProperty("file.separator");
        IniFile iniFile = new IniFile(string3 + "eg_tests.ini");
        boolean bl = true;
        IniFile iniFile2 = new IniFile(string3 + "eg_autoupgrade.ini", true);
        String[] stringArray = iniFile2.getVariables("UPGRADE_NOW");
        if (stringArray == null || stringArray.length <= 0) {
            stringArray = iniFile.getVariables("UPGRADE_NOW");
            bl = false;
        }
        if (stringArray == null) {
            return;
        }
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
            if (!bl) {
                iniFile.deleteValue("UPGRADE_NOW", stringArray[i]);
            } else {
                iniFile2.deleteValue("UPGRADE_NOW", stringArray[i]);
            }
            bl2 = true;
        }
        if (bl2) {
            if (!bl) {
                iniFile.saveFile();
            } else {
                iniFile2.saveFile();
            }
        }
    }
}

