/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class EcpDataServerTest
extends EgSnmpGenericTest {
    private static String cacheNameOid = ".1.3.6.1.4.1.16563.1.1.1.1.2";
    private static String cachePerfRowOid = ".1.3.6.1.4.1.16563.1.1.5.1";
    private static int numMeasures = 5;
    private String instance = "none";
    private Hashtable prevRefs = new Hashtable();
    private Hashtable prevGReq = new Hashtable();
    private Hashtable prevBlkSent = new Hashtable();
    private Hashtable prevBSent = new Hashtable();
    private Hashtable prevBRec = new Hashtable();

    public EcpDataServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(numMeasures);
        this.instance = this.getValueForParam("instanceName");
        if (this.instance == null || this.instance.equals("")) {
            this.instance = "all";
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Hashtable hashtable2 = new Hashtable();
        Hashtable hashtable3 = new Hashtable();
        Hashtable hashtable4 = new Hashtable();
        Hashtable hashtable5 = new Hashtable();
        Hashtable hashtable6 = new Hashtable();
        Hashtable hashtable7 = new Hashtable();
        String string = null;
        if (!this.runSnmpCmdForOid(cacheNameOid)) {
            hashtable3 = new Hashtable();
            hashtable4 = new Hashtable();
            hashtable5 = new Hashtable();
            hashtable6 = new Hashtable();
            hashtable7 = new Hashtable();
            return;
        }
        Hashtable<String, String> hashtable8 = new Hashtable<String, String>();
        for (int i = 0; i < this.lhs.length; ++i) {
            hashtable8.put(this.lhs[i], this.rhs[i]);
        }
        hashtable2 = this.getFromSnmp(cachePerfRowOid);
        if (hashtable2 == null || hashtable2.size() == 0) {
            hashtable3 = new Hashtable();
            hashtable4 = new Hashtable();
            hashtable5 = new Hashtable();
            hashtable6 = new Hashtable();
            hashtable7 = new Hashtable();
            return;
        }
        hashtable3 = this.getFromRows("1.", hashtable2);
        hashtable4 = this.getFromRows("2.", hashtable2);
        hashtable5 = this.getFromRows("3.", hashtable2);
        hashtable6 = this.getFromRows("4.", hashtable2);
        hashtable7 = this.getFromRows("5.", hashtable2);
        Enumeration enumeration = hashtable3.keys();
        while (enumeration.hasMoreElements()) {
            ArrayList<Double> arrayList;
            String string2 = (String)enumeration.nextElement();
            string = this.instance.equalsIgnoreCase("all") || this.instance.equalsIgnoreCase("none") ? (String)hashtable8.get(string2) : this.instance;
            if (string == null) continue;
            Double[] doubleArray = new Double[numMeasures];
            doubleArray[0] = (Double)hashtable3.get(string2);
            doubleArray[1] = (Double)hashtable4.get(string2);
            doubleArray[2] = (Double)hashtable5.get(string2);
            doubleArray[3] = (Double)hashtable6.get(string2);
            doubleArray[4] = (Double)hashtable7.get(string2);
            if (this.timeSinceLastTest <= 0.0) {
                arrayList = new ArrayList<Double>();
                this.prevRefs.put(string, doubleArray[0]);
                this.prevGReq.put(string, doubleArray[1]);
                this.prevBlkSent.put(string, doubleArray[2]);
                this.prevBSent.put(string, doubleArray[3]);
                this.prevBRec.put(string, doubleArray[4]);
                for (int i = 0; i < numMeasures; ++i) {
                    arrayList.add(new Double(-5.0));
                }
                this.addNewMeasure(string, arrayList);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add(new Double(this.getDiff(string, this.prevRefs, doubleArray[0])));
            arrayList.add(new Double(this.getDiff(string, this.prevGReq, doubleArray[1])));
            arrayList.add(new Double(this.getDiff(string, this.prevBlkSent, doubleArray[2])));
            double d = this.getDiff(string, this.prevBSent, doubleArray[3]);
            if (d > 0.0) {
                d /= 1024.0;
            }
            arrayList.add(new Double(d));
            d = this.getDiff(string, this.prevBRec, doubleArray[4]);
            if (d > 0.0) {
                d /= 1024.0;
            }
            arrayList.add(new Double(d));
            this.addNewMeasure(string, arrayList);
        }
    }

    private double getDiff(String string, Hashtable hashtable, Double d) {
        Double d2 = (Double)hashtable.get(string);
        if (d2 != null) {
            double d3 = d - d2;
            if (d3 < 0.0) {
                d3 = -5.0;
            }
            return d3;
        }
        hashtable.put(string, d);
        return -5.0;
    }

    private double getDouble(Hashtable hashtable, String string) {
        if (hashtable == null || hashtable.size() == 0) {
            return -5.0;
        }
        try {
            Double d = (Double)hashtable.get(string);
            if (d == null) {
                return -5.0;
            }
            return d;
        }
        catch (Exception exception) {
            return -5.0;
        }
    }

    private Hashtable getFromRows(String string, Hashtable hashtable) {
        if (hashtable == null) {
            return null;
        }
        Hashtable<String, Double> hashtable2 = new Hashtable<String, Double>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            Double d = (Double)hashtable.get(string2);
            string2 = string2.substring(string.length());
            hashtable2.put(string2, d);
        }
        return hashtable2;
    }

    private Hashtable getFromSnmp(String string) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        boolean bl = this.runSnmpCmdForOid(string);
        if (!bl || this.lhs == null || this.lhs.length == 0) {
            return hashtable;
        }
        for (int i = 0; i < this.lhs.length; ++i) {
            try {
                double d = Double.parseDouble(this.rhs[i]);
                hashtable.put(this.lhs[i], new Double(d));
                continue;
            }
            catch (Exception exception) {
                hashtable.put(this.lhs[i], new Double(-5.0));
            }
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.53", "-port", "161", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        EcpDataServerTest ecpDataServerTest = new EcpDataServerTest(stringArray2);
        ecpDataServerTest.computeMeasures(new Hashtable());
    }
}

