/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgConfigInfo;
import com.eg.EgManagerInfo;
import com.eg.IniFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;

public class DDDataUploader
extends Thread {
    private MainAgentHelper mah = null;
    private static long maxSize = 0x500000L;
    private static boolean isDDEnabled = false;
    private static String mc_managerIP = null;
    private static String mc_managerPort = null;
    private static String mc_urlString = null;
    private static String mc_proxyHost = null;
    private static String mc_proxyPort = null;
    private static String mc_proxyUser = null;
    private static String mc_proxyPassword = null;
    private static boolean mc_useSSL = false;
    private static boolean mc_useProxy = false;
    private static boolean mc_authentication = false;
    private static boolean mc_isEncryptionRequired = false;
    private static Vector syncVector = new Vector();
    private static int maxBurst = 25;
    private static int minBurst = 2;
    private static long maxBurstSize = 1000000L;
    private static long minSleep = 5000L;
    private static long sleepPeriod = 100000L;
    public static long maxSleep = EgConfigInfo.msecPerMin * 10L;
    private static Hashtable measureTimes = new Hashtable();
    private static long timeWhenManagerChangeOccured = 0L;
    private static boolean managerChangeOccured = false;
    private static AgentClusterHelper agentClusterHelper = null;
    private static EgManagerInfo managerToReport = null;
    private static EgMainAgent parent = null;
    public static long managerDownCheckTime = 60000L;
    private static double randomizeFactor = 0.1;
    private static double onePlus = 1.0 + randomizeFactor;
    private static double oneMinus = 1.0 - randomizeFactor;
    public static long lastUpdated = 0L;
    private static final int maxLinesAtOnce = 10;
    private static boolean canFileBeRemoved = true;
    public boolean lastSuccess = true;
    public ArrayList slowTests = new ArrayList();
    public long slowRespTime = (long)((double)EgConfigInfo.msecPerMin * 0.4);
    boolean oneTestAtATime = false;
    public IniFile lineCount = new IniFile(EgInstallInfo.getInstallDir() + "/agent/config/ddcount.ini", true);
    public static String dataFolder = EgInstallInfo.getInstallDir() + "/agent/data/";
    public int dataFolderLength = dataFolder.length();
    private EgConfigInfo myconfigInfo;
    private ArrayList userTests = new ArrayList();
    private ArrayList enduserTests = new ArrayList();
    private ArrayList o365Tests = new ArrayList();
    private boolean blockUserTests = false;
    private boolean blockEUCUserTests = false;
    private boolean blockO365Tests = false;
    private boolean useGZIP = false;
    String skipOldData = "";
    String logOldData = "";
    boolean blockOldData = false;
    boolean logData = false;
    String lookBackDate = "0";
    int lookBackDateVal = 0;
    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    EgDateInfo dateInfo = new EgDateInfo();
    long perDay = 86400000L;
    int fileMaxSize = 0x1E00000;
    EgTesterInfo t = new EgTesterInfo("agent");

    public long getAllLineCountForTest(String string) {
        String[] stringArray = this.lineCount.getVariables("LINE_COUNT");
        long l = 0L;
        for (int i = 0; i < stringArray.length; ++i) {
            long l2;
            if (!stringArray[i].startsWith(string)) continue;
            String string2 = this.lineCount.getValue("LINE_COUNT", stringArray[i]);
            try {
                l2 = Long.parseLong(string2);
            }
            catch (Exception exception) {
                l2 = 0L;
            }
            l += l2;
        }
        return l;
    }

    public void updateLineCount(ArrayList arrayList) {
        String[] stringArray = this.lineCount.getVariables("LINE_COUNT");
        long l = 0L;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(dataFolder);
            if (n >= 0) {
                string = string.substring(this.dataFolderLength);
            }
            if (arrayList.contains(string)) continue;
            this.lineCount.deleteValue("LINE_COUNT", dataFolder + string);
            bl = true;
        }
        stringArray = this.lineCount.getVariables("LINE_COUNT");
        List<String> list = Arrays.asList(stringArray);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (!string.startsWith(dataFolder)) {
                string = dataFolder + string;
            }
            if (list.contains(string)) continue;
            int n = this.getLineCount(string);
            this.lineCount.setValue("LINE_COUNT", string, n + "");
            bl = true;
        }
        if (bl) {
            this.lineCount.saveFile();
        }
    }

    public DDDataUploader(EgMainAgent egMainAgent, MainAgentHelper mainAgentHelper) {
        lastUpdated = System.currentTimeMillis();
        this.myconfigInfo = egMainAgent.configInfo;
        this.mah = mainAgentHelper;
        double d = this.t.getManagerVersion();
        double d2 = this.t.getGZIPSupportedVersion();
        if (d >= d2) {
            System.out.println("Using Gzip Compression while uploading DD data to eG Manager");
            this.useGZIP = true;
        }
        if ((minSleep = this.t.getDataUploadPeriod()) < 3000L) {
            minSleep = 3000L;
        }
        if (EgInstallInfo.isClusterSupported) {
            agentClusterHelper = AgentClusterHelper.getInstance();
            parent = agentClusterHelper.getParent();
            managerToReport = agentClusterHelper.getManagerToUpload();
            if (managerToReport == null) {
                return;
            }
            mc_managerIP = managerToReport.getManagerIP();
            mc_managerPort = managerToReport.getManagerPort();
            mc_urlString = egMainAgent.isDesktopAgent() ? managerToReport.getURL() + "com.eg.UploadDiagnosis?type=da" : managerToReport.getURL() + "com.eg.UploadDiagnosis";
            mc_useSSL = managerToReport.isSSL();
            mc_isEncryptionRequired = managerToReport.isEncryptionRequired();
            mc_useProxy = EgMainAgent.isProxySet;
            if (mc_useProxy) {
                mc_proxyHost = EgMainAgent.proxyHost;
                mc_proxyPort = EgMainAgent.proxyPort;
                mc_proxyUser = EgMainAgent.proxyUsername;
                mc_proxyPassword = EgMainAgent.proxyPassword;
                mc_authentication = EgMainAgent.isAuthenticationRequired;
            }
        } else {
            if (egMainAgent == null) {
                return;
            }
            parent = egMainAgent;
            mc_managerIP = EgMainAgent.mgrIp;
            mc_managerPort = EgMainAgent.port;
            mc_urlString = egMainAgent.isDesktopAgent() ? new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.UploadDiagnosis?type=da") : new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.UploadDiagnosis");
            mc_useSSL = new Boolean(EgMainAgent.sslFlag);
            mc_useProxy = EgMainAgent.isProxySet;
            mc_isEncryptionRequired = EgMainAgent.isEncryptionRequired;
            if (mc_useProxy) {
                mc_proxyHost = EgMainAgent.proxyHost;
                mc_proxyPort = EgMainAgent.proxyPort;
                mc_proxyUser = EgMainAgent.proxyUsername;
                mc_proxyPassword = EgMainAgent.proxyPassword;
                mc_authentication = EgMainAgent.isAuthenticationRequired;
            }
        }
    }

    private boolean isDdWorking() {
        if (EgMainAgent.normalFreq == 0 && EgMainAgent.badFreq == 0) {
            isDDEnabled = false;
            return false;
        }
        isDDEnabled = true;
        return true;
    }

    private boolean needToSleep() {
        String string = dataFolder;
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].endsWith("_tmp") || !stringArray[i].endsWith("_DD")) continue;
                File file2 = new File(string + "/" + stringArray[i]);
                boolean bl = file2.exists();
                long l = file2.length();
                if (!bl || l <= 0L) continue;
                return false;
            }
        }
        return true;
    }

    private long findSleepPeriod() {
        if (EgMgrUpload.isRun) {
            long l = EgMgrUpload.sleepPeriod / 3L;
            if (l <= 0L) {
                l = 1L;
            }
            return l;
        }
        Hashtable hashtable = DDDataUploader.parent.measurePeriodForTest;
        if (hashtable == null || hashtable.size() == 0) {
            return EgConfigInfo.msecPerMin * 2L;
        }
        if (hashtable.equals(measureTimes) && sleepPeriod != managerDownCheckTime) {
            return sleepPeriod;
        }
        measureTimes = (Hashtable)hashtable.clone();
        Enumeration enumeration = hashtable.keys();
        long l = -1L;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)hashtable.get(string);
            if (n == null) continue;
            long l2 = n.intValue();
            if (l < 0L) {
                l = l2;
                continue;
            }
            if (l <= l2) continue;
            l = l2;
        }
        if (l < 0L) {
            return -1L;
        }
        if (l > maxSleep) {
            l = maxSleep;
        }
        return l /= 6L;
    }

    private void sleepFor(long l) {
        long l2 = System.currentTimeMillis() + l;
        long l3 = l;
        while (l3 > 0L) {
            if (l3 > EgAgentCommon.maxSleep) {
                l3 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.sleep(l3);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            long l4 = System.currentTimeMillis();
            l3 = l2 - l4;
        }
    }

    public void run() {
        File file = new File(dataFolder);
        long l = 0L;
        IniFile iniFile = null;
        IniFile iniFile2 = new IniFile(EgConfigInfo.egAgentConfigDir + "eg_tests.ini");
        this.skipOldData = iniFile2.getValue("OLD_DATA", "SkipOldData");
        this.skipOldData = this.skipOldData == null ? "" : this.skipOldData;
        this.logOldData = iniFile2.getValue("OLD_DATA", "LogOldData");
        this.logOldData = this.logOldData == null ? "" : this.logOldData;
        this.lookBackDate = iniFile2.getValue("OLD_DATA", "LookBack_Period_DiscardData");
        this.lookBackDate = this.lookBackDate == null || this.lookBackDate.trim().length() == 0 ? "0" : this.lookBackDate;
        iniFile2 = null;
        try {
            this.lookBackDateVal = Integer.parseInt(this.lookBackDate);
        }
        catch (Exception exception) {
            this.lookBackDateVal = 0;
        }
        if (this.skipOldData != null && (this.skipOldData.equalsIgnoreCase("yes") || this.skipOldData.equalsIgnoreCase("true"))) {
            this.blockOldData = true;
        }
        if (this.logOldData != null && (this.logOldData.equalsIgnoreCase("yes") || this.logOldData.equalsIgnoreCase("true"))) {
            this.logData = true;
        }
        while (true) {
            String[] stringArray;
            if (this.useGZIP) {
                this.useGZIP = EgConfigInfo.useGzip;
                if (!this.useGZIP) {
                    System.out.println("*********** DDDataUploader is not going to use GZIP compression any more!");
                }
            }
            maxSize = EgMainAgent.ddMaxSizePerFile;
            iniFile = new IniFile(EgConfigInfo.egAgentConfigDir + "eg_autoupgrade.ini");
            String string = iniFile.getValue("MANAGER_COMMUNICATION", "user_tests_upload");
            this.blockUserTests = false;
            if (string != null && (string = EgCrypt.olddecrypt(string)).equalsIgnoreCase("no")) {
                this.blockUserTests = true;
                this.userTests = new ArrayList();
                stringArray = iniFile.getVariables("User_Tests");
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (this.userTests.contains(EgCrypt.olddecrypt(stringArray[i]))) continue;
                        this.userTests.add(EgCrypt.olddecrypt(stringArray[i]));
                    }
                }
            }
            stringArray = iniFile.getValue("MANAGER_COMMUNICATION", "enduser_tests_upload");
            this.blockEUCUserTests = false;
            if (stringArray != null && (stringArray = EgCrypt.olddecrypt((String)stringArray)).equalsIgnoreCase("no")) {
                this.blockEUCUserTests = true;
                this.enduserTests = new ArrayList();
                String[] stringArray2 = iniFile.getVariables("Endpoints_Tests");
                if (stringArray2 != null) {
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string2 = EgCrypt.olddecrypt(stringArray2[i]);
                        if (this.enduserTests.contains(string2)) continue;
                        this.enduserTests.add(string2);
                    }
                }
            }
            String string3 = iniFile.getValue("MANAGER_COMMUNICATION", "O365User_tests_upload");
            this.blockO365Tests = false;
            if (string3 != null && (string3 = EgCrypt.olddecrypt(string3)).equalsIgnoreCase("no")) {
                this.blockO365Tests = true;
                this.o365Tests = new ArrayList();
                String[] stringArray3 = iniFile.getVariables("O365_Tests");
                if (stringArray3 != null) {
                    for (int i = 0; i < stringArray3.length; ++i) {
                        String string4 = EgCrypt.olddecrypt(stringArray3[i]);
                        if (this.o365Tests.contains(string4)) continue;
                        this.o365Tests.add(string4);
                    }
                }
            }
            try {
                long l2 = System.currentTimeMillis();
                if (l2 - l >= this.mah.stampPeriod) {
                    this.mah.doWork();
                    l = l2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("################################################## DDDataUploader exception " + exception.toString());
                parent.logToErrorFile("Warn", "DDDataUploader", "failed with " + exception.toString());
            }
            long l3 = 0L;
            try {
                long l4 = this.findSleepPeriod();
                maxBurstSize = EgMainAgent.ddMaxLineSize;
                maxBurst = (int)((double)EgMainAgent.agentMaxBurst * 0.5);
                boolean bl = true;
                if (l4 >= 0L) {
                    sleepPeriod = l4 > minSleep ? l4 : minSleep;
                    bl = this.uploadToMgr();
                }
                if (!bl) {
                    sleepPeriod = managerDownCheckTime;
                } else if (sleepPeriod < 0L) {
                    sleepPeriod = minSleep;
                }
                if (bl && !this.needToSleep()) continue;
                l3 = this.getNextPeriod(sleepPeriod);
                if (l3 < minSleep) {
                    l3 = minSleep;
                } else if (l3 > this.mah.stampPeriod) {
                    l3 = this.mah.stampPeriod;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("################################## DDDataUploader 2exception " + exception.toString());
                parent.logToErrorFile("Warn", "DDDataUploader", "2failed with " + exception.toString());
            }
            this.sleepFor(l3);
        }
    }

    public long getNextPeriod(long l) {
        double d = (double)l * onePlus;
        double d2 = (double)l * oneMinus;
        return (long)(d2 + EgMainAgent.getRandom() * (d - d2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadToMgr() {
        int n;
        Object object;
        Hashtable hashtable;
        Enumeration enumeration;
        Enumeration enumeration2;
        int n2;
        Object object2;
        boolean bl = true;
        String string = dataFolder;
        File file = new File(string);
        String[] stringArray = file.list(new DDDataFileFilter());
        if (stringArray == null || stringArray.length == 0) {
            return true;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Boolean> arrayList4 = new ArrayList<Boolean>();
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = 0;
        int n4 = maxBurst;
        if (!this.lastSuccess) {
            n4 = minBurst;
        }
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].endsWith("_tmp") || !stringArray[i].endsWith("_DD")) continue;
            object2 = stringArray[i];
            bl2 = true;
            arrayList5.add(object2);
        }
        ArrayList arrayList6 = new ArrayList();
        object2 = new Hashtable();
        for (n2 = 0; n2 < arrayList5.size(); ++n2) {
            enumeration2 = (String)arrayList5.get(n2);
            int n5 = ((String)((Object)enumeration2)).indexOf("#");
            enumeration = enumeration2;
            if (n5 >= 0) {
                enumeration = ((String)((Object)enumeration2)).substring(0, n5);
            }
            if ((n5 = ((String)((Object)enumeration)).indexOf("_DD")) >= 0) {
                enumeration = ((String)((Object)enumeration)).substring(0, n5);
            }
            if (!arrayList6.contains(enumeration)) {
                arrayList6.add(enumeration);
            }
            hashtable = (Hashtable)((Hashtable)object2).get(enumeration);
            object = new File(string + "/" + enumeration2);
            long l = 0L;
            int n6 = ((String)((Object)enumeration2)).indexOf("#");
            if (n6 >= 0) {
                String string2 = ((String)((Object)enumeration2)).substring(n6 + 1);
                try {
                    long l2;
                    l = l2 = Long.parseLong(string2);
                }
                catch (Exception exception) {}
            } else {
                l = ((File)object).lastModified();
            }
            if (hashtable == null) {
                hashtable = new Hashtable();
                hashtable.put(enumeration2, new Long(l));
                ((Hashtable)object2).put(enumeration, hashtable);
                continue;
            }
            hashtable.put(enumeration2, new Long(l));
        }
        n2 = 0;
        enumeration2 = EgTest_DD.usedToSyncFileAccess.keys();
        while (enumeration2.hasMoreElements()) {
            String string3 = (String)enumeration2.nextElement();
            if (string3.indexOf("_DD") >= 0 && string3.indexOf("#") < 0) continue;
            EgTest_DD.usedToSyncFileAccess.remove(string3);
        }
        this.updateLineCount(arrayList5);
        for (n = 0; n < arrayList6.size(); ++n) {
            boolean bl4;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string4;
            int n7;
            Object object7;
            Object object8;
            enumeration = (String)arrayList6.get(n);
            hashtable = (Hashtable)((Hashtable)object2).get(enumeration);
            object = new long[hashtable.size()];
            enumeration2 = hashtable.keys();
            int n8 = 0;
            Hashtable<Long, Object> hashtable2 = new Hashtable<Long, Object>();
            while (enumeration2.hasMoreElements()) {
                object8 = (String)enumeration2.nextElement();
                Long l = (Long)hashtable.get(object8);
                object[n8] = l;
                if (hashtable2.containsKey(l)) {
                    object7 = (String)hashtable2.get(l);
                    object7 = (String)object7 + "~" + (String)object8;
                    hashtable2.put(l, object7);
                } else {
                    hashtable2.put(l, object8);
                }
                ++n8;
            }
            if (((long[])object).length > 1) {
                Arrays.sort((long[])object);
            }
            object8 = new ArrayList();
            for (n7 = 0; n7 < ((Object)object).length; ++n7) {
                object7 = new Long((long)object[n7]);
                string4 = (String)hashtable2.get(object7);
                if (string4 == null) continue;
                object6 = new StringTokenizer(string4, "~");
                while (((StringTokenizer)object6).hasMoreTokens()) {
                    object5 = ((StringTokenizer)object6).nextToken();
                    ((ArrayList)object8).add(object5);
                }
            }
            n7 = ((ArrayList)object8).size();
            if (n7 == 0) continue;
            if (n7 > 1) {
                String string5 = (String)((ArrayList)object8).get(n7 - 1);
                string4 = "";
                object6 = string + string5;
                object5 = (String)EgTest_DD.usedToSyncFileAccess.get(object6 = this.findAndReplace((String)object6, "\\", "/"));
                if (object5 == null) {
                    object4 = EgTest_DD.usedToSyncFileAccess;
                    synchronized (object4) {
                        object5 = (String)EgTest_DD.usedToSyncFileAccess.get(object6);
                        if (object5 == null) {
                            object5 = new String((String)object6);
                            EgTest_DD.usedToSyncFileAccess.put(object6, object5);
                        }
                    }
                }
                object4 = object5;
                synchronized (object4) {
                    try {
                        if (!string5.startsWith(dataFolder)) {
                            string5 = dataFolder + string5;
                        }
                        this.removeLinesFromFile(string5, 0L);
                        object3 = new File(string5);
                        if (((File)object3).exists() && ((File)object3).length() == 0L) {
                            this.removeFile((File)object3);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            String string6 = (String)((ArrayList)object8).get(0);
            string4 = string + string6;
            object6 = (String)EgTest_DD.usedToSyncFileAccess.get(string4 = this.findAndReplace(string4, "\\", "/"));
            if (object6 == null) {
                object5 = EgTest_DD.usedToSyncFileAccess;
                synchronized (object5) {
                    object6 = (String)EgTest_DD.usedToSyncFileAccess.get(string4);
                    if (object6 == null) {
                        object6 = new String(string4);
                        EgTest_DD.usedToSyncFileAccess.put(string4, object6);
                    }
                }
            }
            object5 = string;
            if (!string.endsWith("/")) {
                object5 = (String)object5 + "/";
            }
            object5 = (String)object5 + string6;
            object4 = new File((String)object5);
            object3 = new int[1];
            ArrayList arrayList7 = null;
            Object object9 = object6;
            synchronized (object9) {
                if (((File)object4).exists() && ((File)object4).length() == 0L) {
                    this.removeFile((File)object4);
                }
                if ((arrayList7 = this.getLines((String)object5, n4, n2, (int[])object3)) == null || arrayList7.size() == 0) {
                    this.removeFile((File)object4);
                    continue;
                }
            }
            n2 += object3[0];
            boolean bl5 = arrayList7.size();
            int n9 = 0;
            boolean bl6 = false;
            int n10 = arrayList.size();
            for (bl4 = false; bl4 < bl5; bl4 += 1) {
                arrayList.add(arrayList7.get(bl4 ? 1 : 0));
                ++n9;
                if (++n10 >= n4) break;
            }
            arrayList4.add(new Boolean(bl6));
            arrayList2.add(object5);
            arrayList3.add(new Integer(n9));
            boolean bl7 = bl4 = (long)n2 >= maxBurstSize;
            if (!this.oneTestAtATime && n10 < maxBurst && !bl4) continue;
            boolean bl8 = false;
            bl8 = n3 >= 3 ? this.upload(arrayList, arrayList2, arrayList3, arrayList4, false, bl4) : this.upload(arrayList, arrayList2, arrayList3, arrayList4, true, bl4);
            this.lastSuccess = bl8;
            if (bl8) {
                bl3 = true;
                n4 = maxBurst;
            } else {
                bl = false;
                n4 = minBurst;
                this.oneTestAtATime = true;
                if (!bl3) {
                    ++n3;
                }
            }
            arrayList2 = new ArrayList();
            arrayList = new ArrayList();
            arrayList3 = new ArrayList();
            arrayList4 = new ArrayList();
            if (!bl8) break;
        }
        if (arrayList.size() > 0) {
            n = (long)n2 >= maxBurstSize ? 1 : 0;
            boolean bl9 = false;
            bl9 = n3 >= 3 ? this.upload(arrayList, arrayList2, arrayList3, arrayList4, false, n != 0) : this.upload(arrayList, arrayList2, arrayList3, arrayList4, true, n != 0);
            this.lastSuccess = bl9;
            if (bl9) {
                bl3 = true;
            } else {
                bl = false;
            }
        }
        if (bl) {
            this.oneTestAtATime = false;
        }
        if (!bl2) {
            return true;
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upload(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4, boolean bl, boolean bl2) {
        int n;
        String string;
        if (arrayList == null || arrayList.size() == 0) {
            return true;
        }
        boolean bl3 = false;
        if (bl) {
            String string2;
            int n2;
            ArrayList<String> arrayList5;
            ArrayList<String> arrayList6;
            if (this.blockUserTests) {
                arrayList6 = new ArrayList<String>();
                arrayList5 = new ArrayList<String>();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    string = arrayList.get(n2).toString();
                    n = string.indexOf("$&$");
                    if (n == -1 || !this.userTests.contains(string2 = string.substring(0, n))) continue;
                    arrayList6.add(string);
                    arrayList5.add(string2);
                }
                arrayList.removeAll(arrayList6);
                if (arrayList5.size() > 0) {
                    System.err.println("INFO : Following tests have been blocked to upload due to User License violation: " + arrayList5);
                }
            }
            if (this.blockEUCUserTests) {
                arrayList6 = new ArrayList();
                arrayList5 = new ArrayList();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    string = arrayList.get(n2).toString();
                    n = string.indexOf("$&$");
                    if (n == -1 || !this.enduserTests.contains(string2 = string.substring(0, n))) continue;
                    arrayList6.add(string);
                    arrayList5.add(string2);
                }
                arrayList.removeAll(arrayList6);
                if (arrayList5.size() > 0) {
                    System.err.println("INFO : Following tests have been blocked to upload due to EUC Endpoints License violation: " + arrayList5);
                }
            }
            if (this.blockO365Tests) {
                arrayList6 = new ArrayList();
                arrayList5 = new ArrayList();
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    string = arrayList.get(n2).toString();
                    n = string.indexOf("$&$");
                    if (n == -1 || !this.o365Tests.contains(string2 = string.substring(0, n))) continue;
                    arrayList6.add(string);
                    arrayList5.add(string2);
                }
                arrayList.removeAll(arrayList6);
                if (arrayList5.size() > 0) {
                    System.err.println("INFO : Following tests have been blocked to upload due to O365 Users count License violation: " + arrayList5);
                }
            }
            bl3 = arrayList2.size() == 1 ? this.uploadData(arrayList, bl2) : this.uploadData(arrayList, bl2);
        }
        if (bl3) {
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                String string3;
                Serializable serializable;
                String string4;
                String string5;
                string = string5 = (String)arrayList2.get(i);
                n = 0;
                int n4 = string5.lastIndexOf("/");
                if (n4 >= 0) {
                    n = 1;
                } else {
                    n4 = string5.lastIndexOf("\\");
                    if (n4 >= 0) {
                        n = 1;
                    }
                }
                if (n == 0) {
                    string = dataFolder + string5;
                }
                if ((string4 = (String)EgTest_DD.usedToSyncFileAccess.get(string = this.findAndReplace(string, "\\", "/"))) == null) {
                    serializable = EgTest_DD.usedToSyncFileAccess;
                    synchronized (serializable) {
                        string4 = (String)EgTest_DD.usedToSyncFileAccess.get(string);
                        if (string4 == null) {
                            string4 = new String(string);
                            EgTest_DD.usedToSyncFileAccess.put(string, string4);
                        }
                    }
                }
                serializable = (Integer)arrayList3.get(i);
                int n5 = (Integer)serializable;
                boolean bl4 = false;
                if (bl4) {
                    string3 = string4;
                    synchronized (string3) {
                        try {
                            this.removeFile(string5);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                string3 = string4;
                synchronized (string3) {
                    try {
                        this.removeLinesFromFile(string5, n5);
                        File file = new File(string5);
                        if (file.exists() && file.length() == 0L) {
                            this.removeFile(file);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
        } else {
            int n6 = arrayList2.size();
            for (int i = 0; i < n6; ++i) {
                Object object;
                String string6;
                String string7;
                string = string7 = (String)arrayList2.get(i);
                n = 0;
                int n7 = string7.lastIndexOf("/");
                if (n7 >= 0) {
                    n = 1;
                } else {
                    n7 = string7.lastIndexOf("\\");
                    if (n7 >= 0) {
                        n = 1;
                    }
                }
                if (n == 0) {
                    string = dataFolder + string7;
                }
                if ((string6 = (String)EgTest_DD.usedToSyncFileAccess.get(string = this.findAndReplace(string, "\\", "/"))) == null) {
                    object = EgTest_DD.usedToSyncFileAccess;
                    synchronized (object) {
                        string6 = (String)EgTest_DD.usedToSyncFileAccess.get(string);
                        if (string6 == null) {
                            string6 = new String(string);
                            EgTest_DD.usedToSyncFileAccess.put(string, string6);
                        }
                    }
                }
                object = string6;
                synchronized (object) {
                    try {
                        this.removeLinesFromFile(string7, 0L);
                        File file = new File(string7);
                        if (file.exists() && file.length() == 0L) {
                            this.removeFile(file);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        return bl3;
    }

    public void removeFile(File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeFile(String string) {
        try {
            File file = new File(string);
            if (file.exists()) {
                this.removeFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeLinesFromFile(String string, long l) {
        File file;
        long l2;
        Object object;
        long l3;
        int n;
        String string2;
        if (l == 0L) {
            long l4 = this.getLineCount(string);
            if (l4 > 0L) {
                this.lineCount.setValue("LINE_COUNT", string, l4 + "");
            } else {
                this.lineCount.deleteValue("LINE_COUNT", string);
            }
            this.lineCount.saveFile();
            string2 = string;
            n = string2.indexOf("_DD");
            if (n >= 0 && (n = (string2 = string2.substring(0, n)).indexOf("#")) >= 0) {
                string2 = string2.substring(0, n);
            }
            l3 = this.getAllLineCountForTest(string2);
        } else {
            l3 = this.performActualRemove(string, l);
            if (l3 > 0L) {
                this.lineCount.setValue("LINE_COUNT", string, l3 + "");
            } else {
                this.lineCount.deleteValue("LINE_COUNT", string);
            }
            this.lineCount.saveFile();
        }
        if (l3 <= 0L) {
            return;
        }
        string2 = string;
        n = string.lastIndexOf("/");
        boolean bl = false;
        if (n >= 0) {
            bl = true;
        } else {
            n = string.lastIndexOf("\\");
            if (n >= 0) {
                bl = true;
            }
        }
        if (bl) {
            string2 = string.substring(n + 1);
        }
        if ((n = string2.indexOf("#")) >= 0) {
            string2 = string2.substring(0, n);
        } else {
            n = string2.indexOf("_DD");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
        }
        long l5 = this.t.getMaxDDUploadLineCount(string2);
        if (l3 > l5) {
            long l6 = l3 - l5;
            this.performActualRemove(string, l6);
            long l7 = this.getLineCount(string);
            if (l7 > 0L) {
                this.lineCount.setValue("LINE_COUNT", string, l7 + "");
            } else {
                this.lineCount.deleteValue("LINE_COUNT", string);
            }
            this.lineCount.saveFile();
            object = new File(string);
            if (l7 == 0L) {
                this.removeFile((File)object);
                return;
            }
            if (((File)object).exists() && ((File)object).length() == 0L) {
                this.removeFile((File)object);
                return;
            }
        }
        long l8 = l2 = (file = new File(string)).exists() ? file.length() : 0L;
        if (l2 > maxSize && string.indexOf("#") < 0) {
            int n2 = string.indexOf("_DD");
            object = string;
            if (n2 >= 0) {
                object = string.substring(0, n2);
            }
            String string3 = (String)object + "#" + System.currentTimeMillis() + "_DD";
            EgInstallInfo.fileRename(string, string3);
            String string4 = this.lineCount.getValue("LINE_COUNT", string);
            this.lineCount.deleteValue("LINE_COUNT", string);
            this.lineCount.setValue("LINE_COUNT", string3, string4);
            this.lineCount.saveFile();
        }
    }

    public String findAndReplace(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return string;
        }
        String string4 = string;
        int n = 0;
        int n2 = string4.indexOf(string2, n);
        if (n2 < 0) {
            return string;
        }
        int n3 = string2.length();
        int n4 = string3.length() - n3;
        n4 = n4 < 0 ? 0 : n4;
        StringBuilder stringBuilder = new StringBuilder(string.length() + (n4 *= 16));
        while (n2 >= 0) {
            stringBuilder.append(string, n, n2).append(string3);
            n = n2 + n3;
            n2 = string4.indexOf(string2, n);
        }
        stringBuilder.append(string, n, string.length());
        return stringBuilder.toString();
    }

    private long performActualRemove(String string, long l) {
        String string2 = string + "_tmp";
        File file = new File(string2);
        PrintWriter printWriter = null;
        BufferedReader bufferedReader = null;
        long l2 = 0L;
        try {
            printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"), true);
            int n = 0;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.trim().length() == 0) continue;
                if ((long)n >= l) {
                    ++l2;
                    printWriter.println(string3);
                }
                ++n;
            }
            printWriter.close();
            bufferedReader.close();
            this.fileCopy(string2, string);
            this.removeFile(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
            this.removeFile(string2);
            return -1L;
        }
        return l2;
    }

    private void fileCopy(String string, String string2) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8"));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                printWriter.println(string3);
            }
            bufferedReader.close();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private ArrayList getLines(String string, int n, int n2, int[] nArray) {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            int n3 = 0;
            int n4 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n3 <= n) {
                    if (string2.trim().length() == 0) continue;
                    arrayList.add(string2);
                    n4 += string2.length();
                    ++n3;
                }
                if (n3 != n && (long)(n2 + n4) < maxBurstSize) continue;
            }
            nArray[0] = n4;
            bufferedReader.close();
            bufferedReader = null;
            return arrayList;
        }
        catch (Exception exception) {
            nArray[0] = 0;
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private int getLineCount(String string) {
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "UTF-8"));
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.trim().length() == 0) continue;
                ++n;
            }
            bufferedReader.close();
            bufferedReader = null;
            return n;
        }
        catch (Exception exception) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    public void logOldData(String string) {
        boolean bl = true;
        try {
            Closeable closeable;
            String string2 = EgInstallInfo.getInstallDir() + "/agent/logs/oldData.log";
            File file = new File(string2);
            if (file.exists() && this.fileMaxSize < ((FileInputStream)(closeable = new FileInputStream(file))).available()) {
                bl = false;
            }
            closeable = new PrintWriter(new FileWriter(string2, bl));
            String string3 = new Date().toString();
            ((PrintWriter)closeable).write("DDD Data :: " + string3 + " : " + string);
            ((PrintWriter)closeable).write("\n");
            ((PrintWriter)closeable).flush();
            ((PrintWriter)closeable).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean checkForOldData(ArrayList arrayList) {
        if (arrayList != null && arrayList.size() > 8) {
            String string = (String)arrayList.get(7);
            long l = this.dateInfo.egetUTCDate(true);
            long l2 = -1L;
            try {
                Date date = this.sdf.parse(string);
                l2 = date.getTime();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                l2 = -1L;
            }
            long l3 = l - l2;
            long l4 = l3 / this.perDay;
            try {
                if ((int)l4 > this.lookBackDateVal) {
                    if (this.logData) {
                        this.logOldData("" + arrayList);
                    }
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return true;
            }
        }
        return true;
    }

    private boolean uploadData(ArrayList arrayList, boolean bl) {
        ArrayList arrayList2 = null;
        arrayList2 = this.constructObjectsToBeUploaded(arrayList);
        if (EgInstallInfo.isClusterSupported) {
            try {
                if (managerToReport == null) {
                    if (agentClusterHelper == null) {
                        agentClusterHelper = AgentClusterHelper.getInstance();
                        parent = agentClusterHelper.getParent();
                    }
                    if ((managerToReport = agentClusterHelper.getManagerToUpload()) == null) {
                        managerToReport = agentClusterHelper.getManagerToUpload(parent);
                    }
                    if (managerToReport == null) {
                        return false;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception in DDdatauploader...uploaddata " + exception);
                exception.printStackTrace();
            }
            if (DDDataUploader.agentClusterHelper.managerChangeOccured && DDDataUploader.agentClusterHelper.numberOfTimesTried >= 3 && System.currentTimeMillis() > DDDataUploader.agentClusterHelper.timeWhenManagerChangeOccured + 3600000L) {
                agentClusterHelper.setTimesTried(0);
            }
            mc_managerIP = managerToReport.getManagerIP();
            mc_managerPort = managerToReport.getManagerPort();
            mc_urlString = parent.isDesktopAgent() ? (bl ? managerToReport.getURL() + "com.eg.UploadDiagnosis?type=da&isMaxData=true" : managerToReport.getURL() + "com.eg.UploadDiagnosis?type=da") : (bl ? managerToReport.getURL() + "com.eg.UploadDiagnosis?isMaxData=true" : managerToReport.getURL() + "com.eg.UploadDiagnosis");
            mc_useSSL = managerToReport.isSSL();
            mc_useProxy = EgMainAgent.isProxySet;
            mc_isEncryptionRequired = managerToReport.isEncryptionRequired();
            if (mc_useProxy) {
                mc_proxyHost = EgMainAgent.proxyHost;
                mc_proxyPort = EgMainAgent.proxyPort;
                mc_proxyUser = EgMainAgent.proxyUsername;
                mc_proxyPassword = EgMainAgent.proxyPassword;
                mc_authentication = EgMainAgent.isAuthenticationRequired;
            }
        } else {
            if (parent == null) {
                return false;
            }
            mc_managerIP = EgMainAgent.mgrIp;
            mc_managerPort = EgMainAgent.port;
            mc_urlString = parent.isDesktopAgent() ? (bl ? new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.UploadDiagnosis?type=da&isMaxData=true") : new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.UploadDiagnosis?type=da")) : (bl ? new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.UploadDiagnosis?isMaxData=true") : new String(EgInstallInfo.urlPrefix + "//" + EgMainAgent.mgrIp + ":" + EgMainAgent.port + EgConfigInfo.egMgrUrl + "com.eg.UploadDiagnosis"));
            mc_useSSL = new Boolean(EgMainAgent.sslFlag);
            mc_useProxy = EgMainAgent.isProxySet;
            mc_isEncryptionRequired = EgMainAgent.isEncryptionRequired;
            if (mc_useProxy) {
                mc_proxyHost = EgMainAgent.proxyHost;
                mc_proxyPort = EgMainAgent.proxyPort;
                mc_proxyUser = EgMainAgent.proxyUsername;
                mc_proxyPassword = EgMainAgent.proxyPassword;
                mc_authentication = EgMainAgent.isAuthenticationRequired;
            }
        }
        if (arrayList2 == null || arrayList2.size() == 0) {
            return true;
        }
        HttpURLConnection httpURLConnection = null;
        ObjectOutputStream objectOutputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        ObjectOutputStream objectOutputStream2 = null;
        try {
            int n;
            httpURLConnection = this.getConnection();
            if (httpURLConnection == null) {
                return false;
            }
            ConnectionThread connectionThread = null;
            if (this.useGZIP) {
                httpURLConnection.setRequestProperty("Content-Type", "application/x-gzip");
                httpURLConnection.setRequestProperty("Content-Encoding", "gzip");
                connectionThread = new ConnectionThread(httpURLConnection, true, "ag", true, arrayList2, false);
            } else {
                Object[] objectArray = new Object[arrayList2.size()];
                for (n = 0; n < objectArray.length; ++n) {
                    objectArray[n] = arrayList2.get(n);
                }
                connectionThread = new ConnectionThread(httpURLConnection, true, "ag", false, objectArray, false);
            }
            int n2 = 0;
            n = this.checkForTimeout(connectionThread, bl) ? 1 : 0;
            if (n != 0) {
                n2 = connectionThread.code;
            }
            connectionThread = null;
            objectOutputStream = null;
            objectOutputStream2 = null;
            httpURLConnection = null;
            if (bl) {
                return true;
            }
            if (n2 != 200) {
                throw new ConnectException();
            }
        }
        catch (ConnectException connectException) {
            if (EgInstallInfo.isClusterSupported) {
                managerToReport = agentClusterHelper.getManagerToUpload();
            }
            return false;
        }
        catch (SocketException socketException) {
            if (EgInstallInfo.isClusterSupported) {
                managerToReport = agentClusterHelper.getManagerToUpload();
            }
            return false;
        }
        catch (Exception exception) {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            try {
                if (objectOutputStream2 != null) {
                    objectOutputStream2.close();
                }
                objectOutputStream2 = null;
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.close();
                }
                deflaterOutputStream = null;
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        return true;
    }

    public ArrayList constructObjectsToBeUploaded(ArrayList arrayList) {
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        try {
            String string = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl;
                string = (String)arrayList.get(i);
                if (string == null || string.trim().length() == 0) {
                    System.out.println("[DDDataUploader] constructObjectsToBeUploaded line is empty so continue " + string);
                    continue;
                }
                ArrayList arrayList3 = this.convertRawDataToDDDataFormat(string);
                if (this.blockOldData && !(bl = this.checkForOldData(arrayList3))) continue;
                if (arrayList3.size() == 10) {
                    arrayList2.add(arrayList3);
                    continue;
                }
                if (arrayList3.size() > 10) {
                    ArrayList arrayList4 = new ArrayList();
                    int n = arrayList3.size();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int j = 0; j < n; ++j) {
                        if (j < 9) {
                            arrayList4.add(arrayList3.get(j));
                            continue;
                        }
                        if (j == 9) {
                            stringBuffer.append(arrayList3.get(j));
                            continue;
                        }
                        stringBuffer.append("$&$");
                        stringBuffer.append(arrayList3.get(j));
                    }
                    arrayList4.add(stringBuffer);
                    arrayList2.add(arrayList4);
                    continue;
                }
                arrayList2.add(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList2;
    }

    public ArrayList convertRawDataToDDDataFormat(String string) {
        String string2 = "$&$";
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = null;
        int n = string2.length();
        int n2 = 0;
        int n3 = string.indexOf(string2);
        while (n3 >= 0) {
            string3 = string.substring(n2, n3);
            arrayList.add(string3);
            n2 = n3 + n;
            n3 = string.indexOf(string2, n2);
        }
        string3 = string.substring(n2);
        arrayList.add(string3);
        return arrayList;
    }

    private HttpURLConnection getConnection() {
        URL uRL;
        try {
            uRL = new URL(mc_urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        HttpURLConnection httpURLConnection = null;
        Object var4_4 = null;
        try {
            if (mc_useProxy) {
                int n = 0;
                try {
                    if (mc_proxyPort != null) {
                        n = Integer.parseInt(mc_proxyPort.trim());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                InetSocketAddress inetSocketAddress = new InetSocketAddress(mc_proxyHost, n);
                Proxy proxy = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                httpURLConnection = (HttpURLConnection)uRL.openConnection(proxy);
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "text/html;charset=UTF-8");
            return httpURLConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String encode(String string, String string2) {
        String string3 = string + ":" + string2;
        String string4 = Base64Coder.encodeString(string3);
        return "Basic " + string4;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        return this.checkForTimeout(connectionThread, false);
    }

    private boolean checkForTimeout(ConnectionThread connectionThread, boolean bl) {
        long l;
        EgConfigInfo egConfigInfo = new EgConfigInfo("agent");
        long l2 = EgConfigInfo.getResponseCodeTimeout * 2L;
        l2 = l2 * (long)maxBurst / 15L;
        long l3 = EgConfigInfo.msecPerMin * 5L;
        if (bl) {
            l2 = l3;
        } else if (l2 > l3) {
            l2 = l3;
        } else if (l2 < EgConfigInfo.msecPerMin) {
            l2 = EgConfigInfo.msecPerMin;
        }
        long l4 = 0L;
        long l5 = 25L;
        do {
            long l6 = System.currentTimeMillis();
            if (l5 < EgAgentCommon.minimumSleep) {
                l5 = EgAgentCommon.minimumSleep;
            } else if (l5 > EgAgentCommon.maxSleep) {
                l5 = EgAgentCommon.maxSleep;
            }
            try {
                Thread.sleep(l5);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (connectionThread.done) {
                return true;
            }
            long l7 = System.currentTimeMillis();
            long l8 = l7 - l6;
            if ((l4 += l8) >= l2 || l8 < 0L) {
                connectionThread.interrupt();
                try {
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectionThread.stop();
                return false;
            }
            l = l5;
            if (l2 - l4 >= l) continue;
            l = l2 - l4;
        } while ((l5 = l) > 0L);
        connectionThread.interrupt();
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        connectionThread.stop();
        return false;
    }

    class DDDataFileFilter
    implements FilenameFilter {
        DDDataFileFilter() {
        }

        public boolean accept(File file, String string) {
            return string.endsWith("_DD");
        }
    }
}

